<?php

if (file_exists('includes/modules/UPS/config.UPS.php')) {
    require 'includes/modules/UPS/config.UPS.php';
} else {
    require '../includes/modules/UPS/config.UPS.php';
}

/**
 * Service Codes via https://www.ups.com/assets/resources/media/en_CA/CSV_File_Guide_V5.pdf (c 2016)
 * 01 - UPS Next Day Air/UPS Express
 * 02 - UPS 2nd Day Air/UPS Expedited
 * 03 - UPS Ground
 * 07 - UPS Worldwide Express/UPS Express
 * 08 - UPS Worldwide Expedited/UPS Expedited
 * 11 - UPS Worldwide Standard/UPS Standard
 * 12 - UPS 3 Day Select
 * 13 - UPS Next Day Air Saver/UPS Express Savers (to US)
 * 14 - UPS Next Day Air Early/UPS Express Early
 * 21 - UPS Economy
 * 31 - Basic
 * 54 - UPS Worldwide Express Plus/UPS Express Early for CA->CA/US
 * 59 - UPS 2nd Day A.M.
 * 64 - UPS Express NAI
 * 65 - UPS Saver
 * 66 - Worldwide Express Freight
 * 70 - UPS Access Point Economy
 * 82 - UPS Today Standard
 * 83 - UPS Today Dedicated Courier
 * 84 - UPS Today Intercity
 * 85 - UPS Today Express
 * 86 - UPS Today Express Saver
 * 92 - UPS SurePost Less than 1lb
 * 93 - UPS Surepost 1lb or Greater
 * 94 - UPS SurePost: Bound Printed Matter
 * 95 - UPS SurePost Media
 * 96 - UPS Worldwide Express Freight
 */

/**
 * Api Error Codes
 * Hard Errors:
 * 10006 - May not meet specification
 * 250001 - Invalid access license for called tool
 * 250002 - Invalid auth info
 * 250003 - Invalid access license
 * 250004 - Invalid user/password
 * 250005 - No access/auth credentials provided
 * 250006 - Max number of invalid auth attempts reached
 * 250007 - Account locked
 * 250009 - Access license number not recognized
 * 
 * Transient Errors:
 * 20001 - General process failure
 * 250050 - License system not available
 */

function ups_rate_package($shipto, $shipfrom, $products, $service = "03", $version = 'v2205', $requestoption = 'Rate') {
    global $shipperNumber;

    $data = array(
        "RateRequest" => array(
            "Request" => array(
                "SubVersion" => $version,
            ),
            "Shipment" => array(
                "Shipper" => array(
                    "Name" => "Westech Equipment",
                    "ShipperNumber" => $shipperNumber,
                    "Address" => array(
                        "AddressLine" => "195 W 3900 S",
                        "City" => "Millcreek",
                        "StateProvinceCode" => "UT",
                        "PostalCode" => "84107",
                        "CountryCode" => "US"
                    )
                ),
                "ShipTo" => array(
                    "Name" => $shipto['name'],
                    "Address" => array(
                        "AddressLine" => $shipto['addressLine1'],
                        "City" => $shipto['city'],
                        "StateProvinceCode" => $shipto['state'],
                        "PostalCode" => $shipto['zip'],
                        "CountryCode" => $shipto['country']
                    )
                ),
                "ShipFrom" => array(
                    "Name" => $shipfrom['name'],
                    "Address" => array(
                        "AddressLine" => $shipfrom['addressLine1'],
                        "City" => $shipfrom['city'],
                        "StateProvinceCode" => $shipfrom['state'],
                        "PostalCode" => $shipfrom['zip'],
                        "CountryCode" => $shipfrom['country']
                    )
                ),
                // The following is for requesting negotiated rates
                "ShipmentRatingOptions" => array(
                    // TPFC is only available for Third Party / Freight Collect shipments
                    // "TPFCNegotiatedRatesIndicator" => "Y",
                    "NegotiatedRatesIndicator" => "Y"
                ),
                "Service" => array(
                    "Code" => $service
                ),
                "ShipmentTotalWeight" => array(),
                "Package" => array()
            )
        )
    );

    $packages = array();
    $runningWeight = 0;
    $runningQuantity = 0;
    foreach ($products as $product) {
        $runningQuantity += $product['quantity'];
        $packageWeight = $product['weight'] * $product['quantity'];
        $runningWeight += $packageWeight;

        $packages[] = array(
            'PackagingType' => array(
                'Code' => '02',
                'Description' => 'Packaging'
            ),
            'PackageWeight' => array(
                'UnitOfMeasurement' => array(
                    'Code' => 'LBS',
                    'Description' => 'Pounds'
                ),
                'Weight' => "$packageWeight"
            ),
            //The following is for requesting a signature for delivery
            'PackageServiceOptions' => array(
                'DeliveryConfirmation' => array(
                    'DCISType' => '2'
                )
            ),
            'DeclaredValue' => array(
                'CurrencyCode' => 'USD',
                'MonetaryValue' => $product['price']
            )
        );
    }

    if ($shipto['residentialIndicator'] == true) $data['RateRequest']['Shipment']['ShipTo']['Address']['ResidentialAddressIndicator'] = true;
    if ($shipto['liftgateIndicator'] == true) $data['RateRequest']['Shipment']['ShipmentServiceOptions']['DeliveryOptions']['LiftGateAtDeliveryIndicator'] = true;

    $data['RateRequest']['Shipment']['ShipmentTotalWeight'] = array(
        "UnitOfMeasurement" => array(
            "Code" => "LBS",
            "Description" => "Pounds"
        ),
        "Weight" => $runningWeight
    );

    $data['RateRequest']['Shipment']['NumOfPieces'] = $runningQuantity;

    $data['RateRequest']['Shipment']['Package'] = $packages;

    return ups_call_api("api/rating/$version/$requestoption", $data);
}

/**
 * @deprecated moved to tforce's endpoints
 */
function ups_rate_freight($shipto, $shipfrom, $products, $version = 'v1801', $requestoption = 'ground') {
    global $shipperNumber;

    $data = array(
        "FreightRateRequest" => array(
            "ShipFrom" => array(
                "Name" => $shipfrom['name'],
                "ShipperNumber" => $shipperNumber,
                "Address" => array(
                    "AddressLine" => $shipfrom['addressLine'],
                    "City" => $shipfrom['city'],
                    "StateProvinceCode" => $shipfrom['state'],
                    "PostalCode" => $shipfrom['zip'],
                    "CountryCode" => $shipfrom['country']
                )
            ),
            "ShipTo" => array(
                "Name" => $shipto['name'],
                "Address" => array(
                    "AddressLine" => $shipto['addressLine'],
                    "City" => $shipto['city'],
                    "StateProvinceCode" => $shipto['state'],
                    "PostalCode" => $shipto['zip'],
                    "CountryCode" => $shipto['country']
                )
            ),
            "PaymentInformation" => array(
                "Payer" => array(
                    "Name" => "Westech Equipment",
                    "Address" => array(
                        "AddressLine" => "PO BOX 57307",
                        "City" => "Salt Lake City",
                        "StateProvinceCode" => "UT",
                        "PostalCode" => "84157",
                        "CountryCode" => "US"
                    )
                ),
                "ShipmentBillingOption" => array(
                    "Code" => "30"
                )
            ),
            "Service" => array(
                "Code" => "308"
            ),
            "HandlingUnitOne" => array(
                "Description" => "HU1",
                "Quantity" => "1",
                "Type" => array(
                    "Code" => "PCS"
                )
            ),
            "Commodity" => array()
        )
    );

    if ($shipto['residentialIndicator'] == true) $data['FreightRateRequest']['ShipmentServiceOptions']['DeliveryOptions']['ResidentialDeliveryIndicator'] = true;
    if ($shipto['liftgateIndicator'] == true) $data['FreightRateRequest']['ShipmentServiceOptions']['DeliveryOptions']['LiftGateRequiredIndicator'] = true;
    if ($shipto['restrictedAccessIndicator'] == true) $data['FreightRateRequest']['ShipmentServiceOptions']['DeliveryOptions']['LimitedAccessDeliveryIndicator'] = true;

    $commodityArray = array();

    foreach ($products as $product) {
        $commodityArray[] = array(
            "Description" => "FRS-Freight " . $product['id'],
            "Weight" => array(
                "UnitOfMeasurement" => array(
                    "Code" => "LBS"
                ),
                "Value" => $product['weight'] * $product['quantity'] . ""
            ),
            "Dimensions" => array(
                "UnitOfMeasurement" => array(
                    "Code" => "IN"
                ),
                "Length" => $product['length'],
                "Width" => $product['width'],
                "Height" => $product['height'],
            ),
            "NumberOfPieces" => "" . $product['quantity'] . "",
            "PackagingType" => array(
                "Code" => $product['packing_type']
            ),
            "FreightClass" => $product['freight_class']
        );
    }

    $data['FreightRateRequest']['Commodity'] = $commodityArray;

    return ups_call_api("api/freight/$version/rating/$requestoption", $data);
}

function ups_validate_address($address, $version = 'v1', $requestoption = '3', $candidateListSize = 50) {

    $data = array(
        "XAVRequest" => [
            "AddressKeyFormat" => [
                "AddressLine" => [
                    $address['line1'],
                    $address['line2']
                ],
                "PoliticalDivision2" => $address['city'],
                "PoliticalDivision1" => $address['state']
            ]
        ]
    );

    if (isset($address['line3'])) $data['XAVRequest']['AddressKeyFormat']['AddressLine'][] = $address['line3'];

    if (empty($address['line2'])) {
        unset($data['XAVRequest']['AddressKeyFormat']['AddressLine'][1]);
    }
    if (empty($address['line3'])) {
        unset($data['XAVRequest']['AddressKeyFormat']['AddressLine'][2]);
    }

    if (strpos($address['zip'], '-') == false) {
        $data['XAVRequest']['AddressKeyFormat']['PostcodePrimaryLow'] = $address['zip'];
    } else {
        $zipSplit = explode('-', $address['zip']);

        $data['XAVRequest']['AddressKeyFormat']['PostcodePrimaryLow'] = $zipSplit[0];
        $data['XAVRequest']['AddressKeyFormat']['PostcodeExtendedLow'] = $zipSplit[1];
    }

    if (isset($address['urbanization']) && !empty($address['urbanization'])) {
        $data['XAVRequest']['AddressKeyFormat']['Urbanization'] = $address['urbanization'];
    }

    $data['XAVRequest']['AddressKeyFormat']['CountryCode'] = $address['country'];

    return ups_call_api("api/addressvalidation/$version/$requestoption?maximumcandidatelistsize=$candidateListSize", $data);
}