<?php

if (file_exists('includes/modules/authorizenet/config.authorizenet.php'))
{
    require 'includes/modules/authorizenet/config.authorizenet.php';
}
else
{
    require '../includes/modules/authorizenet/config.authorizenet.php';
}

function adn_charge_card($refId, $type="authCaptureTransaction") {
    global $order;

    $lineItems = array();

    $products = $_SESSION['cart']->get_products();

    foreach($products as $item) {
        if (strlen($item['name']) > 28) {
            $item['name'] = substr($item['name'], 0, 28) . '...';
        }

        array_push($lineItems, array(
            "itemId" => $item['id'],
            "name" => $item['name'],
            "description" => $item['alt_name'],
            "quantity" => $item['quantity'],
            "unitPrice" => $item['price'],
        ));
    }

    $data = [
        "createTransactionRequest" => [
            "merchantAuthentication" => adn_get_basic_configuration("auth", false),
            "refId" => $refId,
            "transactionRequest" => [
                "transactionType" => $type,
                "amount" => number_format($order->info['total'], 2, '.', ''),
                "currencyCode" => "USD",
                "payment" => [
                    "creditCard" => [
                        "cardNumber" => $_POST['cc_number'],
                        "expirationDate" => $_POST['cc_expires'],
                        "cardCode" => $_POST['cc_cvv']
                    ]
                ],
                "lineItems" => [
                    "lineItem" => $lineItems
                ],
                "tax" => [
                    "amount" => $order->info['tax'],
                    "name" => "Avatax"
                ],
                "shipping" => [
                    "amount" => $order->info['shipping_cost'],
                    "name" => $order->info['shipping_method']
                ],
                "poNumber" => $refId,
                "customer" => [
                    "id" => $_SESSION['customer_id']
                ],
                "billTo" => [
                    "firstName" => $order->billing['firstname'],
                    "lastName" => $order->billing['lastname'],
                    "address" => $order->billing['street_address'],
                    "city" => $order->billing['city'],
                    "state" => $order->billing['state'],
                    "zip" => $order->billing['postcode']
                ],
                "shipTo" => [
                    "firstName" => $order->delivery['firstname'],
                    "lastName" => $order->delivery['lastname'],
                    "address" => $order->delivery['street_address'],
                    "city" => $order->delivery['city'],
                    "state" => $order->delivery['state'],
                    "zip" => $order->delivery['postcode']
                ],
                "customerIP" => $_SESSION['customers_ip_address']
            ]
        ]
    ];

    return adn_call_api(adn_get_basic_configuration("opts", false, $data));
}

function adn_authorize_card($nextOrderId, $paymentInfo, $saveInfo, $shipping, $billing) {
    global $adn_debug;

    $lowOrderThreshold = 50.00;
    $lowOrderFee = 20.00;

    $subtotalAmount = $_SESSION['cart_calculated']['subtotal'];
    $shippingAmount = $_SESSION['cart_calculated']['shipping'];
    $taxAmount = $_SESSION['cart_calculated']['taxes'];
    $totalAmount = $subtotalAmount + $shippingAmount + $taxAmount;
    $couponAmount = 0.00;
    if (isset($_SESSION['cart_calculated']['coupon']))
    {
        $couponAmount = $_SESSION['cart_calculated']['coupon'];
    }
    $totalAmount -= $couponAmount;
    if ($subtotalAmount < $lowOrderThreshold) $totalAmount += $lowOrderFee;

    $subtotalAmount = number_format($subtotalAmount, 2, '.', '') . "";
    $shippingAmount = number_format($shippingAmount, 2, '.', '') . "";
    $taxAmount = number_format($taxAmount, 2, '.', '') . "";
    $couponAmount = number_format($couponAmount, 2, '.', '') . "";
    $totalAmount = number_format($totalAmount, 2, '.', '') . "";

    $invoiceID = $nextOrderId . '-' . zen_create_random_value(6, 'chars');

    if (strlen($shipping['company']) > 25) $shipping['company'] = substr($shipping['company'], 0, 22) . '...';
    if (strlen($billing['company']) > 25) $billing['company'] = substr($billing['company'], 0, 22) . '...';

    $lineItems = array();

    $products = $_SESSION['cart']->get_products();

    foreach ($products as $product)
    {
        $lineItemId = $product['id'];

        if (strpos($lineItemId, ':') !== false)
        {
            $lineItemId = substr($lineItemId, 0, strpos($lineItemId, ':'));
        }

        $lineItems[] = [
            "itemId" => $lineItemId,
            "name" => substr($product['name'], 0, 28),
            "description" => $product['model'],
            "quantity" => $product['quantity'],
            "unitPrice" => number_format($product['final_price'], 2, '.', '') . "",
            "taxable" => $_SESSION['taxes']['exempt']? 'false' : 'true'
        ];
    }

    if ($subtotalAmount < $lowOrderThreshold)
    {
        $lineItems[] = [
            "itemId" => "Minimum Order Fee",
            "name" => "Minimum Order Fee",
            "description" => "For Orders Under $50",
            "quantity" => 1,
            "unitPrice" => "20.00",
            "taxable" => $_SESSION['taxes']['exempt']? 'false' : 'true'
        ];
    }

    $customer_id = null;
    if (isset($_SESSION['customer_id'])) $customer_id = $_SESSION['customer_id'];
    if (isset($_SESSION['temp_customer_id'])) $customer_id = $_SESSION['temp_customer_id'];

    $data = array();

    if (in_array($paymentInfo['type'], array("guest", "new")))
    {
        $data = [
            "createTransactionRequest" => [
                "merchantAuthentication" => adn_get_basic_configuration("auth", false),
                "refId" => $invoiceID,
                "transactionRequest" => [
                    "transactionType" => "authOnlyTransaction",
                    "amount" => $totalAmount,
                    "currencyCode" => "USD",
                    "payment" => [
                        "creditCard" => [
                            "cardNumber" => $paymentInfo['cardNumber'],
                            "expirationDate" => $paymentInfo['expiration'],
                            "cardCode" => $paymentInfo['cardCode']
                        ],
                    ],
                    "profile" => [
                        "createProfile" => $saveInfo? 'true' : 'false'
                    ],
                    "order" => [
                        "invoiceNumber" => $invoiceID
                    ],
                    "lineItems" => [
                        "lineItem" => $lineItems
                    ],
                    "tax" => [
                        "amount" => $taxAmount,
                        "name" => "",
                        "description" => ""
                    ],
                    "shipping" => [
                        "amount" => $shippingAmount,
                        "name" => "",
                        "description" => ""
                    ],
                    "taxExempt" => $_SESSION['taxes']['exempt']? 'true' : 'false',
                    "customer" => [
                        "id" => $customer_id,
                        "email" => $_SESSION['customers_email_address']
                    ],
                    "billTo" => [
                        "firstName" => $billing['firstName'],
                        "lastName" => $billing['lastName'],
                        "company" => $billing['company'],
                        "address" => $billing['address'],
                        "city" => $billing['city'],
                        "state" => $billing['state'],
                        "zip" => $billing['zip'],
                        "country" => $billing['country'],
                    ],
                    "shipTo" => [
                        "firstName" => $shipping['firstName'],
                        "lastName" => $shipping['lastName'],
                        "company" => $shipping['company'],
                        "address" => $shipping['address'],
                        "city" => $shipping['city'],
                        "state" => $shipping['state'],
                        "zip" => $shipping['zip'],
                        "country" => $shipping['country'],
                    ],
                    "retail" => [
                        "marketType" => 0,
                        "deviceType" => 8
                    ],
                    "transactionSettings" => [
                        "setting" => [
                            [
                                "settingName" => "emailCustomer",
                                "settingValue" => 'true'
                            ]
                        ]
                    ]
                ]
            ]
        ];
    }
    else
    {
        $data = [
            "createTransactionRequest" => [
                "merchantAuthentication" => adn_get_basic_configuration("auth", false),
                "refId" => $invoiceID,
                "transactionRequest" => [
                    "transactionType" => "authOnlyTransaction",
                    "amount" => $totalAmount,
                    "currencyCode" => "USD",
                    "profile" => [
                        "customerProfileId" => $_SESSION['adn']['profile']['customerProfileId'],
                        "paymentProfile" => [
                            "paymentProfileId" => $paymentInfo['id']
                        ]
                    ],
                    "order" => [
                        "invoiceNumber" => $invoiceID
                    ],
                    "lineItems" => [
                        "lineItem" => $lineItems
                    ],
                    "tax" => [
                        "amount" => $taxAmount,
                        "name" => "",
                        "description" => ""
                    ],
                    "shipping" => [
                        "amount" => $shippingAmount,
                        "name" => "",
                        "description" => ""
                    ],
                    "taxExempt" => $_SESSION['taxes']['exempt']? 'true' : 'false',
                    "retail" => [
                        "marketType" => 0,
                        "deviceType" => 8
                    ],
                    "transactionSettings" => [
                        "setting" => [
                            "settingName" => "emailCustomer",
                            "settingValue" => 'true'
                        ]
                    ]
                ]
            ]
        ];
    }

    if ($adn_debug)
    {
        $debug_data = $data;

        if (isset($debug_data['createTransactionRequest']['transactionRequest']['payment']['creditCard']))
        {
            $debug_data['createTransactionRequest']['transactionRequest']['payment']['creditCard']['cardNumber'] = str_repeat('X', MAX(4, strlen($debug_data['createTransactionRequest']['transactionRequest']['payment']['creditCard']['cardNumber'])) - 4) . substr($debug_data['createTransactionRequest']['transactionRequest']['payment']['creditCard']['cardNumber'], -4);
            $debug_data['createTransactionRequest']['transactionRequest']['payment']['creditCard']['expirationDate'] = preg_replace("/[^\/]/", "*", $debug_data['createTransactionRequest']['transactionRequest']['payment']['creditCard']['expirationDate']);
            $debug_data['createTransactionRequest']['transactionRequest']['payment']['creditCard']['cardCode'] = str_repeat('X', strlen($debug_data['createTransactionRequest']['transactionRequest']['payment']['creditCard']['cardCode']));
        }

        return array(
            "auth" => adn_call_api(adn_get_basic_configuration("opts", false, $data)),
            "debug" => $debug_data
        );
    }
    else
    {
        return adn_call_api(adn_get_basic_configuration("opts", false, $data));
    }
}

function adn_authorize_profile() {

}

//reserved for future
function adn_capture_auth() {
    return false;
}

function adn_refund($refId, $amount, $cardnum, $refTrans) {

    $data = [
        "createTransactionRequest" => [
            "merchantAuthentication" => adn_get_basic_configuration("auth", false),
            "refId" => $refId,
            "transactionRequest" => [
                "transactionType" => "refundTransaction",
                "amount" => $amount,
                "payment" => [
                    "creditCard" => [
                        "cardNumber" => $cardnum,
                        "expirationDate" => "XXXX"
                    ]
                ],
                "refTransId" => $refTrans
            ]
        ]
    ];


    return adn_call_api(adn_get_basic_configuration("opts", false, $data));
}

function adn_void($refId, $transId) {
    
    $data = [
        "createTransactionRequest" => [
            "merchantAuthentication" => adn_get_basic_configuration("auth", false),
            "refId" => $refId,
            "transactionRequest" => [
                "transactionType" => "voidTransaction",
                "refTransId" => $transId
            ]
        ]
    ];

    return adn_call_api(adn_get_basic_configuration("opts", false, $data));
}

function adn_get_held($limit = "100", $offset = "1", $orderBy = "id", $orderDescending = false, $status = "pendingApproval", $refId = "") {

    $data = [
        "getUnsettledTransactionListRequest" => [
            "merchantAuthentication" => adn_get_basic_configuration("auth", false),
            "refId" => $refId,
            "status" => $status,
            "sorting" => [
                "orderBy" => $orderBy,
                "orderDescending" => $orderDescending
            ],
            "paging" => [
                "limit" => $limit,
                "offset" => $offset
            ]
        ]
    ];

    $options = adn_get_basic_configuration("opts", false, $data);

    return adn_call_api($options, false);
}

function adn_get_details($tid) {

    $data = [
        "getTransactionDetailsRequest" => [
            "merchantAuthentication" => adn_get_basic_configuration("auth", false),
            "transId" => $tid
        ]
    ];

    $options = adn_get_basic_configuration("opts", false, $data);

    return adn_call_api($options, false);
}

function adn_approve_held() {

}

function adn_decline_held() {

}

function adn_create_profile($details, $live = false) {

    $data = [
        "createCustomerProfileRequest" => [
            "merchantAuthentication" => adn_get_basic_configuration("auth", $live),
            "profile" => $details
        ]
    ];

    return adn_call_api(adn_get_basic_configuration("opts", $live, $data));
}

function adn_get_profile($id, $live = false) {

    $data = [
        "getCustomerProfileRequest" => [
            "merchantAuthentication" => adn_get_basic_configuration("auth", $live),
            "merchantCustomerId" => $id
        ]
    ];

    return adn_call_api(adn_get_basic_configuration("opts", $live, $data));
}

function adn_get_profiles($live = false) {
    
    $data = [
        "getCustomerProfileIdsRequest" => [
            "merchantAuthentication" => adn_get_basic_configuration("auth", $live),
        ]
    ];

    return adn_call_api(adn_get_basic_configuration("opts", $live, $data));
}

function adn_update_profile($details, $live = false) {

    $data = [
        "updateCustomerProfileRequest" => [
            "merchantAuthentication" => adn_get_basic_configuration("auth", $live),
            "profile" => $details
        ]
    ];

    return adn_call_api(adn_get_basic_configuration("opts", $live, $data));
}

function adn_delete_profile($cid, $live = false) {

    $data = [
        "deleteCustomerProfileRequest" => [
            "merchantAuthentication" => adn_get_basic_configuration("auth", $live),
            "customerProfileId" => $cid
        ]
    ];

    return adn_call_api(adn_get_basic_configuration("opts", $live, $data));
}

function adn_create_payment_profile($pid, $billto, $card, $default, $validation = 'testMode', $live = false) {
    
    $data = [
        "createCustomerPaymentProfileRequest" => [
            "merchantAuthentication" => adn_get_basic_configuration("auth", $live),
            "customerProfileId" => $pid,
            "paymentProfile" => [
                "billTo" => [
                    $billto
                ],
                "payment" => [
                    "creditCard" => $card
                ],
                "defaultPaymentProfile" => $default
            ],
            "validationMode" => $validation
        ]
    ];

    return adn_call_api(adn_get_basic_configuration("opts", $live, $data));
}

function adn_get_payment_profile($cid, $pid, $live = false) {
    
    $data = [
        "getCustomerPaymentProfileRequest" => [
            "merchantAuthentication" => adn_get_basic_configuration("auth", $live),
            "customerProfileId" => $cid,
            "customerPaymentProfileId" => $pid
        ]
    ];

    return adn_call_api(adn_get_basic_configuration("opts", $live, $data));
}

function adn_get_payment_profiles($pid, $live = false) {
    
    $data = [
        "getCustomerPaymentProfileListRequest" => [
            "merchantAuthentication" => adn_get_basic_configuration("auth", $live),
            "customerProfileId" => $pid
        ]
    ];

    return adn_call_api(adn_get_basic_configuration("opts", $live, $data));
}

function adn_validate_payment_profile($cid, $payid, $validation = "testMode", $live = false) {
    
    $data = [
        "validateCustomerPaymentProfileRequest" => [
            "merchantAuthentication" => adn_get_basic_configuration("auth", $live),
            "merchantCustomerId" => $cid,
            "customerPaymentProfileId" => $payid,
            "validationMode" => $validation
        ]
    ];

    return adn_call_api(adn_get_basic_configuration("opts", $live, $data));
}

function adn_update_payment_profile($cid, $billto, $card, $payid, $default = false, $validation = "testMode", $live = false) {
    
    $data = [
        "updateCustomerPaymentProfileRequest" => [
            "merchantAuthentication" => adn_get_basic_configuration("auth", $live),
            "merchantCustomerId" => $cid,
            "paymentProfile" => [
                "billTo" => $billto,
                "payment" => [
                    "creditCard" => $card
                ],
                "defaultPaymentProfile" => $default,
                "customerPaymentProfileId" => $payid
            ],
            "validationMode" => $validation
        ]
    ];

    return adn_call_api(adn_get_basic_configuration("opts", $live, $data));
}

function adn_delete_payment_profile($pid, $payid, $live = false) {
    
    $data = [
        "deleteCustomerPaymentProfileRequest" => [
            "merchantAuthentication" => adn_get_basic_configuration("auth", $live),
            "customerProfileId" => $pid,
            "customerPaymentProfileId" => $payid
        ]
    ];

    return adn_call_api(adn_get_basic_configuration("opts", $live, $data));
}

function adn_create_address($pid, $address, $default = false, $live = false) {
    
    $data = [
        "createCustomerShippingAddressRequest" => [
            "merchantAuthentication" => adn_get_basic_configuration("auth", $live),
            "customerProfileId" => $pid,
            "address" => $address,
            "defaultShippingAddress" => $default
        ]
    ];

    return adn_call_api(adn_get_basic_configuration("opts", $live, $data));
}

function adn_get_address($cid, $aid, $live = false) {
    
    $data = [
        "getCustomerShippingAddressRequest" => [
            "merchantAuthentication" => adn_get_basic_configuration("auth", $live),
            "merchantCustomerId" => $cid
        ]
    ];

    if (!empty($aid)) {
        $data['getCustomerShippingAddressRequest']['customerAddressId'] = $aid;
    }

    return adn_call_api(adn_get_basic_configuration("opts", $live, $data));
}

function adn_update_address($cid, $address, $default = false, $live = false) {
    
    $data = [
        "updateCustomerShippingAddressRequest" => [
            "merchantAuthentication" => adn_get_basic_configuration("auth", $live),
            "merchantCustomerId" => $cid,
            "address" => $address,
            "defaultShippingAddress" => $default
        ]
    ];

    return adn_call_api(adn_get_basic_configuration("opts", $live, $data));
}

function adn_delete_address($pid, $aid, $live = false) {
    
    $data = [
        "deleteCustomerShippingAddressRequest" => [
            "merchantAuthentication" => adn_get_basic_configuration("auth", $live),
            "customerProfileId" => $pid,
            "customerAddressId" => $aid
        ]
    ];

    return adn_call_api(adn_get_basic_configuration("opts", $live, $data));
}

function adn_create_profile_from_trans($tid, $live = false) {
    
    $data = [
        "createCustomerProfileFromTransactionRequest" => [
            "merchantAuthentication" => adn_get_basic_configuration("auth", $live),
            "transId" => $tid
        ]
    ];

    return adn_call_api(adn_get_basic_configuration("opts", $live, $data));
}

function adn_profile_check($cid, $email) {
    global $db;

    $check1 = $db->Execute("SELECT * FROM `zen_authorizenet_profiles` WHERE `cid` = {$cid}");
    if (!empty($check1->fields)) return array('messages' => array('resultCode' => "Error", 'message' => "This customer ID is already associated with a ADN profile.", "pid" => $check1->fields['pid']));
    $check2 = $db->Execute("SELECT * FROM `zen_authorizenet_profiles` WHERE `email` = '{$email}'");
    if (!empty($check2->fields)) return array('messages' => array('resultCode' => "Error", 'message' => "This email account is already associated with a ADN profile.", "pid" => $check2->fields['pid']));

    return 1;
}

function adn_call_api($opts, $production_override = false) {
    global $production;
    $production = ($production_override)? true : $production;
    $api_url = "";

    if ($production) {
        $api_url = "https://api.authorize.net/xml/v1/request.api";
    } else {
        $api_url = "https://apitest.authorize.net/xml/v1/request.api";
    }

    $context = stream_context_create($opts);
    $resultOfApi = file_get_contents($api_url, false, $context, 3);

    if ($resultOfApi !== FALSE) 
    {
        $result = json_decode($resultOfApi, true);
    
        if (!$production) {
            $result['debug']['url'] = $api_url;
            $result['debug']['opts'] = json_decode($opts['http']['content'], true);
        }
    
        return $result;
    }
    else
    {
        return array("code" => 0, "message" => "FGC failed.");
    }

}