<?php

/**
 * ot_avatax order-total module
 *
 * @package orderTotal
 * @copyright Copyright 2014 Avalara, Inc.
 * @version 1.0WT 2021-28-10 16:00:00Z ecmoore213 $
 */

if (file_exists('includes/modules/avatax/config.avatax.php'))
{
    require 'includes/modules/avatax/config.avatax.php';
}
else
{
    require '../includes/modules/avatax/config.avatax.php';
}

function avatax_verify_address($address)
{
  $data = [
    "line1" => $address['line1'],
    "line2" => $address['line2'],
    "line3" => $address['line3'],
    "textCase" => "Mixed",
    "city" => $address['city'],
    "region" => $address['region'],
    "country" => "US",
    "postalCode" => $address['postalCode']
  ];

  $curl_opts = avatax_get_basic_configuration(array("curl_opts", "POST", $data));

  return avatax_call_api("api/v2/addresses/resolve", $curl_opts);
}

function avatax_create_customer($customer_details, $address_shipping, $exposure_zones)
{
  $check = avatax_get_customer($customer_details['customers_id']);

  if (isset($check['error']['code']) && !isset($address['messages'][0]['severity']))
  {
    if ($check['error']['code'] == "EntityNotFoundError")
    {
      $company_id = avatax_get_basic_configuration()['value'][0]['id'];

      $data = [
        "companyId" => $company_id,
        "customerCode" => $customer_details['customers_id'],
        "name" => $customer_details['customers_firstname'] . ' ' . $customer_details['customers_lastname'],
        "line1" => $address_shipping['line1'],
        "city" => $address_shipping['city'],
        "postalCode" => $address_shipping['postalCode'],
        "phoneNumber" => $customer_details['customers_telephone'],
        "emailAddress" => $customer_details['customers_email_address'],
        "contactName" => $customer_details['customers_firstname'] . ' ' . $customer_details['customers_lastname'],
        "country" => $address_shipping['country'],
        "region" => $address_shipping['region'],
        "exposureZones" => $exposure_zones
      ];
      
      $curl_opts = avatax_get_basic_configuration(array("curl_opts", "POST", $data));

      return avatax_call_api("api/v2/companies/{$company_id}/customers", $curl_opts);
    }
  }
  else
  {
    if (isset($check['customerCode']))
    {
      return $check;
    }
  }
}

function avatax_get_customer($customer_id)
{
  $company_id = avatax_get_basic_configuration()['value'][0]['id'];

  $curl_opts = avatax_get_basic_configuration(array("curl_opts", "GET"));

  $customer_id = urlencode($customer_id);

  $customer_id = str_replace("+", "%20", $customer_id);

  return avatax_call_api(("api/v2/companies/{$company_id}/customers/$customer_id"), $curl_opts);
}

function avatax_delete_customer($customer_id)
{
  $company_id = avatax_get_basic_configuration()['value'][0]['id'];

  $curl_opts = avatax_get_basic_configuration(array("curl_opts", "DELETE"));

  return avatax_call_api(("api/v2/companies/{$company_id}/customers/" . urlencode($customer_id)), $curl_opts);
}

function avatax_get_customers()
{
  $company_id = avatax_get_basic_configuration()['value'][0]['id'];

  $curl_opts = avatax_get_basic_configuration(array("curl_opts", "GET"));

  return avatax_call_api("api/v2/companies/{$company_id}/customers", $curl_opts);
}

function avatax_get_customers_by_certificate($certificate_id)
{
  $company_id = avatax_get_basic_configuration()['value'][0]['id'];

  $curl_opts = avatax_get_basic_configuration(array("curl_opts", "GET"));

  $customers = array();

  $certinfo = avatax_call_api("api/v2/companies/{$company_id}/certificates/{$certificate_id}?%24include=customers", $curl_opts)['customers'];

  foreach ($certinfo as $customer)
  {
    array_push($customers, $customer['customerCode']);
  }

  return $customers;
}

function avatax_lookup_tax($order, $products, $shipping)
{
  $line = 1;
  $taxCode = "P0000000";
  $lines = array();

  $shippingTaxCode = "FR02000";
  $shippingAndHandlingTaxCode = "FR03000";

  $manfs_charge_labor = array(
    '67', '228', '36', '112', '22', '57'
  );

  $lowOrderThreshold = 50.00;
  $lowOrderFee = 20.00;
  $subtotalAmount = 0.00;

  foreach ($products as $product)
  {
    array_push($lines, array(
      'number' => $line,
      'itemCode' => $product['itemCode'],
      'description' => $product['name'],
      'taxCode' => $taxCode,
      'quantity' => $product['quantity'],
      'amount' => $product['final_price'] * $product['quantity'],
      'discounted' => isset($coupon['id']),
      'ref1' => $product['final_price'],
      'ref2' => $product['quantity']
    ));

    $subtotalAmount += $product['final_price'] * $product['quantity'];

    $line++;

    if (in_array($product['manf'], $manfs_charge_labor))
    {
      $shippingTaxCode = $shippingAndHandlingTaxCode;
    }
  }

  if (isset($shipping['code']) && $shipping['code'] == 1)
  {
    array_push($lines, array(
      'number' => $line,
      'itemCode' => 'Shipping',
      'description' => 'Shipping',
      'taxCode' => $shippingTaxCode,
      'quantity' => 1,
      'amount' => $shipping['values']['total']
    ));

    $line++;
  }

  $coupon = array();

  if (isset($_SESSION['coupon']))
  {
    $coupon['id'] = $_SESSION['coupon']['code'];
    $coupon['type'] = $_SESSION['coupon']['type'];
    $coupon['amount'] = $_SESSION['coupon']['amount'];
  }

  if ($subtotalAmount < $lowOrderThreshold)
  {
    array_push($lines, array(
      'number' => $line,
      'itemCode' => "LOF",
      "description" => "Minimum Order Fee",
      "taxCode" => $taxCode,
      "quantity" => 1,
      "amount" => $lowOrderFee
    ));

    $line++;
  }

  if(isset($coupon['id']))
  {
    if ($coupon['type'] == 'F')
    {
      $coupon_value = $coupon['amount'] * -1;
      array_push($lines, array(
        'number' => $line,
        'itemCode' => 'Coupon',
        'description' => 'Coupon DiscountF',
        'taxCode' => 'OD010000',
        'quantity' => 1,
        'amount' => $coupon_value
      ));
      
      $line++;
    }

    if ($coupon['type'] == 'P')
    {
      array_push($lines, array(
        'number' => $line,
        'itemCode' => 'Coupon',
        'description' => 'Coupon DiscountP',
        'taxCode' => 'OD010000',
        'quantity' => 1,
        'amount' => $coupon['amount'] * -1 * $order['subtotal'],
      ));
      
      $line++;
    }
  }

  $data = [
    "lines" => $lines,
    "type" => 'SalesInvoice',
    "companyCode" => avatax_get_basic_configuration()['value'][0]['companyCode'],
    "date" => date("Y-m-d"),
    "customerCode" => $order['customer_id'],
    "purchaseOrderNo" => $order['id'],
    "addresses" => [
      "shipFrom" => [
        'line1' => '195 W 3900 S',
        'city' => 'Milcreek',
        'region' => 'UT',
        'country' => 'US',
        'postalCode' => '84157',
      ],
      "shipTo" => [
        'line1' => $shipping['line1'],
        'line2' => $shipping['line2'],
        'city' => $shipping['city'],
        'region' => $shipping['region'],
        'country' => $shipping['country'],
        'postalCode' => $shipping['postalCode'],
      ]
    ],
    "commit" => false,
    "currencyCode" => "USD",
    "description" => date("Y-m-d H:i:s")
  ];

  $curl_opts = avatax_get_basic_configuration(array("curl_opts", "POST", $data));

  $tax_info = avatax_call_api("api/v2/transactions/create/", $curl_opts);

  // return $tax_info;

  return array(
    "request" => $data,
    "response" => $tax_info
  );
}

function avatax_get_transaction_by_code($transaction_code) {
  $company_code = avatax_get_basic_configuration()['value'][0]['companyCode'];

  $curl_opts = avatax_get_basic_configuration(array("curl_opts", "GET"));

  return avatax_call_api("api/v2/companies/{$company_code}/transactions/{$transaction_code}", $curl_opts);
}

function avatax_commit_transaction($transaction_id, $commit = true)
{
  $company_code = avatax_get_basic_configuration()['value'][0]['companyCode'];
  $curl_opts = array();
  $commit_string = "";

  if ($commit)
  {
    $fields = [
      "commit" => true
    ];

    $curl_opts = array(
      CURLOPT_HTTPHEADER => array(
        'Accept: application/json',
        'Authorization: Basic ' . base64_encode('webdev@westechequipment.com:WestechDev@1971'),
        'Content-type: application/json'
      ),
      CURLOPT_RETURNTRANSFER => TRUE,
      CURLOPT_FOLLOWLOCATION => FALSE,
      CURLOPT_POST => TRUE,
      CURLOPT_SSL_VERIFYPEER => TRUE,
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_CONNECTTIMEOUT => 10,
      CURLOPT_POSTFIELDS => json_encode($fields),
    );
    $commit_string = "commit";
  }
  else
  {
    $curl_opts = array(
      CURLOPT_HTTPHEADER => array(
        'Accept: application/json',
        'Authorization: Basic ' . base64_encode('webdev@westechequipment.com:WestechDev@1971'),
        'Content-type: application/json'
      ),
      CURLOPT_RETURNTRANSFER => TRUE,
      CURLOPT_FOLLOWLOCATION => FALSE,
      CURLOPT_POST => TRUE,
      CURLOPT_SSL_VERIFYPEER => TRUE,
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_CONNECTTIMEOUT => 10
    );
    $commit_string = "uncommit";
  }

  $result = avatax_call_api("api/v2/companies/{$company_code}/transactions/{$transaction_id}/{$commit_string}", $curl_opts);

  return $result;
}

function avatax_refund_transaction($transaction_id, $mode = array("full"))
{
  $company_code = avatax_get_basic_configuration()['value'][0]['companyCode'];

  $data = [];

  switch($mode[0])
  {
    case "full":
      $data = [
        "refundTransactionCode" => $transaction_id,
        "refundDate" => date("Y-m-d"),
        "refundType" => "Full",
        "referenceCode" => ""
      ];
      break;
    case "partial":
      $data = [
        "refundTransactionCode" => $transaction_id,
        "refundDate" => date("Y-m-d"),
      ];
      break;
    case "taxOnly":
      break;
  }

  $curl_opts = avatax_get_basic_configuration(array("curl_opts", "POST", $data));

  return avatax_call_api("api/v2/companies/{$company_code}/transactions/{$transaction_id}/void", $curl_opts);
}

function avatax_void_transaction($transaction_id)
{
  $company_code = avatax_get_basic_configuration()['value'][0]['companyCode'];

  $data = [
    "code" => "DocVoided"
  ];

  $curl_opts = avatax_get_basic_configuration(array("curl_opts", "POST", $data));

  return avatax_call_api("api/v2/companies/{$company_code}/transactions/{$transaction_id}/void", $curl_opts);
}

function avatax_create_certificate($cert_data, $exposure_zones)
{
  $company_id = avatax_get_basic_configuration()['value'][0]['id'];

  $result = array();

  foreach ($exposure_zones as $zone)
  {
    foreach ($zone as $zK => $zV)
    {
      $data = [
        "signedDate" => $cert_data['signedDate'],
        "expirationDate" => $cert_data['expDate'],
        "filename" => $cert_data['filename'],
        "documentExists" => true,
        "valid" => true,
        "verified" => false,
        "isSingleCertificate" => false,
        "exemptionNumber" => $cert_data['taxNumber'],
        "taxNumberType" => $cert_data['taxType'],
        "exemptionReason" => [
          "name" => $cert_data['exemptionReason']
        ],
        "customers" => [
          [
            "companyId" => $company_id,
            "customerCode" => $cert_data['customers']['customerCode'],
            "name" => $cert_data['customers']['name'],
            "line1" => $cert_data['customers']['line1'],
            "city" => $cert_data['customers']['city'],
            "region" => $cert_data['customers']['region'],
            "postalCode" => $cert_data['customers']['postalCode'],
            "country" => $cert_data['customers']['country'],
            "exposureZones" => $exposure_zones
          ]
        ],
        "exposureZone" => [
          "name" => $zV
        ]
      ];
    
      $curl_opts = avatax_get_basic_configuration(array("curl_opts", "POST", $data));
    
      $result[] = avatax_call_api("api/v2/companies/{$company_id}/certificates", $curl_opts);
    }
  }

  return $result;
}

function avatax_link_certificate($customer_id, $certificate_id) {}

function avatax_get_certificate_by_id($cert_id)
{
  $company_id = avatax_get_basic_configuration()['value'][0]['id'];

  $curl_opts = avatax_get_basic_configuration(array("curl_opts", "GET"));

  return avatax_call_api("api/v2/companies/{$company_id}/certificates/{$cert_id}?%24include=customers%2Cpo_numbers", $curl_opts);
}

function avatax_get_certificates()
{
  $company_id = avatax_get_basic_configuration()['value'][0]['id'];

  $curl_opts = avatax_get_basic_configuration(array("curl_opts", "GET"));

  return avatax_call_api("api/v2/companies/{$company_id}/certificates", $curl_opts);
}

function avatax_get_certificates_by_customer($customer_id)
{
  $company_id = avatax_get_basic_configuration()['value'][0]['id'];

  $curl_opts = avatax_get_basic_configuration(array("curl_opts", "GET"));

  return avatax_call_api("api/v2/companies/{$company_id}/customers/{$customer_id}/certificates", $curl_opts);
}

function avatax_unlink_customers_from_certificate($customers, $certificate_id)
{
  $company_id = avatax_get_basic_configuration()['value'][0]['id'];

  $data = [
    "customers" => [
      $customers
    ]
  ];

  $curl_opts = avatax_get_basic_configuration(array("curl_opts", "POST", $data));

  return avatax_call_api("api/v2/companies/{$company_id}/certificates/{$certificate_id}/customers/unlink", $curl_opts);
}

function avatax_delete_certificate($certificate_id)
{
  $company_id = avatax_get_basic_configuration()['value'][0]['id'];

  $curl_opts = avatax_get_basic_configuration(array("curl_opts", "DELETE"));

  return avatax_call_api("api/v2/companies/{$company_id}/certificates/{$certificate_id}", $curl_opts);
}

function avatax_get_exemption_reasons($include_all = false)
{

  $curl_opts = avatax_get_basic_configuration(array("curl_opts", "GET"));

  $reasons = avatax_call_api("api/v2/definitions/certificateexemptreasons", $curl_opts);

  if ($include_all) return $reasons;

  $reasons_trimmed = array();

  foreach ($reasons['value'] as $reason)
  {
    if (!preg_match('/(exposure|non-nexus|taxable|other)/i', $reason['name']))
    {
      array_push($reasons_trimmed, $reason['name']);
    }
  }

  return $reasons_trimmed;
}