<?php

$freightquote_live_endpoint = true;

$credentials = array(
    'production' => array(
        'url' => 'https://api.navisphere.com',
        'clientID' => '0oa1469czjmjHVEpD358',
        'clientSecret' => 'y28hopiYIq0mnZKclmOJ3t51yItzyvyhlK1ujY00qUloZBKpI7oFhCXAM9yRxSyp'
    ),
    'sandbox' => array(
        'url' => 'https://sandbox-api.navisphere.com',
        'clientID' => '0oa144l3mlwksiONa358',
        'clientSecret' => 'ANRw7VyakgeU93UmM3Jbeb7JpZO84M8_wxj5qdnbpl9UBo0ndF2J14QKQzfDinsj'
    )
);

function freightquote_get_bearer_token() {
    global $freightquote_live_endpoint;
    global $credentials;

    $useCredentials = ($freightquote_live_endpoint)? 'production' : 'sandbox';

    $clientID = $credentials[$useCredentials]['clientID'];
    $clientSecret = $credentials[$useCredentials]['clientSecret'];

    $filename = strrev(hash('md5', 'freightquote_bearer_' . $useCredentials . '_' . $clientID)) . '.txt';

    if (file_exists($filename)) {
        $fileContents = file_get_contents($filename);
        $fileContentsJ = json_decode($fileContents, true);

        if ((time() - filectime($filename)) > $fileContentsJ['expires_in']) {
            unlink($filename);
        } else {
            return array(
                'code' => 1,
                'received' => $fileContentsJ,
                'token' => $fileContentsJ['access_token']
            );
        }
    }

    $url = $credentials[$useCredentials]['url'] . '/v1/oauth/token';
    
    $ch = curl_init();

    $payload = array(
        'client_id' => "$clientID",
        'client_secret' => "$clientSecret",
        'audience' => 'https://inavisphere.chrobinson.com',
        'grant_type' => 'client_credentials'
    );

    curl_setopt_array($ch, array(
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json'
            ),
            CURLOPT_POSTFIELDS => json_encode($payload),
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => "POST"
        )
    );

    $cResponse = curl_exec($ch);
    $cError = curl_error($ch);

    curl_close($ch);

    if ($cError) {
        return array(
            'code' => 0,
            'message' => $cError,
            'sent' => $payload
        );

        return;
    }

    $cResponseAssoc = json_decode($cResponse, true);

    $bearerFile = fopen($filename, 'w');

    fwrite($bearerFile, $cResponse);

    fclose($bearerFile);

    return array(
        'code' => 1,
        'received' => $cResponseAssoc,
        'token' => $cResponseAssoc['access_token']
    );
}

function freightquote_call_api($endpoint, $data) {
    global $freightquote_live_endpoint;
    global $credentials;

    $useCredentials = ($freightquote_live_endpoint)? 'production' : 'sandbox';

    $url = $credentials[$useCredentials]['url'] . $endpoint;

    $bearerToken = freightquote_get_bearer_token();

    $ch = curl_init();

    curl_setopt_array($ch, array(
            CURLOPT_HTTPHEADER => array(
                "Authorization: Bearer {$bearerToken['token']}",
                'Content-Type: application/json'
            ),
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => "POST"
        )
    );

    $cResponse = curl_exec($ch);
    $cError = curl_error($ch);

    curl_close($ch);

    if ($cError) {
        return array(
            'code' => 0,
            'message' => $cError,
            'sent' => $data
        );

        return;
    }

    $cResponseAssoc = json_decode($cResponse, true);

    return array(
        'code' => 1,
        'sent' => $data,
        'received' => $cResponseAssoc
    );
}