function checkInput($input) {
    if($input.val() === "" || $input.val() == null || $input.val() == undefined) {
        $input.toggleClass("input-error", true);
        return true;
    }
    $input.toggleClass("input-error", false);
    return false;
}

function removeInputError($input) {
    $input.toggleClass("input-error", false);
}

async function updateAccount() {
    const $alertInfoAccountContainer = $("#account-info-alert-container");
    const $firstName = $("#account-first-name");
    const $lastName = $("#account-last-name");
    const $phoneNumber = $("#account-phone");
    let errors = false;

    checkInput($phoneNumber) ? errors = true : "";
    checkInput($firstName) ? errors = true : "";
    checkInput($lastName) ? errors = true : "";

    if(errors) return $alertInfoAccountContainer.html('<div class="alert alert-danger" role="alert">All Fields Are Required</div>');

    const data = {
        "firstName": $firstName.val().trim(),
        "lastName": $lastName.val().trim(),
        "phone": $phoneNumber.val().trim(),
    };
    let results = await $.ajax({
        type: "POST",
        url: "ajax_account.php",
        data: {
        "post-action": "update-account-info",
        "post-data": data
        }
    });
    results = JSON.parse(results);
    if(results.code === 0) {
        return $alertInfoAccountContainer.html(`<div class="alert alert-danger" role="alert">${results.message}</div>`);
    }
    $alertInfoAccountContainer.html(`<div class="alert alert-success" role="alert">${results.message}</div>`);
}

async function updateProductNotifications() {
    const $notificationsAlertcontainer = $("#notifications-alert-container");
    const $newsletterCheckbox = $("#newsletter");
    const wantsToSubscribe = $newsletterCheckbox.is(":checked");

    let results = await $.ajax({
        type: "POST",
        url: "ajax_account.php",
        data: {
        "post-action": "update-account-subscription",
        "post-data": {
            "subscribed": wantsToSubscribe
        }
        }
    });
    results = JSON.parse(results);
    if(results.code == 0) {
        return $notificationsAlertcontainer.html(`<div class="alert alert-danger" role="alert">${results.message}</div>`);
    }
    $notificationsAlertcontainer.html(`<div class="alert alert-success" role="alert">${results.message}</div>`);
}

async function updatePassword() {
    const $passwordResetAlertcontainer = $("#password-reset-alert-container");
    const $currentPassword = $("#current-password");
    const $newPassword = $("#new-password");
    const $confirmNewPassword = $("#confirm-new-password");

    let errors = false;

    checkInput($currentPassword) ? errors = true : "";
    checkInput($newPassword) ? errors = true : "";
    checkInput($confirmNewPassword) ? errors = true : "";

    if (errors) {
        return $passwordResetAlertcontainer.html('<div class="alert alert-danger" role="alert">All Fields Are Required</div>');
    }

    const data = {
        "currentPassword": $currentPassword.val().trim(),
        "newPassword": $newPassword.val().trim(),
        "confirmNewPassword": $confirmNewPassword.val().trim()
    }
    let results = await $.ajax({
        type: "POST",
        url: "ajax_account.php",
        data: {
        "post-action": "update-account-password",
        "post-data": data
        }
    });
    results = JSON.parse(results);
    if(results.code === 0) {
        return $passwordResetAlertcontainer.html(`<div class="alert alert-danger" role="alert">${results.message}</div>`);
    }
    $passwordResetAlertcontainer.html(`<div class="alert alert-success" role="alert">${results.message}</div>`);
}

async function updateAddress() {
    const $addressBookAlertContainer = $("#address-book-alert-container");
    const $addressBookListItem = $("#address-book-list").find(":selected");
    const addressBookId = $addressBookListItem.data("address-book-id");
    const $defaultAddress = $("#default-address");
    // const $addressName = $("#address-name");
    const $companyName = $("#company-name");
    const $firstName = $("#first-name");
    const $lastName = $("#last-name");
    const $streetAddressOne = $("#street-address");
    const $streetAddressTwo = $("#street-address-two");
    const $streetAddressThree = $("#street-address-three");
    const $city = $("#city");
    const $state = $("#state");
    const $zip = $("#zip-code");
    const $country = $("#country");
    let errors = false;

    // checkInput($addressName) ? errors = true : "";
    checkInput($firstName) ? errors = true : "";
    checkInput($lastName) ? errors = true : "";
    checkInput($streetAddressOne) ? errors = true : "";
    checkInput($city) ? errors = true : "";
    checkInput($state) ? errors = true : "";
    checkInput($zip) ? errors = true : "";

    if(errors) return;

    const data = {
        // "addressName": $addressName.val().trim(),
        "companyName": $companyName.val().trim(),
        "firstName": $firstName.val().trim(),
        "lastName": $lastName.val().trim(),
        "streetAddressOne": $streetAddressOne.val().trim(),
        "streetAddressTwo": $streetAddressTwo.val().trim(),
        "streetAddressThree": $streetAddressThree.val().trim(),
        "city": $city.val().trim(),
        "state": $state.val(),
        "zip": $zip.val().trim(),
        "country": $country.val().trim(),
        "defaultAddress": $defaultAddress.is(":checked"),
        "addressBookId": addressBookId,
    };
    // Update Data
    let results = await $.ajax({
        type: "POST",
        url: "ajax_address_book.php",
        data: {
        "post-action": "update-address",
        "post-data": data,
        }
    });
    console.log(results);
    resultsJ = JSON.parse(results);
    if(resultsJ.code == 0) return $addressBookAlertContainer.html(`<div class="alert alert-danger" role="alert">${resultsJ.message}</div>`);
    $addressBookAlertContainer.html(`<div class="alert alert-success" role="alert">${resultsJ.message}</div>`);
    $addressBookListItem.data("default", "true");
}

async function deleteAddress() {
    const $addressBookAlertContainer = $("#address-book-alert-container");
    const $addressBookListItem = $("#address-book-list").find(":selected");
    const addressBookId = $addressBookListItem.data("address-book-id");
    const isDefaultAddress = $addressBookListItem.data("default");
    let results = await $.ajax({
        type: "POST",
        url: "ajax_address_book.php",
        data: {
        "post-action": "delete-address",
        "post-data": {
            "addressId": addressBookId,
            "defaultAddress": isDefaultAddress
        }
        }
    });
    results = JSON.parse(results);
    if(results.code == 0) {
        return $addressBookAlertContainer.html(`<div class="alert alert-danger" role="alert">${results.message}</div>`);
    }   
    $addressBookAlertContainer.html(`<div class="alert alert-success" role="alert">${results.message}</div>`);
}

async function saveAddress() {
    const $addressBookAlertContainer = $("#address-book-alert-container");
    const $defaultAddress = $("#default-address");
    // const $addressName = $("#address-name");
    const $companyName = $("#company-name");
    const $firstName = $("#first-name");
    const $lastName = $("#last-name");
    const $streetAddressOne = $("#street-address");
    const $streetAddressTwo = $("#street-address-two");
    const $streetAddressThree = $("#street-address-three");
    const $city = $("#city");
    const $state = $("#state");
    const $zip = $("#zip-code");
    const $country = $("#country");
    let errors = false;

    // checkInput($addressName) ? errors = true : "";
    checkInput($firstName) ? errors = true : "";
    checkInput($lastName) ? errors = true : "";
    checkInput($streetAddressOne) ? errors = true : "";
    checkInput($city) ? errors = true : "";
    checkInput($state) ? errors = true : "";
    checkInput($zip) ? errors = true : "";

    if(errors) return $addressBookAlertContainer.html('<div class="alert alert-danger" role="alert">All Fields Are Required</div>');

    const data = {
        // "addressName": $addressName.val().trim(),
        "companyName": $companyName.val().trim(),
        "firstName": $firstName.val().trim(),
        "lastName": $lastName.val().trim(),
        "streetAddressOne": $streetAddressOne.val().trim(),
        "streetAddressTwo": $streetAddressTwo.val().trim(),
        "streetAddressThree": $streetAddressThree.val().trim(),
        "city": $city.val().trim(),
        "state": $state.val(),
        "zip": $zip.val().trim(),
        "country": $country.val().trim(),
        "defaultAddress": $defaultAddress.is(":checked"),
    };
    // Save Data
    let results = await $.ajax({
        type: "POST",
        url: "ajax_address_book.php",
        data: {
        "post-action": "add-new-address",
        "post-data": data
        }
    });
    results = JSON.parse(results);
    if(results.code == 0) {
        return $addressBookAlertContainer.html(`<div class="alert alert-danger" role="alert">${results.message}</div>`);
    }
    location.reload();
}

$("#address-book-list").change(function() {
    const newAddressButtonHtml = `
        <div class='col-12 col-md-6 offset-md-3'>
            <button type='button' id='address-save-button' class='btn bg-westech-green w-100 text-white' onclick='saveAddress()'>Add Address</button>
        </div>
    `;
    const existingAddressButtonHtml = `
        <div class='col-12 col-md-4 offset-md-2'>
            <button type='button' id='address-update-button' class='btn bg-westech-green w-100 text-white' onclick='updateAddress()'>Update Address</button>
        </div>
        <div class='col-12 col-md-4 offset-md-1'>
            <button type='button' id='address-delete-button' class='btn w-100 btn-danger' onclick='deleteAddress()'>Delete Address</button>
        </div>
    `;
    const $element = $(this).find(":selected");
    const isSaved = $(this).val() == "saved-address";
    const $addressBookAlertContainer = $("#address-book-alert-container");
    const $defaultAddress = $("#default-address");
    // const $addressName = $("#address-name");
    const $companyName = $("#company-name");
    const $firstName = $("#first-name");
    const $lastName = $("#last-name");
    const $streetAddressOne = $("#street-address");
    const $streetAddressTwo = $("#street-address-two");
    const $streetAddressThree = $("#street-address-three");
    const $city = $("#city");
    const $state = $("#state");
    const $zip = $("#zip-code");
    const $country = $("#country");
    const $addressButtonContainer = $("#address-button-container");

    // removeInputError($addressName);
    removeInputError($firstName);
    removeInputError($lastName);
    removeInputError($streetAddressOne);
    removeInputError($city);
    removeInputError($state);
    removeInputError($zip);
    removeInputError($country);
    $addressBookAlertContainer.html("");

    const data = {
        // "addressName": $element.data("address-book-name"),
        "companyName": $element.data("company-name"),
        "firstName": $element.data("first-name"),
        "lastName": $element.data("last-name"),
        "streetAddressOne": $element.data("street-address"),
        "streetAddressTwo": $element.data("street-address-two"),
        "streetAddressThree": $element.data("street-address-three"),
        "city": $element.data("city"),
        "state": $element.data("state"),
        "zip": $element.data("zip"),
        "country": $element.data("country"),
        "defaultAddress": $element.data("default"),
    };
    if(isSaved) {
        $addressButtonContainer.html(existingAddressButtonHtml);
    } else {
        $addressButtonContainer.html(newAddressButtonHtml);
    }
    // $addressName.val(data.addressName);
    $companyName.val(data.companyName);
    $firstName.val(data.firstName);
    $lastName.val(data.lastName);
    $streetAddressOne.val(data.streetAddressOne);
    $streetAddressTwo.val(data.streetAddressTwo);
    $streetAddressThree.val(data.streetAddressThree);
    $city.val(data.city);
    $state.val(isSaved ? data.state : "Choose...");
    $zip.val(data.zip);
    $country.val(data.country);
    $defaultAddress.prop("checked", data.defaultAddress);
});