const $paymentEditButton = $("#checkout-payment-edit-button");
const $paymentContentSection = $("#checkout-payment-info");
const $paymentContinueButton = $("#checkout-payment-continue-button");
const $paymentNameOnCardFirst = $("#payment-name-on-card-first");
const $paymentNameOnCardLast = $("#payment-name-on-card-last");
const $paymentCardNumber = $("#payment-card-number");
const $paymentCardExpirationMonth = $("#payment-card-expiration-month");
const $paymentCardExpirationYear = $("#payment-card-expiration-year");
const $paymentCardCvv = $("#payment-card-cvv");
const $paymentDefaultMethod = $("#payment-default-method");
const $paymentHeaderSubtext = $("#payment-header-subtext");
const $paymentAddressStreet = $("#payment-address-street");
const $paymentAddressState = $("#payment-address-state");
const $paymentAddressCity = $("#payment-address-city");
const $paymentAddressZip = $("#payment-address-zip");
const $paymentAlertContainer = $("#payment-alert-container");
let hasFilledOutPaymentMethod = false;

$paymentContinueButton.click(async function() {
    let errors = false;
    checkInput($paymentNameOnCardFirst) ? errors = true : "";
    checkInput($paymentNameOnCardLast) ? errors = true : "";
    checkInput($paymentCardNumber) ? errors = true : "";
    checkInput($paymentCardExpirationMonth) ? errors = true : "";
    checkInput($paymentCardExpirationYear) ? errors = true : "";
    checkInput($paymentCardCvv) ? errors = true : "";
    checkInput($paymentAddressStreet) ? errors = true : "";
    checkInput($paymentAddressState) ? errors = true : "";
    checkInput($paymentAddressCity) ? errors = true : "";
    checkInput($paymentAddressZip) ? errors = true : "";
    let paymentDefaultChecked = $paymentDefaultMethod.is(":checked");
    if(errors) {
        $paymentAlertContainer.html(`<div class='alert alert-warning'>All highlighted fields are required.</div>`);
        return;
    }

    let data = {
        paymentNameOnCardFirst: $paymentNameOnCardFirst.val(),
        paymentNameOnCardLast: $paymentNameOnCardLast.val(),
        paymentCardNumber: $paymentCardNumber.val(),
        paymentCardExpirationMonth: $paymentCardExpirationMonth.val(),
        paymentCardExpirationYear: $paymentCardExpirationYear.val(),
        paymentCardCvv: $paymentCardCvv.val(),
        paymentDefault: paymentDefaultChecked,
        paymentAddressStreet: $paymentAddressStreet.val(),
        paymentAddressState: $paymentAddressState.val(),
        paymentAddressCity: $paymentAddressCity.val(),
        paymentAddressZip: $paymentAddressZip.val()
    };
    
    let results = await $.ajax({
    type: "POST",
    url: "ajax_payments.php",
    data: {
        "post-action": "add-payment",
        "post-data": data
    }
    });

    let resultsJ = JSON.parse(results);

    if (resultsJ.code == 0) {
        $paymentAlertContainer.html(`<div class='alert alert-danger'>${resultsJ.message}</div>`);
    }

    if (resultsJ.code == 1) {
        $paymentAlertContainer.html(`<div class='alert alert-success'>${resultsJ.message}</div>`);
        location.reload();
    }

    console.log(resultsJ);
});

$('.payment-button-delete').click(
async function() {
    $button = $(this);

    let results = await $.ajax({
        type: "POST",
        url: "ajax_payments.php",
        data: {
            "post-action": "delete-payment",
            "post-data": {
            paymentProfileId: $button.data("payment-id")
            }
        }
    });

    let resultsJ = JSON.parse(results);
    console.log(results);

    if (resultsJ.code == 0) {
        $paymentAlertContainer.html(`<div class='alert alert-danger'>${resultsJ.message}</div>`);
    }
    if (resultsJ.code == 1) {
        $paymentAlertContainer.html(`<div class='alert alert-success'>${resultsJ.message}</div>`);
        location.reload();
    }
}
);