const $taxExEditButton = $("#checkout-tax-ex-edit-button");
const $taxExContentSection = $("#checkout-tax-ex-info");
const $taxExContinueButton = $("#checkout-tax-ex-continue-button");
const $taxExCertificateState = $("#tax-ex-certificate-state");
const $taxExSelectedStates = $("#tax-ex-selected-states");
const $taxExSameAsShipping = $("#tax-ex-same-as-shipping");
const $taxExCompanyName = $("#tax-ex-company-name");
const $taxExFirstName = $("#tax-ex-first-name");
const $taxExLastName = $("#tax-ex-last-name");
const $taxExStreetAddressOne = $("#tax-ex-street-address-one");
const $taxExStreetAddressTwo = $("#tax-ex-street-address-two");
const $taxExCity = $("#tax-ex-city");
const $taxExState = $("#tax-ex-customer-state");
const $taxExZipCode = $("#tax-ex-zip-code");
const $taxExSignedDate = $("#tax-ex-signed-date")
const $taxExType = $("#tax-ex-type");
const $taxExTaxNumber = $("#tax-ex-tax-number");
const $taxExReason = $("#tax-ex-reason");
const $taxExFile = $("#tax-ex-file");
const $taxExTerms = $("#tax-ex-terms");
const $taxExNoExpiration = $("#tax-ex-no-exp");
const $taxExFormContent = $("#tax-ex-form-content");
const $taxExExpirationDate = $("#tax-ex-expiration-date");
const $taxExRemoveSelectedButton = $("#tax-ex-remove-selected-button");
const $taxExFileOutput = $("#tax-ex-file-output");
const $taxExResult = $("#tax-ex-alert-container");
let hasFilledOutTaxEx = false;

const taxExStates = ["Alabama",
    "Alaska",
    "Arizona",
    "Arkansas",
    "California",
    "Colorado",
    "Connecticut",
    "Delaware",
    "Florida",
    "Georgia",
    "Hawaii",
    "Idaho",
    "Illinois",
    "Indiana",
    "Iowa",
    "Kansas",
    "Kentucky",
    "Louisiana",
    "Maine",
    "Maryland",
    "Massachusetts",
    "Michigan",
    "Minnesota",
    "Mississippi",
    "Missouri",
    "Montana",
    "Nebraska",
    "Nevada",
    "New Hampshire",
    "New Jersey",
    "New Mexico",
    "New York",
    "North Carolina",
    "North Dakota",
    "Ohio",
    "Oklahoma",
    "Oregon",
    "Pennsylvania",
    "Rhode Island",
    "South Carolina",
    "South Dakota",
    "Tennessee",
    "Texas",
    "Utah",
    "Vermont",
    "Virginia",
    "Washington",
    "West Virginia",
    "Wisconsin",
    "Wyoming",
];
const taxExSelectedStates = [];

$(window).on("load", () => {
    populateTaxExStates();
    populateSelectedStates();
});

$("#tax-ex-current-records-container").ready(async function() {

let results = await $.ajax({
    type: "POST",
    url: "ajax_exemptions.php",
    data: {
    "post-action": "get-exemptions"
    }
});
results = JSON.parse(results);
console.log(results);
const taxExemptionsArray = [];
if (typeof taxExemptionsArray !== 'undefined' && taxExemptionsArray.length > 0) {
    // the array is defined and has at least one element
}
});

function populateTaxExStates() {
let html = "<option disabled selected>Choose...</option>";
taxExStates.forEach((state) => {
    html += `<option class="unselected-state" value="${state}">${state}</option>\n`;
});
$taxExCertificateState.html(html);
}

function populateSelectedStates() {
    let html = "";
    taxExSelectedStates.forEach((state) => {
        html += `<option class="unselected-state" value="${state}">${state}</option>\n`;
    })
    $taxExSelectedStates.html(html);
}

$taxExRemoveSelectedButton.click(function() {
    const selectedValue = $taxExSelectedStates.val();
    if(selectedValue !== null) {
        const index = taxExSelectedStates.indexOf(selectedValue);
        if(index !== -1) {
            taxExSelectedStates.splice(index, 1);
            taxExStates.push(selectedValue);
            taxExStates.sort();
            populateTaxExStates();
            populateSelectedStates();
        }
    }
});


$taxExCertificateState.change(function(){ 
    const value = this.value;
    if(value !== "Choose...") {
        taxExSelectedStates.push(value);
        const valueIndex = taxExStates.indexOf(value);
        taxExStates.splice(valueIndex, 1);
        populateTaxExStates();
        populateSelectedStates();
    }
});

$taxExNoExpiration.click(function() {
const checked = this.checked;
if(checked) {
    $taxExExpirationDate.prop("disabled", true);
    $taxExExpirationDate.val("");
    return;
}
$taxExExpirationDate.prop("disabled", false);
});

$taxExFile.on("change", function() {
const fileName = this.value.replace(/.*(\/|\\)/, '');
$taxExFileOutput.html(fileName);
});

$taxExContinueButton.click(async function() {

    $taxExContinueButton.prop('disabled', true);
    $taxExContinueButton.html('Submitting...');

    let errors = false;

    $taxExStreetAddressTwo.toggleClass("input-error", false);
    // checkInput($taxExCompanyName) ? errors = true : "";
    checkInput($taxExFirstName) ? errors = true : "";
    checkInput($taxExLastName) ? errors = true : "";
    checkInput($taxExStreetAddressOne) ? errors = true : "";
    checkInput($taxExCity) ? errors = true : "";
    checkInput($taxExState) ? errors = true : "";
    checkInput($taxExZipCode) ? errors = true : "";
    checkInput($taxExSignedDate) ? errors = true : "";
    if(!$taxExNoExpiration.is(":checked")) {
        checkInput($taxExExpirationDate) ? errors = true : "";
    } else {
        $taxExExpirationDate.toggleClass("input-error", false);
    }
    checkInput($taxExType) ? errors = true : "";
    checkInput($taxExTaxNumber) ? errors = true : "";
    checkInput($taxExReason) ? errors = true : "";
    checkInput($taxExFile) ? errors = true : "";
    if(!$taxExTerms.is(":checked")) {
        $taxExTerms.toggleClass("input-error", true);
        errors = true;
    } else {
        $taxExTerms.toggleClass("input-error", false);
    }
    if(taxExSelectedStates.length < 1) {
        $taxExSelectedStates.toggleClass("input-error", true);
        $taxExCertificateState.toggleClass("input-error", true);
    } else {
        $taxExSelectedStates.toggleClass("input-error", false);
        $taxExCertificateState.toggleClass("input-error", false);
    }
    if(errors) {
        $taxExContinueButton.prop('disabled', false);
        $taxExContinueButton.html('Continue');
        return;
    }

    let data = {
        exCompanyName: $taxExCompanyName.val(),
        exFirstName: $taxExFirstName.val(),
        exLastName: $taxExLastName.val(),
        exAddr1: $taxExStreetAddressOne.val(),
        exAddr2: $taxExStreetAddressTwo.val(),
        exCity: $taxExCity.val(),
        exState: $taxExState.val(),
        exZip: $taxExZipCode.val(),
        exDateSigned: $taxExSignedDate.val(),
        exDateExpire: $taxExExpirationDate.val(),
        exNoExp: $taxExNoExpiration.is(":checked"),
        exType: $taxExType.val(),
        exNumber: $taxExTaxNumber.val(),
        exReason: $taxExReason.val(),
        exFile: $taxExFile.val(),
        exSelectedStates: taxExSelectedStates.join(',')
    }

    let formData = new FormData();
    formData.append("file", $taxExFile.prop('files')[0]);
    formData.append("post-action", "add-exemption");
    formData.append("post-data", JSON.stringify(data));

    let results = await $.ajax({
        url: "ajax_exemptions.php",
        data: formData,
        contentType: false,
        processData: false,
        method: "POST"
    });

    let resultsJ = JSON.parse(results);
    switch (resultsJ.code) {
        case 0:
        break;
        case 1:
        $taxExResult.html(`<div class='alert alert-danger'>${resultsJ.message}</div>`);
        $taxExStreetAddressOne.toggleClass("input-error", true);
        $taxExStreetAddressTwo.toggleClass("input-error", true);
        $taxExCity.toggleClass("input-error", true);
        $taxExState.toggleClass("input-error", true);
        $taxExZipCode.toggleClass("input-error", true);

        $taxExContinueButton.prop('disabled', false);
        $taxExContinueButton.html('Continue');
        break;
        break;
        case 2:
        $taxExResult.html(`<div class='alert alert-danger'>${resultsJ.message}</div>`);
        $taxExStreetAddressOne.toggleClass("input-error", true);
        $taxExStreetAddressTwo.toggleClass("input-error", true);
        $taxExCity.toggleClass("input-error", true);
        $taxExState.toggleClass("input-error", true);
        $taxExZipCode.toggleClass("input-error", true);

        $taxExContinueButton.prop('disabled', false);
        $taxExContinueButton.html('Continue');
        break;
        case 3:
        $taxExResult.html(`<div class='alert alert-success'>${resultsJ.message}</div>`);
        $taxExContinueButton.remove();
        // location.reload();
        break;
    }
    console.log(resultsJ);
});

$(".tax-ex-button-delete").click(
    async function() {
        
    const $button = $(this);
    $button.prop('disabled', true);
    $button.html('Deleting...');

    let results = await $.ajax({
    type: "POST",
    url: "ajax_exemptions.php",
    data: {
        "post-action": "delete-exemption",
        "post-data": {
        id: $button.data("cert-id")
        }
    }
    });

    console.log(results);
    
    location.reload();
}
);

$(".tax-ex-button-edit").click(
async function() {

    const $button = $(this);

    let results = await $.ajax({
    type: "POST",
    url: "ajax_exemptions.php",
    data: {
        "post-action": "edit-exemption",
        "post-data": {
        id: $button.data("cert-id")
        }
    }
    });
}
);