async function removeFromCart(product_id) {
    let ajaxCall = await $.ajax({
        type: "POST",
        url: "ajax_cart.php",
        data: {
            "cart-action": "remove",
            "product_id" : product_id
        }
    });

    location.reload();
}

async function updateCart(product_id, new_quantity) {
    if(new_quantity == 0){ 
        const continueUpdateCart = confirm("Are you sure you want to remove this item from the cart?")
        if(!continueUpdateCart) {
            $('button').prop('disabled', false);

            return;
        }
    }
    let ajaxCall = await $.ajax({
        type: "POST",
        url: "ajax_cart.php",
        data: {
            "cart-action": "update",
            "product_id": product_id,
            "new_quantity": new_quantity
            }
    });

    location.reload();
}

async function applyCoupon(coupon_code) {
    let ajaxCall = await $.ajax({
        type: "POST",
        url: "ajax_coupon.php",
        data: {
            "post-action": "apply",
            "post-data": {
                "couponCode": coupon_code
            }
        }
    });

    location.reload();
}

async function removeCoupon() {
    let ajaxCall = await $.ajax({
        type: "POST",
        url: "ajax_coupon.php",
        data: {
            "post-action": "remove"
        }
    });

    location.reload();
}

$(".cart-page-item-quantity").keypress(function(event) {
    // If the user presses the "Enter" key on the keyboard
    if (event.key === "Enter") {
      // Cancel the default action, if needed
      event.preventDefault();
      // Trigger the button element with a click
      $(".cart-page-item-quantity").focusout();
    }
});

$(".cart-page-item-quantity").focusout(function() {
    let product_id = $(this).attr('data-id');

    updateCart(product_id, $(this).val());
});

$(".remove-button").click(function() {
    const $button = $(this);
    const $allButtons = $("button");
    $allButtons.prop("disabled", true );
    const id = $button.attr("data-id");
    const $input = $(`input[data-id="${id}"]`);
    const qty = parseInt($input.val()) - 1;
    updateCart(id, qty);
});

$(".add-button").click(function() {
    const $button = $(this);
    const $allButtons = $("button");
    $allButtons.prop("disabled", true );
    const id = $button.attr("data-id");
    const mainId = $button.data("main-id");
    const $input = $(`input[data-id="${id}"]`);
    const qty = parseInt($input.val()) + 1;
    updateCart(id, qty);
});

$(".remove-from-cart-button").click(function() {
    const $button = $(this);
    const $allButtons = $("button");
    $allButtons.prop( "disabled", true );
    const id = $button.attr("data-id");
    removeFromCart(id);
});

$('#cart-page-summary-coupon-button-apply').click(function() {
    applyCoupon($("#cart-page-summary-coupon").val());
});

$('#cart-page-summary-coupon-button-remove').click(function() {
    removeCoupon();
});