const $shippingAddressModal = $('#shipping-address-modal-target');
const $shippingHeaderSubtext = $("#shipping-header-subtext");
const $shippingEditButton = $("#checkout-shipping-edit-button");
const $shippingContentSection = $("#checkout-shipping-info");
const $shippingAddressBookListDropdown = $("#address-book-list-shipping");
const $shippingCompanyName = $("#shipping-company-name");
const $shippingFirstName = $("#shipping-first-name");
const $shippingLastName = $("#shipping-last-name");
const $shippingStreetAddressOne = $("#shipping-street-address-one");
const $shippingStreetAddressTwo = $("#shipping-street-address-two");
const $shippingStreetAddressThree = $("#shipping-street-address-three");
const $shippingCity = $("#shipping-city");
const $shippingState = $("#shipping-state");
const $shippingZipCode = $("#shipping-zip-code");
const $shippingCountry = $("#shipping-country");
const $shippingExtraResidential = $('#shipping-extra-residential');
const $shippingExtraLiftgate = $('#shipping-extra-liftgate');
const $shippingExtraRestricted = $('#shipping-extra-restricted-access');
const $shippingResult = $('shipping-result-target');
const $shippingContinueButton = $("#checkout-shipping-continue-button");
let shippingValidated = false;
let hasFilledOutShipping = false;

const $billingHeaderSubtext = $("#billing-header-subtext");
const $billingEditButton = $("#checkout-billing-edit-button");
const $billingContentSection = $("#checkout-billing-info");
const $billingSameAsShipping = $("#billing-same-as-shipping");
const $billingAddressBookListDropdown = $("#address-book-list-billing");
const $billingCompanyName = $("#billing-company-name");
const $billingFirstName = $("#billing-first-name");
const $billingLastName = $("#billing-last-name");
const $billingStreetAddressOne = $("#billing-street-address-one");
const $billingStreetAddressTwo = $("#billing-street-address-two");
const $billingStreetAddressThree = $("#billing-street-address-three");
const $billingCity = $("#billing-city");
const $billingState = $("#billing-state");
const $billingZipCode = $("#billing-zip-code");
const $billingCountry = $("#billing-country");
const $billingContinueButton = $("#checkout-billing-continue-button");
let hasFilledOutBilling = false;

const $taxHeaderSubtext = $("#checkout-tax-header-subtext");
const $taxEditButton = $("#checkout-tax-edit-button");
const $taxContentSection = $("#checkout-tax-info");
const $taxTerms = $("#tax-terms");
const $taxButtons = $("#checkout-tax-content-buttons");
let hasFilledOutTaxes = false;

const $paymentHeaderSubtext = $("#payment-header-subtext");
const $paymentEditButton = $("#checkout-payment-edit-button");
const $paymentContentSection = $("#checkout-payment-info");
const $paymentMethodDropdown = $("#payment-method");
const $shippingPhoneNumber = $("#shipping-phone-number");
const $paymentNameOnCard = $("#payment-name-on-card");
const $paymentCardNumber = $("#payment-card-number");
const $paymentCardExpirationMonth = $("#payment-card-expiration-month");
const $paymentCardExpirationYear = $("#payment-card-expiration-year");
const $paymentCardCvv = $("#payment-card-cvv");
const $paymentSaveMethod = $("#payment-save-method");
const $paymentComment = $("#payment-comment");
const $paymentCheckoutButton = $("#checkout-payment-checkout-button");
const $paymentTermsCheckbox = $("#terms-agree-checkbox");
const $paymentInputs = $("#payment-name-on-card, #payment-card-number, #payment-card-expiration-month, #payment-card-expiration-year, #payment-card-cvv, #terms-agree-checkbox");
let hasFilledOutPaymentMethod = false;

function checkInput($input) {
    if($input.val() === "" || $input.val() == null || $input.val() == undefined) {
        $input.toggleClass("input-error", true);
        return true;
    }
    $input.toggleClass("input-error", false);
    return false;
}

function fillShippingAddress() {
    let $selected = $shippingAddressBookListDropdown.find(":selected");

    $shippingFirstName.toggleClass('input-error', false);
    $shippingLastName.toggleClass('input-error', false);
    $shippingStreetAddressOne.toggleClass('input-error', false);
    $shippingCity.toggleClass('input-error', false);
    $shippingState.toggleClass('input-error', false);
    $shippingZipCode.toggleClass('input-error', false);

    const data = {
        "addressName": $selected.data("address-book-name"),
        "companyName": $selected.data("company-name"),
        "firstName": $selected.data("first-name"),
        "lastName": $selected.data("last-name"),
        "streetAddressOne": $selected.data("street-address"),
        "streetAddressTwo": $selected.data("street-address-two"),
        "streetAddressThree": $selected.data("street-address-three"),
        "city": $selected.data("city"),
        "state": $selected.data("state"),
        "zip": $selected.data("zip"),
        "country": $selected.data("country"),
        "defaultAddress": $selected.data("default"),
    };

    $shippingCompanyName.val(data.companyName);
    $shippingFirstName.val(data.firstName);
    $shippingLastName.val(data.lastName);
    $shippingStreetAddressOne.val(data.streetAddressOne);
    $shippingStreetAddressTwo.val(data.streetAddressTwo);
    $shippingStreetAddressThree.val(data.streetAddressThree);
    $shippingCity.val(data.city);
    $shippingState.val(data.state);
    $shippingZipCode.val(data.zip);
    $shippingCountry.val(data.country);

    if ($selected.val() == 'new') {
        renderCartDisplay();
    }
}

async function calculateShippingAndTaxes() {
    let errors = false;
    checkInput($shippingFirstName) ? errors = true : '';
    checkInput($shippingLastName) ? errors = true : '';
    checkInput($shippingStreetAddressOne) ? errors = true : '';
    if ($shippingState.val() == 'PR') checkInput($shippingStreetAddressThree) ? errors = true : '';
    checkInput($shippingCity) ? errors = true : '';
    checkInput($shippingState) ? errors = true : '';
    checkInput($shippingZipCode) ? errors = true : '';
    checkInput($shippingCountry) ? errors = true : '';
    checkInput($shippingPhoneNumber) ? errors = true : '';
    if (errors) {
        return;
    }
    if ($billingSameAsShipping.is(':checked')) {
        copyShippingToBilling();
    }

    $shippingContinueButton.prop('disabled', true);

    shippingValidated = false;

    try {
        
        let postData;

        if ($shippingState.val() == 'PR') {
            postData = {
                line1: $shippingStreetAddressOne.val(),
                line2: $shippingStreetAddressTwo.val(),
                urbanization: $shippingStreetAddressThree.val(),
                city: $shippingCity.val(),
                state: $shippingState.val(),
                zip: $shippingZipCode.val(),
                country: $shippingCountry.val()
            };
        } else {
            postData = {
                line1: $shippingStreetAddressOne.val(),
                line2: $shippingStreetAddressTwo.val(),
                line3: $shippingStreetAddressThree.val(),
                city: $shippingCity.val(),
                state: $shippingState.val(),
                zip: $shippingZipCode.val(),
                country: $shippingCountry.val()
            };
        }

        let ajax_ups_resolve_address = await $.ajax(
            {
                method: 'POST',
                url: 'ajax_ups.php',
                data: {
                    'post-action': 'addresses',
                    'post-data': postData
                }
            }
        );

        let ajax_ups_resolve_address_j = '';

        try {
            ajax_ups_resolve_address_j = JSON.parse(ajax_ups_resolve_address);
        } catch (error) {
            alert('Failed to receive shipping data.');
            console.log(ajax_ups_resolve_address);
            return false;
        }
        let auraj = ajax_ups_resolve_address_j;

        if (auraj.code == 0) {
            console.log(auraj);
            throw new Error(`${auraj.message} (auraj)`);
        }

        if (auraj.subcode !== 2) {
            await showAddressHelpModal(auraj.display);
        }

        let ajax_ups_calculate_shipping = await $.ajax(
            {
                method: 'POST',
                url: 'ajax_shipping.php',
                data: {
                    'post-action': 'getShippingQuote',
                    'post-data': {
                        name: $shippingFirstName.val() + ' ' + $shippingLastName.val(),
                        addressLine1: $shippingStreetAddressOne.val(),
                        addressLine2: $shippingStreetAddressTwo.val(),
                        addressLine3: $shippingStreetAddressThree.val(),
                        city: $shippingCity.val(),
                        state: $shippingState.val(),
                        zip: $shippingZipCode.val(),
                        country: $shippingCountry.val(),
                        residentialCharge: $shippingExtraResidential.is(':checked'),
                        liftgateCharge: $shippingExtraLiftgate.is(':checked'),
                        restrictedAccessCharge: $shippingExtraRestricted.is(':checked')
                    }
                }
            }
        );

        let ajax_ups_calculate_shipping_j = JSON.parse(ajax_ups_calculate_shipping);
        let aucsj = ajax_ups_calculate_shipping_j;

        if (aucsj.code == 0) {
            console.log(aucsj);
            throw new Error(`${aucsj.message} (aucsj)`);
        }

        let ajax_avatax_calculate_taxes = await $.ajax(
            {
                method: 'POST',
                url: 'ajax_avatax.php',
                data: {
                    'post-action': 'taxes',
                    'post-data': {
                        'data-action': 'get',
                        name: $shippingFirstName.val() + ' ' + $shippingLastName.val(),
                        addressLine1: $shippingStreetAddressOne.val(),
                        addressLine2: $shippingStreetAddressTwo.val(),
                        city: $shippingCity.val(),
                        state: $shippingState.val(),
                        zip: $shippingZipCode.val(),
                        country: $shippingCountry.val()
                    }
                }
            }
        );

        let ajax_ajax_avatax_calculate_taxes_j = '';

        try {
            ajax_avatax_calculate_taxes_j = JSON.parse(ajax_avatax_calculate_taxes);
        } catch (error) {
            alert('Failed to receive tax data.');
            console.log(ajax_avatax_calculate_taxes);

            return false;
        }

        let aactj = ajax_avatax_calculate_taxes_j;

        if (aactj.code == 0) {
            console.log(aactj);
            throw new Error(`${aactj.message} (aactj)`);
        }

        $('#checkout-tax-content-summary').html(aactj.display.summary);
        $taxButtons.html(aactj.display.buttons);

        if (aucsj.code == 1 && aactj.code == 1) {
            updateCartDisplay();

            $shippingHeaderSubtext.html(`
                ${$shippingFirstName.val()} ${$shippingLastName.val()} <br />
                ${$shippingStreetAddressOne.val()}, ${$shippingCity.val()}, ${$shippingState.val()} ${$shippingZipCode.val()}
            `);
            $shippingHeaderSubtext.removeClass("d-none");
            $shippingEditButton.removeClass("d-none");
            $shippingContentSection.removeClass("d-block");
            $billingContentSection.addClass("d-block");
        }

    } catch (e) {
        return $shippingResult.html(`<div class='alert alert-warning'>${e}</div>`);
    }

    $shippingContinueButton.prop('disabled', false);
}

function showAddressHelpModal(content) {

    $shippingAddressModal.html(content);
            
    var addressCandidateModal = new bootstrap.Modal('#candidate-modal');
    addressCandidateModal.show();

    $('shipping-address-modal-target').off();

    return new Promise((resolve) => {

        $('#shipping-address-modal-target').on('click', '.list-group-item:not(.bg-westech-green)', function() {
            $current = $(this).siblings('.bg-westech-green');
        
            $current.toggleClass('bg-westech-green', false).toggleClass('text-white', false);
            $current.removeAttr('aria-current');
        
            $(this).toggleClass('bg-westech-green', true).toggleClass('text-white', true);
            $(this).attr('aria-current', true);
        });

        $('#shipping-address-modal-target').on('click', '#shipping-address-modal-target-cancel', function() {
            shippingValidated = false;

            resolve();
        })
        
        $('#shipping-address-modal-target').on('click', '#shipping-address-modal-target-select', function() {
            $selectedAddress = $('.list-group-item[aria-current="true"]');
        
            let $availableAddressLines;
        
            if ($selectedAddress.data('political-division1') == 'PR') {
                $availableAddressLines = [$shippingStreetAddressOne, $shippingStreetAddressTwo];
        
                if ($selectedAddress.data('urbization') !== 'undefined') $shippingStreetAddressThree.val($selectedAddress.data('urbanization'));
            } else {
                $availableAddressLines = [$shippingStreetAddressOne, $shippingStreetAddressTwo, $shippingStreetAddressThree];
            }
        
            let addressLine = $selectedAddress.data('address-line');
        
            let bracketCheck = addressLine.match(/^\[(.*?)\]$/);
        
            if (bracketCheck) {
                let addressData = bracketCheck[1].split(',');
        
                let addressParts = Math.ceil(addressData.length / $availableAddressLines.length);
        
                let addressDataFilled = Array.from({length: $availableAddressLines.length}, () => addressData.splice(0, addressParts));
        
                for (let a = 0; a < addressDataFilled.length; a++) {
                    $availableAddressLines[a].val(addressDataFilled[a].join(', '));
                }
            } else {
                $shippingStreetAddressOne.val(addressLine);
            }
        
            $shippingCity.val($selectedAddress.data('political-division2'));
        
            $shippingState.val($selectedAddress.data('political-division1'));
        
            $shippingZipCode.val(`${$selectedAddress.data('postcode-primary-low')}-${$selectedAddress.data('postcode-extended-low')}`);
        
            $shippingCountry.val($selectedAddress.data('country-code'));
        
            let isResidential = $selectedAddress.data('code') == 2;
        
            $shippingExtraResidential.prop({checked: isResidential, disabled: isResidential});

            shippingValidated = true;

            resolve();
        });

    });

}

    // $("input#payment-card-number").focusout(function () {
    //     var cardNumber = $(this).val();
    //     var amex = /^3[47][0-9]{13}$/;
    //     if (amex.test(cardNumber)) {
    //         $("#payment-card-cvv").attr("maxlength", 4).attr('placeholder', "####");
    //     } else {  
    //         $("#payment-card-cvv").attr("maxlength", 3).attr('placeholder', "###");
    //     }
    // });

//valid shipping address
function isValidShippingAdress(){
    let isValid = true;
    $shippingStreetAddressOne.val() == '' ? isValid = false : '';
    if($shippingState.val() == 'PR') $shippingStreetAddressThree.val()== '' ? isValid = false : '';
    $shippingCity.val() =='' ? isValid = false : '';
    $shippingState.val() =='' ? isValid = false : '';
    $shippingZipCode.val() =='' ? isValid = false : '';
    $shippingCountry.val() =='' ? isValid = false : '';
    $shippingPhoneNumber.val() =='' ? isValid = false : '';
    return isValid;
}


async function applyCoupon(coupon_code) {
    let ajaxCall = await $.ajax({
        type: "POST",
        url: "ajax_coupon.php",
        data: {
            "post-action": "apply",
            "post-data": {
                "couponCode": coupon_code
            }
        }
    });
    updateCartDisplay();
    // if(isValidShippingAdress()){
    //     calculateShippingAndTaxes();
    // };
}

async function removeCoupon() {
    let ajaxCall = await $.ajax({
        type: "POST",
        url: "ajax_coupon.php",
        data: {
            "post-action": "remove"
        }
    });
    updateCartDisplay();
    // if(isValidShippingAdress()){
    //     calculateShippingAndTaxes();
    // };
}

function copyShippingToBilling() {
    $billingCompanyName.val($shippingCompanyName.val());
    $billingFirstName.val($shippingFirstName.val());
    $billingLastName.val($shippingLastName.val());
    $billingStreetAddressOne.val($shippingStreetAddressOne.val());
    $billingStreetAddressTwo.val($shippingStreetAddressTwo.val());
    $billingCity.val($shippingCity.val());
    $billingState.val($shippingState.val());
    $billingZipCode.val($shippingZipCode.val());
    $billingCountry.val($shippingCountry.val());
    let selectedBookID = $shippingAddressBookListDropdown.find(":selected").attr("data-address-book-id");
    $billingAddressBookListDropdown.val("new");
    $("#address-book-list-billing option[data-address-book-id=" + selectedBookID + "]").attr("selected", true)
}

function fillBillingAddress() {
    let $selected = $billingAddressBookListDropdown.find(":selected");
    $billingFirstName.toggleClass('input-error', false);
    $billingLastName.toggleClass('input-error', false);
    $billingStreetAddressOne.toggleClass('input-error', false);
    $billingCity.toggleClass('input-error', false);
    $billingState.toggleClass('input-error', false);
    $billingZipCode.toggleClass('input-error', false);

    const data = {
        "addressName": $selected.data("address-book-name"),
        "companyName": $selected.data("company-name"),
        "firstName": $selected.data("first-name"),
        "lastName": $selected.data("last-name"),
        "streetAddressOne": $selected.data("street-address"),
        "streetAddressTwo": $selected.data("street-address-two"),
        "streetAddressThree": $selected.data("street-address-three"),
        "city": $selected.data("city"),
        "state": $selected.data("state"),
        "zip": $selected.data("zip"),
        "country": $selected.data("country"),
        "defaultAddress": $selected.data("default"),
    };

    $billingCompanyName.val(data.companyName);
    $billingFirstName.val(data.firstName);
    $billingLastName.val(data.lastName);
    $billingStreetAddressOne.val(data.streetAddressOne);
    $billingStreetAddressTwo.val(data.streetAddressTwo);
    $billingStreetAddressThree.val(data.streetAddressThree);
    $billingCity.val(data.city);
    $billingState.val(data.state);
    $billingZipCode.val(data.zip);
    $billingCountry.val(data.country);
}

function fillPaymentMethod() {
    const $selected = $("#payment-method option:selected");
    const nameOnCard = $selected.attr("data-name-on-card");
    const cardNumber = $selected.attr("data-card-number");
    const month = $selected.attr("data-month");
    const year = $selected.attr("data-year");
    const cvv = $selected.attr("data-cvv");
    $paymentNameOnCard.val(nameOnCard);
    $paymentCardNumber.val(cardNumber);
    $paymentCardExpirationMonth.val(month);
    $paymentCardExpirationYear.val(year);
    $paymentCardCvv.val(cvv);
    if ($selected.data('method-type') == "new") {
        $paymentSaveMethod.removeClass("d-none");
        $('.form-check-label[for="payment-save-method"]').removeClass('d-none');
        $('#payment-card-details').removeClass('d-none');
    }
    else if ($selected.data('method-type') == "adn-saved-method") {
        $paymentSaveMethod.prop("checked", false);
        $paymentSaveMethod.addClass("d-none");
        $('.form-check-label[for="payment-save-method"]').addClass('d-none');
        $('#payment-card-details').addClass('d-none');
    }
    else {
        $paymentSaveMethod.prop("checked", false);
        $paymentSaveMethod.addClass("d-none");
        $('.form-check-label[for="payment-save-method"]').addClass('d-none');
        $('#payment-card-details').removeClass('d-none');
    }
}

async function renderCartDisplay() {
    $results = await $.ajax(
        {
            type: "POST",
            url: "ajax_render_cart.php",
            data: {
                "post-action": "renderCart"
            }
        }
    );

    $resultsJ = JSON.parse($results);

    if ($resultsJ.code == 1) {
        $(".cart-info-container").html($resultsJ.content);
        $('.cart-page-item-brand').each(function(){
            $(this).text($(this).text().replace(/(Freedom Electronics)|(RDM)|PMP/g, "Rebuilt Part"));
        }); 
    }
}

async function updateCartDisplay() {
    $results = await $.ajax(
        {
            type: "POST",
            url: "ajax_render_cart.php",
            data: {
                "post-action": "updateCart"
            }
        }
    );

    $resultsJ = JSON.parse($results);

    if ($resultsJ.code == 1) {
        $("#summary-line-items").html($resultsJ.content);
        $("#total-cost").html($resultsJ.total);
    } else {
        alert($resultsJ);
    }
}

$(window).on('load',
    function() {
        renderCartDisplay();

        fillShippingAddress();
        fillBillingAddress();
        fillPaymentMethod();
    }
);

$(".cart-info-container").on('click', '#coupon-code-apply', function() {
    applyCoupon($("#coupon-code-input").val());
});

$(".cart-info-container").on('click', '#coupon-code-remove', function() {
    removeCoupon();
});

$shippingState.change(function() {
    if ($(this).val() == 'PR') {
        $shippingStreetAddressThree.attr('placeholder', 'Urbanization');
        $shippingStreetAddressThree.siblings('label').html('Urbanization');
    } else {
        $shippingStreetAddressThree.attr('placeholder', 'Shipping Address Line 3 ');
        $shippingStreetAddressThree.siblings('label').html('Street Address 3 (Optional)');
    }
});

$shippingAddressBookListDropdown.change(
    function() {
        fillShippingAddress();
    }
);

$shippingContinueButton.click(
    function() {
        calculateShippingAndTaxes();
    }
);

$(".input-shipping").change(
    function() {
        if (shippingValidated) {
            shippingValidated = false;
            $shippingContinueButton.prop('disabled', true);
            if ($(this).attr('type') == 'checkbox') {
                calculateShippingAndTaxes();
            }
        }
    }
);

$shippingEditButton.click(
    function() {
        $(".checkout-item-content.d-block").removeClass("d-block");
        $shippingContinueButton.prop('disabled', false);
        $shippingContentSection.addClass("d-block");
    }
);

$billingSameAsShipping.change(
    function() {
        if(this.checked) {
            copyShippingToBilling();
            $billingCompanyName.prop("disabled", true);
            $billingFirstName.prop("disabled", true);
            $billingLastName.prop("disabled", true);
            $billingStreetAddressOne.prop("disabled", true);
            $billingStreetAddressTwo.prop("disabled", true);
            $billingStreetAddressThree.prop("disabled", true);
            $billingCity.prop("disabled", true);
            $billingState.prop("disabled", true);
            $billingZipCode.prop("disabled", true);
            $billingCountry.prop("disabled", true);
            return;
        }
                
        $billingCompanyName.prop("disabled", false);
        $billingFirstName.prop("disabled", false);
        $billingLastName.prop("disabled", false);
        $billingStreetAddressOne.prop("disabled", false);
        $billingStreetAddressTwo.prop("disabled", false);
        $billingStreetAddressThree.prop("disabled", false);
        $billingCity.prop("disabled", false);
        $billingState.prop("disabled", false);
        $billingZipCode.prop("disabled", false);
        $billingCountry.prop("disabled", false);
    }
);

$billingAddressBookListDropdown.change(
    function() {
        fillBillingAddress();
    }
);

$billingContinueButton.click(
    function() {
        let errors = false;
        checkInput($billingFirstName) ? errors = true : "";
        checkInput($billingLastName) ? errors = true : "";
        checkInput($billingStreetAddressOne) ? errors = true : "";
        checkInput($billingCity) ? errors = true : "";
        checkInput($billingState) ? errors = true : "";
        checkInput($billingZipCode) ? errors = true : "";
        checkInput($billingCountry) ? errors = true : "";
        if(errors) {
            return;
        }
        $billingHeaderSubtext.html(`
            ${$billingFirstName.val()} ${$billingLastName.val()} <br />
            ${$billingStreetAddressOne.val()}, ${$billingCity.val()}, ${$billingState.val()} ${$billingZipCode.val()}
        `);
        $billingHeaderSubtext.removeClass("d-none");
        $billingEditButton.removeClass("d-none");
        $billingContentSection.removeClass("d-block");
        $taxContentSection.addClass("d-block");

        hasFilledOutBilling = true;
    }
);

$billingEditButton.click(
    function() {
        $(".checkout-item-content.d-block").removeClass("d-block");
        $billingContinueButton.prop('disabled', false);
        $billingContentSection.addClass("d-block");
    }
);

$taxButtons.on('click', "#checkout-tax-continue-button",
    function() {
        $taxContentSection.removeClass("d-block");
        $taxEditButton.removeClass('d-none');
        $paymentContentSection.removeClass("d-none");
        $paymentContentSection.addClass("d-block");
        
        let rateT = 0.00;
        let amountT = 0.00;
    
        $("#checkout-tax-content-summary > table > tbody > tr").each(
            function() {
                rateT += Number.parseFloat($(this).children('td').eq(2).text());
                amountT += Number.parseFloat($(this).children('td').eq(3).text().substr(1));
            }
        );

        rateT *= 100 // Get percent instead of decimal percentage
        rateT = parseFloat((Math.floor(rateT*1000)/1000).toFixed(4)); // round to nearest
        amountT = (Math.floor(amountT*1000)/1000).toFixed(2); // round to nearest
    
        $taxHeaderSubtext.html(`
            ${rateT}% <br /> $${amountT}
        `);
    }

);

$taxEditButton.click(
    function() {
        $(".checkout-item-content.d-block").removeClass("d-block");
        $("#checkout-tax-continue-button").prop('disabled', false);
        $taxContentSection.addClass("d-block");
    }
);

$paymentMethodDropdown.change(
    function() {
        fillPaymentMethod();
    }
);

$paymentCheckoutButton.click(
    async function() {

        let userEmailResponse = await $.ajax({
            method: "POST",
            url: "ajax_account.php",
        }); 
        console.log(JSON.parse(userEmailResponse));
        $paymentInputs.each(function() {
            $(this).toggleClass("input-error", false);
        });

        $paymentCheckoutButton.prop('disabled', true);
        $("#checkout-message-container").toggleClass("bg-warning text-white", false);
        $("#checkout-message").html('');

        const $selected = $("#payment-method option:selected");
        let cardData;

        let errors = false;

        if ($shippingPhoneNumber.val() == "") $shippingPhoneNumber.val().match("\\+?\\d{1,4}?[- .\s]?\\(?\\d{1,3}\\)?[- .\s]?\\d{1,4}[- .\s]?\\d{1,9}[ :]?(ext|extension)?[. :]{0,2}(\\d{0,5}).*") ? "" : errors = true;
        checkInput($paymentNameOnCard) ? errors = true : "";
        checkInput($paymentCardNumber) ? errors = true : "";

        if (!$paymentTermsCheckbox.is(":checked"))
        {
            errors = true;
            $paymentTermsCheckbox.toggleClass("input-error", true);
        }

        switch ($selected.data('method-type')) {
            case 'new':

                checkInput($paymentCardExpirationMonth) ? errors = true : "";
                checkInput($paymentCardExpirationYear) ? errors = true : "";
                checkInput($paymentCardCvv) ? errors = true : "";

                cardData = {
                    type: 'new',
                    name: $paymentNameOnCard.val(),
                    cardNumber: $paymentCardNumber.val(),
                    exp_month: $paymentCardExpirationMonth.val(),
                    exp_year: $paymentCardExpirationYear.val(),
                    cardCode: $paymentCardCvv.val(),
                    save: $paymentSaveMethod.is(":checked")
                };

                break;
            case 'adn-saved-method':

                cardData = {
                    type: 'adn-saved',
                    id: $selected.val(),
                    save: false
                };

                break;
        }

        if(errors) {
            $paymentCheckoutButton.prop('disabled', false);
            return;
        }

        $results = await $.ajax(
            {
                type: "POST",
                url: "ajax_authorizenet_transaction.php",
                data: {
                    cardData,
                    shippingCompany: $shippingCompanyName.val(),
                    shippingFirstName: $shippingFirstName.val(),
                    shippingLastName: $shippingLastName.val(),
                    shippingStreetAddressOne: $shippingStreetAddressOne.val(),
                    shippingStreetAddressTwo: $shippingStreetAddressTwo.val(),
                    shippingStreetAddressThree: $shippingStreetAddressThree.val(),
                    shippingCity: $shippingCity.val(),
                    shippingState: $shippingState.val(),
                    shippingZip: $shippingZipCode.val(),
                    shippingCountry: $shippingCountry.val(),
                    billingCompany: $billingCompanyName.val(),
                    phoneNumber: $shippingPhoneNumber.val(),
                    billingFirstName: $billingFirstName.val(),
                    billingLastName: $billingLastName.val(),
                    billingStreetAddressOne: $billingStreetAddressOne.val(),
                    billingStreetAddressTwo: $billingStreetAddressTwo.val(),
                    billingStreetAddressThree: $billingStreetAddressThree.val(),
                    billingCity: $billingCity.val(),
                    billingState: $billingState.val(),
                    billingZip: $billingZipCode.val(),
                    billingCountry: $billingCountry.val(),
                    comments: $paymentComment.val()
                }
            }
        );

        $resultsJ = "";
        const isSubscribing = $("#subscribe-email-checkbox").is(":checked");

        try {
            $resultsJ = JSON.parse($results);
            if(isSubscribing) {
                let userEmailResponse = await $.ajax({
                    method: "POST",
                    url: "ajax_account.php",
                    data: {
                        "post-action": "get-user-email"
                    },
                }); 

                userEmailResponse = JSON.parse(userEmailResponse);

                let subscriptionResults = await $.ajax({
                    method: "POST",
                    url: "ajax_email_subscription.php",
                    data: {
                        "email": userEmailResponse.email
                    },
                });
                subscriptionResults = JSON.parse(subscriptionResults);
            }
        } catch (e) {
            console.log($results);
        }

        if ($resultsJ.code == 1) {
            current_location = window.location.href;
            window.location.replace(`${current_location}_confirmation`);
        } else if ($resultsJ.code == 0) {
            $("#checkout-message-container").toggleClass(`bg-danger text-white`, true);
            $("#checkout-message").html($resultsJ.message);
        }

        $paymentCheckoutButton.prop('disabled', false);
    }
);

//show/hide cart contents in mobile environment
$(".cart-info-container").on("click", "#summary-container-button", function() {
        $collapsed = "";

        if (typeof $("#summary-details-container").data("collapsed") == "undefined") {
            $collapsed = true;
        } else {
            $collapsed = $("#summary-details-container").data("collapsed");
        }

        $('#summary-details-container').data('collapsed', !$collapsed);
        $('#summary-container-button').html($collapsed? '&#9650;' : '&#9660;');
        $('#summary-line-items').toggleClass('d-none', $collapsed);
        $(".checkout-collapsed-total").toggleClass('d-none', !$collapsed);
        $('#summary-details-container').toggleClass('d-none', $collapsed);
    }
);