const $guestHeaderSubtext = $('#guest-header-subtext');
const $guestEditButton = $('#guest-checkout-edit-button');
const $guestContentSection = $('#guest-checkout-info');
const $guestLoginEmail = $('#login-email');
const $guestLoginPassword = $('#login-password');
const $guestLoginButton = $('#login-button');
const $guestEmail = $('#guest-email');
const $guestFirstName = $('#guest-first-name');
const $guestLastName = $('#guest-last-name');
const $guestContinueButton = $('#guest-checkout-continue-button');

const $shippingAddressModal = $('#shipping-address-modal-target');
const $shippingHeaderSubtext = $('#shipping-header-subtext');
const $shippingEditButton = $('#checkout-shipping-edit-button');
const $shippingContentSection = $('#checkout-shipping-info');
const $shippingCompanyName = $('#shipping-company-name');
const $shippingFirstName = $('#shipping-first-name');
const $shippingLastName = $('#shipping-last-name');
const $shippingStreetAddressOne = $('#shipping-street-address-one');
const $shippingStreetAddressTwo = $('#shipping-street-address-two');
const $shippingStreetAddressThree = $('#shipping-street-address-three');
const $shippingCity = $('#shipping-city');
const $shippingState = $('#shipping-state');
const $shippingZipCode = $('#shipping-zip-code');
const $shippingCountry = $('#shipping-country');
const $shippingExtraResidential = $('#shipping-extra-residential');
const $shippingExtraLiftgate = $('#shipping-extra-liftgate');
const $shippingExtraRestricted = $('#shipping-extra-restricted-access');
const $shippingResult = $('#shipping-result-target');
const $shippingContinueButton = $('#checkout-shipping-continue-button');
let shippingValidated = false;
let hasFilledOutShipping = false;
let typingTimer;

const $billingHeaderSubtext = $('#billing-header-subtext');
const $billingEditButton = $('#checkout-billing-edit-button');
const $billingContentSection = $('#checkout-billing-info');
const $billingSameAsShipping = $('#billing-same-as-shipping');
const $billingCompanyName = $('#billing-company-name');
const $billingFirstName = $('#billing-first-name');
const $billingLastName = $('#billing-last-name');
const $billingStreetAddressOne = $('#billing-street-address-one');
const $billingStreetAddressTwo = $('#billing-street-address-two');
const $billingStreetAddressThree = $('#billing-street-address-three');
const $billingCity = $('#billing-city');
const $billingState = $('#billing-state');
const $billingZipCode = $('#billing-zip-code');
const $billingCountry = $('#billing-country');
const $billingContinueButton = $('#checkout-billing-continue-button');
let hasFilledOutBilling = false;

const $taxHeaderSubtext = $('#checkout-tax-header-subtext');
const $taxEditButton = $('#checkout-tax-edit-button');
const $taxContentSection = $('#checkout-tax-info');
const $taxTerms = $('#tax-terms');
const $taxButtons = $('#checkout-tax-content-buttons');
let hasFilledOutTaxes = false;

const $paymentHeaderSubtext = $('#payment-header-subtext');
const $paymentEditButton = $('#checkout-payment-edit-button');
const $paymentContentSection = $('#checkout-payment-info');
const $paymentMethodDropdown = $('#payment-method');
const $shippingPhoneNumber = $('#shipping-phone-number');
const $paymentNameOnCard = $('#payment-name-on-card');
const $paymentCardNumber = $('#payment-card-number');
const $paymentCardExpirationMonth = $('#payment-card-expiration-month');
const $paymentCardExpirationYear = $('#payment-card-expiration-year');
const $paymentCardCvv = $('#payment-card-cvv');
const $paymentSaveMethod = $('#payment-save-method');
const $paymentComment = $('#payment-comment');
const $paymentTermsCheckbox = $('#terms-agree-checkbox');
const $paymentCheckoutButton = $('#checkout-payment-checkout-button');
let hasFilledOutPaymentMethod = false;

function checkInput($input) {
    if ($input.val() === '' || $input.val() == null || $input.val() == undefined) {
        $input.toggleClass('input-error', true);
        return true;
    }
    $input.toggleClass('input-error', false);
    return false;
}

async function renderCartDisplay() {
    $results = await $.ajax(
        {
            type: 'POST',
            url: 'ajax_render_cart.php',
            data: {
                'post-action': 'renderCart'
            }
        }
    );

    $resultsJ = JSON.parse($results);

    if ($resultsJ.code == 1) {
        $('.cart-info-container').html($resultsJ.content);
        $('.cart-page-item-brand').each(function(){
            $(this).text($(this).text().replace(/(Freedom Electronics)|(RDM)|PMP/g, 'Rebuilt Part'));
        }); 
    }
}

async function updateCartDisplay() {
    $results = await $.ajax(
        {
            type: 'POST',
            url: 'ajax_render_cart.php',
            data: {
                'post-action': 'updateCart'
            }
        }
    );

    $resultsJ = JSON.parse($results);

    if ($resultsJ.code == 1) {
        $('#summary-line-items').html($resultsJ.content);
        $("#total-cost").html($resultsJ.total);
    } else {
        alert($resultsJ);
    }
}

async function applyCoupon(coupon_code) {
    let ajaxCall = await $.ajax({
        type: 'POST',
        url: 'ajax_coupon.php',
        data: {
            'post-action': 'apply',
            'post-data': {
                'couponCode': coupon_code
            }
        }
    });

    updateCartDisplay();
}

async function removeCoupon() {
    let ajaxCall = await $.ajax({
        type: 'POST',
        url: 'ajax_coupon.php',
        data: {
            'post-action': 'remove'
        }
    });

    updateCartDisplay();
}

async function calculateShippingAndTaxes() {
    let errors = false;
    checkInput($shippingFirstName) ? errors = true : '';
    checkInput($shippingLastName) ? errors = true : '';
    checkInput($shippingStreetAddressOne) ? errors = true : '';
    if ($shippingState.val() == 'PR') checkInput($shippingStreetAddressThree) ? errors = true : '';
    checkInput($shippingCity) ? errors = true : '';
    checkInput($shippingState) ? errors = true : '';
    checkInput($shippingZipCode) ? errors = true : '';
    checkInput($shippingCountry) ? errors = true : '';
    checkInput($shippingPhoneNumber) ? errors = true : '';
    if (errors) {
        return;
    }
    if ($billingSameAsShipping.is(':checked')) {
        copyShippingToBilling();
    }

    $shippingContinueButton.prop('disabled', true);

    shippingValidated = false;

    try {
        
        let postData;

        if ($shippingState.val() == 'PR') {
            postData = {
                line1: $shippingStreetAddressOne.val(),
                line2: $shippingStreetAddressTwo.val(),
                urbanization: $shippingStreetAddressThree.val(),
                city: $shippingCity.val(),
                state: $shippingState.val(),
                zip: $shippingZipCode.val(),
                country: $shippingCountry.val()
            };
        } else {
            postData = {
                line1: $shippingStreetAddressOne.val(),
                line2: $shippingStreetAddressTwo.val(),
                line3: $shippingStreetAddressThree.val(),
                city: $shippingCity.val(),
                state: $shippingState.val(),
                zip: $shippingZipCode.val(),
                country: $shippingCountry.val()
            };
        }

        let ajax_ups_resolve_address = await $.ajax(
            {
                method: 'POST',
                url: 'ajax_ups.php',
                data: {
                    'post-action': 'addresses',
                    'post-data': postData
                }
            }
        );

        let ajax_ups_resolve_address_j = JSON.parse(ajax_ups_resolve_address);
        let auraj = ajax_ups_resolve_address_j;

        if (auraj.code == 0) {
            console.log(auraj);
            throw new Error(`${auraj.message} (auraj)`);
        }

        if (auraj.subcode !== 2) {
            await showAddressHelpModal(auraj.display);
        }

        let ajax_ups_calculate_shipping = await $.ajax(
            {
                method: 'POST',
                url: 'ajax_shipping.php',
                data: {
                    'post-action': 'getShippingQuote',
                    'post-data': {
                        name: $shippingFirstName.val() + ' ' + $shippingLastName.val(),
                        addressLine1: $shippingStreetAddressOne.val(),
                        addressLine2: $shippingStreetAddressTwo.val(),
                        addressLine3: $shippingStreetAddressThree.val(),
                        city: $shippingCity.val(),
                        state: $shippingState.val(),
                        zip: $shippingZipCode.val(),
                        country: $shippingCountry.val(),
                        residentialCharge: $shippingExtraResidential.is(':checked'),
                        liftgateCharge: $shippingExtraLiftgate.is(':checked'),
                        restrictedAccessCharge: $shippingExtraRestricted.is(':checked')
                    }
                }
            }
        );

        let ajax_ups_calculate_shipping_j = JSON.parse(ajax_ups_calculate_shipping);
        let aucsj = ajax_ups_calculate_shipping_j;

        if (aucsj.code == 0) {
            console.log(aucsj);
            throw new Error(`${aucsj.message} (aucsj)`);
        }

        let ajax_avatax_calculate_taxes = await $.ajax(
            {
                method: 'POST',
                url: 'ajax_avatax.php',
                data: {
                    'post-action': 'taxes',
                    'post-data': {
                        'data-action': 'get',
                        name: $shippingFirstName.val() + ' ' + $shippingLastName.val(),
                        addressLine1: $shippingStreetAddressOne.val(),
                        addressLine2: $shippingStreetAddressTwo.val(),
                        city: $shippingCity.val(),
                        state: $shippingState.val(),
                        zip: $shippingZipCode.val(),
                        country: $shippingCountry.val()
                    }
                }
            }
        );

        let ajax_avatax_calculate_taxes_j = JSON.parse(ajax_avatax_calculate_taxes);
        let aactj = ajax_avatax_calculate_taxes_j;

        if (aactj.code == 0) {
            console.log(aactj);
            throw new Error(`${aactj.message} (aactj)`);
        }

        // console.log(aactj);

        $('#checkout-tax-content-summary').html(aactj.display.summary);
        $taxButtons.html(aactj.display.buttons);

        if (aucsj.code == 1 && aactj.code == 1) {
            updateCartDisplay();

            $shippingHeaderSubtext.html(`
                ${$shippingFirstName.val()} ${$shippingLastName.val()} <br />
                ${$shippingStreetAddressOne.val()}, ${$shippingCity.val()}, ${$shippingState.val()} ${$shippingZipCode.val()}
            `);
            $shippingHeaderSubtext.removeClass("d-none");
            $shippingEditButton.removeClass("d-none");
            $shippingContentSection.removeClass("d-block");
            $billingContentSection.addClass("d-block");
        }

    } catch (e) {
        return $shippingResult.html(`<div class='alert alert-warning'>${e}</div>`);
    }

    $shippingContinueButton.prop('disabled', false);
}

function showAddressHelpModal(content) {

    $shippingAddressModal.html(content);
            
    var addressCandidateModal = new bootstrap.Modal('#candidate-modal');
    addressCandidateModal.show();

    $('shipping-address-modal-target').off();

    return new Promise((resolve) => {

        $('#shipping-address-modal-target').on('click', '.list-group-item:not(.bg-westech-green)', function() {
            $current = $(this).siblings('.bg-westech-green');
        
            $current.toggleClass('bg-westech-green', false).toggleClass('text-white', false);
            $current.removeAttr('aria-current');
        
            $(this).toggleClass('bg-westech-green', true).toggleClass('text-white', true);
            $(this).attr('aria-current', true);
        });

        $('#shipping-address-modal-target').on('click', '#shipping-address-modal-target-cancel', function() {
            shippingValidated = false;

            resolve();
        })
        
        $('#shipping-address-modal-target').on('click', '#shipping-address-modal-target-select', function() {
            $selectedAddress = $('.list-group-item[aria-current="true"]');
        
            let $availableAddressLines;
        
            if ($selectedAddress.data('political-division1') == 'PR') {
                $availableAddressLines = [$shippingStreetAddressOne, $shippingStreetAddressTwo];
        
                if ($selectedAddress.data('urbization') !== 'undefined') $shippingStreetAddressThree.val($selectedAddress.data('urbanization'));
            } else {
                $availableAddressLines = [$shippingStreetAddressOne, $shippingStreetAddressTwo, $shippingStreetAddressThree];
            }
        
            let addressLine = $selectedAddress.data('address-line');
        
            let bracketCheck = addressLine.match(/^\[(.*?)\]$/);
        
            if (bracketCheck) {
                let addressData = bracketCheck[1].split(',');
        
                let addressParts = Math.ceil(addressData.length / $availableAddressLines.length);
        
                let addressDataFilled = Array.from({length: $availableAddressLines.length}, () => addressData.splice(0, addressParts));
        
                for (let a = 0; a < addressDataFilled.length; a++) {
                    $availableAddressLines[a].val(addressDataFilled[a].join(', '));
                }
            } else {
                $shippingStreetAddressOne.val(addressLine);
            }
        
            $shippingCity.val($selectedAddress.data('political-division2'));
        
            $shippingState.val($selectedAddress.data('political-division1'));
        
            $shippingZipCode.val(`${$selectedAddress.data('postcode-primary-low')}-${$selectedAddress.data('postcode-extended-low')}`);
        
            $shippingCountry.val($selectedAddress.data('country-code'));
        
            let isResidential = $selectedAddress.data('code') == 2;
        
            $shippingExtraResidential.prop({checked: isResidential, disabled: isResidential});

            shippingValidated = true;

            resolve();
        });

    });

}

// $("input#payment-card-number").focusout(function () {
//     var cardNumber = $(this).val();
//     var amex = /^3[47][0-9]{13}$/;
//     if (amex.test(cardNumber)) {
//         $("#payment-card-cvv").attr("maxlength", 4).attr('placeholder', "####");
//     } else {  
//         $("#payment-card-cvv").attr("maxlength", 3).attr('placeholder', "###");
//     }
// });

function copyShippingToBilling() {
    $billingCompanyName.val($shippingCompanyName.val());
    $billingFirstName.val($shippingFirstName.val());
    $billingLastName.val($shippingLastName.val());
    $billingStreetAddressOne.val($shippingStreetAddressOne.val());
    $billingStreetAddressTwo.val($shippingStreetAddressTwo.val());
    $billingCity.val($shippingCity.val());
    $billingState.val($shippingState.val());
    $billingZipCode.val($shippingZipCode.val());
    $billingCountry.val($shippingCountry.val());
}

$(window).on('load',
    function() {
        renderCartDisplay();
    }
);

$('.cart-info-container').on('click', '#coupon-code-apply', function() {
    applyCoupon($('#coupon-code-input').val());
});

$('.cart-info-container').on('click', '#coupon-code-remove', function() {
    removeCoupon();
});

$guestLoginButton.click(
    async function() {
        $guestLoginButton.prop('disabled', true);
        $('#alert-box-guest-login').html('');

        let errors = false;

        checkInput($guestLoginEmail)? errors = true : '';
        checkInput($guestLoginPassword)? errors = true : '';
        if (errors) {
            $guestLoginButton.prop('disabled', false);
            return;
        }

        let guestLoginResut = await $.ajax(
            {
                type: 'POST',
                url: 'ajax_login_process.php',
                data: {
                    'mode': 'login',
                    'email': $guestLoginEmail.val(),
                    'password': $guestLoginPassword.val()
                }
            }
        );

        let guestLoginResultJ = JSON.parse(guestLoginResut);

        $guestLoginButton.prop('disabled', false);

        if (guestLoginResultJ.code == 0) {
            return $('#alert-box-guest-login').html(`<div class='alert alert-danger'>${guestLoginResultJ.message}</div>`);
        }

        location.reload();
    }
);

$guestContinueButton.click(
    async function() {
        $('#alert-box-guest-continue').html('');
        $guestContinueButton.prop('disabled', true);

        let errors = false;

        checkInput($guestFirstName)? errors = true : '';
        checkInput($guestLastName)? errors = true : '';
        checkInput($guestEmail)? errors = true : '';

        if (errors) {
            $guestContinueButton.prop('disabled', false);
            return;
        }

        let checkEmail = await $.ajax(
            {
                type: 'POST',
                url: 'ajax_login_process.php',
                data: {
                    'mode': 'guest',
                    'first': $guestFirstName.val(),
                    'last': $guestLastName.val(),
                    'email': $guestEmail.val()
                }
            }
        );

        checkEmailJ = JSON.parse(checkEmail);

        $guestContinueButton.prop('disabled', false);

        if (checkEmailJ.code == 0) {
            return $('#alert-box-guest-continue').html(`<div class='alert alert-danger'>${checkEmailJ.message}</div>`);
        }

        $guestEditButton.removeClass('d-none');
        $guestContentSection.removeClass('d-block');
        $shippingContentSection.addClass('d-block');
    }
);

$guestEditButton.click(
    function() {
        $('.checkout-item-content.d-block').removeClass('d-block');
        $guestContinueButton.prop('disabled', false);
        $guestContentSection.addClass('d-block');
    }
);

$shippingState.change(function() {
    if ($(this).val() == 'PR') {
        $shippingStreetAddressThree.attr('placeholder', 'Urbanization');
        $shippingStreetAddressThree.siblings('label').html('Urbanization');
    } else {
        $shippingStreetAddressThree.attr('placeholder', 'Shipping Address Line 3 ');
        $shippingStreetAddressThree.siblings('label').html('Street Address 3 (Optional)');
    }
});

$shippingContinueButton.click(
    function() {
        calculateShippingAndTaxes();
    }
);

$billingSameAsShipping.change(
    function() {
        if(this.checked) {
            copyShippingToBilling();
            $billingCompanyName.prop('disabled', true);
            $billingFirstName.prop('disabled', true);
            $billingLastName.prop('disabled', true);
            $billingStreetAddressOne.prop('disabled', true);
            $billingStreetAddressTwo.prop('disabled', true);
            $billingStreetAddressThree.prop('disabled', true);
            $billingCity.prop('disabled', true);
            $billingState.prop('disabled', true);
            $billingZipCode.prop('disabled', true);
            $billingCountry.prop('disabled', true);
            return;
        }
        $billingCompanyName.prop('disabled', false);
        $billingFirstName.prop('disabled', false);
        $billingLastName.prop('disabled', false);
        $billingStreetAddressOne.prop('disabled', false);
        $billingStreetAddressTwo.prop('disabled', false);
        $billingStreetAddressThree.prop('disabled', false);
        $billingCity.prop('disabled', false);
        $billingState.prop('disabled', false);
        $billingZipCode.prop('disabled', false);
        $billingCountry.prop('disabled', false);
    }
);

$shippingEditButton.click(
    function() {
        $('.checkout-item-content.d-block').removeClass('d-block');
        $shippingContinueButton.prop('disabled', false);
        $shippingContentSection.addClass('d-block');
    }
);

$billingContinueButton.click(
    function() {
        let errors = false;
        checkInput($billingFirstName)? errors = true : '';
        checkInput($billingLastName)? errors = true : '';
        checkInput($billingStreetAddressOne)? errors = true : '';
        checkInput($billingCity)? errors = true : '';
        checkInput($billingState)? errors = true : '';
        checkInput($billingZipCode)? errors = true : '';
        checkInput($billingCountry)? errors = true : '';
        if (errors) {
            return;
        }

        $billingHeaderSubtext.removeClass('d-none');
        $billingEditButton.removeClass('d-none');
        $billingContentSection.removeClass('d-block');
        $taxContentSection.addClass('d-block');

        $billingHeaderSubtext.html(`
            ${$billingFirstName.val()} ${$billingLastName.val()} <br />
            ${$billingStreetAddressOne.val()}, ${$billingCity.val()}, ${$billingState.val()} ${$billingZipCode.val()}
        `);
    }
);

$billingEditButton.click(
    function() {
        $('.checkout-item-content.d-block').removeClass('d-block');
        $billingContinueButton.prop('disabled', false);
        $billingContentSection.addClass('d-block');
    }
);

$taxButtons.on('click', '#checkout-tax-continue-button',
    function() {
        $taxHeaderSubtext.removeClass('d-none');
        $taxEditButton.removeClass('d-none');
        $taxContentSection.removeClass('d-block');
        $paymentContentSection.addClass('d-block');

        let rateT = 0.00;
        let amountT = 0.00;

        $('#checkout-tax-content-summary > table > tbody > tr').each(
            function() {
                rateT += Number.parseFloat($(this).children('td').eq(2).text());
                amountT += Number.parseFloat($(this).children('td').eq(3).text().substr(1));
            }
        );

        rateT *= 100 // Get percent instead of decimal percentage
        rateT = parseFloat((Math.floor(rateT*1000)/1000).toFixed(4)); // round to nearest
        amountT = (Math.floor(amountT*1000)/1000).toFixed(2); // round to nearest

        $taxHeaderSubtext.html(`
            ${rateT}% <br /> $${amountT}
        `);
    }
);

$taxEditButton.click(
    function() {
        $('.checkout-item-content.d-block').removeClass('d-block');
        $('#checkout-tax-continue-button').prop('disabled', false);
        $taxContentSection.addClass('d-block');
    }
);

$paymentCheckoutButton.click(
    async function() {
        $paymentCheckoutButton.prop('disabled', true);
        $('#checkout-message-container').toggleClass('bg-warning text-white', false);
        $('#checkout-message').html('');

        let errors = false;

        if (!$shippingPhoneNumber.val() == '') $shippingPhoneNumber.val().match('\\+?\\d{1,4}?[- .\s]?\\(?\\d{1,3}\\)?[- .\s]?\\d{1,4}[- .\s]?\\d{1,9}[ :]?(ext|extension)?[. :]{0,2}(\\d{0,5}).*') ? '' : errors = true;
        checkInput($paymentNameOnCard)? errors = true : '';
        checkInput($paymentCardNumber)? errors = true : '';
        checkInput($paymentCardExpirationMonth)? errors = true : '';
        checkInput($paymentCardExpirationYear)? errors = true : '';
        checkInput($paymentCardCvv)? errors = true : '';

        if (!$paymentTermsCheckbox.is(':checked'))
        {
            errors = true;
            $paymentTermsCheckbox.toggleClass('input-error', true);
        }

        if (errors) {
            $paymentCheckoutButton.prop('disabled', false);
            return;
        }

        let cardData = {
            type: 'guest',
            name: $paymentNameOnCard.val(),
            cardNumber: $paymentCardNumber.val(),
            exp_month: $paymentCardExpirationMonth.val(),
            exp_year: $paymentCardExpirationYear.val(),
            cardCode: $paymentCardCvv.val()
        }

        $results = await $.ajax(
            {
                type: 'POST',
                url: 'ajax_authorizenet_transaction.php',
                data: {
                    email: $guestEmail.val(),
                    cardData,
                    shippingCompany: $shippingCompanyName.val(),
                    shippingFirstName: $shippingFirstName.val(),
                    shippingLastName: $shippingLastName.val(),
                    shippingStreetAddressOne: $shippingStreetAddressOne.val(),
                    shippingStreetAddressTwo: $shippingStreetAddressTwo.val(),
                    shippingStreetAddressThree: $shippingStreetAddressThree.val(),
                    shippingCity: $shippingCity.val(),
                    shippingState: $shippingState.val(),
                    shippingZip: $shippingZipCode.val(),
                    shippingCountry: $shippingCountry.val(),
                    billingCompany: $billingCompanyName.val(),
                    phoneNumber: $shippingPhoneNumber.val(),
                    billingFirstName: $billingFirstName.val(),
                    billingLastName: $billingLastName.val(),
                    billingStreetAddressOne: $billingStreetAddressOne.val(),
                    billingStreetAddressTwo: $billingStreetAddressTwo.val(),
                    billingStreetAddressThree: $billingStreetAddressThree.val(),
                    billingCity: $billingCity.val(),
                    billingState: $billingState.val(),
                    billingZip: $billingZipCode.val(),
                    billingCountry: $billingCountry.val(),
                    comments: $paymentComment.val(),
                    save: false
                }
            }
        );

        $resultsJ = "";

        try {
            $resultsJ = JSON.parse($results);
            if(isSubscribing) {
                let subscriptionResults = await $.ajax({
                    method: "POST",
                    url: "ajax_email_subscription.php",
                    data: {
                        "email": $guestEmail.val()
                    },
                });
                subscriptionResults = JSON.parse(subscriptionResults);
            }
        } catch (e) {
            console.log($results);
        }

        if ($resultsJ.code == 1) {
            current_location = window.location.href;
            window.location.replace(`${current_location}_confirmation`);
        } else if ($resultsJ.code == 0) {
            $('#checkout-message-container').toggleClass(`bg-danger text-white`, true);
            $('#checkout-message').html($resultsJ.message);
        }

        $paymentCheckoutButton.prop('disabled', false);
    }
);

//show/hide cart contents in mobile environment
$('.cart-info-container').on('click', '#summary-container-button', function() {
        $collapsed = '';

        if (typeof $('#summary-details-container').data('collapsed') == 'undefined') {
            $collapsed = true;
        } else {
            $collapsed = $('#summary-details-container').data('collapsed');
        }

        $('#summary-details-container').data('collapsed', !$collapsed);
        $('#summary-container-button').html($collapsed? '&#9650;' : '&#9660;');
        $('#summary-line-items').toggleClass('d-none', $collapsed);
        $(".checkout-collapsed-total").toggleClass('d-none', !$collapsed);
        $('#summary-details-container').toggleClass('d-none', $collapsed);
    }
);