<?php
/**
 * checkout_confirmation header_php.php
 *
 * @copyright Copyright 2003-2022 Zen Cart Development Team
 * @copyright Portions Copyright 2003 osCommerce
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version $Id: torvista 2022 Feb 18 Modified in v1.5.8-alpha $
 */

// This should be first line of the script:
$zco_notifier->notify('NOTIFY_HEADER_START_CHECKOUT_CONFIRMATION');

// if the customer is not logged on, redirect them to the shopping cart page
if (!isset($_SESSION['temp_customer_id'])) {
  zen_redirect(zen_href_link(FILENAME_TIME_OUT));
}

$oID = null;

if (isset($_SESSION['new_oID']))
{
  $oID = $_SESSION['new_oID'];

  //unset as this page will contain a gtag event that should only ever fire once to track conversions
  unset($_SESSION['new_oID']);
}

if (is_null($oID))
{
  zen_redirect(FILENAME_SHOPPING_CART);
}

$order_query = $db->Execute("SELECT * FROM zen_orders WHERE orders_id = $oID");

if ($order_query->fields['customers_id'] != $_SESSION['temp_customer_id'])
{
  zen_redirect(FILENAME_SHOPPING_CART);
}

define('HEADING_TITLE', 'Checkout Confirmation');

// This should be last line of the script:
$zco_notifier->notify('NOTIFY_HEADER_END_CHECKOUT_CONFIRMATION');
