const $sendEmailButton = $("#contact-send-email-button");

function checkInput($input) {
    if ($input.val() === "" || $input.val() == null || $input.val() == undefined) {
        $input.toggleClass("input-error", true);
        return true;
    }
    $input.toggleClass("input-error", false);
    return false;
}

async function sendContactEmail() {
    $sendEmailButton.prop("disabled", true);
    $sendEmailButton.html("Sending...");
    const emailData = {
        toEmail: $("#contact-email").val(),
        toName: $("#contact-full-name").val(),
        subject: $("#contact-subject").val(),
        phoneNumber: $("#contact-phone").val(),
        body: $("#contact-message").val(),
        isContactRequest: true,
    }
    let hasError = false;
    checkInput($("#contact-email"))? hasError = true : "";
    checkInput($("#contact-full-name"))? hasError = true : "";
    checkInput($("#contact-subject"))? hasError = true : "";
    checkInput($("#contact-phone"))? hasError = true : "";
    checkInput($("#contact-message"))? hasError = true : "";

    if(hasError) {
        $sendEmailButton.html("Send");
        $sendEmailButton.prop("disabled", false);
        return $('#alert-box').html(`<div class="alert alert-danger">Could not send message. These fields are required.</div>`);
    }
    let emailResult = await $.ajax({
        method: "POST",
        url: "ajax_send_email.php",
        data: emailData,
    });
    emailResult = JSON.parse(emailResult);
    if(emailResult.result_code === 0) {
        $sendEmailButton.html("Send");
        $sendEmailButton.prop("disabled", true);
        return $('#alert-box').html(`<div class="alert alert-success">${account_results.message}</div>`);
    }
    $sendEmailButton.html("Email Sent!");
}

$sendEmailButton.click(sendContactEmail);