<?php

if (file_exists('includes/modules/tforce/config.tforce.php'))
{
    require 'includes/modules/tforce/config.tforce.php';
}
else
{
    require '../includes/modules/tforce/config.tforce.php';
}

function tforce_freight_rate($shipto, $shipfrom, $products, $serviceCode = '308') {
    global $shipperNumber;

    $url = "https://api.tforcefreight.com/rating/getRate?api-version=v1";

    $data = array(
        'requestOptions' => array(
            'serviceCode' => $serviceCode,
            'pickupDate' => date('Y-m-d', strtotime('+5 days')),
            'type' => 'L',
            'densityEligble' => true
        ),
        'shipFrom' => array(
            'address' => array(
                'city' => $shipfrom['city'],
                'stateProvinceCode' => $shipfrom['state'],
                'postalCode' => $shipfrom['zip'],
                'country' => $shipfrom['country'],
            )
        ),
        'shipTo' => array(
            'address' => array(
                'city' => $shipto['city'],
                'stateProvinceCode' => $shipto['state'],
                'postalCode' => $shipto['zip'],
                'country' => $shipto['country'],
                'isResidential' => $shipto['residential']
            )
        ),
        'payment' => array(
            'payer' => array(
                'address' => array(
                    'city' => 'Millcreek',
                    'stateProvinceCode' => 'UT',
                    'postalCode' => '84157',
                    'country' => 'US'
                )
            ),
            'billingCode' => '10'
        )
    );

    if ($shipto['residential'] || $shipto['liftgate'] || $shipto['restricted']) {
        $data['serviceOptions'] = array(
            'delivery' => array()
        );

        if ($shipto['liftgate']) $data['serviceOptions']['delivery'][] = 'LIFD';
        if ($shipto['restricted']) $data['serviceOptions']['delivery'][] = 'LADL';
        // if ($shipto['residential']) $data['serviceOptions']['delivery'][] = 'RESD';
    }

    $commodities = array();

    foreach ($products as $commodity) {
        $commodities[] = array(
            'class' => "{$commodity['freight_class']}",
            'pieces' => $commodity['quantity'],
            'weight' => array(
                'weight' => $commodity['weight'] * $commodity['quantity'],
                'weightUnit' => 'LBS'
            ),
            'packagingType' => 'PAL',
            'dimensions' => array(
                'length' => $commodity['length'],
                'width' => $commodity['width'],
                'height' => $commodity['height'],
                'unit' => 'IN'
            )
        );
    }

    $data['commodities'] = $commodities;

    return tforce_call_api($url, $data);
}