$footerSubscribeButton = $("#footer-subscribe-button");
$footerEmailSubscriptionInput = $("#footer-email-subscription-input");

// Flag to enable and disable button
let buttonDisabled = true;

/*
    $footerEmailSubscriptionInput.keyup()
    Purpose: Control the submit button disabled status
    Params: 
        event - Keyup event for input field
    Returns: NONE
*/
$footerEmailSubscriptionInput.keyup(({ target }) => {
    // Check if input is not empty and button is not disabled
    if(target.value != "" && buttonDisabled) {
        // toggle disabled button flag
        buttonDisabled = false;
        // Update button disabled status
        $footerSubscribeButton.prop("disabled", buttonDisabled);
    }
    // Check if input is empty and button is enabled 
    else if(target.value == "" && buttonDisabled == false) {
        // toggle disabled button flag
        buttonDisabled = true;
        // Update button disabled status
        $footerSubscribeButton.prop("disabled", buttonDisabled);
    }
}); // End $footerEmailSubscriptionInput.keyup()

$footerSubscribeButton.click(async function(){
    let isSubscribing = true;
    const email = $footerEmailSubscriptionInput.val();
    $footerSubscribeButton.prop("disabled", true);
    $footerSubscribeButton.html("Subscribing...");
    let subscriptionResults = await $.ajax({
        method: "POST",
        url: "ajax_email_subscription.php",
        data: {
            "email": email
        },
    });
    subscriptionResults = JSON.parse(subscriptionResults);
    if(subscriptionResults.result_code == 0) {
        $footerSubscribeButton.prop("disabled", false);
        $footerSubscribeButton.html("Subscribe");
        return alert(subscriptionResults.message);
    }
    $footerSubscribeButton.html("Subscribed!");
    return alert(subscriptionResults.message);
});