 // Grab all navvbar nav-item class elements
 const $NAV_ITEMS = $(".nav-item");
 // Init a timeout variable to be used below
 let timeout = null;
 let focusTimeout = null;
 // Actions that can occur
 const ACTIONS = {
     MouseEnter: "MouseEnter",
     MouseLeave: "MouseLeave",
 };
 
 /*
     handleNavebarLinkInteractions()
     Purpose: handle all nav-item class element interactions
     Params:
         el - Element that is to be altered
         action - action to take for the interaction
     Returns:
         NONE
 */
 function handleNavItemInteractions(el, action) {
     // use Jquery to get window and store it in a variable
     const $WINDOW = $(window);
     // boolean to check if the device is a mobile device
     // Value is set using navigator.userAgentData object
     // Added null checks for browser compatibility
     const isMobile = navigator?.userAgentData?.mobile;
     // Get link and dropdown elements
     const [ linkTag, dropdownList ] = el.children;
     // Check if window width is greater than or equal to tablet size
     if($WINDOW.width() >= 768 && !isMobile ) {
         // use Jquery to store link element into a variable
         const $LINK_TAG_ELEMENT = $(linkTag);
         // use jquery to store dropdown element into a variable
         const $DROPDOWN_LIST_ELEMENT = $(dropdownList);
         // Check Actions
         switch(action) {
             case ACTIONS.MouseEnter: // mouse enter action
                 // Add show class and update aria-expanded to true to link tag
                 $LINK_TAG_ELEMENT.addClass("show").attr("aria-expanded", "true");
                 // Add class show to dropdown list
                 $DROPDOWN_LIST_ELEMENT.addClass("show");  
                 break;
             case ACTIONS.MouseLeave: // Mouse Leae Action
                 $LINK_TAG_ELEMENT.removeClass("show").attr("aria-expanded", "false");
                 $DROPDOWN_LIST_ELEMENT.removeClass("show");
                 break;
             default: // No action taken
                 console.log("No action taken");
                 break;
         } // end checking actions
     } // End checking window width

 } // End handleNavItemInteractions()

 /*
     mouseenter()
     Purpose: alter navbar element on mouse entering the element
     params: 
         function() - declarred function to handle element manipulation
     returns: 
         NONE
 */
 $NAV_ITEMS.mouseenter(function(){
     handleNavItemInteractions(this, ACTIONS.MouseEnter);
 }); // End mouseenter()

 /*
     mouseleave()
     Purpose: alter navbar element on mouse leaving the element
     params: 
         function() - declarred function to handle element manipulation
     returns: 
         NONE
 */
 $NAV_ITEMS.mouseleave(function(){
     handleNavItemInteractions(this, ACTIONS.MouseLeave);
 }); // End mouseLeave()

 $("#navbar-search-input").keyup(function(event) {
    const invalidKeyCodes = [16, 19, 20, 27, 33, 34, 35, 36, 37, 38, 39, 40, 91, 92];

    $input = $(this);
    const inputvalue = $input.val();
    clearTimeout(timeout);
    const $searchContainer = $("#navbar-search-results-container");
    if(inputvalue == "" || invalidKeyCodes.includes(event.keyCode)) {
        $searchContainer.addClass("d-none");
        $searchContainer.removeClass("d-block");
        return;   
    } else {
        $searchContainer.removeClass("d-none");
        $searchContainer.addClass("d-block");
    }
    timeout = setTimeout(async () => {
        const queryData = await $.ajax({
            type: "POST",
            url: "ajax_search.php",
            data: {
                "post-action": "quick-search",
                "post-data": {
                    "term": inputvalue
                },
            }
        });
        console.log(queryData);
        const { code, message, results } = JSON.parse(queryData);
        let listItems = "";
        let count = 0;
        for(const resultId in results) {
            const {id, manufacturesId, productImage, productName, urlLink, manufacturesName, productModel} = results[resultId];
            const listItemClass = count % 2 == 0 ? " quick-search-even-row" : " quick-search-odd-row";
            listItems += `
                <li class='list-group-item quick-search-item ${listItemClass}'>
                    <a class='quick-search-link' href='${urlLink}' title='${manufacturesName} quick search result'>
                        <div class='row quick-search-row'>
                            <div class='col-3 left-column'>
                                <img src='images/${productImage}' class='img-fluid quick-search-image' alt='${productName} preview' />
                            </div>
                            <div class='col-9'>
                                <p class='mb-1 manu-text'>${productModel} - ${manufacturesName}</p>
                                <p class='mb-0 name-text'>${productName}</p>   
                            </div>
                        </div>
                    </a>
                </li>
            `;
            count++;
        }
        let html = `
            <div class='quick-search-list-container'>
                <ul class='list-group'>
                    ${listItems}
                    <li class='list-group-item'>
                        <p class='text-center small-text mb-1'>
                            Didn't find what you are looking for? Try our <a href="/?main_page=search" class='text-black'>Advanced Search</a>
                        </p>
                    </li>
                </ul>
            </div>
        `;
        $("#navbar-search-results-container").html(html);
    }, 500);
});

$("#navbar-search-input").focusin(function() {
    const $input = $(this);
    const inputValue = $input.val();
    if(inputValue != "") {
        const $searchContainer = $("#navbar-search-results-container");
        $searchContainer.addClass("d-block");
        $searchContainer.removeClass("d-none");
    }
});
$("#navbar-search-input").focusout(function() {
    clearTimeout(focusTimeout);
    const $input = $(this);
    const inputValue = $input.val();
    if(inputValue != "") { 
        focusTimeout = setTimeout(() => {
            const $searchContainer = $("#navbar-search-results-container");
            $searchContainer.addClass("d-none");
            $searchContainer.removeClass("d-block");
        }, 1000);
    }
});
$("#navbar-search-form").submit(function(event) {
    event.preventDefault();
    const $input = $("#navbar-search-input");
    const inputValue = $input.val();
    if(inputValue == "") {
        window.location.href = `?main_page=search`;
    } else {
        window.location.href = `?main_page=search_result&keyword=${inputValue}&search-in-description=on&inc_subcat=1&search_in_description=0&sort=20a`;
    }
});
