<?php
    $display = isset($_GET['display'])? $_GET['display'] : false;
    $defaultListItemClass = "list-group-item list-group-item-action";
    $activeListItemClass = "list-group-item list-group-item-action active";
    $state_abbreviations = array(
        array('id' => 'AL', 'text' => 'Alabama'),
        array('id' => 'AK', 'text' => 'Alaska'),
        array('id' => 'AZ', 'text' => 'Arizona'),
        array('id' => 'AR', 'text' => 'Arkansas'),
        array('id' => 'CA', 'text' => 'California'),
        array('id' => 'CO', 'text' => 'Colorado'),
        array('id' => 'CT', 'text' => 'Connecticut'),
        array('id' => 'DE', 'text' => 'Delaware'),
        array('id' => 'DC', 'text' => 'District of Columbia'),
        array('id' => 'FL', 'text' => 'Florida'),
        array('id' => 'GA', 'text' => 'Georgia'),
        array('id' => 'HI', 'text' => 'Hawaii'),
        array('id' => 'ID', 'text' => 'Idaho'),
        array('id' => 'IL', 'text' => 'Illinois'),
        array('id' => 'IN', 'text' => 'Indiana'),
        array('id' => 'IA', 'text' => 'Iowa'),
        array('id' => 'KS', 'text' => 'Kansas'),
        array('id' => 'KY', 'text' => 'Kentucky'),
        array('id' => 'LA', 'text' => 'Louisiana'),
        array('id' => 'ME', 'text' => 'Maine'),
        array('id' => 'MD', 'text' => 'Maryland'),
        array('id' => 'MA', 'text' => 'Massachusetts'),
        array('id' => 'MI', 'text' => 'Michigan'),
        array('id' => 'MN', 'text' => 'Minnesota'),
        array('id' => 'MS', 'text' => 'Mississippi'),
        array('id' => 'MO', 'text' => 'Missouri'),
        array('id' => 'MT', 'text' => 'Montana'),
        array('id' => 'NE', 'text' => 'Nebraska'),
        array('id' => 'NV', 'text' => 'Nevada'),
        array('id' => 'NH', 'text' => 'New Hampshire'),
        array('id' => 'NJ', 'text' => 'New Jersey'),
        array('id' => 'NM', 'text' => 'New Mexico'),
        array('id' => 'NY', 'text' => 'New York'),
        array('id' => 'NC', 'text' => 'North Carolina'),
        array('id' => 'ND', 'text' => 'North Dakota'),
        array('id' => 'OH', 'text' => 'Ohio'),
        array('id' => 'OK', 'text' => 'Oklahoma'),
        array('id' => 'OR', 'text' => 'Oregon'),
        array('id' => 'PA', 'text' => 'Pennsylvania'),
        array('id' => 'RI', 'text' => 'Rhode Island'),
        array('id' => 'SC', 'text' => 'South Carolina'),
        array('id' => 'SD', 'text' => 'South Dakota'),
        array('id' => 'TN', 'text' => 'Tennessee'),
        array('id' => 'TX', 'text' => 'Texas'),
        array('id' => 'UT', 'text' => 'Utah'),
        array('id' => 'VT', 'text' => 'Vermont'),
        array('id' => 'VA', 'text' => 'Virginia'),
        array('id' => 'WA', 'text' => 'Washington'),
        array('id' => 'WV', 'text' => 'West Virginia'),
        array('id' => 'WI', 'text' => 'Wisconsin'),
        array('id' => 'WY', 'text' => 'Wyoming'),
        array('id' => 'AS', 'text' => 'American Samoa'),
        array('id' => 'GU', 'text' => 'Guam'),
        array('id' => 'MP', 'text' => 'Northern Marina Islands'),
        array('id' => 'PR', 'text' => 'Puerto Rico'),
        array('id' => 'UM', 'text' => 'US Minor Islands'),
        array('id' => 'VI', 'text' => 'Virgin Islands'),
        array('id' => 'AA', 'text' => 'Armed Forces America (Outside Canada)'),
        array('id' => 'AE', 'text' => 'Armed Forces Africa'),
        array('id' => 'AE', 'text' => 'Armed Forces Canada'),
        array('id' => 'AE', 'text' => 'Armed Forces Europe'),
        array('id' => 'AE', 'text' => 'Armed Forces Middle East'),
        array('id' => 'AP', 'text' => 'Armed Forces Pacific')
    );

    $stateListIdsToText = "";
    $stateListTextToText = "";
    foreach ($state_abbreviations as $state)
    {
        $id = $state['id'];
        $text = $state['text'];
        $stateListIdsToText .=  "<option value='$id'>$text</option>";
        $stateListTextToText .=  "<option value='$text'>$text</option>";
    }

    function renderAddressBook() {
        global $stateListIdsToText;
        global $db;
        $customerId = $_SESSION['customer_id'];
        $customerInfo = $db->Execute("SELECT customers_default_address_id FROM zen_customers WHERE customers_id = $customerId");
        $_SESSION['customer_default_address_id'] = $customerInfo->fields['customers_default_address_id'];
        $customerDefaultAddressId = $customerInfo->fields['customers_default_address_id'];
        $addressBookQuery = "
         SELECT * FROM `zen_address_book` WHERE customers_id = $customerId;
        ";
        $existingAddressList = "";
        $addressResults = $db->Execute($addressBookQuery);
        // Create Dropdown List Saved Address Options
        foreach($addressResults as $address){
            $addressBookId = $address['address_book_id'];
            $addressCompanyName = $address['entry_company'];
            $addressFirstName = $address['entry_firstname'];
            $addressLastName = $address['entry_lastname'];
            $addressStreetAddress = $address['entry_street_address'];
            $addressStreetAddressTwo = $address['entry_street_address_two'];
            $addressStreetAddressThree = $address['entry_street_address_three'];
            $addressCity = $address['entry_city'];
            $addressState = $address['entry_state'];
            $addressZipCode = $address['entry_postcode'];
            $addressCountry = $address['entry_country_id'];
            $isDefaultAddress = $customerDefaultAddressId == $addressBookId ? "true" : "false";
            $addressText = "$addressStreetAddress $addressStreetAddressTwo, $addressCity, $addressState, $addressZipCode";
            $addressText .= $isDefaultAddress == "true" ? " (Default)" : "";
            $existingAddressList .= "
                <option 
                    data-company-name='$addressCompanyName' 
                    data-first-name='$addressFirstName' data-last-name='$addressLastName' data-state='$addressState'
                    data-city='$addressCity' data-zip='$addressZipCode' data-country='$addressCountry' data-default='$isDefaultAddress'
                    data-street-address='$addressStreetAddress' data-street-address-two='$addressStreetAddressTwo' 
                    data-street-address-three='$addressStreetAddressThree' data-address-book-id='$addressBookId'
                    value='saved-address'
                >
                    $addressText
                </option>
            ";
        }

        $title = "<h2 class='mb-3'>Address Book</h2>";

        $dropdownList = "
        <div class='mb-5 form-floating-label-container'>
            <select class='form-select' id='address-book-list' name='address-book-list'>
                <option 
                    data-company-name='' data-default='true'
                    data-first-name='' data-last-name='' data-state=''
                    data-city='' data-zip='' 
                    data-street-address='' data-street-address-two='' 
                    data-street-address-two='' value='new' selected
                >
                    New Address
                </option>
                $existingAddressList
            </select>
            <label for='address-book-list'>Select Address</label>
        </div>
        ";

        $addressBookForm = "
        <form class='account-form mb-3' id='address-book-form'>
            $dropdownList
            <div class='mb-3 form-floating-label-container'>
                <input class='form-control' id='company-name' name='company-name' placeholder='Input Company Name' />
                <label for='company-name'>Company Name (Optional)</label>
            </div>
            <div class='row'>
                <div class='col-sm-12 col-md-6'>
                    <div class='mb-3 form-floating-label-container'>
                        <input class='form-control' id='first-name' name='first-name' placeholder='Input First Name' />
                        <label for='first-name'>First Name</label>
                    </div>
                </div>
                <div class='col-sm-12 col-md-6'>
                    <div class='mb-3 form-floating-label-container'>
                        <input class='form-control' id='last-name' name='last-name' placeholder='Input Last Name' />
                        <label for='last-name'>Last Name</label>
                    </div>
                </div>
            </div>
            <div class='mb-3 form-floating-label-container'>
                <input class='form-control' id='street-address' name='street-address' placeholder='Input Street Address' />
                <label for='street-address'>Street Address One</label>
            </div>
            <div class='mb-3 form-floating-label-container'>
                <input class='form-control' id='street-address-two' name='street-address-two' placeholder='Input Address Line Two' />
                <label for='street-address-two'>Street Address 2 (Optional)</label>
            </div>
            <div class='mb-3 form-floating-label-container'>
                <input class='form-control' id='street-address-three' name='street-address-three' placeholder='Input Address Line Three' />
                <label for='street-address-three'>Street Address 3 (Optional)</label>
            </div>
            <div class='row'>
                <div class='col-12 col-md-6'>
                    <div class='mb-3 form-floating-label-container'>
                        <input type='text' class='form-control' id='city' name='city' placeholder='Input City Name' />
                        <label for='city'>City</label>
                    </div>
                </div>
                <div class='col-6 col-md-3'>
                    <div class='form-floating-label-container'>
                        <select class='form-select' id='state' name='state'>
                            <option disabled selected>Choose...</option>
                            $stateListIdsToText
                        </select>
                        <label for='state'>State</label>
                    </div>
                </div>
                <div class='col-6 col-md-3'>
                    <div class='mb-3 form-floating-label-container'>
                        <input type='text' class='form-control' id='zip-code' name='zip-code' placeholder='Input Zip'>
                        <label for='zip-code'>Zip Code</label>
                    </div>
                </div>
            </div>
            <div class='row'>
                <div class='form-floating-label-container'>
                    <select class='form-select' id='country' name='country'>
                        <option disabled selected>Select Country...</option>
                        <option value='US'>United States</option>
                    </select>
                    <label for='country'>Country</label>
                </div>
            </div>
            <div class='form-check mb-3'>
                <input class='form-check-input' type='checkbox' id='default-address' checked>
                <label class='form-check-label' for='default-address'>
                    Default Address
                </label>
            </div>
            <div id='address-book-alert-container'></div>
            <div class='row' id='address-button-container'>
                <div class='col-12 col-md-6 offset-md-3'>
                    <button type='button' id='address-save-button' class='btn bg-westech-green w-100 text-white' onclick='saveAddress()'>Add Address</button>
                </div>
            </div>
        </form>
        ";

        return $title . $addressBookForm;
    }
    function renderAccountInformation() {
        global $db;
        $seperator = "<div class='seperator mb-5'></div>";
        $customerId = $_SESSION['customer_id'];
        $emailAddress = $_SESSION['customers_email_address'];
        $customerInfo = $db->Execute("
            SELECT ci.customers_info_date_account_created, c.customers_firstname, c.customers_lastname, c.customers_telephone, c.customers_newsletter 
            FROM zen_customers_info ci LEFT JOIN zen_customers c ON c.customers_id = ci.customers_info_id  
            WHERE customers_info_id = $customerId"
        );
        $accountCreatedDate = $customerInfo->fields['customers_info_date_account_created'];
        $accountCreatedDate = date('M d, Y', strtotime($accountCreatedDate));
        $firstName = $customerInfo->fields['customers_firstname'];
        $lastName = $customerInfo->fields['customers_lastname'];
        $phoneNumber = $customerInfo->fields['customers_telephone'];
        
        $emailSubscription = $db->Execute("SELECT * FROM zen_email_subscriptions WHERE subscription_email = '$emailAddress'");

        $title = "<h2>Account Information </h2><h4>Profile ID #$customerId</h4>";
        $accountForm = "
            <form class='account-form mb-5'>
                <div class='row'>
                    <div class='mb-3 col-12 col-md-6'>
                        <label for='account-email-address'>Email Address</label>
                        <input class='form-control' id='account-email-address' name='account-email-address' disabled value='$emailAddress' />
                    </div>
                    <div class='mb-3 col-12 col-md-6'>
                        <label for='account-created-date'>Date Created</label>
                        <input class='form-control' id='account-created-date' name='account-created-date' disabled value='$accountCreatedDate' />
                    </div>
                    <div class='col-12 col-md-6'>
                        <div class='mb-3 form-floating-label-container'>
                            <input type='text' class='form-control' id='account-first-name' name='account-first-name' placeholder='Input First Name' value='$firstName' />
                            <label for='account-first-name'>First Name</label>
                        </div>
                    </div>
                    <div class='col-12 col-md-6'>
                        <div class='mb-3 form-floating-label-container'>
                            <input type='text' class='form-control' id='account-last-name' name='account-last-name' placeholder='Input Last Name' value='$lastName' />
                            <label for='account-last-name'>Last Name</label>
                        </div>
                    </div>
                    <div class='col-12 col-md-6'>
                        <div class='mb-3 form-floating-label-container'>
                            <input type='text' class='form-control' id='account-phone' name='account-phone' placeholder='Input Last Name' value='$phoneNumber' />
                            <label for='account-phone'>Phone Number</label>
                        </div>
                    </div>
                </div>
                <div id='account-info-alert-container'>
                </div>
                <div class='row'>
                    <div class='col-12 col-md-6'>
                        <button type='button' id='account-update-button' class='btn bg-westech-green text-white w-100' onclick='updateAccount()'>Update Account</button>
                    </div>
                </div>
            </form>
        ";
        $updatePasswordTitle = "<h3>Update Password</h3>";
        $updatePasswordForm = "
            <form class='account-form mb-5'>
                <div class='row'>
                    <div class='col-12 col-md-6'>
                        <div class='mb-3 form-floating-label-container'>
                            <input type='password' class='form-control' id='current-password' name='current-password' placeholder='Input Current Password' />
                            <label for='current-password'>Current Password</label>
                        </div>
                    </div>
                </div>
                <div class='row'>
                    <div class='col-12 col-md-6'>
                        <div class='mb-3 form-floating-label-container'>
                            <input type='password' class='form-control' id='new-password' name='new-password' placeholder='New Password' />
                            <label for='new-password'>New Password</label>
                        </div>
                    </div>
                </div>
                <div class='row'>
                    <div class='col-12 col-md-6'>
                        <div class='mb-3 form-floating-label-container'>
                            <input type='password' class='form-control' id='confirm-new-password' name='confirm-new-password' placeholder='Confirm New Password' />
                            <label for='confirm-new-password'>Confirm New Password</label>
                        </div>
                    </div>
                </div>
                <div id='password-reset-alert-container'>
                </div>
                <div class='row'>
                    <div class='col-12 col-md-6'>
                        <button type='button' id='account-password-update-button' class='btn bg-westech-green text-white w-100' onclick='updatePassword()'>Update Password</button>
                    </div>
                </div>
            </form>
        ";
        $productNotificationsTitle = "<h3>Product Notifications</h3>";
        $notificationsText = $emailSubscription->RecordCount() > 0 ? "You are currently subscribed to the newsletter" : "You are not subscribed to the newsletter";
        $checkbox = $emailSubscription->RecordCount() > 0 ? "<input class='form-check-input' type='checkbox' id='newsletter' checked>" : "<input class='form-check-input' type='checkbox' id='newsletter' >";
        $productNotificationsForm = "
            $notificationsText
            <form class='account-form mb-5'>
                <div class='form-check mb-3'>
                    $checkbox
                    <label class='form-check-label' for='newsletter'>
                    Subscribe for Exclusive Offers and News.
                    </label>
                </div>
                <div id='notifications-alert-container'>
                </div>
                <div class='row'>
                    <div class='col-12 col-md-6'>
                        <button type='button' id='notifications-update-button' class='btn bg-westech-green text-white w-100' onclick='updateProductNotifications()'>Update Preferences  </button>
                    </div>
                </div>
            </form>
        ";
        return $title . $accountForm . $seperator . $updatePasswordTitle . $updatePasswordForm . $seperator . $productNotificationsTitle . $productNotificationsForm ;
    }
    function renderTaxExmeptions() {
        global $stateListTextToText;

        $currentExemptions = avatax_get_certificates_by_customer($_SESSION['customer_id']);
        // prePrintPre($currentExemptions);

        $currentRecords = "";
        if (isset($currentExemptions['@recordsetCount']))
        {
            $currentRecords = "<div class='row mb-3'>";
            $currentRecords .= "<h3>Current Exemptions</h3>";
            foreach ($currentExemptions['value'] as $record)
            {
                $rId = $record['id'];
                $rSigned = $record['signedDate'];
                $rExp = $record['expirationDate'];
                $rValid = $record['valid'];
                $rVerified = $record['verified'];
                $rTaxNumber = $record['exemptionNumber'];
                $rVReason = $record['validatedExemptionReason']['name'];
                $rReason = $record['exemptionReason']['name'];
                $rCreated = $record['createdDate'];
                $rTaxType = $record['taxNumberType'];
                $rZone = $record['exposureZone']['name'];

                $exposure = (strpos($rVReason, "EXPOSURE") === false) ? '' : substr($rVReason, strpos($rVReason, "EXPOSURE: "));
                $valid = ($rValid)? 'tax-ex-cert-valid' : "tax-ex-cert-invalid";
                $expire = ($rExp == "9999-12-31")? 'No Expiration' : $rExp;

                $currentRecords .= "
                    <div class='col-12 col-md-4'>
                        <div class='text-ex-cert-container card $valid'>
                            <div class='card-body'>
                                <h5 class='card-title'>$rZone - ID: $rId</h5>
                                <p class='card-text'>Created: $rCreated</p>
                                <p class='card-text'>Expires: $expire</p>
                                <p class='card-text'>$exposure</p>
                                <button type='button' class='btn btn-danger tax-ex-button-delete' data-cert-id='$rId' data-id='tax-ex-cert-delete'>Delete</button>
                            </div>
                        </div>
                    </div>
                ";
            }
            $currentRecords .= "</div>";
        }

        $exemptionReasons = array();
        foreach (avatax_get_exemption_reasons() as $reason) {
            array_push($exemptionReasons, "<option value=\"" . $reason . "\">" . ucwords(ucwords(strtolower($reason), "&/-")) . "</option>");
        }
        $exemptionReasons = implode("", $exemptionReasons);

        $taxExForm = "
            <h3 class='mb-2'>View or Add Tax Exemptions</h3>
            <p class='mb-3'>
                Tax exemptions will be automatically applied to the cart. Before completing checkout please verify tax was removed in order summary.
                If you are having issues uploading your exemption please call us directly at 1-800-433-8831.
            </p>
            <div id='tax-ex-current-records-container'>
                $currentRecords
            </div>
            <form class='account-form mb-3' enctype='multipart/form-data'>
                <h3>New Certificate</h3>
                <h4 class='text-center'>Customer Details</h4>
                <div class='mb-3 form-floating-label-container'>
                    <input type='text' class='form-control' id='tax-ex-company-name' name='tax-ex-company-name' placeholder='Input Company Name' />
                    <label for='tax-ex-company-name'>Company Name</label>
                </div>
                <div class='row'>
                    <div class='col-12 col-md-6'>
                        <div class='mb-3 form-floating-label-container'>
                            <input class='form-control' id='tax-ex-first-name' name='tax-ex-first-name' placeholder='Input First Name' />
                            <label for='tax-ex-first-name'>First Name</label>
                        </div>
                    </div>
                    <div class='col-12 col-md-6'>
                        <div class='mb-3 form-floating-label-container'>
                            <input class='form-control' id='tax-ex-last-name' name='tax-ex-last-name' placeholder='Input Last Name' />
                            <label for='tax-ex-last-name'>Last Name</label>
                        </div>
                    </div>
                </div>
                <div class='mb-3 form-floating-label-container'>
                    <input class='form-control' id='tax-ex-street-address-one' name='tax-ex-street-address-one' placeholder='Input Street Address' />
                    <label for='tax-ex-street-address-one'>Street Address</label>
                </div>
                <div class='mb-3 form-floating-label-container'>
                    <input class='form-control' id='tax-ex-street-address-two' name='tax-ex-street-address-two' placeholder='Input Street Address Line Two' />
                    <label for='tax-ex-street-address-two'>Street Address 2 (Optional)</label>
                </div>
                <div class='row'>
                    <div class='col-12 col-md-4'>
                        <div class='mb-3 form-floating-label-container'>
                            <input class='form-control' id='tax-ex-city' name='tax-ex-city' placeholder='Input City Name' />
                            <label for='tax-ex-city'>City</label>
                        </div>
                    </div>
                    <div class='col-12 col-md-4'>
                        <div class='mb-3 form-floating-label-container'>
                            <select class='form-select' id='tax-ex-customer-state' name='tax-ex-customer-state'>
                                <option disabled selected>Choose...</option>
                                $stateListTextToText
                            </select>
                            <label for='tax-ex-customer-state'>State</label>
                        </div>
                    </div>
                    <div class='col-12 col-md-4'>
                        <div class='mb-3 form-floating-label-container'>
                            <input type='text' class='form-control' id='tax-ex-zip-code' name='tax-ex-zip-code' placeholder='Input Zip'>
                            <label for='tax-ex-zip-code'>Zip Code</label>
                        </div>
                    </div>
                </div>
                <h4 class='text-center'>Certificate Details</h4>
                <div class='row mb-3'>
                    <label for='tax-ex-signed-date' class='col-12 col-md-6 col-form-label'>Signed Date</label>
                    <div class='col-12 col-md-6'>
                        <input type='date' class='form-control text-center text-uppercase' id='tax-ex-signed-date' name='tax-ex-signed-date' />
                    </div>
                </div>
                <div class='row mb-3'>
                    <label for='tax-ex-expiration-date' class='col-12 col-md-6 col-form-label'>Expiration Date</label>
                    <div class='col-12 col-md-6'>
                        <input type='date' class='form-control text-center text-uppercase' id='tax-ex-expiration-date' name='tax-ex-expiration-date' />
                        <div class='form-check d-flex align-items-center justify-content-center'>
                            <input class='form-check-input' type='checkbox' id='tax-ex-no-exp' name='tax-ex-no-exp'>
                            <label class='form-check-label col-form-label ps-2' for='tax-ex-no-exp'>
                                No Expiration
                            </label>
                        </div>
                    </div>
                </div>
                <div class='row mb-3'>
                    <div class='col-12 col-md-4'>
                        <div class='mb-3 form-floating-label-container'>
                            <select class='form-select' id='tax-ex-type' name='tax-ex-type'>
                                <option disabled selected>Tax Type</option>
                                <option value='TID'>Tax ID</option>
                                <option value='EIN'>EIN</option>
                                <option value='FEIN'>FEIN</option>
                                <option value='SSN'>SSN</option>
                            </select>
                            <label for='tax-ex-type'>Tax Type</label>
                        </div>
                    </div>
                    <div class='col-12 col-md-4'>
                        <div class='mb-3 form-floating-label-container'>
                            <input class='form-control' id='tax-ex-tax-number' placeholder='Input Tax Number' />
                            <label for='tax-ex-tax-number'>Tax Number</label>
                        </div>
                    </div>
                    <div class='col-12 col-md-4'>
                        <div class='mb-3 form-floating-label-container'>
                            <select class='form-select' id='tax-ex-reason' name='tax-ex-reason'>
                                <option disabled selected>Reason</option>
                                $exemptionReasons
                            </select>
                            <label for='tax-ex-reason'>Reason</label>
                        </div>
                    </div>
                </div>
                <div class='row'>
                    <p>Taxes are calculated based on point of consumption, so select the state(s) you'll be <b>shipping</b> to.</p>
                </div>
                <div class='row'>
                    <div class='col-12 col-md-4'>
                        <div class='mb-3 form-floating-label-container'>
                            <select class='form-select' id='tax-ex-certificate-state' name='tax-ex-certificate-state'>
                                <option disabled selected>Choose...</option>
                            </select>
                            <label for='tax-ex-certificate-state'>State</label>
                        </div>
                    </div>
                    <div class='col-12 col-md-8' id='tax-ex-states'>
                        <div class='mb-3 form-floating-label-container'>
                            <select class='form-select' id='tax-ex-selected-states' name='tax-ex-selected-states' size='5'>
                                
                            </select>
                            <label for='tax-ex-selected-states'>Selected States</label>
                        </div>
                        <button id='tax-ex-remove-selected-button' type='button' class='btn w-100'>Remove Selected State</button>
                    </div>
                </div>
                <div class='d-flex justify-content-center align-items-center'>
                    <div class='text-center'>
                        <div class='mt-3'>
                            <input type='file' id='tax-ex-file' aria-label='Tax Exemption File Input' accept='.pdf' aria-labelledby='tax-ex-file-info' />
                            <label for='tax-ex-file'  class='file-upload-container'>
                                Upload File
                            </label>
                        </div>
                        <p class='mb-0' id='tax-ex-file-info'>Exemption File<br />(PDF only) max 8MB:</p>
                        <p class='mb-3' id='tax-ex-file-output'>No File Chosen</p>
                    </div>
                </div>
                <div class='form-check'>
                    <input class='form-check-input' type='checkbox' id='tax-ex-terms'>
                    <label class='form-check-label' for='tax-ex-terms'>
                        I agree to the terms and conditions of this module
                    </label>
                </div>
                <div id='tax-ex-alert-container'>
                </div>
                <div class='row mb-5'>
                    <div class='col-10 offset-1 col-md-8 offset-md-2'>
                        <button type='button' class='btn bg-westech-green text-white w-100' id='checkout-tax-ex-continue-button'>Continue</button>
                    </div>
                </div>
            </form>
        ";
        return $taxExForm;
    }
    function renderPaymentMethods() {
        global $stateListIdsToText;

        $profile = adn_get_profile($_SESSION['customer_id'], false);

        $paymentProfiles = "";
        $paymentProfilesDisplay = "";

        if ($profile['messages']['message'][0]['code'] !== "E00040")
        {
            if (isset($profile['profile']['paymentProfiles']))
            {
                $paymentProfiles = $profile['profile']['paymentProfiles'];
            }

            if (is_array($paymentProfiles))
            {
                $paymentProfilesDisplay .= "<div class='row mb-3'>";
                foreach($paymentProfiles as $profile)
                {
                    $paymentDefault = isset($profile['defaultPaymentProfile'])? '(default)' : '';
                    $paymentId = $profile['customerPaymentProfileId'];
                    $card = $profile['payment']['creditCard'];
                    $cardNumber = $card['cardNumber'];
                    $cardType = $card['cardType'];
                    $bill = $profile['billTo'];
                    $billFirst = $bill['firstName'];
                    $billLast = $bill['lastName'];
                    $billAddress = $bill['address'];
                    $billCity = $bill['city'];
                    $billState = $bill['state'];
                    $billZip = $bill['zip'];

                    $paymentProfilesDisplay .= "
                        <div class='col-12 col-md-4'>
                            <div class='card'>
                                <div class='card-body'>
                                    <h5 class='card-title'>$cardNumber $paymentDefault</h5>
                                    <p class='card-text'>$billFirst $billLast</p>
                                    <p class='card-text'>$billAddress $billCity, $billState $billZip</p>
                                    <p class='card-text'>$cardType</p>
                                    <button type='button' class='btn btn-danger payment-button-delete' data-payment-id='$paymentId'>Delete</button>
                                </div>
                            </div>
                        </div>
                    ";
                }
                $paymentProfilesDisplay .= "</div>";
            }
        }

        $yearList = "";
        $currentYear = date("Y");
        for ($y = 0; $y < 11; $y++)
        {
            $yearList .= '<option value="' . ($currentYear + $y) . '">' . ($currentYear + $y) . '</option>';
        }

        $paymentForm = "
            <h3 class='mb-3'>Saved Payments</h3>
            $paymentProfilesDisplay
            <form class='account-form mb-3'>
                <div class='row mb-3'>
                    <div class='col-3 payment-icons'>
                        <p class='mb-0 fw-bold payment-text'>We Accept:</p>
                        <img src='/images/capture3.JPG' alt='accepted payment methods' class='img-fluid payment-method-image' />
                    </div>
                </div>
                <div class='row'>
                    <div class='col-12 col-md-6'>
                        <div class='mb-3 form-floating-label-container'>
                            <input class='form-control' id='payment-name-on-card-first' name='payment-name-on-card-first' placeholder='First Name On Card' />
                            <label for='payment-name-on-card-first'>First Name</label>
                        </div>
                    </div>
                    <div class='col-12 col-md-6'>
                        <div class='mb-3 form-floating-label-container'>
                            <input class='form-control' id='payment-name-on-card-last' name='payment-name-on-card-last' placeholder='Last Name On Card' />
                            <label for='payment-name-on-card-last'>Last Name</label>
                        </div>
                    </div>
                </div>
                <div class='mb-3 form-floating-label-container'>
                    <input class='form-control' id='payment-address-street' name='payment-address-street' placeholder='Input Primary Address' />
                    <label for='payment-address-street'>Primary Address</label>
                </div>
                <div class='row'>
                    <div class='col-6 col-md-4'>
                        <div>
                            <div class='mb-3 form-floating-label-container'>
                                <input class='form-control' id='payment-address-city' name='payment-address-city' placeholder='City' />
                                <label for='payment-address-city'>City</label>
                            </div>
                        </div>
                    </div>
                    <div class='col-6 col-md-4'>
                        <div class='mb-3 form-floating-label-container'>
                            <select class='form-select' id='payment-address-state' name='payment-address-state'>
                                <option disabled selected value=''>State</option>
                                $stateListIdsToText
                            </select>
                            <label for='payment-address-state'>State</label>
                        </div>
                    </div>
                    <div class='col-6 col-md-4'>
                        <div class='mb-3 form-floating-label-container'>
                            <input class='form-control' id='payment-address-zip' name='payment-address-zip' placeholder='#####' />
                            <label for='payment-address-zip'>ZIP</label>
                        </div>
                    </div>
                </div>
                <div class='mb-3 form-floating-label-container'>
                    <input class='form-control' id='payment-card-number' name='payment-card-number' placeholder='Input Number On Card' />
                    <label for='payment-card-number'>Card Number</label>
                </div>
                <div class='row'>
                    <div class='col-6 col-md-4'>
                        <div class='mb-3 form-floating-label-container'>
                            <select class='form-select' id='payment-card-expiration-month' name='payment-card-expiration-month'>
                                <option disabled selected value=''>MM</option>
                                <option value='01'>01</option>
                                <option value='02'>02</option>
                                <option value='03'>03</option>
                                <option value='04'>04</option>
                                <option value='05'>05</option>
                                <option value='06'>06</option>
                                <option value='07'>07</option>
                                <option value='08'>08</option>
                                <option value='09'>09</option>
                                <option value='10'>10</option>
                                <option value='11'>11</option>
                                <option value='12'>12</option>
                            </select>
                            <label for='payment-card-expiration-month'>Month</label>
                        </div>
                    </div>
                    <div class='col-6 col-md-4'>
                        <div>
                            <div class='mb-3 form-floating-label-container'>
                                <select class='form-select' id='payment-card-expiration-year' name='payment-card-expiration-year'>
                                    <option disabled selected value=''>YYYY</option>
                                    $yearList
                                </select>
                                <label for='payment-card-expiration-year'>Year</label>
                            </div>
                        </div>
                    </div>
                    <div class='col-6 col-md-4'>
                        <div class='mb-3 form-floating-label-container secure-input'>
                            <i class='fa-solid fa-lock'></i>
                            <input class='form-control' id='payment-card-cvv' name='payment-card-cvv' placeholder='###' />
                            <label for='payment-card-cvv'>CVV</label>
                        </div>
                    </div>
                </div>
                <div class='form-check mb-3 payment-save-checkbox-container'>
                    <input class='form-check-input' type='checkbox' id='payment-default-method' />
                    <label class='form-check-label' for='payment-default-method'>Default payment method</label>
                </div>
                <div id='payment-alert-container'>
                </div>
                <div class='row'>
                    <div class='col-10 offset-1 col-md-8 offset-md-2'>
                        <button type='button' class='btn bg-westech-green text-white w-100' id='checkout-payment-continue-button'>Continue</button>
                    </div>
                </div>


            </form>
        ";

        return $paymentForm;
    }
    function renderOrderHistory() {
        global $db;
        require DIR_WS_CLASSES . 'order.php';

        $orders = $db->Execute("SELECT zo.orders_id, zos.orders_status_name FROM zen_orders AS zo LEFT JOIN zen_orders_status AS zos ON zo.orders_status = zos.orders_status_id WHERE customers_id = " . $_SESSION['customer_id']);
        
        $orderHistoryContent = "";

        while (!$orders->EOF)
        {
            $order = new order($orders->fields['orders_id']);

            // prePrintPre($order);

            $status = $orders->fields['orders_status_name'];
            $orderID = $order->info['order_id'];
            $placedDate = date("d M, Y", strtotime($order->info['date_purchased']));

            $orderItems = "";

            foreach ($order->products as $product)
            {
                $quantity = $product['qty'];
                $name = $product['name'];
                $model = $product['model'];
                $price = "$" . number_format($product['price'] * $product['qty'], 2);

                $orderItems .= "

                <div>
                <p class='m-0'><b>$quantity x $model</b> ($price)</p>
                <p class='m-0 text-muted'>$name</p>
                </div>
                <div class='seperator'></div>
                ";
            }

            $card = "
            <div class='card mb-3'>
                <div class='card-header'>
                    $status
                </div>
                <div class='card-body'>
                    <h5 class='card-title'><b><a href='?main_page=order_history&oID=$orderID'>Order #$orderID</a></b></h5>
                    <h6 class='card-subtitle mb-5 text-muted'>Placed $placedDate</h6>
                    <div>
                        $orderItems
                    </div>
                </div>
            </div>
            ";

            $orderHistoryContent .= $card;

            $orders->MoveNext();
        }

        echo $orderHistoryContent;
    }
?>
<style>
    
    #tax-ex-file[type="file"] {
        display: none;
    }
    #tax-ex-file[type="file"].input-error + label {
        border-color: red!important;
    }
    #tax-ex-remove-selected-button {
        border: 1px black solid;
        background-color: #dadada;
    }
    .list-group-item.list-group-item-action.active {
        background: var(--westech-green);
        color: white;
    }
    .file-upload-container {
        border: 1px black solid;
        background-color: #dadada;
        display: inline-block;
        padding: 6px 12px;
        cursor: pointer;
    }

    @media only screen and (min-width: 768px) {
        .account-form {
            width: 80%;
        }
    }

    @media only screen and (min-width: 768px) and (max-width: 991px) {
    }
    /* Desktop CSS Changes */
    @media only screen and (min-width: 992px) {
    }

    @media only screen and (min-width: 1200px){
        .address-book-form {
            width: 75%;
            margin: auto;
        }
    }
</style>
<main class="container-lg">
    <div class="row">
        <div class="col-sm-12 col-md-3">
            <div class="list-group mb-5">
                <a 
                    href="/index.php?main_page=account" 
                    class='<?php echo !$display ? $activeListItemClass: $defaultListItemClass; ?>' 
                    <?php if(!$display) echo 'aria-current="true"' ?>
                >
                    Account Information
                </a>
                <a 
                    href="/index.php?main_page=account&display=address-book"  
                    class='<?php echo $display == "address-book" ? $activeListItemClass: $defaultListItemClass; ?>' 
                    <?php if($display == "address-book") echo 'aria-current="true"' ?>
                >
                    Address Book
                </a>
                <a 
                    href="/index.php?main_page=account&display=tax-exemptions"  
                    class='<?php echo $display == "tax-exemptions" ? $activeListItemClass: $defaultListItemClass; ?>' 
                    <?php if($display == "tax-exemptions") echo 'aria-current="true"' ?>
                >
                    Tax Exemptions
                </a>
                <a 
                    href="/index.php?main_page=account&display=payment-methods"  
                    class='<?php echo $display == "payment-methods" ? $activeListItemClass: $defaultListItemClass; ?>' 
                    <?php if($display == "payment-methods") echo 'aria-current="true"' ?>
                >
                    Payment Methods
                </a>
                <?php
                
                $orders_check = $db->Execute("SELECT orders_id FROM zen_orders WHERE customers_id = " . $_SESSION['customer_id']);

                if ($orders_check->RecordCount() > 0)
                {
                    $classDec = $display == "history"? $activeListItemClass : $defaultListItemClass;
                    $ariaC = $display == "history"? 'aria-current="true"' : '';

                    echo "
                    <a
                        href='/index.php?main_page=account&display=history'
                        class='$classDec'
                        $ariaC
                    >
                        Order History
                    </a>
                    ";
                }
                
                ?>
            </div>
        </div>
        <div class="col-sm-12 col-md-9">
            <?php
                switch($display){ 
                    case "address-book":
                        echo renderAddressBook();
                        break;
                    case "history":
                        echo renderOrderHistory();
                        break;
                    case "tax-exemptions":
                        echo renderTaxExmeptions();
                        break;
                    case "payment-methods":
                        echo renderPaymentMethods();
                        break;
                    default:
                        echo renderAccountInformation();
                        break;
                }
            ?>
        </div>
    </div>
</main>
