<?php

    $runningTotal = 0.0;

    $_SESSION['cart']->calculate();

    // $runningTotal += $_SESSION['cart']->total;
    
    $cart_items = $_SESSION['cart']->get_products();

    // prePrintPre($cart_items);

    $numberOfCartItems = $_SESSION['cart']->count_contents();

    $cartList = "";
    $cartData = array();
    $coreData = array();
    foreach($cart_items as $item) {
        $itemId = $item['id'];
        $url = "?main_page=product_info&products_id=$itemId";
        $attributes = $item['attributes'] ?: "";
        $attributesValues = array();

        $isExchange = false;
        $coreData = array();
        $productQuery = "
            SELECT p.products_id, zp.products_alt_name, p.is_exchange, p.is_core, p.products_image, m.manufacturers_name
            FROM zen_products p
            LEFT JOIN zen_products_description zp ON zp.products_id = p.products_id
            LEFT JOIN zen_manufacturers m ON m.manufacturers_id = p.manufacturers_id
            WHERE p.products_id = '$itemId'
        ";
        $product = $db->Execute($productQuery);
        $manufacturerName = $product->fields['manufacturers_name'];
        $itemCoreId = $product->fields['products_id']; 
        $isExchange = $product->fields['is_exchange'];
        $isCore = $product->fields['is_core'];
        $imgPath = $item['image'];
        if($isCore) {
            continue;
        }
        if($isExchange) {
            $productQuery = "
                SELECT x.products_id, p.products_image
                FROM zen_products_xsell x
                LEFT JOIN zen_products p on x.products_id = p.products_id
                WHERE xsell_id = $itemId 
            ";
            $queryResults = $db->Execute($productQuery);
            $queryProductId = $queryResults->fields['products_id'];
            $imgPath = $queryResults->fields['products_image'];
            $url = "?main_page=product_info&products_id=$queryProductId";
            $coreQuery = "
                SELECT xsell_id 
                FROM zen_products_xsell 
                WHERE products_id = $queryProductId AND xsell_id != $itemId
            ";
            $queryResults = $db->Execute($coreQuery);
            $xsellId = $queryResults->fields['xsell_id'];
            $coreProductInfoQuery = "
                SELECT zm.manufacturers_name, p.products_id, p.products_image, 
                p.products_price, p.products_model, zp.products_alt_name, 
                zp.products_name, zp.products_alt_name, p.is_exchange, p.is_core 
                FROM zen_products p
                LEFT JOIN zen_products_description zp ON zp.products_id = p.products_id
                LEFT JOIN zen_manufacturers zm ON zm.manufacturers_id = p.manufacturers_id
                WHERE p.products_id = '$xsellId'
            ";
            $queryResults = $db->Execute($coreProductInfoQuery);

            $coreData = array(
                "corePrice" => $queryResults->fields['products_price'],
                "coreId" => $queryResults->fields['products_id'],
                "coreAltName" => $queryResults->fields['products_alt_name'],
                "coreName" => $queryResults->fields['products_name'],
                "coreModel"=> $queryResults->fields['products_model'],
                "coreManufacturersName" => $queryResults->fields['manufacturers_name'],
            );
        }
        
        if(is_array($attributes)) {
            foreach($attributes as $optionsId => $optionsValueId) {
                $optionalIndex = $optionsId;
                if (strpos($optionsId, "chk") !== false) {
                    $optionalIndex = substr($optionsId, (strpos($optionsId, "chk") + 3));
                    $optionsId = strtok($optionsId, "_");
                }
                $typeQuery = "
                    SELECT products_options_type
                    FROM zen_products_options
                    WHERE products_options_id = $optionsId
                ";
                $typeResult = $db->Execute($typeQuery);
                if($typeResult->fields['products_options_type'] == 1) {
                    $optionInfoQuery = "
                        SELECT products_options_name
                        FROM `zen_products_options`
                        WHERE `products_options_id` = $optionsId
                    ";
                    $optionsInfo = $db->Execute($optionInfoQuery);
                    $attributesValues[$optionalIndex] = array(
                        "name" => $optionsInfo->fields['products_options_name'],
                        "optionsId" => $optionsId,
                        "optionsValueId" => null,
                        "optionsValueText" => $optionsValueId,
                        "optionsValuePrice" => 0.00,
                    );
                    continue;
                }
                $optionInfoQuery = "
                    SELECT pa.options_values_price, pa.price_prefix, poa.products_options_values_name, po.products_options_name
                    FROM `zen_products_attributes` pa
                    LEFT JOIN `zen_products_options_values` poa ON poa.products_options_values_id = pa.options_values_id
                    LEFT JOIN `zen_products_options` po ON po.products_options_id = pa.options_id
                    WHERE `products_id` = '$itemId' AND `options_id` = $optionsId AND `options_values_id` = $optionsValueId
                ";
                $optionsInfo = $db->Execute($optionInfoQuery);
                
                $attributesValues[$optionalIndex] = array(
                    "name" => $optionsInfo->fields['products_options_name'],
                    "optionsId" => $optionsId,
                    "optionsValueId" => $optionsValueId,
                    "optionsValueText" => $optionsInfo->fields['products_options_values_name'],
                    "optionsValuePrice" => ($optionsInfo->fields['price_prefix'] == "+")? $optionsInfo->fields['options_values_price'] : -1 * $optionsInfo->fields['options_values_price'],
                );
            }
        }

        $cartData[$itemId] = array(
            "id" => $itemId,
            "mainId" => $itemCoreId,
            "qty" => $item['quantity'],
            "urlLink" => $url,
            "manufacturers_name"=> $manufacturerName,
            "products_image" => $imgPath,
            "products_price" => $item['price'],
            "products_model" => $item['model'],
            "products_alt_name" => $product->fields['products_alt_name'],
            "products_name" => $item['name'],
            "attributes" => $attributes,
            "attributesValues" => $attributesValues,
            "hasCore" => $isExchange,
            "coreData" => $coreData 
        );

    }

    function renderCartData() {
        global $cartData;
        global $runningTotal;

        foreach($cartData as $id => $cartItem) {
            $qty = $cartItem['qty'];
            $manufacturerName = $cartItem['manufacturers_name'];
            $imgUrl = "/images/" . $cartItem['products_image'];
            $price = $cartItem['products_price'];
            $model = $cartItem['products_model'];
            $altName = $cartItem['products_alt_name'];
            $mainId = $cartItem['mainId'];
            $name = $cartItem['products_name'] ?: $cartItem['products_alt_name'];
            $productUrl = $cartItem['urlLink'];
            $formattedPrice = "$" . number_format($price, 2);
            $corePriceTotal = 0;
            $attributesPriceTotal = 0;

            $coreHtml = "";
            $attributesHtml = "";
            if(!empty($cartItem['coreData'])) {
                $coreData = $cartItem['coreData'];
                $corePrice = $coreData['corePrice'];
                $coreId = $coreData['coreId'];
                $coreAltName = $coreData['coreAltName'];
                $coreName = $coreData['coreName'];
                $coreModel = $coreData['coreModel'];
                $coreManufacturersName = $coreData['coreManufacturersName'];
                $corePriceTotal = $corePrice;
                $formattedCorePrice = number_format($corePrice, 2);

                $mainProductTotal = $qty * $price;
                $coreProductTotal = $corePrice;
                $coreHtml = "
                    <div>
                        <p class=''>This product includes the core price (+$$formattedCorePrice ea.). The core charge can be refunded if core is returned within 30 days.</p>
                    </div>
                ";
            }
            if(!empty($cartItem['attributesValues'])) {
                $attributeListItems = "";
                foreach($cartItem['attributesValues'] as $attribute) {
                    $attributeName = $attribute['name'];
                    $attributePrice = $attribute['optionsValuePrice'];
                    $attributeText = $attribute['optionsValueText'];
                    $attributeText .= $attribute['optionsValuePrice'] !== "0.0000" ? " ($" . number_format($attributePrice, 2) . ")" : "";
                    $attributesPriceTotal = $attributesPriceTotal + $attributePrice;
                    $attributeListItems .= "
                        <li>
                            $attributeName : $attributeText
                        </li>
                    ";
                }
                $attributesHtml = "
                    <div>
                        <ul>
                            $attributeListItems
                        <ul>
                    </div>
                ";
            }
            
            $itemTotal =  $corePriceTotal + $attributesPriceTotal + $price;
            $runningTotal += $itemTotal * $qty;
            $formattedItemTotal = "$" . number_format($itemTotal, 2);

            $total = "$" . number_format($qty * $itemTotal, 2);
            echo "
            <div class='row cart-page-item'>
                <div class='col-12 col-sm-3 col-md-2 col-lg-3 col-xl-2 text-center zoom-container'>
                    <img class='cart-page-item-image' src='$imgUrl' alt='$name'/>
                </div>
                <div class='col-12 col-sm-9 col-md-10 col-lg-9 col-xl-10'>
                    <div class='row'>
                        <div class='col-12 col-sm-7 col-md-8 col-lg-7'>
                            <a href='$productUrl' class='cart-page-item-title mb-0'>
                                <span class='cart-page-item-brand'>$manufacturerName</span>
                                <span class='cart-page-item-model'>$model </span>
                                <span class='cart-page-item-name'>$name </span>
                            </a>
                            <p class='text-muted'>
                                $formattedItemTotal ea.
                            <p>
                            $coreHtml
                            $attributesHtml
                        </div>
                        <div class='col-12 col-sm-5 col-md-4 col-lg-5'>    
                            <div class='cart-page-item-quantity-summary'>
                                
                                <form class='cart-page-item-form'>
                                    <button type='button' data-id='$id' class='btn remove-button cart-page-item-button me-1' ><i  class='fa-solid fa-minus' aria-hidden='true'></i></button>
                                    <input type='number' data-id='$id' class='form-control cart-page-item-quantity' aria-label='quantity' value='$qty' />
                                    <button type='button' data-id='$id' class='btn add-button cart-page-item-button ms-1'><i class='fa-solid fa-plus' aria-hidden='true'></i></button>
                                </form>
                                <p class='text-muted cart-page-item-cost'>$total</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class='col-12 text-end'>
                    <button type='button' data-id='$id' class='btn remove-from-cart-button'>
                        <i class='fa-solid fa-trash fa-lg text-darker-grey'></i>
                    </button>
                </div>
            </div>";
        }
    }
?>
<main class="container-lg">
    <div class="cart-container">
        <h2 class="fs-4">Your Shopping Cart</h2>
        <div class="row mb-3">
            <div class="col-12 col-lg-8 mb-3">
                <?php

                if ($numberOfCartItems > 0)
                {
                    $productModelANDQuantitySubqueries = array();
                    
                    foreach ($cart_items as $product)
                    {
                        $id = $product['id'];
                        if (strpos($id, ':') !== FALSE) $id = substr($id, 0, strpos($id, ':'));
                        $model = $product['model'];
                        $quantity = $product['quantity'];

                        $productModelANDQuantitySubqueries[] = "SELECT m.manufacturers_id, m.manufacturers_name, m.manufacturers_min_order, (p.products_price * $quantity) AS total_price
                        FROM zen_products p
                        JOIN zen_manufacturers m ON p.manufacturers_id = m.manufacturers_id
                        WHERE p.products_id = '$id'";
                    }

                $modelsAndQuantityUnion = implode(" UNION ", $productModelANDQuantitySubqueries);
            
                $manfMinToProductQuery = "SELECT manufacturers_id, manufacturers_name, manufacturers_min_order, SUM(total_price) as total_products_price
                FROM ($modelsAndQuantityUnion) AS SQ
                GROUP BY manufacturers_id
                HAVING SUM(total_price) < manufacturers_min_order";
            
                $manfMinToProductQueryResult = $db->Execute($manfMinToProductQuery);

                if ($manfMinToProductQueryResult->RecordCount() > 0)
                {
                    $manfMinToProductWarningManfs = "<ul>";

                    while (!$manfMinToProductQueryResult->EOF)
                    {
                        $manfName = $manfMinToProductQueryResult->fields['manufacturers_name'];
                        $manfMin = number_format($manfMinToProductQueryResult->fields['manufacturers_min_order'], 2);

                        $manfMinToProductWarningManfs .= "
                            <li>$manfName - $$manfMin</li>
                        ";

                        $manfMinToProductQueryResult->MoveNext();
                    }

                    $manfMinToProductWarningManfs .= "</ul>";

                    $manfMinToProductWarningContent = "
                    <div class='row'>
                        <div class='col-12'>
                            <div class='row'>
                                <div class='alert alert-warning' role='alert'>
                                    <span>One or more of your cart items do not meet the following manufacturer minimums:</span>
                                    $manfMinToProductWarningManfs
                                    <span class='mb-3'><b>Orders that do not meet the manufacturer minimum cannot be shipped directly and instead
                                    have to be special ordered from the manufacturer.</b></span>
                                    <br>
                                    <span class='mb-3'>This may result in extended shipping times and
                                    additional inbound and outbound shipping charges that will automatically be invoiced separately once
                                    your order is received and ready for shipping.</span>
                                    <br>
                                    <span>Please contact us to check lead times and availability, and we will be happy to assist you.</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    ";

                        echo $manfMinToProductWarningContent;
                    }

                    renderCartData();
                }
                else
                {
                    echo "<h3 class='text-center'>No items in your cart</h3>";
                }

                ?>
            </div>
            <div class="col-12 col-lg-4">
                <div class="row cart-page-summary-container">
                    <div class="cart-page-summary">
                        <h5>Summary</h5>
                        <div class="cart-page-shipping-summary">
                            <div class="cart-page-summary-cost-row">
                                <p>Subtotal</p>
                                <p>$<?php echo number_format($runningTotal, 2); ?></p>
                            </div>
                            <div class="cart-page-summary-cost-row">
                                <p>Shipping</p>
                                <p>TBD</p>
                            </div>
                            <div class="cart-page-summary-cost-row">
                                <p>Taxes</p>
                                <p>TBD</p>
                            </div>
                        </div>
                        <div class="cart-page-coupon-summary">
                            <div class="cart-page-summary-cost-row mb-3">
                                <div class="form-floating-label-container coupon-input-container">
                                    <input type="text" id="cart-page-summary-coupon" class="form-control" placeholder="Coupon Code"<?php echo (isset($_SESSION['coupon']['code']))? 'value="' . $_SESSION['coupon']['code'] . '"' : ''; ?>>
                                </div>
                                <?php
                                if (isset($_SESSION['coupon']))
                                {

                                if ($_SESSION['coupon']['type'] == "P")
                                {
                                    $runningTotal = $runningTotal *  (1 - $_SESSION['coupon']['amount']);
                                    $coupon_amount = '-'. ($_SESSION['coupon']['amount'] * 100) . '%';
                                }
                                if ($_SESSION['coupon']['type'] == "F")
                                {
                                    $runningTotal -= $_SESSION['coupon']['amount'];
                                    $coupon_amount = '- $' . number_format($_SESSION['coupon']['amount'], 2);
                                }
                        
                                $runningTotal = max(0, $runningTotal);

                                ?>
                                <button type="button" class="btn btn-danger text-white" id="cart-page-summary-coupon-button-remove">Remove</button>
                                <?php
                                }
                                else
                                {
                                ?>
                                <button type="button" class="btn bg-darker-gray text-white mx-1" id="cart-page-summary-coupon-button-apply">Apply</button>
                                <?php
                                }
                                ?>
                            </div>
                            <div class="cart-page-summary-cost-row">
                                <?php echo (isset($_SESSION['coupon']['amount'])? "
                                    <p>Coupon<span id='cart-page-summary-coupon-code-target'></span></p>
                                    <p><span id='cart-page-summary-coupon-target'>$coupon_amount</span></p>": ''); 
                                ?>
                            </div>
                        </div>
                        <div class="cart-page-disclaimer">
                            <div class="cart-page-disclaimer-text-row">
                                <span class="text-fine-print">Prices shown in cart summary may not reflect final prices calculated during checkout.</span>
                            </div>
                        </div>
                        <div class="seperator w-100 m-0"></div>
                        <div class="p-1 cart-page-total">
                            <p class="pe-3">Estimated Total</p>
                            <p>$<span id="cart-page-summary-total-target"><?php echo number_format($runningTotal, 2); ?></span></p>
                        </div>
                        <div class="col-8 offset-2">
                            <?php
                            $logged_in = ((isset($_SESSION['customer_id'])) && (zen_is_logged_in()));
                            ?>
                            <a href="?main_page=checkout<?php echo ($logged_in? '' : '_guest'); ?>"><button type="button" class="btn bg-westech-green text-white w-100">Proceed to Checkout</button></a>
                        </div>
                    </div>
                </div>
                <div class="col-12 p-2 text-center">
                    <p>We accept the following payment methods:</p>
                    <img src="/images/capture3.JPG" alt="accepted payment methods" class="img-fluid payment-method-image" />
                </div>
            </div>
        </div>
    </div>
    <script>
        $(document).ready(function() {
            $('.cart-page-item-brand').each(function(){
                $(this).text($(this).text().replace(/(Freedom Electronics)|(RDM)|PMP/g, "Rebuilt Part"));
            }); 
        });
    </script>
</main>