<?php

include(DIR_WS_MODULES . zen_get_module_directory(FILENAME_PRODUCT_LISTING));

$page = $_SESSION['listing_filter'][$current_category_id]['page'] ?? 1;
$page = 2;
$count_key = 'p.products_id';
// $max_display_page_links = $max_display_page_links ?? 25;
$max_display_page_links = 8;
$splitResult = new splitPageResults($listing_sql, $max_display_page_links, $count_key);
$query = $splitResult->sql_query;

function renderProducts() {
    global $query;
    global $db;
    $products = "";
    $productList = $db->Execute($query);
    foreach ($productList as $product)
    {
        $productId = $product['products_id'];
        $productName = $product['products_name'];
        $productAltName = $product['products_alt_name'];
        $isBaseProduct = $product['is_base_product'] == 1;
        $isExchange = $product['is_exchange'] == '1';
        $isCall = $product['product_is_call'] == '1';
        $manufacturerId = $product['manufacturers_id'];
        $manufacturerName =  $product['manufacturers_name'];
        $productBoldText = "Model # " . $product['products_model']. " (" . $manufacturerName . ")";
        $brands_to_rebuilt = array(
            "PMP NEW", "ESCO SERVICES", "DAVIS AIRTECH","FREEDOM ELECTRONICS", "RDM", "FREEDOM / RDM OUTRIGHT", "GLOBAL LIGHT", "PMP", 
        );
        if (in_array(strtoupper($manufacturerName), $brands_to_rebuilt))
        {
            $manufacturerName = '<em>(REBUILT PART)</em>';
        }
        $imagePath = "/images/" . $product['products_image'];
        $productName = $product['products_name'];
        $price = "";
        
        $urlLink = isset($cPath)? "?main_page=product_info&cPath=$cPath&products_id=$productId" : "?main_page=product_info&products_id=$productId";
        
        if ($isBaseProduct)
        {
            $subProductListQuery = "SELECT MIN(p.products_price) as min_price
            FROM zen_products_xsell px
            INNER JOIN zen_products p on px.xsell_id = p.products_id
            WHERE px.products_id = $productId
                AND px.xsell_placement = 'options'
                AND p.product_is_call <> 1
                AND p.is_core <> 1";

            $subProductListResult = $db->Execute($subProductListQuery);
            $lowestPrice = $subProductListResult->fields['min_price'];
            $formattedPrice = number_format($lowestPrice, 2);
            $price = ($isCall)? 'Call for Price' : "Starting at $$formattedPrice ";
        }
        else
        {
            $price = "Only $" . number_format($product['products_price'], 2);
        }
        $freeShippingElement = $product['product_is_always_free_shipping'] ? "<p class='product-item-free-shipping'>Free Shipping</p>" : "";

        $products .= "
            <a class='products-grid-item' href='$urlLink' title='$productName link'>
                $freeShippingElement
                <div class='products-grid-item-product'>
                    <img class='img-fluid' src='$imagePath' alt='$productName Image'/>
                    <div class='fs-6 fw-bold product-item-additional-info'>$productBoldText</div>
                    <p class='product-item-name'>$productName</p>
                    <p class='product-item-alt-name'>$productAltName</p>
                    <p class='product-item-price fw-bold text-danger'>$price</p>
                </div>
            </a>
        ".PHP_EOL;
    }
    return $products;
}

$options = array(
    '000' => array(
        'filterName' => "Manufacturer",
        'options' => array(
            'indexed' => array(),
            'filter' => array()
        )
    ),
);
$products_list = $db->Execute($listing_sql);
$list_of_product_ids = array();
foreach ($products_list as $product)
{
    $manufacturerId = $product['manufacturers_id'];
    $manufacturerName = $product['manufacturers_name'];

    if (!in_array($manufacturerId, $options['000']['options']['indexed']))
    {
        $options['000']['options']['indexed'][] = $manufacturerId;
        $options['000']['options']['filter'][] = array(
            'id' => $manufacturerId,
            'text' => $manufacturerName
        );
    }
    
    $productId = $product['products_id'];

    $list_of_product_ids[] = $productId;
}

$list_of_product_ids_string = implode(', ', $list_of_product_ids);

$read_only_attributes_ordered_query =
    "SELECT pa.options_id, pa.options_values_id,
        po.products_options_name, po.products_options_sort_order,
        pov.products_options_values_name, pov.products_options_values_sort_order
    FROM zen_products_attributes pa
    INNER JOIN zen_products_options po ON pa.options_id = po.products_options_id
    INNER JOIN zen_products_options_values pov ON pa.options_values_id = pov.products_options_values_id
    WHERE pa.products_id IN ($list_of_product_ids_string) AND po.products_options_type = 5
    ORDER BY po.products_options_sort_order ASC, pov.products_options_values_sort_order ASC, po.products_options_name ASC, pov.products_options_values_name ASC
    ";

$read_only_attributes_ordered_result = $db->Execute($read_only_attributes_ordered_query);

foreach ($read_only_attributes_ordered_result as $read_only_attribute)
{
    $attribute = $read_only_attribute;

    $optionId = $attribute['options_id'];
    $optionValueId = $attribute['options_values_id'];
    $optionName = $attribute['products_options_name'];
    $optionValueName = $attribute['products_options_values_name'];
    
    if (!isset($options[$optionId]))
    {
        $options[$optionId] = array('filterName' => $optionName);
    }
    if (!isset($options[$optionId]['options']))
    {
        $options[$optionId]['options']['indexed'] = array();
        $options[$optionId]['options']['filter'] = array();
    }
    if (!in_array($optionValueId, $options[$optionId]['options']['indexed']))
    {
        $options[$optionId]['options']['indexed'][] = $optionValueId;

        $options[$optionId]['options']['filter'][] = array(
            'id' => $optionValueId,
            'text' => $optionValueName
        );
    }
}

?>
<main class="container-lg">
    
    <p class="small-text breadcrumb-container">
    <?php echo $breadcrumb->trail("/"); ?>
    </p>
    <div class="row mb-5 pt-3">
        <div class="col-sm-12 col-lg-3">
            <ul class="list-group" id="products-page-sublist">      
                <div class="dropdown">
                    <button class="btn btn-secondary dropdown-toggle w-100" type="button" id="products-page-sublist-dropdown" data-bs-toggle="dropdown" aria-expanded="false">
                    Filter
                    </button>
                    <ul class="dropdown-menu" aria-labelledby="products-page-sublist-dropdown" id="products-page-sublist-dropdown-menu">

                        <?php

                        foreach($options as $key => $filter)
                        {
                            $filterName = $filter['filterName'];
                            $filterOptions = "";
                            $numberOfOptions = count($filter['options']);
                            if($numberOfOptions > 0)
                            {
                                foreach($filter['options']['filter'] as $option)
                                {
                                    $opID = $option['id'];
                                    $opText = $option['text'];
                                    $preChecked = "";
                                    if (isset($_SESSION['listing_filter'][$current_category_id][$key]) && in_array($opID, $_SESSION['listing_filter'][$current_category_id][$key])) $preChecked = " checked='true'";

                                    $filterOptions .= "
                                    <div class='form-check'>
                                        <input class='form-check-input filter-checkbox' type='checkbox' id='$key-$opID-radio-button'$preChecked data-filter-option-id='$key' data-filter-option-value-id='$opID'/>
                                        <label class='form-check-label' for='$key-$opID-radio-button'>
                                            $opText
                                        </label>
                                    </div>
                                    ";
                                }

                                echo "<li class='product-attribute'>
                                    <p class='products-page-attribute-title'>$filterName</p>
                                    <form>
                                        $filterOptions
                                    </form>
                                </li>";
                            }
                        }
                        ?>

                    </ul>
                </div>
            </ul>
        </div>
        <div class="col-sm-12 col-lg-9" id="products-container">
            <h1><?php echo $current_categories_name; ?></h1>
            <div class="row">
                <div id="products-grid">
                    <?php echo renderProducts(); ?>
                </div>
            </div>
            <div class="westech-pagination pt-3">
                <div id="productsListingListingTopLinks" class="navSplitPagesLinks forward">
                    <?php
                        $max_display_page_links = 8;
                        $paginateAsURL = $paginateAsURL ?? false;
                        echo $splitResult->display_links($max_display_page_links, '', $paginateAsURL, '', false); 
                    ?>
                </div>

                <div id="productsListingBottomNumber" class="navSplitPagesResult back">
                    <?php echo $splitResult->display_count(TEXT_DISPLAY_NUMBER_OF_PRODUCTS); ?>
                </div>
            </div>

            <?php 
            if (!empty(trim($current_categories_description)))
            {
                echo "
                <div class='bg-grey p-3'>
                    $current_categories_description
                </div>
                ";
            }
            ?>
        </div>
        <script>

        function setImageOnError() {
            $('.products-grid-item-product > img').attr('onerror', "this.onerror=null;this.src='images/no_picture_original.gif'");
        }

        $(document).ready(async function() {
            setImageOnError();
            $('.form-check-label').each(function(){
                $(this).text($(this).text().replace(/(Freedom Electronics)|(RDM)|PMP/g, "Rebuilt Part"));
            }); 
            $('.product-item-additional-info').each(function(){
                $(this).text($(this).text().replace(/(Freedom Electronics)|(RDM)|PMP/g, "Rebuilt Part"));
            });
            const cPath = "<?php echo $cPath?>";

            let $updateFilterResult = await $.ajax(
                {
                    method: "POST",
                    url: "ajax_filter_product_listing.php",
                    data: {
                        ccID: <?php echo $current_category_id; ?>,
                        page: <?php echo $_SESSION['listing_filter'][$current_category_id]['page'] ?? 1; ?>,
                        cPath: cPath
                    }
                }
            );

            try {
                $updateFilterResultJ = JSON.parse($updateFilterResult);
                
                if ($updateFilterResultJ.result == 1)
                {

                    // $("#products-page-sublist-dropdown-menu").html($updateFilterResultJ.contents.filter);
                    $("#products-grid").html($updateFilterResultJ.contents.listing.products);
                    $("#productsListingListingTopLinks").html($updateFilterResultJ.contents.listing.forward);
                    $("#productsListingBottomNumber").html($updateFilterResultJ.contents.listing.back);

                    setImageOnError();
                    $('.form-check-label').each(function(){
                        $(this).text($(this).text().replace(/(Freedom Electronics)|(RDM)|PMP/g, "Rebuilt Part"));
                    }); 
                    $('.product-item-additional-info').each(function(){
                        $(this).text($(this).text().replace(/(Freedom Electronics)|(RDM)|PMP/g, "Rebuilt Part"));
                    });
                    $(".SPR-nav").on("click", function() {
                        window.scroll(0, 0);
                    });
                }
                else
                {
                    alert($updateFilterResultJ.message);
                }
            } catch (e) {
                alert('Listing update failed while parsing AJAX data.');
            }
        });

        $('#products-page-sublist-dropdown-menu').on('click', '.filter-checkbox', async function() {
            let $updateFilterResult = await $.ajax(
                {
                    method: "POST",
                    url: "ajax_filter_product_listing.php",
                    data: {
                        ccID: <?php echo $current_category_id; ?>,
                        filterOption: $(this).data('filter-option-id'),
                        filterValue: $(this).data('filter-option-value-id'),
                        filterToggle: $(this).is(':checked')
                    }
                }
            );

            try {
                $updateFilterResultJ = JSON.parse($updateFilterResult);
                
                if ($updateFilterResultJ.result == 1)
                {
                    // $("#products-page-sublist-dropdown-menu").html($updateFilterResultJ.contents.filter);
                    $("#products-grid").html($updateFilterResultJ.contents.listing.products);
                    $("#productsListingListingTopLinks").html($updateFilterResultJ.contents.listing.forward);
                    $("#productsListingBottomNumber").html($updateFilterResultJ.contents.listing.back);

                    setImageOnError();
                    $('.form-check-label').each(function(){
                        $(this).text($(this).text().replace(/(Freedom Electronics)|(RDM)|PMP/g, "Rebuilt Part"));
                    }); 
                    $('.product-item-additional-info').each(function(){
                        $(this).text($(this).text().replace(/(Freedom Electronics)|(RDM)|PMP/g, "Rebuilt Part"));
                    });
                    
                    $(".SPR-nav").on("click", function() {
                        window.scroll(0, 0);
                    });
                }
                else
                {
                    alert($updateFilterResultJ.message);
                }
            } catch (e) {
                alert('Listing update failed while parsing AJAX data.');
            }
        });

        $('#productsListingListingTopLinks').on('click', '.SPR-nav', async function(event) {
            event.preventDefault();

            $action = $(this).data('pagaction');

            let $updatePageResult = await $.ajax(
                {
                    method: "POST",
                    url: "ajax_filter_product_listing.php",
                    data: {
                        ccID: <?php echo $current_category_id; ?>,
                        page: $action
                    }
                }
            );

            try {
                $updatePageResultJ = JSON.parse($updatePageResult);
                
                if ($updatePageResultJ.result == 1)
                {
                    // $("#products-page-sublist-dropdown-menu").html($updatePageResultJ.contents.filter);
                    $("#products-grid").html($updatePageResultJ.contents.listing.products);
                    $("#productsListingListingTopLinks").html($updatePageResultJ.contents.listing.forward);
                    $("#productsListingBottomNumber").html($updatePageResultJ.contents.listing.back);

                    setImageOnError();
                    $('.form-check-label').each(function(){
                        $(this).text($(this).text().replace(/(Freedom Electronics)|(RDM)|PMP/g, "Rebuilt Part"));
                    }); 
                    $('.product-item-additional-info').each(function(){
                        $(this).text($(this).text().replace(/(Freedom Electronics)|(RDM)|PMP/g, "Rebuilt Part"));
                    });
                    
                    $(".SPR-nav").on("click", function() {
                        window.scroll(0, 0);
                    });
                }
                else
                {
                    alert($updatePageResultJ.message);
                }
            } catch (e) {
                alert('Listing update failed while parsing AJAX data.');
            }
        });


        </script>
    </div>
</main>