<?php

/**
 * Page Template
 *
 * Loaded automatically by index.php?main_page=product_info.
 * Displays details of a typical product
 *
 * @copyright Copyright 2003-2022 Zen Cart Development Team
 * @copyright Portions Copyright 2003 osCommerce
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version $Id: Scott C Wilson 2021 Aug 07 Modified in v1.5.8-alpha $
 */

  //in linked header_php.php:
  //$product_info = zen_get_product_details($products_id_current = (!empty($_GET['products_id']) ? (int)$_GET['products_id'] : 0));


  $isRebuilt = 0;
  $productPrice = $product_info->fields['product_is_call']? 'Call for Price' : "Starting at $" .  number_format($product_info->fields['products_price'], 2);
  $productId = $product_info->fields['products_id'];
  
  $attributesQuery = "SELECT pa.options_id, pa.options_values_id, pa.options_values_price, po.products_options_type 
    FROM zen_products_attributes pa 
    LEFT JOIN zen_products_options po ON po.products_options_id = pa.options_id  
    WHERE pa.products_id = '$productId' AND po.products_options_type != 5
    ORDER BY pa.options_values_id
  ";
  $attributes = $db->Execute($attributesQuery);
  $attributesCount = $attributes->RecordCount();

  $check_attributes_sql = "SELECT pa.options_id, MAX(po.products_options_type) as max_po_pot
    FROM zen_products_attributes pa
    LEFT JOIN zen_products_options po ON pa.options_id = po.products_options_id
    WHERE pa.products_id = '$productId' 
    GROUP BY pa.options_id
  ";

  $pr_attr = $db->Execute($check_attributes_sql);
  $check_attributes_count	= $pr_attr->RecordCount();
  $pr_attr->fields['total']	= $check_attributes_count; //Fix for template checks
  
  $brands_to_rebuilt = array(
      "PMP NEW", "ESCO SERVICES", "DAVIS AIRTECH","FREEDOM ELECTRONICS", "RDM", "FREEDOM / RDM OUTRIGHT", "GLOBAL LIGHT", "PMP", 
  );
  if (array_search(strtoupper($manufacturers_name), $brands_to_rebuilt))
  {
    $manufacturers_name = '<em>(REBUILT PART)</em>';
    $isRebuilt = 1;
  }
  $imageUrl = "/images/" . $product_info->fields['products_image'];
  $productTitle = "<h5><span class='brand-text-color'>$manufacturers_name</span> <span class='model-text-color'>$products_model</span> $products_name</h5>";
  $productAlternateName = $product_info->fields["products_alt_name"];
  $isFreeShipping = $product_info->fields["product_is_always_free_shipping"];
  $warrantyLength = $product_info->fields["warranty"];
  $isMadeInTheUsa = $product_info->fields["madein"];
  $certification = $product_info->fields['certification'];
  $warrantySection = "";
  if($warrantyLength > 0)
  {
    $warrantyImageUrl = "";
    $altText= "";
    switch($warrantyLength)
    {
      case "1":
        $warrantyImageUrl = "/images/design/full-manufacturers-warranty.png";
        $altText = "Full Manufacturer Warranty";
        break;
      case "2":
        $warrantyImageUrl = "/images/design/1-year-mfr-warranty.png";
        $altText = "One Year Manufacturer Warranty";
        break;
      case "3":
        $warrantyImageUrl = "/images/design/2-year-mfr-warranty.png";
        $altText = "Two Year Manufacturer Warranty";
        break;
      case "4":
        $warrantyImageUrl = "/images/design/3-year-mfr-warranty.png";
        $altText = "Three Year Manufacturer Warranty";
        break;
      case "5":
        $warrantyImageUrl = "/images/design/5-year-mfr-warranty.png";
        $altText = "Five Year Manufacturer Warranty";
        break;
      case "6":
        $warrantyImageUrl = "/images/design/4-year-warranty.png";
        $altText = "Four Year Manufacturer Warranty";
        break;
      case "7":
        $warrantyImageUrl = "/images/design/10-year-warranty.png";
        $altText = "Ten Year Manufacturer Warranty";
        break;
      default:
      break;
    }
    $warrantySection = 
      "<div>
        <img class='img-fluid product-sub-image' src='$warrantyImageUrl ' alt='$altText' />
      </div>";
  }
  $productDescription = $product_info->fields["products_description"];
  $isCallProduct = $product_info->fields["product_is_call"] == '1';
  $hasAccessories = false;
  $isBaseProduct = $product_info->fields["is_base_product"] == '1';
  
  $products = array();
  if($isBaseProduct)
  {
    $products = $db->Execute("select distinct p.products_id, p.products_price as price, p.products_image, pd.products_name, pd.products_alt_name, p.products_model, p.is_core, p.is_exchange, px.sort_order, p.product_is_call
    from " . "zen_products_xsell" . " px, " . "zen_products" . " p, " . "zen_products_description" . " pd
    where px.products_id = '" . $_GET['products_id'] . "'
    and px.xsell_id = p.products_id
    and p.products_id = pd.products_id
    and px.xsell_placement = '". "options" ."'
    order by px.sort_order asc limit " . "100");  
  }
  else
  {
    $products["0"] = array(
      "products_id" => $product_info->fields["products_id"],
      "price" => $isCallProduct == "1" ? "Call For Price" : $product_info->fields["products_price"],
      "products_name" => $product_info->fields["products_name"],
      "products_alt_name" => $product_info->fields["products_alt_name"],
      "products_model" => $product_info->fields["products_model"],
      "product_is_call" => $product_info->fields['product_is_call']
    );
  }

  $accessories = $db->Execute("select distinct p.products_id, p.products_price as price, p.products_image, pd.products_name, pd.products_alt_name, p.products_model, p.is_core, p.is_exchange, px.sort_order
  from " . "zen_products_xsell" . " px, " . "zen_products" . " p, " . "zen_products_description" . " pd
  where px.products_id = '" . $_GET['products_id'] . "' AND p.is_core = '0'
  and px.xsell_id = p.products_id
  and p.products_id = pd.products_id
  and px.xsell_placement = '" . "accessories" . "'
  order by px.sort_order asc limit " . "100"); 
  $cores = $db->Execute("select distinct p.products_id, p.products_price as price, p.products_image, pd.products_name, pd.products_alt_name, p.products_model, p.is_core, p.is_exchange, px.sort_order
  from " . "zen_products_xsell" . " px, " . "zen_products" . " p, " . "zen_products_description" . " pd
  where px.products_id = '" . $_GET['products_id'] . "' AND p.is_core = '1'
  and px.xsell_id = p.products_id
  and p.products_id = pd.products_id
  and px.xsell_placement = '" . "accessories" . "'
  order by px.sort_order asc limit " . "100");
  $xsell = $db->Execute("select distinct p.products_id, p.products_price as price, p.products_image, pd.products_name, pd.products_alt_name, p.products_model, p.is_base_product, px.sort_order
  from " . "zen_products_xsell" . " px, " . "zen_products" . " p, " . "zen_products_description" . " pd
  where px.products_id = '" . $_GET['products_id'] . "'
  and px.xsell_id = p.products_id
  and p.products_id = pd.products_id
  and px.xsell_placement = '" . "regular" . "'
  order by px.sort_order asc limit " . "100");

  $hasCores = $cores->RecordCount() > 0;
  $hasAccessories = $accessories->RecordCount() > 0;
  $hasXSell = $xsell->RecordCount() > 0;

  function echoIfTrue($expression, $print_me) {
    if($expression == true)
    {
      echo $print_me;
    }
  }

  function getStringBetween($string, $start, $end) {
    $string = ' ' . $string;
    $ini = strpos($string, $start);
    if ($ini == 0) return '';
    $ini += strlen($start);
    $len = strpos($string, $end, $ini) - $ini;
    return substr($string, $ini, $len);
  }

  function renderTabs($description) {
    global $db;
    global $cPath;
    global $productId;

    $tabButtonsHtml = "";
    $tabsHtml = "";
    if($description == "" || $description == null)
    {
      return "";
    }

    $description .= "<!--%EOF%-->";
    $match = array();
    

    preg_match_all('/\<!--\%(.*?)\%--\>/', $description, $match);

    $tokensBlank = $match[0];
    $tokensReal = $match[1];

    $matches = array();

    for ($token = 0; $token < sizeof($tokensBlank); $token++)
    {
      if ($token < (sizeof($tokensBlank) - 1))
      {
        $matches[] = getStringBetween($description, $tokensBlank[$token], $tokensBlank[$token + 1]);
      }
    }

    $tabs = "";
    $tabsContent = "";

    if(sizeof($matches) == 0) {
      return;
    }

    for ($content = 0; $content < sizeof($matches); $content++)
    {
      if ($content == 0)
      {
        $tabs .= "<button class='nav-link me-1 active' id='tab{$content}-tab' data-bs-toggle='tab' data-bs-target='#tab{$content}' type='button' role='tab' aria-controls='tab{$content}' aria-selected='true'>{$tokensReal[$content]}</button>";

        $tabsContent .= "<div class='tab-pane fade show active' id='tab{$content}' role='tabpanel' aria-labelledby='tab{$content}-tab'>{$matches[$content]}</div>";
      }
      else
      {
        $tabs .= "<button class='nav-link me-1' id='tab{$content}-tab' data-bs-toggle='tab' data-bs-target='#tab{$content}' type='button' role='tab' aria-controls='tab{$content}' aria-selected='false'>{$tokensReal[$content]}</button>";

        $tabsContent .= "<div class='tab-pane fade' id='tab{$content}' role='tabpanel' aria-labelledby='tab{$content}-tab'>{$matches[$content]}</div>";
      }
    }
    
    $addProductReviewLink = "/index.php?main_page=product_reviews&cPath=$cPath&products_id=$productId";
    $writeReviewButton = "<a class='btn bg-westech-green text-white w-100' href='$addProductReviewLink'>Write A Review</a>";

    $tabs .= "
     <button class='nav-link me-1' id='tabreviews-tab' data-bs-toggle='tab' data-bs-target='#tabreviews' type='button' role='tab' aria-controls='tabreviews' aria-selected='false'>Reviews</button>
    ";

    $productReviews = $db->Execute("SELECT *
      FROM zen_reviews r
      LEFT JOIN zen_reviews_description rd ON r.reviews_id = rd.reviews_id
      WHERE r.products_id = $productId
      AND r.status = 1
      ORDER BY r.reviews_rating, r.last_modified
      LIMIT 10;"
    );

    $numberOfReviews = $productReviews->RecordCount();

    $reviewButtonText = 'Write a Review';
    $reviews = '';

    if ($numberOfReviews > 0) {

      $productReviewAverage = $db->Execute("SELECT AVG(reviews_rating) as average FROM zen_reviews");
      $averageRating = (float)number_format($productReviewAverage->fields['average'], 1);
      $averageRating = 3.5;
      $averageRatingDifference = $averageRating - floor($averageRating);

      while (!$productReviews->EOF) {
        foreach ($productReviews->fields as $fieldname => $field) {
          $$fieldname = $field;
        }
  
        $last_modified = date('m/d/Y', strtotime($last_modified));
        $customers_name = substr($customers_name, 0,  strpos($customers_name, ':'));
  
        $reviews .= "
          <div class='row'>
            <div style='display: flex; justify-content: space-between; width: 100%;'>
              <div class='rating-stars'>
                <span class='fa fa-star" . (($reviews_rating >= 1)? ' checked' : '') . "'></span>
                <span class='fa fa-star" . (($reviews_rating >= 2)? ' checked' : '') . "'></span>
                <span class='fa fa-star" . (($reviews_rating >= 3)? ' checked' : '') . "'></span>
                <span class='fa fa-star" . (($reviews_rating >= 4)? ' checked' : '') . "'></span>
                <span class='fa fa-star" . (($reviews_rating >= 5)? ' checked' : '') . "'></span>
              </div>
              <div class='rating-date'><p style='margin: 0;'>$last_modified</p></div>
            </div>
            <p class='review-title' style='font-weight: bold; margin: 0;'>$reviews_title</p>
            <p class='review-description' style='margin: 0;'>$reviews_text</p>
            <p class='review-uploader' style='margin: 0; font-weight: bold; color: var(--custom-darker-grey);'>By $customers_name</p>
          </div>
        <hr />
        ";
  
        $productReviews->MoveNext();
      }
    } else {
      $reviews = "
        <div class='row'>
          <p class='review-title' style='font-weight: bold; margin: 0;'>No reviews yet!</p>
          <p class='review-description' style='margin: 0;'>Be the first to add a review.</p>
          <p class='review-uploader' style='margin: 0; font-weight: bold; color: var(--custom-darker-grey);'>*Reviews are subject to approval</p>
        </div>
      <hr />
      ";
    }
    
    $tabsContent .= "
      <div class='tab-pane fade' id='tabreviews' role='tabpanel' aria-labelledby='tabreviews-tab'>
        <div class='container-fluid'>
          <div class='row'>
            <div class='rating-summary'>
              <div class='reviews-overall-rating'>
                <p class='m-0'>Overall Rating</p>
                <div class='d-flex'>
                  <div class='rating-stars'>
                    <span class='fa fa-star" . (($averageRating >= 1)? ' checked' : '') . ((ceil($averageRating) == 1 && $averageRatingDifference >= 0.5)? ' half-checked' : '') . "'></span>
                    <span class='fa fa-star" . (($averageRating >= 2)? ' checked' : '') . ((ceil($averageRating) == 2 && $averageRatingDifference >= 0.5)? ' half-checked' : '') . "'></span>
                    <span class='fa fa-star" . (($averageRating >= 3)? ' checked' : '') . ((ceil($averageRating) == 3 && $averageRatingDifference >= 0.5)? ' half-checked' : '') . "'></span>
                    <span class='fa fa-star" . (($averageRating >= 4)? ' checked' : '') . ((ceil($averageRating) == 4 && $averageRatingDifference >= 0.5)? ' half-checked' : '') . "'></span>
                    <span class='fa fa-star" . (($averageRating == 5)? ' checked' : '') . ((ceil($averageRating) == 5 && $averageRatingDifference >= 0.5)? ' half-checked' : '') . "'></span>
                  </div>
                  <div class='rating-score'>
                    <p>$averageRating</p>
                  </div>
                  <div class='pipe'>
                    <span>|</span>
                  </div>
                  <div class='review-count'>
                    <p>$numberOfReviews Review(s)</p>
                  </div>
                </div>
              </div>
              <div class='reviews-write'>
                $writeReviewButton
              </div>
            </div>
          </div>
          <hr />
          $reviews
        </div>
      </div>
    ";

    $tabsSectionHtml = "
      <nav>
          <div class='nav nav-tabs' id='product-page-tabs' role='tablist'>
              $tabs
          </div>
      </nav>
      <div class='tab-content mb-3' id='product-page-tab-content'>
          $tabsContent
      </div>
    ".PHP_EOL;

    return $tabsSectionHtml;
  }

  function renderConfigurableProduct() {
    global $productId;
    global $isCallProduct;
    global $attributes;
    global $db;
    global $productPrice;
    $html = "";
    $tableDescriptionHeader = "
      <div>
          <p class='table-description'>Please Choose:</p>
      </div>
    ";
    $options = array();
    foreach($attributes as $attribute)
    {
      $optionId = $attribute['options_id'];
      $optionValueId = $attribute["options_values_id"];
      $price = $attribute["options_values_id"];
      $optionsData = $db->Execute("SELECT products_options_name, products_options_type FROM zen_products_options WHERE products_options_id = $optionId");
      if(!isset($options["$optionId"]))
      {
        $options["$optionId"] = array();
        $options["$optionId"]["id"] = $optionId;
        $options["$optionId"]["title"] = $optionsData->fields['products_options_name'];
        $options["$optionId"]["type"] = $optionsData->fields['products_options_type'];
      } 
      $optionNameData = $db->Execute("SELECT * FROM zen_products_options_values WHERE products_options_values_id = '$optionValueId'");
      $options["$optionId"]["options"][] = array(
        "valueId" => $optionValueId,
        "optionName" => $optionNameData->fields['products_options_values_name'],
        "optionPrice" => $attribute['options_values_price'],
      );
    }
    foreach($options as $option)
    {
      $id = $option['id'];
      $optionTitle = $option['title'];
      $optionInput = "";
      switch($option['type'])
      {
        case 0:
          $selectOptions = "";
          foreach($option['options'] as $o)
          {
            $oTitle = $o['optionName'];
            $oPrice = $o['optionPrice'];
            $oValueId = $o['valueId'];
            if($oPrice > 0)
            {
              $oTitle .= " ( +$" . number_format($oPrice, 2) . " )";
            }
            $selectOptions .= "<option value='$oValueId'>$oTitle</option>";
          }
          $onfocussize = (count($option['options']) > 10)? 10 : count($option['options']) + 1;
          $html .= "
            <div class='product-attribute-dropdown'>
              <label for='option-$id'>$optionTitle</label>
              <select class='form-select attribute-input' data-id='$id' id='option-$id' name='option-$id' onfocus='this.size=$onfocussize;' onblur='this.size=1;' onchange='this.size=1; this.blur();'>
                  <option disabled selected value=''>Please Select One...</option>
                  $selectOptions
              </select>
            </div>
          ";
          // Dropdown Input
          break;
        case '1':
          $html .= "
            <div class='mb-3'>
              <label for='option-$id'>$optionTitle</label>
              <input class='form-control attribute-input' data-attribute='true' id='option-$id'  type='text' data-id='$id' />
            </div>
          ";
          // Text Input
          break;
        case '2':
          
          // Radio Input
          break;
        case '3':
          $checkboxOptions = "";
          foreach($option['options'] as $o)
          {
            $oTitle = $o['optionName'];
            $oPrice = $o['optionPrice'];
            $oValueId = $o['valueId'];
            if($oPrice > 0)
            {
              $oTitle .= " ( +$" . number_format($oPrice, 2) . " )";
            }
            $checkboxOptions .= "
              <div class='form-check'>
                <input class='form-check-input attribute-input' type='checkbox' id='option-$oValueId' data-id='$id' value='$oValueId' >
                <label class='form-check-label' for='option-$oValueId'>
                  $oTitle
                </label>
              </div>
            ";
          }
          $html .= " 
            <div class=''>
              <p class='mb-1'>$optionTitle </p>
              $checkboxOptions
            </div>
          ";
          // Ceckbox Input
          break;
        case '4':
          $html .= "
          ";
          // File Input
          break;
        default:
          break;
      }
    }
    $input = $isCallProduct? "" : "
      <label>Qty</label> 
      <input data-id='$productId' name='products_id[$productId]' type='number' class='form-control product-quantity-input' id='product-quantity-input-field' placeholder='0' aria-label='product quantity' aria-describedby='product quantity' />
    ";

    $buttonsSection = $isCallProduct? "" : "
    <div class='col-10' style='align-self: end;'>
      <button type='button' class='btn bg-message-red text-white' id='product-buttons-atc' onClick='addConfigurableToCart()'>
          <i class='fa-solid fa-plus fa-lg'></i> ADD TO CART
      </button>
      <a class='d-none' id='product-buttons-checkout' href='?main_page=checkout'>
        <button type='button' class='btn bg-westech-green text-white'>
            <i class='fa-solid fa-arrow-right'></i> GO TO CHECKOUT
        </button>
      </a>
    </div>
  ";

    return "
      <p>$productPrice</p>
      $tableDescriptionHeader
      <form class=''>
        $html
        <div class='row mb-3'>
          <div class='col-2'>
            $input
          </div>
          $buttonsSection
        </div>
      </form>
    ";
  }

  function renderProductsTable() {
    global $products;
    global $isCallProduct;
    global $isBaseProduct;
    global $db;
    global $cores;
    $tableDescriptionHeader = "
      <div>
          <p class='table-description'>Select Model &amp; Quantity:</p>
      </div>
    ";
    $tableCols = "<thead>";
    if($isCallProduct)
    {
      $tableCols .= "
        <tr class='bg-dark-grey'>
            <th scope='col' class='table-model-col'>Model #</th>
            <th scope='col' class='table-description-col'>Description</th>
            <th scope='col' class='table-price-col'>Price</th>
        </tr>
      ";
    }
    else
    {
      $tableCols .= "
        <tr class='bg-dark-grey'>
            <th scope='col' class='table-model-col'>Model #</th>
            <th scope='col' class='table-description-col'>Description</th>
            <th scope='col' class='table-price-col'>Price</th>
            <th scope='col'>Qty</th>
        </tr>
      ";
    }
    $tableCols .= "</thead>";
    $tableBody = "<tbody>";

    foreach($products as $product)
    {
      
      $id = $product['products_id'];
      $price = ($isCallProduct || $product['product_is_call'] == '1') ? "Call For Price" : "$" . number_format($product['price'], 2);
      $isExchange = false;
      $coreDataAttribute = "";
      if (isset($product['is_exchange']))
      {
        $isExchange = $product['is_exchange'];
        $coreID = $cores->fields['products_id'];
        $coreDataAttribute = "data-core-id='$coreID'";
      }
      $description = $product['products_alt_name'] ?: $product['products_name'];
      if($isExchange)
      {
        $description .= "</br><span class='text-blue font-weight-500'>When selecting this product, the core charge (seen below) will automatically be added to your cart.</span>";
      }
      $model = $product['products_model'];


      $extraClasses = ($isCallProduct || $product['product_is_call'] == '1') ? "non-addable-product" : "";
      $inputField = ($isCallProduct || $product['product_is_call'] == '1') ? "" :  "<td><input data-id='$id' name='products_id[$id]' type='number' class='form-control product-quantity-input' placeholder='0' aria-label='product quantity' aria-describedby='product quantity' /></td>";
      $colspan = ($isCallProduct || $product['product_is_call'] == '1') ? " colspan='2' " : '';
      $tableRow = "
        <tr data-input-id='$id' $coreDataAttribute class='$extraClasses'>
          <th scope='row'>$model</th>
          <td>$description</td>
          <td$colspan>$price</td$colspan>
          $inputField
        </tr>
      ";
      $tableBody .= $tableRow;
    }
    $tableBody .= "</tbody>";
    $table = "
      <div class='table-responsive products-table'>
        <table class='table table-bordered product-table'>
          $tableCols 
          $tableBody 
        </table>
      </div>
    ";
    return $tableDescriptionHeader . $table;
  }

  function renderAccessoriesTable() {
    global $accessories;
    global $db;
    global $isCallProduct;

    $tableHeader = "
      <div>
          <p class='table-description'>Add Optional Accessories</p>
      </div>
    ";
    $tableColumns= "<thead>";
    if($isCallProduct)
    {
    $tableColumns .= "
          <tr class='bg-dark-grey'>
              <th scope='col' class='table-model-col'>Model #</th>
              <th scope='col' class='table-description-col'>Description</th>
              <th scope='col' class='table-price-col'>Price</th>
          </tr>
    ";
    }
    else
    {
      $tableColumns .= "
        <tr class='bg-dark-grey'>
            <th scope='col' class='table-model-col'>Model #</th>
            <th scope='col' class='table-description-col'>Description</th>
            <th scope='col' class='table-price-col'>Price</th>
            <th scope='col'>Qty</th>
        </tr>
      ";
    }
    $tableColumns .= "</thead>";
    $tableBody = "<tbody>";
    foreach($accessories as $accessory)
    {
      $id = $accessory['products_id'];
      $description = $accessory['products_name'];
      $description .= $accessory['products_alt_name'] ? " - " . $accessory['products_alt_name'] : "";
      $model = $accessory['products_model'];
      $priceQuery = $db->Execute("select products_price as price from zen_products where products_id = $id;");
      $isCore = $accessory['is_core'] ? 
                "<span class='text-blue font-weight-500'>For those planning on returning a core - This amount will be refunded to your card if the core is returned within 30 days.</span></br>" :
                "";
      foreach($priceQuery as $row)
      {
        $price = number_format($row['price'], 2);
      }
      $extraClasses = ($isCallProduct || $product['product_is_call'] == '1') ? "non-addable-product" : "";
      $inputField = ($isCallProduct || $product['product_is_call'] == '1') ? "" :  "<td><input data-id='$id' name='products_id[$id]' type='number' class='form-control product-quantity-input' placeholder='0' aria-label='product quantity' aria-describedby='product quantity' /></td>";
      $colspan = ($isCallProduct || $product['product_is_call'] == '1') ? " colspan='2' " : '';
      if ($isCallProduct || $product['product_is_call'] == '1'){
        $price = "Call For Price";
      }
      else {
        $price = "$" . $price; 
      }
      $tableRow =  "
        <tr data-input-id='$id' class='$extraClasses'>
          <th scope='row'>$model</th>
          <td>
            $isCore
            $description
          </td>
          <td$colspan>$price</td$colspan>
          $inputField
        </tr>
      ";
      $tableBody .= $tableRow;
    }
    $tableBody .= "</tbody>";


    $table = "
      <div class='table-responsive products-table'>
        <table class='table table-bordered product-table'>
        $tableColumns
        $tableBody
        </table>
      </div>
    ";

    return $tableHeader . $table;
  }

  function renderCoresTables() {
    global $db;
    global $cores;
    global $isCallProduct;

    $tableHeader = "
      <div>
          <p class='table-description'>Core Charge</p>
      </div>
    ";
    $tableColumns = "
    ";
    if($isCallProduct)
    {
      $tableColumns .= "
        <tr class='bg-dark-grey'>
            <th scope='col' class='table-model-col'>Model #</th>
            <th scope='col' class='table-description-col'>Description</th>
            <th scope='col' class='table-price-col'>Price</th>
        </tr>
      ";
    }
    else
    {
      $tableColumns .= "
        <tr class='bg-dark-grey'>
            <th scope='col'>Model #</th>
            <th scope='col'>Description</th>
            <th scope='col'>Price</th>
        </tr>
      ";
    }
    $tableBody = "<tbody>";
    foreach($cores as $core)
    {
      $id = $core['products_id'];
      $description = $core['products_name'];
      $model = $core['products_model'];
      $price = $isCallProduct ? "Call For Price" :  "$" . number_format($core['price'], 2);
      $isCore = $core['is_core'] ? 
                "<span class='text-blue font-weight-500'>For those planning on returning a core - This amount will be refunded to your card if the core is returned within 30 days.</span></br>" :
                "";

               $tableRow =  "
        <tr data-input-id='$id' class='non-addable-product'>
          <th scope='row'>$model</th>
          <td>
            $isCore
            $description
          </td>
          <td>$price</td>
        </tr>
      ";
      $tableBody .= $tableRow;
    }
    $tableBody .= "</tbody>";


    $table = "
      <div class='table-responsive pb-3 products-table'>
        <table class='table table-bordered product-table'> 
        <thead>
          $tableColumns
        </thead>
        $tableBody
        </table>
      </div>
    ";

    return $tableHeader . $table;
  }

  function renderButtons() {
    global $isCallProduct;

   
    $buttonsSection = $isCallProduct? "" : "
      <div class='pb-3 product-buttons-container'>
        <button type='button' class='btn bg-message-red text-white' id='product-buttons-atc' onClick='addToCart()'>
            <i class='fa-solid fa-plus fa-lg'></i> ADD TO CART
        </button>
        <a class='d-none' id='product-buttons-checkout' href='?main_page=checkout'>
          <button type='button' class='btn bg-westech-green text-white'>
              <i class='fa-solid fa-arrow-right'></i> GO TO CHECKOUT
          </button>
        </a>
      </div>
    ";
    return $buttonsSection;
  }

  function renderXSellCarousel() {
    global $db;
    global $productId;
    global $xsell;

    $xSellCards = "";

    foreach ($xsell as $xsellproduct)
    {
      $productID = $xsellproduct['products_id'];
      $isBaseProduct = $xsellproduct['is_base_product'] == '1';
      $productImage = $xsellproduct['products_image'];
      $productImageAlt = $xsellproduct['products_name'];
      $productModel = $xsellproduct['products_model'];
      $productName = $xsellproduct['products_name'];
      $productAltName = $xsellproduct['products_alt_name'];
      $productPrice = $xsellproduct['price'];
      $productPrice = number_format($productPrice, 2);
      $productPrice = "$$productPrice";

      if ($isBaseProduct)
      {
        $minChildPrice = $db->Execute("
        SELECT
          MIN(zp.products_price) as minChildPrice
        FROM
          zen_products_xsell zpx
        LEFT JOIN
          zen_products zp ON zpx.xsell_id = zp.products_id
        WHERE
          zpx.products_id = '$productID'
          AND
          zpx.xsell_placement = 'options'
        ");

        $productPrice = $minChildPrice->fields['minChildPrice'];
        $productPrice = number_format($productPrice, 2);
        $productPrice = "Starting at $$productPrice";
      }

      $xSellCards .= "
        <a class='xSellCarousel-item' href='?main_page=product_info&products_id=$productID'>
          <div class='card'>
            <img src='images/$productImage' alt='$productImageAlt'>
            <h5 class='card-title'>Model # $productModel</h5>
            <p class='card-text d-flex flex-grow-1'>$productAltName</p>
            <p class='card-text d-flex'>$productPrice</p>
          </div>
        </a>
      ";
    }

    $xSellSection = "
    <div class='d-flex flex-column'>
      <h3 class='d-flex align-self-center'>Related Products</h3>
      <div id='xSellCarousel' class='xSellCarousel mb-3'>
        <div class='xSellCarousel-inner'>
          $xSellCards
        </div>
        <button class='carousel-control-prev' type='button' data-bs-target='#xSellCarousel' data-bs-slide='prev'>
          <span class='carousel-control-prev-icon' aria-hidden='true'></span>
          <span class='visually-hidden'>Previous</span>
        </button>
        <button class='carousel-control-next' type='button' data-bs-target='#xSellCarousel' data-bs-slide='next'>
          <span class='carousel-control-next-icon' aria-hidden='true'></span>
          <span class='visually-hidden'>Next</span>
        </button>
      </div>
    </div>
    ";

    return $xSellSection;
  }
?>

<main class="container-lg">
    <p class="small-text breadcrumb-container">
      <?php echo $breadcrumb->trail("/"); ?>
    </p>
    <div class="row mt-5">
        <div class="col-sm-12 col-lg-5">
            <div class="product-page-image-container pb-3">
                <?php
                  echoIfTrue($isFreeShipping, '<img class="p-absolute free-shipping-image" src="/images/always-free-shipping.gif" alt="Free shippping" />');
                ?>
                <div class="d-flex flex-column justify-content-center active-image-container">

                  <?php

                    $lastDelim = strrpos($imageUrl, '.');
                    $imageWOExt = ($imageUrl[0] == '/')? substr($imageUrl, 1, ($lastDelim - 1)) : substr($imageUrl, 0, $lastDelim);
                    $sanitizedImageURL = str_replace('//', '/', $imageUrl);
                    $pattern = "$imageWOExt*.*";
                    // Get images
                    $multiImageCheck = glob($pattern, GLOB_MARK);
                    /*
                      Set regex to check for a valid image
                      CONDITION(S):
                        Image string can contain with _{d}{d} 
                        Images string can end with _{d}
                        Images string can end with -{d}{d} 
                        Images string can end with -{d}
                        Image string can have the follow extenstions (jpg|jpeg|png|gif|bmp|svg|webp|tiff)

                    */
                    // $imageRegex = "/^(.*?)[_-]\d{1,2}\.(jpg|jpeg|png|gif|bmp|svg|webp|tiff)/";
                    $sanitizedURL =  str_replace(["/", "//", "-"], ["\/", "\/\/", "\-"], $imageWOExt);
                    // Create regex using the base string of the main image
                    $imageRegex  = "/" . $sanitizedURL . "[_-]\d{1,2}\.(jpg|jpeg|png|gif|bmp|svg|webp|tiff)/";
                    // Main product image being displayed
                    $displayImage = "
                      <div class='d-flex main-product-img-container'>
                        <img 
                          class='img-fluid main-image' 
                          src='$imageUrl' 
                          alt='$products_name' 
                          onerror=\"this.onerror=null;this.src='/images/no_picture_original.gif';\"
                        />
                      </div>
                    ";

                    // Create Image carousel with empty string
                    $imageCarousel = "";                    
                    // Filter images to remove any invalid ones from the list
                    $productImages  = array_filter($multiImageCheck, function($value) use($imageUrl, $imageRegex) {
                      // Create in case someone input image with / at the begining
                      $tempStr = "/" . $value;
                      // Regex to check if the image is valid using $imageRex
                      $isValidImage = preg_match($imageRegex, $value);
                      // Return true if image doesnt match main image path and is a valid image using the regex
                      return (
                        $imageUrl !== $tempStr 
                        && $imageUrl !== $value
                        && $isValidImage
                      );
                    });

                    // Generate image carousel if image count is greater than 1
                    if (count($productImages ) > 1)
                    {
                      // List of images for the milti image carousel. Starting with the main image at the start
                      $carouselItems = " 
                        <div class='multiImageCarousel-item'>
                            <img 
                              class='secondary-image active'  
                              src='$imageUrl' 
                              alt='$products_name' 
                              onerror=\"this.onerror=null;this.src='/images/no_picture_original.gif';\"
                            />
                        </div>"
                      ;
                      
                      
                      // Loop through each image for the product
                      foreach ($productImages  as $productImage)
                      {
                        // create a multiimage carousel item
                        $carouselItem = "
                          <div class='multiImageCarousel-item'>
                            <img 
                              class='secondary-image'  
                              src='$productImage' 
                              alt='$products_name' 
                              onerror=\"this.onerror=null;this.src='/images/no_picture_original.gif';\"
                            />
                          </div>
                        ";
                        // Add item to product image list
                        $carouselItems .= $carouselItem;
                      }

                      // Create image carousel
                      $imageCarousel = "
                        <div class='multiImageCarousel'>
                          <div class='multiImageCarousel-inner'> 
                            $carouselItems
                          </div>
                          <button class='carousel-control-prev' type='button' data-bs-target='#multiImageCarousel' data-bs-slide='prev'>
                            <span class='carousel-control-prev-icon' aria-hidden='true'></span>
                            <span class='visually-hidden'>Previous</span>
                          </button>
                          <button class='carousel-control-next' type='button' data-bs-target='#multiImageCarousel' data-bs-slide='next'>
                            <span class='carousel-control-next-icon' aria-hidden='true'></span>
                            <span class='visually-hidden'>Next</span>
                          </button>
                        </div>
                      ";
                    }
                    // Display image and carousel
                    echo "
                      $displayImage
                      $imageCarousel
                    ";
                  ?>

                  
                </div>
                <div class="logo-sizing"> 
                  <?php
                    echo $warrantySection;
                  ?>
                  <?php
                    echoIfTrue(
                      $isMadeInTheUsa, 
                      '<div>
                        <img class="img-fluid product-sub-image" src="/images/made-in-usa-icon.png" alt="" />
                      </div>'
                    );
                  ?>
                  
                  <?php
                    if ($certification > 0)
                    {
                      $defaultColumn = "col-3";
                      if($certification == 3 || $certification == 6 || $certification == 7 || $certification == 9) {
                        $defaultColumn = "col-6";
                      }
                       //  col-lg-3
                      $certificationIcon = "<div>";
                      switch ($certification)
                      {
                        case 1:
                          $certificationIcon .= '<img class="img-fluid product-sub-image" src="/images/design/UL-USA.jpg" alt="" />';
                          break;
                        case 2:
                          $certificationIcon .= '<img class="img-fluid product-sub-image" src="/images/design/UL-CANADA.jpg" alt="" />';
                          break;
                        case 3:
                          $certificationIcon .= '<img class="img-fluid product-sub-image" src="/images/design/UL-USA-CANADA.jpg" alt="" />';
                          break;
                        case 4:
                          $certificationIcon .= '<img class="img-fluid product-sub-image" src="/images/design/CE.jpg" alt="" />';
                          break;
                        case 5:
                          $certificationIcon .= '<img class="img-fluid product-sub-image" src="/images/design/LEED.jpg" alt="" />';
                          break;
                        case 6:
                          $certificationIcon .= '<img class="img-fluid product-sub-image" src="/images/design/UL-CSA.jpg" alt="" />';
                          break;
                        case 7:
                          $certificationIcon .= '<img class="img-fluid product-sub-image" src="/images/design/UL-USA-CANADA-CE.jpg" alt="" />';
                          break;
                        case 8:
                          $certificationIcon .= '<img class="img-fluid product-sub-image" src="/images/design/FM.jpg" alt="" />';
                          break;
                        case 9:
                          $certificationIcon .= '<img class="img-fluid product-sub-image" src="/images/design/FM-CE.jpg" alt="" />';
                          break;
                      }
                      $certificationIcon .= '</div>';

                      echo $certificationIcon;
                    }
                  ?>
                </div>
                <?php echoIfTrue($isFreeShipping, '<p class="mb-0 text-center">*Free shipping Excludes Hawaii and Alaska</p>'); ?>
                <p class="text-center small-text text-muted">*Image is a representation of this item. Actual item may vary.*<br />Hover over image to zoom</p>
            </div>
        </div>
        <div class="col-sm-12 col-lg-7 pb-5">
            <div class="m-0 pb-4">
                <?php echo $productTitle; ?>
                <p><?php echo $productAlternateName; ?></p>
                <div class="seperator"></div>
            </div>
            <div class="row">
                <?php
                  if ($products_quantity == 1)
                  {
                    echo '<img src="/images/design/in_stock.jpg" border="0" alt="In stock product"  height="50" width="70" />';
                  }
                  else if ($products_quantity == 2)
                  {
                    echo '<img src="/images/design/in_stock_v1.jpg" border="0" alt="In stock product"  height="50" width="70" />';
                  }
                  else if ($products_quantity == 3)
                  {
                    echo '<div><img src="/images/design/quick-ship-icon.jpg" border="0" alt="Quick Ship product" height="40" width="70" /></div>';
                  }
                  else
                  {
                    echo '<p class="fw-bold m-0">Ships From Manufacturer</p>';
                  }
                ?>
                <?php 
                  if(!$hasAccessories && !$hasCores && $attributesCount > 0)
                  {
                    echo renderConfigurableProduct();
                  } 
                  else
                  {
                    echo renderProductsTable();
                    if($hasAccessories) echo renderAccessoriesTable();
                    if($hasCores) echo renderCoresTables();
                    echo renderButtons();
                  } 
                ?>
                <div>
                    <a href="?main_page=contact_us" class="product-contact-us-section bg-dark-grey text-center d-block"><i class="fa-solid fa-envelope"></i> Contact Us</a>
                </div>
            </div>
        </div>
    </div>
    <?php
      echo renderTabs($productDescription);
      if($hasXSell) echo renderXSellCarousel();
    ?>
</main>
<script>
  function checkInput($input) {
    if($input.val() === "" || $input.val() == null || $input.val() == undefined) {
        $input.toggleClass("input-error", true);
        return true;
    }
    $input.toggleClass("input-error", false);
    return false;
  }


  $(document).ready(function() {
    $('.main-image')
    .wrap('<span style="display:inline-block"></span>')
    .css('display', 'block')
    .parent()
    .zoom({
      magnify: 2,
      touch: false,
    callback: function(){
      var mainImg = $('.main-image');
      var imgAlt = (mainImg).attr('alt');
      $(this).attr('alt', imgAlt);
      }
    });



    function toggleCoreRowClass(inputElement, className, isOn){
      const coreID =inputElement.attr('data-core-id');
      if(coreID > 0) {
        const $coreRow = $(`.product-table tbody tr[data-input-id='${coreID}']`);
        isOn ? $coreRow.addClass(className) : $coreRow.removeClass(className);
      }
    }

    $(".product-table tbody tr:not(.non-addable-product)").hover( function(){
        const $currentElement = $(this);
        const id = $currentElement.data("input-id");
        const $inputField = $(`input[data-id="${id}"]`);
        let value = $inputField.val();
        if(value == "0" || value == null || value == undefined || value == "") {
            $currentElement.toggleClass("bg-dark-grey", true);
        } else {
            $currentElement.toggleClass("bg-error-pink", true);
        }
    }, function(){
        const $currentElement = $(this);
        $currentElement.toggleClass("bg-dark-grey", false);
        $currentElement.toggleClass("bg-error-pink", false);
    });

    $("td input").click(function(event){
        event.stopPropagation();
    });

    $("input").change(function() {
        const inputElement = $(this);
        const id = inputElement.data("id");
        const tableRow = $(`tr[data-input-id="${id}"]`);
        const value = inputElement.val();
        if(value > 0) {
          !tableRow.hasClass("product-page-highlighted-row") ? toggleCoreRowClass(tableRow, "product-page-highlighted-row", true): "";
          !tableRow.hasClass("product-page-highlighted-row") ? tableRow.addClass("product-page-highlighted-row") : "";
        } else {
          tableRow.hasClass("product-page-highlighted-row") ? toggleCoreRowClass(tableRow, "product-page-highlighted-row", false): "";
           tableRow.hasClass("product-page-highlighted-row") ? tableRow.removeClass("product-page-highlighted-row") : "";
        }
    });
    $("tbody tr:not(.non-addable-product)").click(function() {
        const tableRow = $(this);
        const id = tableRow.data("input-id");
        const inputElement = $(`input[data-id="${id}"]`);
        let value = inputElement.val() || 0;
        value >= 1 ? value-- : value++;
        if(value >= 1) {
          !tableRow.hasClass("product-page-highlighted-row") ? toggleCoreRowClass(tableRow, "product-page-highlighted-row", true): "";
          !tableRow.hasClass("product-page-highlighted-row") ? tableRow.addClass("product-page-highlighted-row") : "";
        } else {
          tableRow.hasClass("product-page-highlighted-row") ? toggleCoreRowClass(tableRow, "product-page-highlighted-row", false):"";
          tableRow.hasClass("product-page-highlighted-row") ? tableRow.removeClass("product-page-highlighted-row") : "";
        }
        inputElement.val(value);
    });

  });

  function showCheckoutButton() {
    $atcButton = $('#product-buttons-atc');
    $checkoutButton = $('#product-buttons-checkout');

    if ($checkoutButton.hasClass('d-none')) {
      $checkoutButton.removeClass('d-none');
    }
  }

  async function addToCart() {
      let products = {};

      $('.product-quantity-input').each(
          function(i) {
              $inputQuantity = $(this);
          
              if ($inputQuantity.val() > 0) {
                  products[$inputQuantity.attr('data-id')] = parseInt($inputQuantity.val());
              }
          }
      );

      if (Object.keys(products).length == 0) return;

      let ajaxCall = await $.ajax({
          type: "POST",
          url: "ajax_cart.php",
          data: {
          "cart-action" : "add",
          "products" : products
          }
      });

      updateCartDisplay(true, products);

      showCheckoutButton();

  }

  async function addConfigurableToCart() {
    const attributeInputs = $('.attribute-input');
    let errors = false;
    let attributesData = {};
    attributeInputs.each(function(index) {
      const inputValue = this.value;
        const input = $(this);
        const id = input.data('id');
      if(inputValue !== '' && input.attr("type") != "checkbox") {
        attributesData[id] = inputValue;
      }
      else if (input.attr("type") == "checkbox") {
        if(input.is(":checked")) {
          if(Array.isArray(attributesData[id])) {
            attributesData[id] = [...attributesData[id], inputValue];
          } else {
            attributesData[id] = [inputValue];
          }
        }
      } else {
        attributesData[id] = null;
        errors = true;
      }
    });
    if (parseInt($('#product-quantity-input-field').val()) < 1 || $('#product-quantity-input-field').val() == "") {
      errors = true;
    }
    if (errors) return;
    if (Object.keys(attributesData).length == 0) return;
    let results = await $.ajax({
      type: 'POST',
      url: 'ajax_cart.php',
      data: {
        'cart-action': 'add-configurable',
        'post-data': {
          productId: $('#product-quantity-input-field').data('id'),
          attributes: attributesData,
          quantity: $('#product-quantity-input-field').val()
        }
      }
    });

    updateCartDisplay();

    showCheckoutButton();
  }
</script>