<?php
    $breadcrumb->add("Add Review", $link = '');

    $review_info_query = "
        SELECT 
            zp.products_id,
            zm.manufacturers_name,
            zp.products_model,
            zp.products_image,
            zpd.products_alt_name,
            zpd.products_name
        FROM zen_products zp
        JOIN zen_products_description zpd
            ON zpd.products_id = zp.products_id
        JOIN zen_manufacturers zm
            ON zm.manufacturers_id = zp.manufacturers_id
        WHERE
            zp.products_id = :productID:;
    ";

    $review_info_query = $db->bindVars($review_info_query, ':productID:', $_GET['products_id'], 'integer');
    $review_info = $db->Execute($review_info_query);

    $productName = $review_info->fields['products_name'];
    $productID = $review_info->fields['products_id'];
    $productModel = $review_info->fields['products_model'];
    $productImagePath = $review_info->fields['products_image'];
    $productAltName = $review_info->fields['products_alt_name'];
    $productManufacturesName = $review_info->fields['manufacturers_name'];

    $customerID = '';
    $customerFirstName = '';
    $customerLastName = '';
    $customerEmailAddress = '';
    
    if (isset($_SESSION['customer_id'])) {
        $customerQuery = "
            SELECT	
                zc.customers_id,
                zc.customers_firstname,
                zc.customers_lastname,
                zc.customers_email_address,
                zc.customers_nick
            FROM zen_customers zc
            WHERE
                zc.customers_id = :customerId:;
        ";
        $customerQuery = $db->bindVars($customerQuery, ':customerId:', $_SESSION['customer_id'], 'integer');
        $customerInfo = $db->Execute($customerQuery);

        $customerID = $customerInfo->fields['customers_id'];
        $customerFirstName = $customerInfo->fields['customers_firstname'];
        $customerLastName = $customerInfo->fields['customers_lastname'];
        $customerEmailAddress = $customerInfo->fields['customers_email_address'];
    }

    $defaultName = (!empty($customerFirstName) && !empty($customerLastName))? "$customerFirstName $customerLastName" : FALSE;
?>
<main class="container">
    <p class="small-text breadcrumb-container">
      <?php echo $breadcrumb->trail("/"); ?>
    </p>
    <div class="row pb-3">
        <div class="col-12 col-lg-4" id="review-image-section">
            <div class="product-image-container">
                <img src='images/<?php echo $productImagePath; ?>' alt='<?php echo $productAltName; ?>' class="img-fluid" />
            </div>
        </div>
        <div class="col-12 col-lg-8" id="review-product-info-section">
            <div class="review-information-container">
                <h5>
                    <span class="brand-text-color">
                        <?php echo $productManufacturesName; ?>
                    </span> 
                    <span class="model-text-color"><?php echo $productModel; ?></span> 
                    <?php echo $productName; ?>
                </h5>
                <p class="mb-lg-5"><?php echo $productAltName; ?></p>
                <h5 style="font-weight: bold;">Rate This Product</h5>
                
                <div class='rating-stars' style="font-size: 2rem;">
                    <span class='fa fa-star checked' data-rating-value="1"></span>
                    <span class='fa fa-star checked' data-rating-value="2"></span>
                    <span class='fa fa-star checked selected' data-rating-value="3"></span>
                    <span class='fa fa-star' data-rating-value="4"></span>
                    <span class='fa fa-star' data-rating-value="5"></span>
                </div>
            </div>
        </div>
    </div>
    <div class="" id="review-form-section">
        <form style="max-width: 800px">
            <input type="hidden" id="products-id" value="<?php echo $productID; ?>">
            <input type="hidden" id="customers-id" value="<?php echo $_SESSION['customers_id'] ?? 0; ?>">
            <div class="mb-3 form-floating-label-container">
                <input 
                    class="form-control" id="display-name" 
                    name="display-name" placeholder="Enter Display Name"
                    <?php echo ($defaultName !== FALSE)? "value='$defaultName'" : '';?>
                />
                <label for="display-name">Diplay Name (Optional)</label>
            </div>
            <div class="mb-3 form-floating-label-container">
                <input 
                    class="form-control" id="customers-email" 
                    name="review-email" placeholder="Enter Email"  
                    required <?php echo (!empty($customerEmailAddress))? "value='$customerEmailAddress'" : '';?>
                />
                <label for="review-email">Email</label>
            </div>
            <div class="mb-3 form-floating-label-container">
                <input 
                    class="form-control" id="review-title" 
                    name="review-title" placeholder="Enter Review Title"  
                    required
                />
                <label for="review-title">Review Title</label>
            </div>
            <div class="mb-3 form-floating-label-container">
                <textarea class="form-control" id="review-description" name="review-description" rows="3" placeholder="Enter Review Here"></textarea>
                <label for="review-description" class="form-label">Your Description</label>
            </div>
            <div class="row mb-3">
                <div class="col-12 col-md-3">
                    <button type="button" class="btn bg-westech-green text-white" id="review-submit-button">Submit Review</button>
                </div>
            </div>

        </form>
        <p><span style="font-weight: bold;">NOTE:</span> Reviews may require prior approval before they will be displayed. HTML tags are not allowed</p>
    </div>
</main>


<script>

    $(window).on("load", () => {

        $(".fa.fa-star").on( "mouseenter", function() {
            const stars = $(".fa.fa-star");
            const selectedStar = $(this);
            const rating = selectedStar.data("rating-value");

            for(let i = 0; i < rating; i++) {
                const star = $(stars[i]);
                star.addClass("isHovered");
            }

            for(let i = rating; i < 5; i++) {
                const star = $(stars[i]);
                star.addClass("isNotHoverd");
            }
        } ).on( "mouseleave", function() {
            const stars = $(".fa.fa-star");
            stars.removeClass("isHovered");
            stars.removeClass("isNotHoverd");
        } );


        $(".fa.fa-star").click(function(event) {
            const stars = $(".fa.fa-star");
            stars.removeClass("selected");
            stars.removeClass("checked");
            const selectedStar = $(this);
            selectedStar.addClass("selected");
            const rating = selectedStar.data("rating-value");

            for(let i = 0; i < rating; i++) {
                const star = $(stars[i]);
                star.addClass("checked");
            }
        })

        $("#review-submit-button").on('click', async function(e) {
            e.preventDefault();

            $(this).html('Submitting review...');
            $(this).attr('disabled', true);

            const productID = $("#products-id").val();
            const customerID = $("#customers-id").val();
            const customerName = $("#display-name").val();
            const customerEmail = $("#customers-email").val();
            const rating = $(".fa.fa-star.selected").data("rating-value");
            const reviewTitle = $("#review-title").val();
            const reviewText = $("#review-description").val();

            $review_submit_result = await $.ajax(
                {
                    url: 'ajax_reviews.php',
                    method: 'POST',
                    data: {
                        productID: productID,
                        customerID: customerID,
                        customerName: customerName,
                        customerEmail: customerEmail,
                        rating: rating,
                        reviewTitle: reviewTitle,
                        reviewText: reviewText
                    }
                }
            );

            try {
                if ($review_submit_result_j.code == 0) {
                    throw new Error($review_submit_result_j.message);
                }

                $(this).html('Review Submitted! Thank you.');
            } catch (error) {
                $(this).html('Submit Review');
                $(this).attr('disabled', false);

                console.log($review_submit_result);
                alert(error);
            }


        });
    });
</script>