<?php
/**
 * Page Template
 *
 * Loaded automatically by index.php?main_page=search.
 * Displays options fields upon which a product search will be run
 *
 * @copyright Copyright 2003-2022 Zen Cart Development Team
 * @copyright Portions Copyright 2003 osCommerce
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version $Id: DrByte 2020 Dec 25 New in v1.5.8-alpha $
 */

$cats = $db->Execute("SELECT c.categories_id, cd.categories_name, c.categories_status, c.sort_order
FROM zen_categories c LEFT JOIN zen_categories_description cd ON c.categories_id = cd.categories_id
WHERE parent_id = 2 AND c.categories_status = 1 ORDER BY c.sort_order, cd.categories_name");

$mans = $db->Execute("SELECT manufacturers_id, manufacturers_name
FROM zen_manufacturers
ORDER BY manufacturers_name");


$categoriesDropdownOptions = "";
while (!$cats->EOF) {
    $catId = $cats->fields['categories_id'];
    $catText = $cats->fields['categories_name'];
    $categoriesDropdownOptions .= "<option value='$catId'>$catText</option>";

    $cats->MoveNext();
}
$manufacturesDropdown = "";
while (!$mans->EOF) {
    $manId = $mans->fields['manufacturers_id'];
    $manText = $mans->fields['manufacturers_name'];
    $manufacturesDropdown .= "<option value='$manId'>$manText</option>";

    $mans->MoveNext();
}

?>
<main class="container-lg">
    <?php echo zen_draw_form('search', zen_href_link(FILENAME_SEARCH_RESULT, '', $request_type, false), 'get', 'onsubmit="return check_form(this);"') . zen_hide_session_id(); ?>
        <?php echo zen_draw_hidden_field('main_page', FILENAME_SEARCH_RESULT); ?>
        <?php if ($messageStack->size('search') > 0) echo $messageStack->output('search'); ?>
    
        <h1 id="searchDefaultHeading">Advanced Search</h1>
        <div class="row mb-3">
            <div class="col-12 col-md-4">
                <div class="mb-3 form-floating-label-container">
                    <input type="search" name="keyword" class="form-control" placeholder="Input Keywords" />
                    <label for="shipping-company-name">Keywords</label>
                </div>
            </div>
            <div class="col-12 col-md-4">
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" id="search_in_description" name="search-in-description" checked>
                    <label class="form-check-label" for="billing-same-as-shipping">
                        Search In Product Descriptions
                    </label>
                </div>
            </div>
        </div>
        <div class="form-floating-label-container">
            <select class="form-select" id="tax" name="categories_id" id="searchCategoryId">
                <option value="" selected="selected">All Categories</option>
                <?php 
                    echo $categoriesDropdownOptions;
                ?>
            </select>
            <label for="categories_id">Limit to Category</label>
        </div>
        <div class="mb-3 form-check">
            <input class="form-check-input" type="checkbox" value="1" id="inc-subcat" name="inc_subcat" checked>
            <label class="form-check-label" for="inc-subcat">
                Search In Product Descriptions
            </label>
        </div>
        <?php if (empty($skip_manufacturers)) { ?>
            <div class="form-floating-label-container">
                <select class="form-select" id="tax" name="manufacturers_id" id="searchMfgId">
                <option value="" selected="selected">All Manufacturers</option>
                    <?php 
                        echo $manufacturesDropdown;
                    ?>
                </select>
                <label for="categories_id">Limit to Manufacturer</label>
            </div>
        <?php } ?>

        <h2 class="mb-3 mt-3">Price Range</h3>
        <div class="row mb-3">
            <div class="col-sm-12 col-md-3">
                <div class="mb-3 form-floating-label-container">
                    <input type="text" name="pfrom" class="form-control" id="pfrom" placeholder="Input Price" inputmode="decimal" />
                    <label for="pfrom">Price From</label>
                </div>
            </div>
            <div class="col-sm-12 col-md-3">
                <div class="mb-3 form-floating-label-container">
                    <input type="text" name="pto" class="form-control" id="pto"  placeholder="Input Price" inputmode="decimal" />
                    <label for="pto">Price To</label>
                </div>
            </div>
        </div>
        <!-- <h3 class="mb-3">Search By Date Added</h3>
        <div class="row">
            <div class="col-sm-12 col-md-3">
                <div class="mb-3 form-floating-label-container">
                    <input type="text" name="dfrom" class="form-control" id="dfrom" placeholder="MM/DD/YYY" />
                    <label for="dfrom">Date From</label>
                </div>
            </div>
            <div class="col-sm-12 col-md-3">
                <div class="mb-3 form-floating-label-container">
                    <input type="text" name="dto" class="form-control" id="dto" placeholder="MM/DD/YYY"  />
                    <label for="dto">Date To</label>
                </div>
            </div>
        </div> -->
        <div class="row mb-3">
            <div class="col-12 col-md-6 offset-md-3">
                <button type="submit" class="btn bg-westech-green w-100 text-white submit_button button  button_search" value="Search">Search</button>
            </div>
        </div>
    </form>
</main>
