<?php

/**
 * @package     ceon_advanced_shipper
 * @author      Conor Kerr <zen-cart.advanced-shipper@dev.ceon.net>
 * @author      Waqas Hussain <waqas20@gmail.com>
 * @copyright   Copyright 2007-2018 Ceon
 * @copyright   Portions Copyright 2003-2006 Zen Cart Development Team
 * @copyright   Portions Copyright 2003 osCommerce
 * @link        http://dev.ceon.net/web/zen-cart/advanced-shipper
 * @license     http://www.gnu.org/copyleft/gpl.html   GNU Public License V2.0
 * @version     $Id: advshipper.php 981 2012-03-27 16:28:46Z conor $ Updated v6.0.4
 */

require('includes/application_top.php');

require(DIR_WS_CLASSES . 'currencies.php');
$currencies = new currencies();

$languages = zen_get_languages();

$current_time = time();

require_once(DIR_WS_FUNCTIONS . 'advshipper.php');

if (defined('ADVSHIPPER_ZONES_SUPPORT') && ADVSHIPPER_ZONES_SUPPORT == 'Yes') {
	require_once(DIR_WS_FUNCTIONS . 'advshipper_zones.php');
}

$advshipper_demo = isset($advshipper_demo) ? $advshipper_demo : false;

// Determine which configuration profile should be loaded
if (isset($_POST['advshipper_configuration_name'])) {
	// Use the selected configuration
} else {
	// Get the name of the configuration profile to use from the database
	$config_name = 'default';
}

// Output warning if database tables don't exist
$table_exists_query = 'SHOW TABLES LIKE "' . TABLE_ADVANCED_SHIPPER_CONFIGS . '";';

$table_exists_result = $db->Execute($table_exists_query);

if ($table_exists_result->EOF) {
	print '<div style="font-family: arial, helvetica, sans-serif;">';
	print '<p style="background: #f33; color: #fff; padding: 0.2em; border: 1px solid #f00;">' .
		'<strong>Error: The Advanced Shipper Database Tables Do Not Exist!</strong></p>';
	print '<p>Please create the database tables, according to the installation instructions!</p>';
	print '<p>For convenience, <a href="' . zen_href_link(FILENAME_SQLPATCH) .
		'">here\'s the link to the SQL Patch utility</a>.</p>';
	print '</div>';
	
	exit();
}

// Load the main configuration
$load_main_config_sql = "
	SELECT
		*		
	FROM
		" . TABLE_ADVANCED_SHIPPER_CONFIGS . "
	WHERE
		config_name = '" . $config_name . "';";

$load_main_config_result = $db->Execute($load_main_config_sql);

if ($load_main_config_result->EOF) {
	// Couldn't load selected config!
	if ($config_name == 'default') {
		// Create default config
		$create_first_config_sql = "
			INSERT INTO
				" . TABLE_ADVANCED_SHIPPER_CONFIGS . "
				(
				config_id,
				config_name
				)
			VALUES
				(
				'1',
				'default'
				);";
		
		$create_first_config_result = $db->Execute($create_first_config_sql);
	}
	
	$config_id = 1;
	
	$custom_product_field_name = null;
	
} else {
	$config_id = $load_main_config_result->fields['config_id'];
	
	if (isset($load_main_config_result->fields['custom_product_field_name']) &&
			strlen(trim($load_main_config_result->fields['custom_product_field_name'])) > 0) {
		$custom_product_field_name =
			trim($load_main_config_result->fields['custom_product_field_name']);
	} else {
		$custom_product_field_name = null;
	}
}


// Check if the database needs to be updated ///////////////////////////////////////////////////////

// Find out what the latest version number is
require_once(DIR_FS_CATALOG . DIR_WS_MODULES . 'shipping/advshipper.php');

if (!defined('MODULE_ADVANCED_SHIPPER_MADE_BY_CEON')) {
	print '<div style="font-family: arial, helvetica, sans-serif;">';
	print '<p style="background: #f33; color: #fff; padding: 0.2em; border: 1px solid #f00;">' .
		'<strong>The Ceon Advanced Shipper module has not been installed yet!</strong></p>';
	print '<p>Please  <a href="' . zen_href_link(FILENAME_MODULES,
		'set=shipping&module=advshipper') . '">click here' . '</a> to be redirected to' .
		' <em>Modules &gt; Shipping &gt; Ceon Advanced Shipper</em>, then click' .
		' &ldquo;Install&rdquo;.</p>';
	print '</div>';
	
	exit();
	
} else if (MODULE_ADVANCED_SHIPPER_MADE_BY_CEON != MODULE_ADVANCED_SHIPPER_VERSION_NO) {
	include_once('advshipper_auto_upgrade.php');
	
	if (!isset($advshipper_upgraded) || $advshipper_upgraded != true) {
		print '<strong><span style="color: red">Warning:</span><br />The Advanced Shipper ' .
			'Database is out of date - upgrade failed!</strong>';
		
		exit();
		
	} else {
		$messageStack->add(sprintf(SUCCESS_DATABASE_AND_CONFIG_UPDATED,
			MODULE_ADVANCED_SHIPPER_VERSION_NO), 'success');
	}
}


// Use custom product field functionality if available
$custom_product_field_functionality = false;

if (file_exists(DIR_WS_FUNCTIONS . 'advshipper_custom_product_field_functions.php')) {
	require_once(DIR_WS_FUNCTIONS . 'advshipper_custom_product_field_functions.php');
	
	// The language definitions file is loaded within the functions file and is required as it also
	// includes the list of values and their titles
	if (!defined('TEXT_ADVANCED_SHIPPER_CUSTOM_PRODUCT_FIELD_LABEL')) {
		// Can't/shouldn't use functionality without the language file!
		echo '<p>Unfortunately the language definitions file for the custom product field' .
			' functionality is missing, please upload it!' . "</p>\n";
		
		echo '<p>It should be uploaded to:</p>';
		
		echo '<p>' . DIR_WS_LANGUAGES . $_SESSION['language'] . '/' .
			'advshipper_custom_product_field_functionality.php' . "</p>\n";
		
		exit;
	}
	
	$custom_product_field_functionality = true;
}


$num_shipping_methods_query = "
	SELECT
		COUNT(*) AS num_shipping_methods
	FROM
		" . TABLE_ADVANCED_SHIPPER_METHOD_CONFIGS . "
	WHERE
		config_id = '" . $config_id . "';";

$num_shipping_methods_result = $db->Execute($num_shipping_methods_query);

$num_shipping_methods = $num_shipping_methods_result->fields['num_shipping_methods'];


// Have any buttons been pressed? //////////////////////////////////////////////////////////////////
$affected_method = null;

$action = 'display';

if (isset($_POST) && sizeof($_POST) != 0) {
	foreach ($_POST as $post_var => $post_var_value) {
		if (substr($post_var, 0, 7) == 'insert_' && is_numeric(substr($post_var, 7, 1))) {
			$action = 'insert';
			$affected_method = substr($post_var, 7, strlen($post_var) - 7);
			$affected_method = str_replace('_x', '', $affected_method);
			$affected_method = str_replace('_y', '', $affected_method);
			break;
		} else if (substr($post_var, 0, 5) == 'copy_' && is_numeric(substr($post_var, 5, 1))) {
			$action = 'copy';
			$affected_method = substr($post_var, 5, strlen($post_var) - 5);
			$affected_method = str_replace('_x', '', $affected_method);
			$affected_method = str_replace('_y', '', $affected_method);
			break;
		} else if (substr($post_var, 0, 7) == 'delete_' && is_numeric(substr($post_var, 7, 1))) {
			$action = 'delete';
			$affected_method = substr($post_var, 7, strlen($post_var) - 7);
			$affected_method = str_replace('_x', '', $affected_method);
			$affected_method = str_replace('_y', '', $affected_method);
			break;
		}
	}
	if (isset($_POST['page']) && ($_POST['page'] != $_GET['page'])) {
		$_GET['page'] = $_POST['page'];
	}
}

if (isset($_GET['toggle_method'])) {
	$action = 'toggle_method';
	
	$affected_method = (int) $_GET['toggle_method'];
	
	unset($_GET['toggle_method']);
}

if ($advshipper_demo) {
	switch ($action) {
		case 'insert':
			$num_shipping_methods_to_insert =
				$_POST['insert_num_shipping_methods_' . $affected_method];
				
			if ($num_shipping_methods_to_insert == 1) {
				$messageStack->add(sprintf(SUCCESS_METHOD_INSERTED_DEMO, $config_name), 'success');
			} else {
				$messageStack->add(sprintf(SUCCESS_METHODS_INSERTED_DEMO,
					$num_shipping_methods_to_insert, $config_name), 'success');
			}
			break;
		case 'copy':
			$num_shipping_methods_to_insert =
				$_POST['copy_num_shipping_methods_' . $affected_method];
			
			$insert_after = $_POST['copy_to_' . $affected_method];
			
			if ($insert_after == '-1') {
				$insert_after = $affected_method;
			}
			
			if ($num_shipping_methods_to_insert != '-1' &&
					is_numeric($num_shipping_methods_to_insert) && is_numeric($insert_after)) {
				if ($num_shipping_methods_to_insert == 1) {
					$messageStack->add(sprintf(SUCCESS_METHOD_COPIED_ONCE_DEMO,
						$affected_method, $insert_after), 'success');
				} else {
					$messageStack->add(sprintf(SUCCESS_METHOD_COPIED_MULTIPLE_TIMES_DEMO,
						$affected_method, $num_shipping_methods_to_insert, $insert_after),
						'success');
				}
			}
			break;
		case 'delete':
			$messageStack->add(sprintf(SUCCESS_METHOD_DELETED_DEMO, $affected_method), 'success');
			break;
		case 'toggle_method':
			$messageStack->add(sprintf(SUCCESS_METHOD_TOGGLED_DEMO, $affected_method), 'success');
			break;
	}
	
	$action = 'display';
}

if ($action == 'insert') {
	// How many methods should be inserted? ////////////////////////////////////////////////////////
	$num_shipping_methods_to_insert = $_POST['insert_num_shipping_methods_' . $affected_method];
	
	if ($num_shipping_methods_to_insert != '-1' && is_numeric($num_shipping_methods_to_insert)) {
		// Re-number all following methods to allow space to insert the new method(s)
		for ($method_i = $num_shipping_methods; $method_i >= $affected_method; $method_i--) {
			$update_method_sql = "
				UPDATE
					" . TABLE_ADVANCED_SHIPPER_METHOD_CONFIGS . "
				SET
					method = '" . ($method_i + $num_shipping_methods_to_insert) . "'
				WHERE
					config_id = '" . $config_id . "'
				AND
					method = '" . $method_i . "';";
			
			$update_method_result = $db->Execute($update_method_sql);
			
			$update_method_sql = "
				UPDATE
					" . TABLE_ADVANCED_SHIPPER_METHOD_TITLES . "
				SET
					method = '" . ($method_i + $num_shipping_methods_to_insert) . "'
				WHERE
					config_id = '" . $config_id . "'
				AND
					method = '" . $method_i . "';";
			
			$update_method_result = $db->Execute($update_method_sql);
			
			$update_method_sql = "
				UPDATE
					" . TABLE_ADVANCED_SHIPPER_METHOD_ADMIN_TITLES . "
				SET
					method = '" . ($method_i + $num_shipping_methods_to_insert) . "'
				WHERE
					config_id = '" . $config_id . "'
				AND
					method = '" . $method_i . "';";
			
			$update_method_result = $db->Execute($update_method_sql);
			
			$update_method_sql = "
				UPDATE
					" . TABLE_ADVANCED_SHIPPER_METHOD_CATEGORIES . "
				SET
					method = '" . ($method_i + $num_shipping_methods_to_insert) . "'
				WHERE
					config_id = '" . $config_id . "'
				AND
					method = '" . $method_i . "';";
			
			$update_method_result = $db->Execute($update_method_sql);
			
			$update_method_sql = "
				UPDATE
					" . TABLE_ADVANCED_SHIPPER_METHOD_CUSTOM_PRODUCT_FIELD_VALUES . "
				SET
					method = '" . ($method_i + $num_shipping_methods_to_insert) . "'
				WHERE
					config_id = '" . $config_id . "'
				AND
					method = '" . $method_i . "';";
			
			$update_method_result = $db->Execute($update_method_sql);
			
			$update_method_sql = "
				UPDATE
					" . TABLE_ADVANCED_SHIPPER_METHOD_MANUFACTURERS . "
				SET
					method = '" . ($method_i + $num_shipping_methods_to_insert) . "'
				WHERE
					config_id = '" . $config_id . "'
				AND
					method = '" . $method_i . "';";
			
			$update_method_result = $db->Execute($update_method_sql);
			
			$update_method_sql = "
				UPDATE
					" . TABLE_ADVANCED_SHIPPER_METHOD_PRODUCTS . "
				SET
					method = '" . ($method_i + $num_shipping_methods_to_insert) . "'
				WHERE
					config_id = '" . $config_id . "'
				AND
					method = '" . $method_i . "';";
			
			$update_method_result = $db->Execute($update_method_sql);
			
			$update_method_sql = "
				UPDATE
					" . TABLE_ADVANCED_SHIPPER_REGION_CONFIGS . "
				SET
					method = '" . ($method_i + $num_shipping_methods_to_insert) . "'
				WHERE
					config_id = '" . $config_id . "'
				AND
					method = '" . $method_i . "';";
			
			$update_method_result = $db->Execute($update_method_sql);
			
			$update_method_sql = "
				UPDATE
					" . TABLE_ADVANCED_SHIPPER_REGION_ADMIN_TITLES . "
				SET
					method = '" . ($method_i + $num_shipping_methods_to_insert) . "'
				WHERE
					config_id = '" . $config_id . "'
				AND
					method = '" . $method_i . "';";
			
			$update_method_result = $db->Execute($update_method_sql);
			
			$update_method_sql = "
				UPDATE
					" . TABLE_ADVANCED_SHIPPER_REGION_TITLES . "
				SET
					method = '" . ($method_i + $num_shipping_methods_to_insert) . "'
				WHERE
					config_id = '" . $config_id . "'
				AND
					method = '" . $method_i . "';";
			
			$update_method_result = $db->Execute($update_method_sql);
			
			$update_method_sql = "
				UPDATE
					" . TABLE_ADVANCED_SHIPPER_REGION_SURCHARGE_TITLES . "
				SET
					method = '" . ($method_i + $num_shipping_methods_to_insert) . "'
				WHERE
					config_id = '" . $config_id . "'
				AND
					method = '" . $method_i . "';";
			
			$update_method_result = $db->Execute($update_method_sql);
			
			$update_method_sql = "
				UPDATE
					" . TABLE_ADVANCED_SHIPPER_REGION_UPS_CONFIGS . "
				SET
					method = '" . ($method_i + $num_shipping_methods_to_insert) . "'
				WHERE
					config_id = '" . $config_id . "'
				AND
					method = '" . $method_i . "';";
			
			$update_method_result = $db->Execute($update_method_sql);
			
			$update_method_sql = "
				UPDATE
					" . TABLE_ADVANCED_SHIPPER_REGION_USPS_CONFIGS . "
				SET
					method = '" . ($method_i + $num_shipping_methods_to_insert) . "'
				WHERE
					config_id = '" . $config_id . "'
				AND
					method = '" . $method_i . "';";
			
			$update_method_result = $db->Execute($update_method_sql);
			
			$update_method_sql = "
				UPDATE
					" . TABLE_ADVANCED_SHIPPER_REGION_FEDEX_CONFIGS . "
				SET
					method = '" . ($method_i + $num_shipping_methods_to_insert) . "'
				WHERE
					config_id = '" . $config_id . "'
				AND
					method = '" . $method_i . "';";
			
			$update_method_result = $db->Execute($update_method_sql);
		}
		
		// Now add the new methods
		for ($method_i = $affected_method; $method_i <
				($affected_method + $num_shipping_methods_to_insert); $method_i++) {
			
			$insert_method_sql = "
				INSERT INTO
					" . TABLE_ADVANCED_SHIPPER_METHOD_CONFIGS . "
					(
					config_id,
					method
					)
				VALUES
					(
					'" . $config_id . "',
					'" . $method_i . "'
					);";
			
			$insert_method_result = $db->Execute($insert_method_sql);
			
			for ($language_i = 0, $n = sizeof($languages); $language_i < $n; $language_i++) {
				
				$insert_method_title_sql = "
					INSERT INTO
						" . TABLE_ADVANCED_SHIPPER_METHOD_TITLES . "
						(
						config_id,
						method,
						language_id
						)
					VALUES
						(
						'" . $config_id . "',
						'" . $method_i . "',
						'" . $languages[$language_i]['id'] . "'
						);";
				
				$insert_method_title_result = $db->Execute($insert_method_title_sql);
			}
			
			for ($language_i = 0, $n = sizeof($languages); $language_i < $n; $language_i++) {
				
				$insert_method_admin_title_sql = "
					INSERT INTO
						" . TABLE_ADVANCED_SHIPPER_METHOD_ADMIN_TITLES . "
						(
						config_id,
						method,
						language_id
						)
					VALUES
						(
						'" . $config_id . "',
						'" . $method_i . "',
						'" . $languages[$language_i]['id'] . "'
						);";
				
				$insert_method_admin_title_result = $db->Execute($insert_method_admin_title_sql);
			}
		}
		
		$num_shipping_methods += $num_shipping_methods_to_insert;
		
		if ($num_shipping_methods_to_insert == 1) {
			$messageStack->add(sprintf(SUCCESS_METHOD_INSERTED, $config_name), 'success');
		} else {
			$messageStack->add(sprintf(SUCCESS_METHODS_INSERTED, $num_shipping_methods_to_insert,
				$config_name), 'success');
		}
	}
} else if ($action == 'copy') {
	// How many copies of the region should be inserted? ///////////////////////////////////////////
	$num_shipping_methods_to_insert = $_POST['copy_num_shipping_methods_' . $affected_method];
	
	$insert_after = $_POST['copy_to_' . $affected_method];
	
	if ($insert_after == '-1') {
		$insert_after = $affected_method;
	}
	
	if ($num_shipping_methods_to_insert != '-1' && is_numeric($num_shipping_methods_to_insert) &&
			is_numeric($insert_after)) {
		// Load the data for the selected method first so it can be copied
		$load_method_config_sql = "
			SELECT
				asmc.method,
				asmc.enabled,
				asmc.select_products,
				asmc.availability_scheduling,
				asmc.once_only_start_datetime,
				asmc.once_only_end_datetime,
				asmc.availability_recurring_mode,
				asmc.availability_weekly_start_day,
				asmc.availability_weekly_start_time,
				asmc.availability_weekly_cutoff_day,
				asmc.availability_weekly_cutoff_time,
				asmc.usage_limit,
				asmc.once_only_shipping_datetime,
				asmc.availability_weekly_shipping_scheduling,
				asmc.availability_weekly_shipping_show_num_weeks,
				asmc.availability_weekly_shipping_regular_weekday_day,
				asmc.availability_weekly_shipping_regular_weekday_time
			FROM
				" . TABLE_ADVANCED_SHIPPER_METHOD_CONFIGS . " asmc
			WHERE
				asmc.config_id = '" . $config_id . "'
			AND
				asmc.method = '" . $affected_method . "';";
		
		$load_method_config_result = $db->Execute($load_method_config_sql);
		
		$method_titles = array();
		
		$load_method_titles_sql = "
			SELECT
				asmt.title,
				asmt.language_id
			FROM
				" . TABLE_ADVANCED_SHIPPER_METHOD_TITLES . " asmt
			WHERE
				asmt.config_id = '" . $config_id . "'
			AND
				asmt.method = '" . $affected_method . "';";
		
		$load_method_titles_result = $db->Execute($load_method_titles_sql);
		
		if ($load_method_titles_result->EOF) {
			
		} else {
			while (!$load_method_titles_result->EOF) {
				$method_titles[$load_method_titles_result->fields['language_id']] =
					$load_method_titles_result->fields['title'];
				
				$load_method_titles_result->MoveNext();
			}
		}
		
		$method_admin_titles = array();
		
		$load_method_admin_titles_sql = "
			SELECT
				asmat.title,
				asmat.language_id
			FROM
				" . TABLE_ADVANCED_SHIPPER_METHOD_ADMIN_TITLES . " asmat
			WHERE
				asmat.config_id = '" . $config_id . "'
			AND
				asmat.method = '" . $affected_method . "';";
		
		$load_method_admin_titles_result = $db->Execute($load_method_admin_titles_sql);
		
		if ($load_method_admin_titles_result->EOF) {
			
		} else {
			while (!$load_method_admin_titles_result->EOF) {
				$method_admin_titles[$load_method_admin_titles_result->fields['language_id']] =
					$load_method_admin_titles_result->fields['title'];
				
				$load_method_admin_titles_result->MoveNext();
			}
		}
		
		// Load any category selections for this method
		$categories = array();
		
		$load_categories_config_sql = "
			SELECT
				asmc.category_order,
				asmc.category_id
			FROM
				" . TABLE_ADVANCED_SHIPPER_METHOD_CATEGORIES . " asmc
			WHERE
				asmc.config_id = '" . $config_id . "'
			AND
				asmc.method = '" . $affected_method . "'
			ORDER BY
				asmc.category_order;";
		
		$load_categories_config_result = $db->Execute($load_categories_config_sql);
		
		if ($load_categories_config_result->EOF) {
			
		} else {
			while (!$load_categories_config_result->EOF) {
				$num_categories = sizeof($categories);
				
				foreach ($load_categories_config_result->fields as $key => $value) {
					$categories[$num_categories][$key] = $value;
				}
				
				$load_categories_config_result->MoveNext();
			}
		}
		
		// Load any custom product field value selections for this method
		$custom_product_field_values = array();
		
		$load_custom_product_field_values_config_sql = "
			SELECT
				asmcpfv.field_value_order,
				asmcpfv.field_value
			FROM
				" . TABLE_ADVANCED_SHIPPER_METHOD_CUSTOM_PRODUCT_FIELD_VALUES . " asmcpfv
			WHERE
				asmcpfv.config_id = '" . $config_id . "'
			AND
				asmcpfv.method = '" . $affected_method . "'
			ORDER BY
				asmcpfv.field_value_order;";
		
		$load_custom_product_field_values_config_result =
			$db->Execute($load_custom_product_field_values_config_sql);
		
		if ($load_custom_product_field_values_config_result->EOF) {
			
		} else {
			while (!$load_custom_product_field_values_config_result->EOF) {
				$num_custom_product_field_values = sizeof($custom_product_field_values);
				
				foreach ($load_custom_product_field_values_config_result->fields as
						$key => $value) {
					$custom_product_field_values[$num_custom_product_field_values][$key] = $value;
				}
				
				$load_custom_product_field_values_config_result->MoveNext();
			}
		}
		
		// Load any manufacturer selections for this method
		$manufacturers = array();
		
		$load_manufacturers_config_sql = "
			SELECT
				asmm.manufacturer_order,
				asmm.manufacturer_id
			FROM
				" . TABLE_ADVANCED_SHIPPER_METHOD_MANUFACTURERS . " asmm
			WHERE
				asmm.config_id = '" . $config_id . "'
			AND
				asmm.method = '" . $affected_method . "'
			ORDER BY
				asmm.manufacturer_order;";
		
		$load_manufacturers_config_result = $db->Execute($load_manufacturers_config_sql);
		
		if ($load_manufacturers_config_result->EOF) {
			
		} else {
			while (!$load_manufacturers_config_result->EOF) {
				$num_manufacturers = sizeof($manufacturers);
				
				foreach ($load_manufacturers_config_result->fields as $key => $value) {
					$manufacturers[$num_manufacturers][$key] = $value;
				}
				
				$load_manufacturers_config_result->MoveNext();
			}
		}
		
		// Load any product selections for this method
		$products = array();
		
		$load_products_config_sql = "
			SELECT
				asmp.product_order,
				asmp.product_id,
				asmp.product_attributes_id
			FROM
				" . TABLE_ADVANCED_SHIPPER_METHOD_PRODUCTS . " asmp
			WHERE
				asmp.config_id = '" . $config_id . "'
			AND
				asmp.method = '" . $affected_method . "'
			ORDER BY
				asmp.product_order;";
		
		$load_products_config_result = $db->Execute($load_products_config_sql);
		
		if ($load_products_config_result->EOF) {
			
		} else {
			while (!$load_products_config_result->EOF) {
				$num_products = sizeof($products);
				
				foreach ($load_products_config_result->fields as $key => $value) {
					$products[$num_products][$key] = $value;
				}
				
				$load_products_config_result->MoveNext();
			}
		}
		
		// Load the regions configurations for this method
		$regions = array();
		
		$load_regions_config_sql = "
			SELECT
				asrc.region,
				asrc.definition_method,
				asrc.countries_postcodes,
				asrc.countries_zones,
				asrc.countries_cities,
				asrc.countries_states,
				asrc.distance,
				asrc.tax_class,
				asrc.rates_include_tax,
				asrc.rate_limits_inc,
				asrc.total_up_price_inc_tax,
				asrc.table_of_rates,
				asrc.max_weight_per_package,
				asrc.packaging_weights,
				asrc.surcharge
			FROM
				" . TABLE_ADVANCED_SHIPPER_REGION_CONFIGS . " asrc
			WHERE
				asrc.config_id = '" . $config_id . "'
			AND
				asrc.method = '" . $affected_method . "'
			ORDER BY
				asrc.region;";
		
		$load_regions_config_result = $db->Execute($load_regions_config_sql);
		
		if ($load_regions_config_result->EOF) {
			
		} else {
			while (!$load_regions_config_result->EOF) {
				foreach ($load_regions_config_result->fields as $key => $value) {
					$regions[$load_regions_config_result->fields['region']][$key] = $value;
				}
				
				$load_regions_config_result->MoveNext();
			}
		}
		
		$region_admin_titles = array();
		
		$load_region_admin_titles_sql = "
			SELECT
				asrat.region,
				asrat.language_id,
				asrat.title
			FROM
				" . TABLE_ADVANCED_SHIPPER_REGION_ADMIN_TITLES . " asrat
			WHERE
				asrat.config_id = '" . $config_id . "'
			AND
				asrat.method = '" . $affected_method . "';";
		
		$load_region_admin_titles_result = $db->Execute($load_region_admin_titles_sql);
		
		if ($load_region_admin_titles_result->EOF) {
			
		} else {
			while (!$load_region_admin_titles_result->EOF) {
				$region_admin_titles[$load_region_admin_titles_result->fields['region']][$load_region_admin_titles_result->fields['language_id']] =
					$load_region_admin_titles_result->fields['title'];
				
				$load_region_admin_titles_result->MoveNext();
			}
		}
		
		$region_titles = array();
		
		$load_region_titles_sql = "
			SELECT
				asrt.region,
				asrt.language_id,
				asrt.title
			FROM
				" . TABLE_ADVANCED_SHIPPER_REGION_TITLES . " asrt
			WHERE
				asrt.config_id = '" . $config_id . "'
			AND
				asrt.method = '" . $affected_method . "';";
		
		$load_region_titles_result = $db->Execute($load_region_titles_sql);
		
		if ($load_region_titles_result->EOF) {
			
		} else {
			while (!$load_region_titles_result->EOF) {
				$region_titles[$load_region_titles_result->fields['region']][$load_region_titles_result->fields['language_id']] =
					$load_region_titles_result->fields['title'];
				
				$load_region_titles_result->MoveNext();
			}
		}
		
		$region_surcharge_titles = array();
		
		$load_region_surcharge_titles_sql = "
			SELECT
				asrst.region,
				asrst.language_id,
				asrst.title
			FROM
				" . TABLE_ADVANCED_SHIPPER_REGION_SURCHARGE_TITLES . " asrst
			WHERE
				asrst.config_id = '" . $config_id . "'
			AND
				asrst.method = '" . $affected_method . "';";
		
		$load_region_surcharge_titles_result = $db->Execute($load_region_surcharge_titles_sql);
		
		if ($load_region_surcharge_titles_result->EOF) {
			
		} else {
			while (!$load_region_surcharge_titles_result->EOF) {
				$region_surcharge_titles[$load_region_surcharge_titles_result->fields['region']][$load_region_surcharge_titles_result->fields['language_id']] =
					$load_region_surcharge_titles_result->fields['title'];
				
				$load_region_surcharge_titles_result->MoveNext();
			}
		}
		
		$region_ups_configs = array();
		
		$load_region_ups_configs_sql = "
			SELECT
				asruc.*
			FROM
				" . TABLE_ADVANCED_SHIPPER_REGION_UPS_CONFIGS . " asruc
			WHERE
				asruc.config_id = '" . $config_id . "'
			AND
				asruc.method = '" . $affected_method . "'
			ORDER BY
				asruc.region;";
		
		$load_region_ups_configs_result = $db->Execute($load_region_ups_configs_sql);
		
		if ($load_region_ups_configs_result->EOF) {
			
		} else {
			while (!$load_region_ups_configs_result->EOF) {
				foreach ($load_region_ups_configs_result->fields as $key => $value) {
					$region_ups_configs[$load_region_ups_configs_result->fields['region']][$key] =
						$value;
				}
				
				$load_region_ups_configs_result->MoveNext();
			}
		}
		
		$region_usps_configs = array();
		
		$load_region_usps_configs_sql = "
			SELECT
				asruc.*
			FROM
				" . TABLE_ADVANCED_SHIPPER_REGION_USPS_CONFIGS . " asruc
			WHERE
				asruc.config_id = '" . $config_id . "'
			AND
				asruc.method = '" . $affected_method . "'
			ORDER BY
				asruc.region;";
		
		$load_region_usps_configs_result = $db->Execute($load_region_usps_configs_sql);
		
		if ($load_region_usps_configs_result->EOF) {
			
		} else {
			while (!$load_region_usps_configs_result->EOF) {
				foreach ($load_region_usps_configs_result->fields as $key => $value) {
					$region_usps_configs[$load_region_usps_configs_result->fields['region']][$key] =
						$value;
				}
				
				$load_region_usps_configs_result->MoveNext();
			}
		}
		
		$region_fedex_configs = array();
		
		$load_region_fedex_configs_sql = "
			SELECT
				asrfc.*
			FROM
				" . TABLE_ADVANCED_SHIPPER_REGION_FEDEX_CONFIGS . " asrfc
			WHERE
				asrfc.config_id = '" . $config_id . "'
			AND
				asrfc.method = '" . $affected_method . "'
			ORDER BY
				asrfc.region;";
		
		$load_region_fedex_configs_result = $db->Execute($load_region_fedex_configs_sql);
		
		if ($load_region_fedex_configs_result->EOF) {
			
		} else {
			while (!$load_region_fedex_configs_result->EOF) {
				foreach ($load_region_fedex_configs_result->fields as $key => $value) {
					$region_fedex_configs[$load_region_fedex_configs_result->fields['region']][$key] =
						$value;
				}
				
				$load_region_fedex_configs_result->MoveNext();
			}
		}
		
		// Re-number all methods after the insertion method to allow space to insert the new
		// method(s)
		for ($method_i = $num_shipping_methods; $method_i > $insert_after; $method_i--) {
			$update_method_sql = "
				UPDATE
					" . TABLE_ADVANCED_SHIPPER_METHOD_CONFIGS . "
				SET
					method = '" . ($method_i + $num_shipping_methods_to_insert) . "'
				WHERE
					config_id = '" . $config_id . "'
				AND
					method = '" . $method_i . "';";
			
			$update_method_result = $db->Execute($update_method_sql);
			
			$update_method_sql = "
				UPDATE
					" . TABLE_ADVANCED_SHIPPER_METHOD_TITLES . "
				SET
					method = '" . ($method_i + $num_shipping_methods_to_insert) . "'
				WHERE
					config_id = '" . $config_id . "'
				AND
					method = '" . $method_i . "';";
			
			$update_method_result = $db->Execute($update_method_sql);
			
			$update_method_sql = "
				UPDATE
					" . TABLE_ADVANCED_SHIPPER_METHOD_ADMIN_TITLES . "
				SET
					method = '" . ($method_i + $num_shipping_methods_to_insert) . "'
				WHERE
					config_id = '" . $config_id . "'
				AND
					method = '" . $method_i . "';";
			
			$update_method_result = $db->Execute($update_method_sql);
			
			$update_method_sql = "
				UPDATE
					" . TABLE_ADVANCED_SHIPPER_METHOD_CATEGORIES . "
				SET
					method = '" . ($method_i + $num_shipping_methods_to_insert) . "'
				WHERE
					config_id = '" . $config_id . "'
				AND
					method = '" . $method_i . "';";
			
			$update_method_result = $db->Execute($update_method_sql);
			
			$update_method_sql = "
				UPDATE
					" . TABLE_ADVANCED_SHIPPER_METHOD_CUSTOM_PRODUCT_FIELD_VALUES . "
				SET
					method = '" . ($method_i + $num_shipping_methods_to_insert) . "'
				WHERE
					config_id = '" . $config_id . "'
				AND
					method = '" . $method_i . "';";
			
			$update_method_result = $db->Execute($update_method_sql);
			
			$update_method_sql = "
				UPDATE
					" . TABLE_ADVANCED_SHIPPER_METHOD_MANUFACTURERS . "
				SET
					method = '" . ($method_i + $num_shipping_methods_to_insert) . "'
				WHERE
					config_id = '" . $config_id . "'
				AND
					method = '" . $method_i . "';";
			
			$update_method_result = $db->Execute($update_method_sql);
			
			$update_method_sql = "
				UPDATE
					" . TABLE_ADVANCED_SHIPPER_METHOD_PRODUCTS . "
				SET
					method = '" . ($method_i + $num_shipping_methods_to_insert) . "'
				WHERE
					config_id = '" . $config_id . "'
				AND
					method = '" . $method_i . "';";
			
			$update_method_result = $db->Execute($update_method_sql);
			
			$update_method_sql = "
				UPDATE
					" . TABLE_ADVANCED_SHIPPER_REGION_CONFIGS . "
				SET
					method = '" . ($method_i + $num_shipping_methods_to_insert) . "'
				WHERE
					config_id = '" . $config_id . "'
				AND
					method = '" . $method_i . "';";
			
			$update_method_result = $db->Execute($update_method_sql);
			
			$update_method_sql = "
				UPDATE
					" . TABLE_ADVANCED_SHIPPER_REGION_ADMIN_TITLES . "
				SET
					method = '" . ($method_i + $num_shipping_methods_to_insert) . "'
				WHERE
					config_id = '" . $config_id . "'
				AND
					method = '" . $method_i . "';";
			
			$update_method_result = $db->Execute($update_method_sql);
			
			$update_method_sql = "
				UPDATE
					" . TABLE_ADVANCED_SHIPPER_REGION_TITLES . "
				SET
					method = '" . ($method_i + $num_shipping_methods_to_insert) . "'
				WHERE
					config_id = '" . $config_id . "'
				AND
					method = '" . $method_i . "';";
			
			$update_method_result = $db->Execute($update_method_sql);
			
			$update_method_sql = "
				UPDATE
					" . TABLE_ADVANCED_SHIPPER_REGION_SURCHARGE_TITLES . "
				SET
					method = '" . ($method_i + $num_shipping_methods_to_insert) . "'
				WHERE
					config_id = '" . $config_id . "'
				AND
					method = '" . $method_i . "';";
			
			$update_method_result = $db->Execute($update_method_sql);
			
			$update_method_sql = "
				UPDATE
					" . TABLE_ADVANCED_SHIPPER_REGION_UPS_CONFIGS . "
				SET
					method = '" . ($method_i + $num_shipping_methods_to_insert) . "'
				WHERE
					config_id = '" . $config_id . "'
				AND
					method = '" . $method_i . "';";
			
			$update_method_result = $db->Execute($update_method_sql);
			
			$update_method_sql = "
				UPDATE
					" . TABLE_ADVANCED_SHIPPER_REGION_USPS_CONFIGS . "
				SET
					method = '" . ($method_i + $num_shipping_methods_to_insert) . "'
				WHERE
					config_id = '" . $config_id . "'
				AND
					method = '" . $method_i . "';";
			
			$update_method_result = $db->Execute($update_method_sql);
			
			$update_method_sql = "
				UPDATE
					" . TABLE_ADVANCED_SHIPPER_REGION_FEDEX_CONFIGS . "
				SET
					method = '" . ($method_i + $num_shipping_methods_to_insert) . "'
				WHERE
					config_id = '" . $config_id . "'
				AND
					method = '" . $method_i . "';";
			
			$update_method_result = $db->Execute($update_method_sql);
		}
		
		// Now add the new method, copying the data loaded from the selected method ////////////////
		for ($method_i = $insert_after + 1; $method_i <
				($insert_after + 1 + $num_shipping_methods_to_insert); $method_i++) {
			
			$insert_method_sql = "
				INSERT INTO
					" . TABLE_ADVANCED_SHIPPER_METHOD_CONFIGS . "
					(
					config_id,
					method,
					enabled,
					select_products,
					availability_scheduling,
					once_only_start_datetime,
					once_only_end_datetime,
					availability_recurring_mode,
					availability_weekly_start_day,
					availability_weekly_start_time,
					availability_weekly_cutoff_day,
					availability_weekly_cutoff_time,
					usage_limit,
					once_only_shipping_datetime,
					availability_weekly_shipping_scheduling,
					availability_weekly_shipping_show_num_weeks,
					availability_weekly_shipping_regular_weekday_day,
					availability_weekly_shipping_regular_weekday_time
					)
				VALUES
					(
					'" . $config_id . "',
					'" . $method_i . "',
					'" . $db->prepare_input($load_method_config_result->fields['enabled']) . "',
					'" . $db->prepare_input($load_method_config_result->fields['select_products']) . "',
					'" . $db->prepare_input($load_method_config_result->fields['availability_scheduling']) . "',
					" . (is_null($load_method_config_result->fields['once_only_start_datetime']) ? 'null' : "'" . $db->prepare_input($load_method_config_result->fields['once_only_start_datetime']) . "'") . ",
					" . (is_null($load_method_config_result->fields['once_only_end_datetime']) ? 'null' : "'" . $db->prepare_input($load_method_config_result->fields['once_only_end_datetime']) . "'") . ",
					'" . $db->prepare_input($load_method_config_result->fields['availability_recurring_mode']) . "',
					" . (is_null($load_method_config_result->fields['availability_weekly_start_day']) ? 'null' : "'" . $db->prepare_input($load_method_config_result->fields['availability_weekly_start_day']) . "'") . ",
					" . (is_null($load_method_config_result->fields['availability_weekly_start_time']) ? 'null' : "'" . $db->prepare_input($load_method_config_result->fields['availability_weekly_start_time']) . "'") . ",
					" . (is_null($load_method_config_result->fields['availability_weekly_cutoff_day']) ? 'null' : "'" . $db->prepare_input($load_method_config_result->fields['availability_weekly_cutoff_day']) . "'") . ",
					" . (is_null($load_method_config_result->fields['availability_weekly_cutoff_time']) ? 'null' : "'" . $db->prepare_input($load_method_config_result->fields['availability_weekly_cutoff_time']) . "'") . ",
					" . (is_null($load_method_config_result->fields['usage_limit']) ? 'null' :  "'" . $db->prepare_input($load_method_config_result->fields['availability_weekly_start_day']) . "'") . ",
					" . (is_null($load_method_config_result->fields['once_only_shipping_datetime']) ? 'null' : "'" . $db->prepare_input($load_method_config_result->fields['once_only_shipping_datetime']) . "'") . ",
					'" . $db->prepare_input($load_method_config_result->fields['availability_weekly_shipping_scheduling']) . "',
					" . (is_null($load_method_config_result->fields['availability_weekly_shipping_show_num_weeks']) ? 'null' : "'" . $db->prepare_input($load_method_config_result->fields['availability_weekly_shipping_show_num_weeks']) . "'") . ",
					" . (is_null($load_method_config_result->fields['availability_weekly_shipping_regular_weekday_day']) ? 'null' : "'" . $db->prepare_input($load_method_config_result->fields['availability_weekly_shipping_regular_weekday_day']) . "'") . ",
					" . (is_null($load_method_config_result->fields['availability_weekly_shipping_regular_weekday_time']) ? 'null' : "'" . $db->prepare_input($load_method_config_result->fields['availability_weekly_shipping_regular_weekday_time']) . "'") . "
					);";
			
			$insert_method_result = $db->Execute($insert_method_sql);
			
			for ($language_i = 0, $n = sizeof($languages); $language_i < $n; $language_i++) {
				
				$insert_method_title_sql = "
					INSERT INTO
						" . TABLE_ADVANCED_SHIPPER_METHOD_TITLES . "
						(
						config_id,
						method,
						language_id,
						title
						)
					VALUES
						(
						'" . $config_id . "',
						'" . $method_i . "',
						'" . $languages[$language_i]['id'] . "',
						'" . $db->prepare_input($method_titles[$languages[$language_i]['id']]) . "'
						);";
				
				$insert_method_title_result = $db->Execute($insert_method_title_sql);
			}
			
			for ($language_i = 0, $n = sizeof($languages); $language_i < $n; $language_i++) {
				
				$insert_method_admin_title_sql = "
					INSERT INTO
						" . TABLE_ADVANCED_SHIPPER_METHOD_ADMIN_TITLES . "
						(
						config_id,
						method,
						language_id,
						title
						)
					VALUES
						(
						'" . $config_id . "',
						'" . $method_i . "',
						'" . $languages[$language_i]['id'] . "',
						'" . $db->prepare_input($method_admin_titles[$languages[$language_i]['id']]) . "'
						);";
				
				$insert_method_admin_title_result = $db->Execute($insert_method_admin_title_sql);
			}
			
			// Copy any category selections for this method
			$num_categories = sizeof($categories);
			
			for ($category_i = 0; $category_i < $num_categories; $category_i++) {
				
				$insert_category_sql = "
					INSERT INTO
						" . TABLE_ADVANCED_SHIPPER_METHOD_CATEGORIES . "
						(
						config_id,
						method,
						category_order,
						category_id
						)
					VALUES
						(
						'" . $config_id . "',
						'" . $method_i . "',
						'" . $db->prepare_input($categories[$category_i]['category_order']) . "',
						'" . $db->prepare_input($categories[$category_i]['category_id']) . "'
						);";
				
				$insert_category_result = $db->Execute($insert_category_sql);
			}
			
			// Copy any custom product field value selections for this method
			$num_custom_product_field_values = sizeof($custom_product_field_values);
			
			for ($custom_product_field_value_i = 0;
					$custom_product_field_value_i < $num_custom_product_field_values;
					$custom_product_field_value_i++) {
				
				$insert_custom_product_field_value_sql = "
					INSERT INTO
						" . TABLE_ADVANCED_SHIPPER_METHOD_CUSTOM_PRODUCT_FIELD_VALUES . "
						(
						config_id,
						method,
						field_value_order,
						field_value
						)
					VALUES
						(
						'" . $config_id . "',
						'" . $method_i . "',
						'" . $db->prepare_input($custom_product_field_values[
							$custom_product_field_value_i]['field_value_order']) . "',
						'" . $db->prepare_input($custom_product_field_values[
							$custom_product_field_value_i]['field_value']) . "'
						);";
				
				$insert_custom_product_field_value_result =
					$db->Execute($insert_custom_product_field_value_sql);
			}
			
			// Copy any manufacturer selections for this method
			$num_manufacturers = sizeof($manufacturers);
			
			for ($manufacturer_i = 0; $manufacturer_i < $num_manufacturers; $manufacturer_i++) {
				$insert_manufacturer_sql = "
					INSERT INTO
						" . TABLE_ADVANCED_SHIPPER_METHOD_MANUFACTURERS . "
						(
						config_id,
						method,
						manufacturer_order,
						manufacturer_id
						)
					VALUES
						(
						'" . $config_id . "',
						'" . $method_i . "',
						'" . $db->prepare_input($manufacturers[$manufacturer_i]['manufacturer_order']) . "',
						'" . $db->prepare_input($manufacturers[$manufacturer_i]['manufacturer_id']) . "'
						);";
				
				$insert_manufacturer_result = $db->Execute($insert_manufacturer_sql);
			}
			
			// Copy any product selections for this method
			$num_products = sizeof($products);
			
			for ($product_i = 0; $product_i < $num_products; $product_i++) {
				$insert_product_sql = "
					INSERT INTO
						" . TABLE_ADVANCED_SHIPPER_METHOD_PRODUCTS . "
						(
						config_id,
						method,
						product_order,
						product_id,
						product_attributes_id
						)
					VALUES
						(
						'" . $config_id . "',
						'" . $method_i . "',
						'" . $db->prepare_input($products[$product_i]['product_order']) . "',
						'" . $db->prepare_input($products[$product_i]['product_id']) . "',
						" . (is_null($products[$product_i]['product_attributes_id']) ? "'0'" : "'" . $db->prepare_input($products[$product_i]['product_attributes_id']) . "'") . "
						);";
				
				$insert_product_result = $db->Execute($insert_product_sql);
			}
			
			// Copy any region configurations for this method
			$num_regions = sizeof($regions);
			
			for ($region_i = 1; $region_i <= $num_regions; $region_i++) {
				$insert_region_sql = "
					INSERT INTO
						" . TABLE_ADVANCED_SHIPPER_REGION_CONFIGS . "
						(
						config_id,
						method,
						region,
						definition_method,
						countries_postcodes,
						countries_zones,
						countries_cities,
						countries_states,
						distance,
						tax_class,
						rates_include_tax,
						rate_limits_inc,
						total_up_price_inc_tax,
						table_of_rates,
						max_weight_per_package,
						packaging_weights,
						surcharge
						)
					VALUES
						(
						'" . $config_id . "',
						'" . $method_i . "',
						'" . $region_i . "',
						'" . $db->prepare_input($regions[$region_i]['definition_method']) . "',
						" . ((is_null($regions[$region_i]['countries_postcodes']) || strlen(trim($regions[$region_i]['countries_postcodes'])) == 0) ? 'null' : "'" . zen_db_prepare_input($regions[$region_i]['countries_postcodes']) . "'") . ",
						" . ((is_null($regions[$region_i]['countries_zones']) || strlen(trim($regions[$region_i]['countries_zones'])) == 0) ? 'null' : "'" . zen_db_prepare_input($regions[$region_i]['countries_zones']) . "'") . ",
						" . ((is_null($regions[$region_i]['countries_cities']) || strlen(trim($regions[$region_i]['countries_cities'])) == 0) ? 'null' : "'" . zen_db_prepare_input($regions[$region_i]['countries_cities']) . "'") . ",
						" . ((is_null($regions[$region_i]['countries_states']) || strlen(trim($regions[$region_i]['countries_states'])) == 0) ? 'null' : "'" . zen_db_prepare_input($regions[$region_i]['countries_states']) . "'") . ",
						" . ((is_null($regions[$region_i]['distance']) || strlen(trim($regions[$region_i]['distance'])) == 0) ? 'null' : "'" . zen_db_prepare_input($regions[$region_i]['distance']) . "'") . ",
						'" . $db->prepare_input($regions[$region_i]['tax_class']) . "',
						'" . $db->prepare_input($regions[$region_i]['rates_include_tax']) . "',
						'" . $db->prepare_input($regions[$region_i]['rate_limits_inc']) . "',
						'" . $db->prepare_input($regions[$region_i]['total_up_price_inc_tax']) . "',
						'" . $db->prepare_input($regions[$region_i]['table_of_rates']) . "',
						" . ((is_null($regions[$region_i]['max_weight_per_package']) || strlen(trim($regions[$region_i]['max_weight_per_package'])) == 0) ? 'null' : "'" . zen_db_prepare_input($regions[$region_i]['max_weight_per_package']) . "'") . ",
						" . ((is_null($regions[$region_i]['packaging_weights']) || strlen(trim($regions[$region_i]['packaging_weights'])) == 0) ? 'null' : "'" .  zen_db_prepare_input($regions[$region_i]['packaging_weights']) . "'") . ",
						" . ((is_null($regions[$region_i]['surcharge']) || strlen(trim($regions[$region_i]['surcharge'])) == 0) ? 'null' : "'" . zen_db_prepare_input($regions[$region_i]['surcharge']) . "'") . "
						);";
				
				$insert_region_result = $db->Execute($insert_region_sql);
				
				for ($language_i = 0, $n = sizeof($languages); $language_i < $n; $language_i++) {
					$insert_region_admin_title_sql = "
						INSERT INTO
							" . TABLE_ADVANCED_SHIPPER_REGION_ADMIN_TITLES . "
							(
							config_id,
							method,
							region,
							language_id,
							title
							)
						VALUES
							(
							'" . $config_id . "',
							'" . $method_i . "',
							'" . $region_i . "',
							'" . $languages[$language_i]['id'] . "',
							'" . $db->prepare_input($region_admin_titles[$region_i][$languages[$language_i]['id']]) . "'
							);";
					
					$insert_region_admin_title_result = $db->Execute($insert_region_admin_title_sql);
					
					$insert_region_title_sql = "
						INSERT INTO
							" . TABLE_ADVANCED_SHIPPER_REGION_TITLES . "
							(
							config_id,
							method,
							region,
							language_id,
							title
							)
						VALUES
							(
							'" . $config_id . "',
							'" . $method_i . "',
							'" . $region_i . "',
							'" . $languages[$language_i]['id'] . "',
							'" . $db->prepare_input($region_titles[$region_i][$languages[$language_i]['id']]) . "'
							);";
					
					$insert_region_title_result = $db->Execute($insert_region_title_sql);
					
					$insert_region_surcharge_title_sql = "
						INSERT INTO
							" . TABLE_ADVANCED_SHIPPER_REGION_SURCHARGE_TITLES . "
							(
							config_id,
							method,
							region,
							language_id,
							title
							)
						VALUES
							(
							'" . $config_id . "',
							'" . $method_i . "',
							'" . $region_i . "',
							'" . $languages[$language_i]['id'] . "',
							" . ((is_null($region_surcharge_titles[$region_i][$languages[$language_i]['id']]) || strlen(trim($region_surcharge_titles[$region_i][$languages[$language_i]['id']])) == 0) ? 'null' : "'" . $region_surcharge_titles[$region_i][$languages[$language_i]['id']] . "'") . "
							);";
					
					$insert_region_surcharge_title_result = $db->Execute($insert_region_surcharge_title_sql);
				}
				
				if (isset($region_ups_configs[$region_i])) {
					$region_ups_config_data_array = array(
						'config_id' => $config_id,
						'method' => $method_i,
						'region' => $region_i,
						'source_country' => zen_db_prepare_input($region_ups_configs[$region_i]['source_country']),
						'source_postcode' => zen_db_prepare_input($region_ups_configs[$region_i]['source_postcode']),
						'pickup_method' => zen_db_prepare_input($region_ups_configs[$region_i]['pickup_method']),
						'packaging' => zen_db_prepare_input($region_ups_configs[$region_i]['packaging']),
						'delivery_type' => zen_db_prepare_input($region_ups_configs[$region_i]['delivery_type']),
						'shipping_service_1dm' => zen_db_prepare_input($region_ups_configs[$region_i]['shipping_service_1dm']),
						'shipping_service_1dml' => zen_db_prepare_input($region_ups_configs[$region_i]['shipping_service_1dml']),
						'shipping_service_1da' => zen_db_prepare_input($region_ups_configs[$region_i]['shipping_service_1da']),
						'shipping_service_1dal' => zen_db_prepare_input($region_ups_configs[$region_i]['shipping_service_1dal']),
						'shipping_service_1dapi' => zen_db_prepare_input($region_ups_configs[$region_i]['shipping_service_1dapi']),
						'shipping_service_1dp' => zen_db_prepare_input($region_ups_configs[$region_i]['shipping_service_1dp']),
						'shipping_service_1dpl' => zen_db_prepare_input($region_ups_configs[$region_i]['shipping_service_1dpl']),
						'shipping_service_2dm' => zen_db_prepare_input($region_ups_configs[$region_i]['shipping_service_2dm']),
						'shipping_service_2dml' => zen_db_prepare_input($region_ups_configs[$region_i]['shipping_service_2dml']),
						'shipping_service_2da' => zen_db_prepare_input($region_ups_configs[$region_i]['shipping_service_2da']),
						'shipping_service_2dal' => zen_db_prepare_input($region_ups_configs[$region_i]['shipping_service_2dal']),
						'shipping_service_3ds' => zen_db_prepare_input($region_ups_configs[$region_i]['shipping_service_3ds']),
						'shipping_service_gnd' => zen_db_prepare_input($region_ups_configs[$region_i]['shipping_service_gnd']),
						'shipping_service_std' => zen_db_prepare_input($region_ups_configs[$region_i]['shipping_service_std']),
						'shipping_service_xpr' => zen_db_prepare_input($region_ups_configs[$region_i]['shipping_service_xpr']),
						'shipping_service_xprl' => zen_db_prepare_input($region_ups_configs[$region_i]['shipping_service_xprl']),
						'shipping_service_xdm' => zen_db_prepare_input($region_ups_configs[$region_i]['shipping_service_xdm']),
						'shipping_service_xdml' => zen_db_prepare_input($region_ups_configs[$region_i]['shipping_service_xdml']),
						'shipping_service_xpd' => zen_db_prepare_input($region_ups_configs[$region_i]['shipping_service_xpd']),
						'shipping_service_wxs' => zen_db_prepare_input($region_ups_configs[$region_i]['shipping_service_wxs'])
						);
					
					$region_ups_config_result = zen_db_perform(TABLE_ADVANCED_SHIPPER_REGION_UPS_CONFIGS, $region_ups_config_data_array);
				}
				
				// Save any USPS calculator settings
				if (isset($region_usps_configs[$region_i])) {
					$region_usps_config_data_array = array(
						'config_id' => $config_id,
						'method' => $method_i,
						'region' => $region_i,
						'user_id' => zen_db_prepare_input($region_usps_configs[$region_i]['user_id']),
						'server' => zen_db_prepare_input($region_usps_configs[$region_i]['server']),
						'source_country' => zen_db_prepare_input($region_usps_configs[$region_i]['source_country']),
						'source_postcode' => zen_db_prepare_input($region_usps_configs[$region_i]['source_postcode']),
						'machinable' => zen_db_prepare_input($region_usps_configs[$region_i]['machinable']),
						'display_transit_time' => zen_db_prepare_input($region_usps_configs[$region_i]['display_transit_time']),
						'domestic_express' => zen_db_prepare_input($region_usps_configs[$region_i]['domestic_express']),
						'domestic_priority' => zen_db_prepare_input($region_usps_configs[$region_i]['domestic_priority']),
						'domestic_first_class' => zen_db_prepare_input($region_usps_configs[$region_i]['domestic_first_class']),
						'domestic_retail_ground' => zen_db_prepare_input($region_usps_configs[$region_i]['domestic_retail_ground']),
						'domestic_media' => zen_db_prepare_input($region_usps_configs[$region_i]['domestic_media']),
						'domestic_bpm' => zen_db_prepare_input($region_usps_configs[$region_i]['domestic_bpm']),
						'domestic_library' => zen_db_prepare_input($region_usps_configs[$region_i]['domestic_library']),
						'international_geg' => zen_db_prepare_input($region_usps_configs[$region_i]['international_geg']),
						'international_geg_d' => zen_db_prepare_input($region_usps_configs[$region_i]['international_geg_d']),
						'international_geg_ndr' => zen_db_prepare_input($region_usps_configs[$region_i]['international_geg_ndr']),
						'international_geg_ndnr' => zen_db_prepare_input($region_usps_configs[$region_i]['international_geg_ndnr']),
						'international_geg_e' => zen_db_prepare_input($region_usps_configs[$region_i]['international_geg_e']),
						'international_emi' => zen_db_prepare_input($region_usps_configs[$region_i]['international_emi']),
						'international_emi_fre' => zen_db_prepare_input($region_usps_configs[$region_i]['international_emi_fre']),
						'international_emi_lfre' => zen_db_prepare_input($region_usps_configs[$region_i]['international_emi_lfre']),
						'international_pmi' => zen_db_prepare_input($region_usps_configs[$region_i]['international_pmi']),
						'international_pmi_sfrb' => zen_db_prepare_input($region_usps_configs[$region_i]['international_pmi_sfrb']),
						'international_pmi_mfrb' => zen_db_prepare_input($region_usps_configs[$region_i]['international_pmi_mfrb']),
						'international_pmi_lfrb' => zen_db_prepare_input($region_usps_configs[$region_i]['international_pmi_lfrb']),
						'international_pmi_dfrb' => zen_db_prepare_input($region_usps_configs[$region_i]['international_pmi_dfrb']),
						'international_pmi_lvfrb' => zen_db_prepare_input($region_usps_configs[$region_i]['international_pmi_lvfrb']),
						'international_pmi_fre' => zen_db_prepare_input($region_usps_configs[$region_i]['international_pmi_fre']),
						'international_pmi_sfre' => zen_db_prepare_input($region_usps_configs[$region_i]['international_pmi_sfre']),
						'international_pmi_pfre' => zen_db_prepare_input($region_usps_configs[$region_i]['international_pmi_pfre']),
						'international_pmi_gcfre' => zen_db_prepare_input($region_usps_configs[$region_i]['international_pmi_gcfre']),
						'international_pmi_lfre' => zen_db_prepare_input($region_usps_configs[$region_i]['international_pmi_lfre']),
						'international_fcmi_le' => zen_db_prepare_input($region_usps_configs[$region_i]['international_fcmi_le']),
						'international_fcmi_p' => zen_db_prepare_input($region_usps_configs[$region_i]['international_fcmi_p']),
						'international_fcmi_l' => zen_db_prepare_input($region_usps_configs[$region_i]['international_fcmi_l'])
						);
					
					$region_usps_config_result = zen_db_perform(TABLE_ADVANCED_SHIPPER_REGION_USPS_CONFIGS, $region_usps_config_data_array);
				}
				
				// Save any FedEx calculator settings
				if (isset($region_fedex_configs[$region_i])) {
					$region_fedex_config_data_array = array(
						'config_id' => $config_id,
						'method' => $method_i,
						'region' => $region_i,
						'source_country' => zen_db_prepare_input($region_fedex_configs[$region_i]['source_country']),
						'source_postcode' => zen_db_prepare_input($region_fedex_configs[$region_i]['source_postcode']),
						'fedex_key' => zen_db_prepare_input($region_fedex_configs[$region_i]['fedex_key']),
						'fedex_password' => zen_db_prepare_input($region_fedex_configs[$region_i]['fedex_password']),
						'fedex_account' => zen_db_prepare_input($region_fedex_configs[$region_i]['fedex_account']),
						'fedex_meter' => zen_db_prepare_input($region_fedex_configs[$region_i]['fedex_meter']),
						'server' => zen_db_prepare_input($region_fedex_configs[$region_i]['server']),
						'weight_units' => zen_db_prepare_input($region_fedex_configs[$region_i]['weight_units']),
						'rate_request_types' => zen_db_prepare_input($region_fedex_configs[$region_i]['rate_request_types']),
						'drop_off_type' => zen_db_prepare_input($region_fedex_configs[$region_i]['drop_off_type']),
						'packaging_type' => zen_db_prepare_input($region_fedex_configs[$region_i]['packaging_type']),
						'shipping_saturday' => zen_db_prepare_input($region_fedex_configs[$region_i]['shipping_saturday']),
						'shipping_service_fedex_1_day_freight' => zen_db_prepare_input($region_fedex_configs[$region_i]['shipping_service_fedex_1_day_freight']),
						'shipping_service_fedex_2_day' => zen_db_prepare_input($region_fedex_configs[$region_i]['shipping_service_fedex_2_day']),
						'shipping_service_fedex_2_day_freight' => zen_db_prepare_input($region_fedex_configs[$region_i]['shipping_service_fedex_2_day_freight']),
						'shipping_service_fedex_3_day_freight' => zen_db_prepare_input($region_fedex_configs[$region_i]['shipping_service_fedex_3_day_freight']),
						'shipping_service_fedex_express_saver' => zen_db_prepare_input($region_fedex_configs[$region_i]['shipping_service_fedex_express_saver']),
						'shipping_service_fedex_ground' => zen_db_prepare_input($region_fedex_configs[$region_i]['shipping_service_fedex_ground']),
						'shipping_service_ground_home_delivery' => zen_db_prepare_input($region_fedex_configs[$region_i]['shipping_service_ground_home_delivery']),
						'shipping_service_standard_overnight' => zen_db_prepare_input($region_fedex_configs[$region_i]['shipping_service_standard_overnight']),
						'shipping_service_first_overnight' => zen_db_prepare_input($region_fedex_configs[$region_i]['shipping_service_first_overnight']),
						'shipping_service_priority_overnight' => zen_db_prepare_input($region_fedex_configs[$region_i]['shipping_service_priority_overnight']),
						'shipping_service_smart_post' => zen_db_prepare_input($region_fedex_configs[$region_i]['shipping_service_smart_post']),
						'shipping_service_fedex_freight' => zen_db_prepare_input($region_fedex_configs[$region_i]['shipping_service_fedex_freight']),
						'shipping_service_fedex_national_freight' => zen_db_prepare_input($region_fedex_configs[$region_i]['shipping_service_fedex_national_freight']),
						'shipping_service_international_ground' => zen_db_prepare_input($region_fedex_configs[$region_i]['shipping_service_international_ground']),
						'shipping_service_international_economy' => zen_db_prepare_input($region_fedex_configs[$region_i]['shipping_service_international_economy']),
						'shipping_service_international_economy_freight' => zen_db_prepare_input($region_fedex_configs[$region_i]['shipping_service_international_economy_freight']),
						'shipping_service_international_first' => zen_db_prepare_input($region_fedex_configs[$region_i]['shipping_service_international_first']),
						'shipping_service_international_priority' => zen_db_prepare_input($region_fedex_configs[$region_i]['shipping_service_international_priority']),
						'shipping_service_international_priority_freight' => zen_db_prepare_input($region_fedex_configs[$region_i]['shipping_service_international_priority_freight']),
						'shipping_service_europe_first_international_priority' => zen_db_prepare_input($region_fedex_configs[$region_i]['shipping_service_europe_first_international_priority'])
						);
					
					$region_fedex_config_result = zen_db_perform(TABLE_ADVANCED_SHIPPER_REGION_FEDEX_CONFIGS, $region_fedex_config_data_array);
				}
			}
		}
		
		$num_shipping_methods += $num_shipping_methods_to_insert;
		
		if ($num_shipping_methods_to_insert == 1) {
			$messageStack->add(sprintf(SUCCESS_METHOD_COPIED_ONCE, $affected_method, $insert_after), 'success');
		} else {
			$messageStack->add(sprintf(SUCCESS_METHOD_COPIED_MULTIPLE_TIMES, $affected_method, $num_shipping_methods_to_insert, $insert_after), 'success');
		}
	}
} else if ($action == 'delete') {
	// Delete shipping method from database ////////////////////////////////////////////////////////
	$delete_method_sql = "
		DELETE FROM
			" . TABLE_ADVANCED_SHIPPER_METHOD_CONFIGS . "
		WHERE
			config_id = '" . $config_id . "'
		AND
			method = '" . $affected_method . "';";
	
	$delete_method_result = $db->Execute($delete_method_sql);
	
	$delete_method_sql = "
		DELETE FROM
			" . TABLE_ADVANCED_SHIPPER_METHOD_TITLES . "
		WHERE
			config_id = '" . $config_id . "'
		AND
			method = '" . $affected_method . "';";
	
	$delete_method_result = $db->Execute($delete_method_sql);
	
	$delete_method_sql = "
		DELETE FROM
			" . TABLE_ADVANCED_SHIPPER_METHOD_ADMIN_TITLES . "
		WHERE
			config_id = '" . $config_id . "'
		AND
			method = '" . $affected_method . "';";
	
	$delete_method_result = $db->Execute($delete_method_sql);
	
	$delete_method_sql = "
		DELETE FROM
			" . TABLE_ADVANCED_SHIPPER_METHOD_CATEGORIES . "
		WHERE
			config_id = '" . $config_id . "'
		AND
			method = '" . $affected_method . "';";
	
	$delete_method_result = $db->Execute($delete_method_sql);
	
	$delete_method_sql = "
		DELETE FROM
			" . TABLE_ADVANCED_SHIPPER_METHOD_CUSTOM_PRODUCT_FIELD_VALUES . "
		WHERE
			config_id = '" . $config_id . "'
		AND
			method = '" . $affected_method . "';";
	
	$delete_method_result = $db->Execute($delete_method_sql);
	
	$delete_method_sql = "
		DELETE FROM
			" . TABLE_ADVANCED_SHIPPER_METHOD_MANUFACTURERS . "
		WHERE
			config_id = '" . $config_id . "'
		AND
			method = '" . $affected_method . "';";
	
	$delete_method_result = $db->Execute($delete_method_sql);
	
	$delete_method_sql = "
		DELETE FROM
			" . TABLE_ADVANCED_SHIPPER_METHOD_PRODUCTS . "
		WHERE
			config_id = '" . $config_id . "'
		AND
			method = '" . $affected_method . "';";
	
	$delete_method_result = $db->Execute($delete_method_sql);
	
	$delete_method_sql = "
		DELETE FROM
			" . TABLE_ADVANCED_SHIPPER_REGION_CONFIGS . "
		WHERE
			config_id = '" . $config_id . "'
		AND
			method = '" . $affected_method . "';";
	
	$delete_method_result = $db->Execute($delete_method_sql);
	
	$delete_method_sql = "
		DELETE FROM
			" . TABLE_ADVANCED_SHIPPER_REGION_ADMIN_TITLES . "
		WHERE
			config_id = '" . $config_id . "'
		AND
			method = '" . $affected_method . "';";
	
	$delete_method_result = $db->Execute($delete_method_sql);
	
	$delete_method_sql = "
		DELETE FROM
			" . TABLE_ADVANCED_SHIPPER_REGION_TITLES . "
		WHERE
			config_id = '" . $config_id . "'
		AND
			method = '" . $affected_method . "';";
	
	$delete_method_result = $db->Execute($delete_method_sql);
	
	$delete_method_sql = "
		DELETE FROM
			" . TABLE_ADVANCED_SHIPPER_REGION_SURCHARGE_TITLES . "
		WHERE
			config_id = '" . $config_id . "'
		AND
			method = '" . $affected_method . "';";
	
	$delete_method_result = $db->Execute($delete_method_sql);
	
	$delete_method_sql = "
		DELETE FROM
			" . TABLE_ADVANCED_SHIPPER_REGION_UPS_CONFIGS . "
		WHERE
			config_id = '" . $config_id . "'
		AND
			method = '" . $affected_method . "';";
	
	$delete_method_result = $db->Execute($delete_method_sql);
	
	$delete_method_sql = "
		DELETE FROM
			" . TABLE_ADVANCED_SHIPPER_REGION_USPS_CONFIGS . "
		WHERE
			config_id = '" . $config_id . "'
		AND
			method = '" . $affected_method . "';";
	
	$delete_method_result = $db->Execute($delete_method_sql);
	
	$delete_method_sql = "
		DELETE FROM
			" . TABLE_ADVANCED_SHIPPER_REGION_FEDEX_CONFIGS . "
		WHERE
			config_id = '" . $config_id . "'
		AND
			method = '" . $affected_method . "';";
	
	$delete_method_result = $db->Execute($delete_method_sql);
	
	// Re-number all following methods
	for ($method_i = $affected_method; $method_i < $num_shipping_methods; $method_i++) {
		$update_method_sql = "
			UPDATE
				" . TABLE_ADVANCED_SHIPPER_METHOD_CONFIGS . "
			SET
				method = '" . $method_i . "'
			WHERE
				config_id = '" . $config_id . "'
			AND
				method = '" . ($method_i + 1) . "';";
		
		$update_method_result = $db->Execute($update_method_sql);
		
		$update_method_sql = "
			UPDATE
				" . TABLE_ADVANCED_SHIPPER_METHOD_TITLES . "
			SET
				method = '" . $method_i . "'
			WHERE
				config_id = '" . $config_id . "'
			AND
				method = '" . ($method_i + 1) . "';";
		
		$update_method_result = $db->Execute($update_method_sql);
		
		$update_method_sql = "
			UPDATE
				" . TABLE_ADVANCED_SHIPPER_METHOD_ADMIN_TITLES . "
			SET
				method = '" . $method_i . "'
			WHERE
				config_id = '" . $config_id . "'
			AND
				method = '" . ($method_i + 1) . "';";
		
		$update_method_result = $db->Execute($update_method_sql);
		
		$update_method_sql = "
			UPDATE
				" . TABLE_ADVANCED_SHIPPER_METHOD_CATEGORIES . "
			SET
				method = '" . $method_i . "'
			WHERE
				config_id = '" . $config_id . "'
			AND
				method = '" . ($method_i + 1) . "';";
		
		$update_method_result = $db->Execute($update_method_sql);
		
		$update_method_sql = "
			UPDATE
				" . TABLE_ADVANCED_SHIPPER_METHOD_CUSTOM_PRODUCT_FIELD_VALUES . "
			SET
				method = '" . $method_i . "'
			WHERE
				config_id = '" . $config_id . "'
			AND
				method = '" . ($method_i + 1) . "';";
		
		$update_method_result = $db->Execute($update_method_sql);
		
		$update_method_sql = "
			UPDATE
				" . TABLE_ADVANCED_SHIPPER_METHOD_MANUFACTURERS . "
			SET
				method = '" . $method_i . "'
			WHERE
				config_id = '" . $config_id . "'
			AND
				method = '" . ($method_i + 1) . "';";
		
		$update_method_result = $db->Execute($update_method_sql);
		
		$update_method_sql = "
			UPDATE
				" . TABLE_ADVANCED_SHIPPER_METHOD_PRODUCTS . "
			SET
				method = '" . $method_i . "'
			WHERE
				config_id = '" . $config_id . "'
			AND
				method = '" . ($method_i + 1) . "';";
		
		$update_method_result = $db->Execute($update_method_sql);
		
		$update_method_sql = "
			UPDATE
				" . TABLE_ADVANCED_SHIPPER_REGION_CONFIGS . "
			SET
				method = '" . $method_i . "'
			WHERE
				config_id = '" . $config_id . "'
			AND
				method = '" . ($method_i + 1) . "';";
		
		$update_method_result = $db->Execute($update_method_sql);
		
		$update_method_sql = "
			UPDATE
				" . TABLE_ADVANCED_SHIPPER_REGION_ADMIN_TITLES . "
			SET
				method = '" . $method_i . "'
			WHERE
				config_id = '" . $config_id . "'
			AND
				method = '" . ($method_i + 1) . "';";
		
		$update_method_result = $db->Execute($update_method_sql);
		
		$update_method_sql = "
			UPDATE
				" . TABLE_ADVANCED_SHIPPER_REGION_TITLES . "
			SET
				method = '" . $method_i . "'
			WHERE
				config_id = '" . $config_id . "'
			AND
				method = '" . ($method_i + 1) . "';";
		
		$update_method_result = $db->Execute($update_method_sql);
		
		$update_method_sql = "
			UPDATE
				" . TABLE_ADVANCED_SHIPPER_REGION_SURCHARGE_TITLES . "
			SET
				method = '" . $method_i . "'
			WHERE
				config_id = '" . $config_id . "'
			AND
				method = '" . ($method_i + 1) . "';";
		
		$update_method_result = $db->Execute($update_method_sql);
		
		$update_method_sql = "
			UPDATE
				" . TABLE_ADVANCED_SHIPPER_REGION_UPS_CONFIGS . "
			SET
				method = '" . $method_i . "'
			WHERE
				config_id = '" . $config_id . "'
			AND
				method = '" . ($method_i + 1) . "';";
		
		$update_method_result = $db->Execute($update_method_sql);
		
		$update_method_sql = "
			UPDATE
				" . TABLE_ADVANCED_SHIPPER_REGION_USPS_CONFIGS . "
			SET
				method = '" . $method_i . "'
			WHERE
				config_id = '" . $config_id . "'
			AND
				method = '" . ($method_i + 1) . "';";
		
		$update_method_result = $db->Execute($update_method_sql);
		
		$update_method_sql = "
			UPDATE
				" . TABLE_ADVANCED_SHIPPER_REGION_FEDEX_CONFIGS . "
			SET
				method = '" . $method_i . "'
			WHERE
				config_id = '" . $config_id . "'
			AND
				method = '" . ($method_i + 1) . "';";
		
		$update_method_result = $db->Execute($update_method_sql);
	}
	
	$num_shipping_methods--;
	
	$messageStack->add(sprintf(SUCCESS_METHOD_DELETED, $affected_method), 'success');
	
} else if ($action == 'toggle_method') {
	// Is the selected method to be enabled or disabled?
	$method_enabled_sql = "
		SELECT
			asmc.enabled
		FROM
			" . TABLE_ADVANCED_SHIPPER_METHOD_CONFIGS . " asmc
		WHERE
			asmc.config_id = '" . $config_id . "'
		AND
			asmc.method = '" . $affected_method . "';";
	
	$method_enabled_result = $db->Execute($method_enabled_sql);
	
	if ($method_enabled_result->fields['enabled'] == 1) {
		$disable_method_sql = "
			UPDATE
				" . TABLE_ADVANCED_SHIPPER_METHOD_CONFIGS . "
			SET
				enabled = '0'
			WHERE
				config_id = '" . $config_id . "'
			AND
				method = '" . $affected_method . "';";
		
		$disable_method_result = $db->Execute($disable_method_sql);
		
		$messageStack->add_session(sprintf(SUCCESS_METHOD_DISABLED, $affected_method), 'success');
	} else {
		$disable_method_sql = "
			UPDATE
				" . TABLE_ADVANCED_SHIPPER_METHOD_CONFIGS . "
			SET
				enabled = '1'
			WHERE
				config_id = '" . $config_id . "'
			AND
				method = '" . $affected_method . "';";
		
		$disable_method_result = $db->Execute($disable_method_sql);
		
		$messageStack->add_session(sprintf(SUCCESS_METHOD_ENABLED, $affected_method), 'success');
	}
	
	// Redirect to remove toggle parameter from URI
	zen_redirect(zen_href_link(FILENAME_ADVANCED_SHIPPER, zen_get_all_get_params()));
}


// Load the settings for the shipping methods for the loaded configuration
$load_methods_config_sql = "
	SELECT
		asmc.method,
		asmc.enabled,
		asmc.select_products,
		asmc.availability_scheduling,
		asmc.once_only_start_datetime,
		asmc.once_only_end_datetime,
		asmc.availability_recurring_mode,
		asmc.availability_weekly_start_day,
		asmc.availability_weekly_start_time,
		asmc.availability_weekly_cutoff_day,
		asmc.availability_weekly_cutoff_time,
		asmc.usage_limit,
		asmc.once_only_shipping_datetime,
		asmc.availability_weekly_shipping_scheduling,
		asmc.availability_weekly_shipping_show_num_weeks,
		asmc.availability_weekly_shipping_regular_weekday_day,
		asmc.availability_weekly_shipping_regular_weekday_time
	FROM
		" . TABLE_ADVANCED_SHIPPER_METHOD_CONFIGS . " asmc
	WHERE
		asmc.config_id = '" . $config_id . "'
	ORDER BY
		asmc.method";

// Split Page
// reset page when page is unknown
if (isset($_GET['page']) && ($_GET['page'] == '' || $_GET['page'] <= 1)) {
	$_GET['page'] = 1;
}

// Fix silly problems with Zen Cart's splitPageResults class
$load_methods_config_sql = strtolower(str_replace("\n", ' ', $load_methods_config_sql));
$load_methods_config_sql = str_replace("\r", ' ', $load_methods_config_sql);
$load_methods_config_sql = str_replace("\t", ' ', $load_methods_config_sql);

// Cope with table names that have capital letter(s) in them
$load_methods_config_sql = str_replace(strtolower(TABLE_ADVANCED_SHIPPER_METHOD_CONFIGS . " asmc"),
	TABLE_ADVANCED_SHIPPER_METHOD_CONFIGS . " asmc", $load_methods_config_sql);

$num_of_rows = '';

$methods_split = new splitPageResults($_GET['page'], MAX_DISPLAY_SEARCH_RESULTS_ORDERS,
	$load_methods_config_sql, $num_of_rows);

$methods = $db->Execute($load_methods_config_sql);

$num_pages = ceil($num_of_rows / MAX_DISPLAY_SEARCH_RESULTS_ORDERS);

// Build the list of values for the insert region and copy regions selects
$insert_select_values = array();

$insert_select_values[] = array(
	'id' => '-1',
	'text' => TEXT_NUM_METHODS_TO_INSERT
	);

for ($i = 1; $i < 11; $i++) {
	$insert_select_values[] = array(
		'id' => $i,
		'text' => $i
		);
}

$num_copies_select_values = array();

$num_copies_select_values[] = array(
	'id' => '-1',
	'text' => TEXT_NUM_METHODS_TO_COPY
	);

for ($i = 1; $i < 11; $i++) {
	$num_copies_select_values[] = array(
		'id' => $i,
		'text' => $i
		);
}

$copy_to_select_values = array();

for ($i = 1; $i <= $num_shipping_methods; $i++) {
	$copy_to_select_values[] = array(
		'id' => $i,
		'text' => sprintf(TEXT_INSERT_AFTER_METHOD, $i)
		);
}

?>
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
	<title><?php echo TITLE; ?></title>
	<link rel="stylesheet" type="text/css" href="includes/stylesheet.css">
	<link rel="stylesheet" type="text/css" href="includes/cssjsmenuhover.css" media="all" id="hoverJS">
	<script language="javascript" type="text/javascript" src="includes/menu.js"></script>
	<script language="javascript" type="text/javascript" src="includes/general.js"></script>
	<script language="javascript"  type="text/javascript">
	<!--
<?php require(DIR_WS_INCLUDES . 'javascript/ceon/adv_shipper/advshipper.php'); ?>
	//-->
	</script>
	<script type="text/javascript">
		<!--
		function init()
		{
			cssjsmenu('navbar');
			if (document.getElementById)
			{
				var kill = document.getElementById('hoverJS');
				kill.disabled = true;
			}
		}
		// -->
	</script>
	<style type="text/css">
	#advanced-shipper-logo { float: right; margin-top: 3px; margin-bottom: 0.4em; }
	h1#advanced-shipper-page-heading { margin-top: 1.2em; margin-bottom: 1.2em; }
	
	fieldset { padding: 0.8em 0.8em; }
	fieldset fieldset { margin-bottom: 1em; }
	legend { font-weight: bold; font-size: 1.3em; }
	.SpacerSmall { clear: both; }
	
	fieldset.CeonPanel {
		background: #fff;
		border: 1px solid #296629;
	}
	fieldset.CeonPanel legend {
		font-size: 1.4em;
		background: #fff;
		padding: 0.1em 0.4em 1em 0.4em;
	}
	fieldset.CeonPanel fieldset legend {
		background: none;
		padding-bottom: 0.4em;
		font-size: 1.3em;
	}
	
	ul#ceon-panels-menu {
		list-style: none;
		margin: 0;
		padding: 0 0 0.6em 0;
		background: #599659;
		white-space: nowrap;
	}
	ul#ceon-panels-menu li {
		display: inline;
		padding: 0;
		margin: 0;
	}
	ul#ceon-panels-menu li a {
		background: #79b679;
		color: #fff;
		font-size: 1.2em;
		padding: 0.3em 2em 0.7em 2em;
		font-weight: bold;
		margin: 0 0.4em 0 0;
		border-left: 1px solid #79b679;
		border-top: 1px solid #79b679;
	}
	ul#ceon-panels-menu li a:hover {
		background: #89c689;
		border-left: 1px solid #89c689;
		border-top: 1px solid #89c689;
	}
	ul#ceon-panels-menu li a:visited, ul#ceon-panels-menu li a:active,
	ul#ceon-panels-menu li a:focus {
		outline: none;
	}
	
	ul#ceon-panels-menu li.CeonPanelTabSelected {
		display: inline;
		padding: 0;
	}
	ul#ceon-panels-menu li.CeonPanelTabSelected a {
		background: #599659 url(<?php echo DIR_WS_IMAGES; ?>ceon-tab-background-selected.png) top left repeat-x;
		padding: 0.7em 2em 0.5em 2em;
		border-left: 1px solid #69a669;
		border-top: 1px solid #69a669;
	}
	ul#ceon-panels-menu li.CeonPanelTabSelected a:hover {
		text-decoration: none;
		background: #599659;
		border-left: 1px solid #69a669;
		border-top: 1px solid #69a669;
	}
	ul#ceon-panels-menu li.CeonPanelTabSelected a:visited,
	ul#ceon-panels-menu li.CeonPanelTabSelected a:active,
	ul#ceon-panels-menu li.CeonPanelTabSelected a:focus {
		outline: none;
	}
	
	#ceon-panels-wrapper {
		border: 1px solid #599659;
		background: #599659;
		padding: 1em 1em 1.2em 1em;
		margin-bottom: 0;
	}
	
	.AdvancedShipperMethodOdd {
		background-color: #d0d0d0;
		box-shadow: inset 0px 0px 8px 1px #c4c4c4;
	}
	.AdvancedShipperMethodEven {
		background-color: #f3f3f3;
		box-shadow: inset 0px 0px 8px 1px #e3e3e3;
	}
	.AdvancedShipperMethodSummaryOdd {
		background-color: #d9d9d9;
		padding-bottom: 0;
		box-shadow: inset 0px 0px 8px 1px #ccc;
	}
	.AdvancedShipperMethodSummaryEven {
		background-color: #fafafa;
		padding-bottom: 0;
		box-shadow: inset 0px 0px 8px 1px #e3e3e3;
	}
	.AdvancedShipperMethodOddMethodOdd {
		background-color: #c6c6d6;
	}
	.AdvancedShipperMethodOddMethodEven {
		background-color: #d6d6e6;
	}
	.AdvancedShipperMethodEvenMethodOdd {
		background-color: #dae6da;
	}
	.AdvancedShipperMethodEvenMethodEven {
		background-color: #edfded;
	}
	
	.AdvancedShipperConfigLabel, .AdvancedShipperConfigField, .AdvancedShipperConfigDesc,
	.AdvancedShipperConfigButtonPanel {
		vertical-align: top;
	}
	.AdvancedShipperConfigLabel { font-weight: bold; padding-right: 1em; vertical-align: top; }
	.AdvancedShipperConfigLabel { width: 20%; }
	.AdvancedShipperConfigField { padding-bottom: 1.3em; vertical-align: top; }
	.AdvancedShipperConfigIntro { padding-top: 0.5em; padding-bottom:1.1em;  }
	.AdvancedShipperConfigButtonPanel { text-align: right; margin-bottom: 0.8em; vertical-align: top; }
	.AdvancedShipperConfigButtonPanel input { vertical-align: middle; }
	
	fieldset.AdvancedShipperMethodSummary, fieldset.AdvancedShipperMethodSummaryOdd,
	fieldset.AdvancedShipperMethodSummaryEven {
		padding: 0.4em 0.8em;
		margin: 0.3em 0 0.3em 0;
	}
	
	fieldset.AdvancedShipperMethodOddRegionEven {
		background-color: #e2e2e2;
		box-shadow: inset 0px 0px 8px 1px #d3d3d3;
	}
	
	fieldset.AdvancedShipperMethodEvenRegionEven {
		background-color: #fdfdfd;
		box-shadow: inset 0px 0px 8px 1px #ddd;
	}
	
	fieldset.AdvancedShipperMethodOddRegionOdd {
		box-shadow: inset 0px 0px 8px 1px #ccc;
	}
	
	fieldset.AdvancedShipperMethodEvenRegionOdd {
		box-shadow: inset 0px 0px 8px 1px #eee;
	}
	
	fieldset.AdvancedShipperMethodSummaryOdd p, fieldset.AdvancedShipperMethodSummaryEven p {
		margin: 0 0 0.8em 0;
		padding: 0;
	}
	
	.NoRegionsDefined { font-weight: bold; }
	
	.Collapse { display: none; }
	
	select {
		margin-bottom: 0.3em;
	}
	
	#footer {
		margin-top: 0.7em;
		text-align: right;
		font-size: 0.9em;
		padding-bottom: 2em;
	}
	#footer img {
		border: none;
		margin-top: 2px;
	}
	#ceon-button-logo {
		float: left;
		margin-right: 14px;
	}
	#footer p {
		margin: 0 0 0.8em 0;
	}
	</style>
	<!--[if IE]>
	<style type="text/css">
	#advanced-shipper-logo { margin-bottom: 0; }
	fieldset {
		position: relative;
	}
	legend, fieldset.CeonPanel legend, fieldset.CeonPanel fieldset legend {
		position: absolute;
		top: -0.55em;
		left: .2em;
		padding: 0;
	}
	
	fieldset fieldset, fieldset.AdvancedShipperMethodSummary,
	fieldset.AdvancedShipperMethodSummaryOdd, fieldset.AdvancedShipperMethodSummaryEven {
		padding-top: 1.8em;
	}
	fieldset fieldset {
		margin-bottom: 1.8em;
	}
	fieldset.AdvancedShipperMethodSummary,
	fieldset.AdvancedShipperMethodSummaryOdd, fieldset.AdvancedShipperMethodSummaryEven {
		margin-bottom: 1em;
	}
	</style>
	<![endif]-->
</head>
<body onload="init()">
<!-- header //-->
<?php require(DIR_WS_INCLUDES . 'header.php'); ?>
<!-- header_eof //-->

<!-- body //-->
<table border="0" width="100%" cellspacing="2" cellpadding="2">
	<tr>
<!-- body_text //-->
		<td width="100%" valign="top">
			<table border="0" width="100%" cellspacing="0" cellpadding="0">
				<tr>
					<td>
						<img src="<?php echo DIR_WS_IMAGES; ?>ceon-advanced-shipper-logo-w150.png" alt="Ceon Advanced Shipper" id="advanced-shipper-logo" />
						<h1 id="advanced-shipper-page-heading"><?php echo HEADING_TITLE; ?></h1>
						
						<div class="SpacerSmall"></div>
						
						<ul id="ceon-panels-menu">
							<li id="shipping-methods-tab" class="CeonPanelTabSelected"><a href=""><?php echo TEXT_SHIPPING_METHODS; ?></a></li>
						</ul>
						<div id="ceon-panels-wrapper">
							<fieldset id="autogen-panel" class="CeonPanel">
              <legend><?php echo $methods_split->display_count($num_of_rows, MAX_DISPLAY_SEARCH_RESULTS_ORDERS, $_GET['page'], TEXT_DISPLAY_NUMBER_OF_METHODS); ?></legend> 
								<table border="0" width="100%" cellpadding="0" cellspacing="0">

<?php if ($num_of_rows > 0) { ?>
				<tr>
					<td style="padding-bottom: 2em;">
						<table cellpadding="0" cellspacing="0" border="0" width="100%">
							<tr>
								<td class="smallText" align="right"><?php echo $methods_split->display_links($num_of_rows, MAX_DISPLAY_SEARCH_RESULTS_ORDERS, MAX_DISPLAY_PAGE_LINKS, $_GET['page'], zen_get_all_get_params(array('page', 'oID', 'action'))); ?></td>
							</tr>
						</table>
					</td>
				</tr>
<?php } ?>
<?php if (true || false) {?>
				<tr>
					<td>
						<?php echo zen_draw_form('advshipper', FILENAME_ADVANCED_SHIPPER,
							'page=' . $_GET['page'], 'post', 'onsubmit=""', true);
						echo zen_hide_session_id(); ?>
<?php
	// Don't collapse this method's display if errors must be displayed!
	if (!isset($collapse)) $collapse = true;

	if (!empty($num_of_rows) && $num_of_rows > 1) {
		echo '<a href="#" name="selectAdvshipperToggleAllMethods" data-val="' . ($collapse ? 'true' : 'false') . '" onclick="return advshipperToggleAllMethods(this, \'' . TEXT_HIDE_ALL_METHODS . '\', \'' . TEXT_SHOW_ALL_METHODS . '\');">';
		if (!empty($collapse)) {
			// Display control to show hidden content
			echo TEXT_SHOW_ALL_METHODS . '</a>';
		} else {
			// Display control to hide content
			echo TEXT_HIDE_ALL_METHODS . '</a>';
		}
	}

// Build controls for each shipping method and a summary of products and regions included //////////
while (!$methods->EOF) {
	$method_num = $methods->fields['method'];
	
	// Get the admin title for this method
	$method_admin_titles = array();
	
	$load_method_admin_titles_config_sql = "
		SELECT
			asmat.title,
			asmat.language_id
		FROM
			" . TABLE_ADVANCED_SHIPPER_METHOD_ADMIN_TITLES . " asmat
		WHERE
			asmat.config_id = '" . $config_id . "'
		AND
			asmat.method = '" . $method_num . "';";
	
	$load_method_admin_titles_config_result = $db->Execute($load_method_admin_titles_config_sql);
	
	if ($load_method_admin_titles_config_result->EOF) {
		
	} else {
		while (!$load_method_admin_titles_config_result->EOF) {
			$method_admin_titles[$method_num][$load_method_admin_titles_config_result->fields
				['language_id']] = $load_method_admin_titles_config_result->fields['title'];
			
			$load_method_admin_titles_config_result->MoveNext();
		}
	}
	
	// Get the catalog-side title for this method
	$method_titles = array();
	
	$load_method_titles_config_sql = "
		SELECT
			asmt.title,
			asmt.language_id
		FROM
			" . TABLE_ADVANCED_SHIPPER_METHOD_TITLES . " asmt
		WHERE
			asmt.config_id = '" . $config_id . "'
		AND
			asmt.method = '" . $method_num . "';";
	
	$load_method_titles_config_result = $db->Execute($load_method_titles_config_sql);
	
	if ($load_method_titles_config_result->EOF) {
		
	} else {
		while (!$load_method_titles_config_result->EOF) {
			$method_titles[$method_num][$load_method_titles_config_result->fields['language_id']] =
				$load_method_titles_config_result->fields['title'];
			
			$load_method_titles_config_result->MoveNext();
		}
	}
	
	if ($methods->fields['select_products'] == ADVSHIPPER_SELECT_PRODUCT_FALLOVER) {
		$method_uses_fallover = true;
	} else {
		$method_uses_fallover = false;
	}
	
	// Load the categories to which this shipping method applies (if any) //////////////////////////
	$categories = array();
	
	$load_categories_sql = "
		SELECT
			asmc.category_id
		FROM
			" . TABLE_ADVANCED_SHIPPER_METHOD_CATEGORIES . " asmc
		WHERE
			asmc.config_id = '" . $config_id . "'
		AND
			asmc.method = '" . $method_num . "'
		ORDER BY
			asmc.category_order;";
	
	$load_categories_result = $db->Execute($load_categories_sql);
	
	if ($load_categories_result->EOF) {
		// No categories for this method
	} else {
		while (!$load_categories_result->EOF) {
			$category_id = $load_categories_result->fields['category_id'];
			
			$category_name = advshipperGetGeneratedCategoryPath($category_id);
			
			$categories[] = array(
				'id' => $category_id,
				'name' => $category_name
				);
			
			$load_categories_result->MoveNext();
		}
	}
	
	// Load the manufacturers to which this shipping method applies (if any) ///////////////////////
	$manufacturers = array();
	
	$load_manufacturers_sql = "
		SELECT
			asmm.manufacturer_id
		FROM
			" . TABLE_ADVANCED_SHIPPER_METHOD_MANUFACTURERS . " asmm
		WHERE
			asmm.config_id = '" . $config_id . "'
		AND
			asmm.method = '" . $method_num . "'
		ORDER BY
			asmm.manufacturer_order;";
	
	$load_manufacturers_result = $db->Execute($load_manufacturers_sql);
	
	if ($load_manufacturers_result->EOF) {
		// No manufacturers for this method
	} else {
		while (!$load_manufacturers_result->EOF) {
			$manufacturer_id = $load_manufacturers_result->fields['manufacturer_id'];
			
			$manufacturer_name = advshipperGetManufacturerName($manufacturer_id);
			
			$manufacturers[] = array(
				'id' => $manufacturer_id,
				'name' => $manufacturer_name
				);
			
			$load_manufacturers_result->MoveNext();
		}
	}
	
	// Load the products to which this shipping method applies (if any) ////////////////////////////
	$products = array();
	
	$load_products_sql = "
		SELECT
			DISTINCT asmp.product_order,
			asmp.product_id
		FROM
			" . TABLE_ADVANCED_SHIPPER_METHOD_PRODUCTS . " asmp
		WHERE
			asmp.config_id = '" . $config_id . "'
		AND
			asmp.method = '" . $method_num . "'
		ORDER BY
			asmp.product_order;";
	
	$load_products_result = $db->Execute($load_products_sql);
	
	if ($load_products_result->EOF) {
		// No products for this method
	} else {
		while (!$load_products_result->EOF) {
			$product_id = $load_products_result->fields['product_id'];
			$product_order = $load_products_result->fields['product_order'];
			
			$product_name = zen_get_products_name($product_id, $_SESSION['languages_id']);
			
			$product_has_attributes = zen_has_product_attributes($product_id);
			
			if ($product_has_attributes) {
				// Have any product options been selected for this product?
				$load_product_options_sql = "
					SELECT
						asmp.product_attributes_id
					FROM
						" . TABLE_ADVANCED_SHIPPER_METHOD_PRODUCTS . " asmp
					WHERE
						asmp.config_id = '" . $config_id . "'
					AND
						asmp.method = '" . $method_num . "'
					AND
						asmp.product_order = '" . $product_order . "';";
				
				$load_product_options_result = $db->Execute($load_product_options_sql);
				
				if (!$load_product_options_result->EOF) {
					while (!$load_product_options_result->EOF) {
						$product_attributes_id =
							$load_product_options_result->fields['product_attributes_id'];
						
						$product_id .= '-' . $product_attributes_id;
						
						// Is this a catch-all?
						if ($product_attributes_id == 0) {
							$product_name .= TEXT_ALL_PRODUCT_OPTIONS_SELECTED;
						} else {
							$option_name_sql = "
								SELECT
									po.products_options_name
								FROM
									" . TABLE_PRODUCTS_OPTIONS . " po
								LEFT JOIN
									" . TABLE_PRODUCTS_ATTRIBUTES . " pa
								ON
									po.products_options_id = pa.options_id
								WHERE
									pa.products_attributes_id = '" . $product_attributes_id . "'
								AND
									po.language_id = '" . (int) $_SESSION['languages_id'] . "';";
							
							$option_value_name_sql = "
								SELECT
									pov.products_options_values_name
								FROM
									" . TABLE_PRODUCTS_OPTIONS_VALUES . " pov
								LEFT JOIN
									" . TABLE_PRODUCTS_ATTRIBUTES . " pa
								ON
									pov.products_options_values_id = pa.options_values_id
								WHERE
									pa.products_attributes_id = '" . $product_attributes_id . "'
								AND
									pov.language_id = '" . (int) $_SESSION['languages_id'] . "';";
							
							$option_name_result = $db->Execute($option_name_sql);
							$option_value_result = $db->Execute($option_value_name_sql);
							
							$product_name .= '<br />// ' .
								$option_name_result->fields['products_options_name'] . ' -- ' .
								$option_value_result->fields['products_options_values_name'];
						}
						
						$load_product_options_result->MoveNext();;
					}
				}
			}
			
			$products[] = array(
				'id' => $product_id,
				'name' => $product_name
				);
			
			$load_products_result->MoveNext();
		}
	}
	
	// Load the custom product field values to which this shipping method applies (if any) /////////
	// Only use functionality if custom product field key has been configured
	if ($custom_product_field_functionality && !is_null($custom_product_field_name)) {
		
		$custom_product_field_values = array();
		
		$load_custom_product_field_values_sql = "
			SELECT
				asmcpfv.field_value
			FROM
				" . TABLE_ADVANCED_SHIPPER_METHOD_CUSTOM_PRODUCT_FIELD_VALUES . " asmcpfv
			WHERE
				asmcpfv.config_id = '" . $config_id . "'
			AND
				asmcpfv.method = '" . $method_num . "'
			ORDER BY
				asmcpfv.field_value_order;";
		
		$load_custom_product_field_values_result = $db->Execute($load_custom_product_field_values_sql);
		
		if ($load_custom_product_field_values_result->EOF) {
			// No custom_product_field_values for this method
		} else {
			while (!$load_custom_product_field_values_result->EOF) {
				$field_value = $load_custom_product_field_values_result->fields['field_value'];
				
				// Look up and use title for field value, instead of value itself, if specified
				$field_value_title = advshipperGetCustomFieldValueTitle($field_value);
				
				if ($field_value_title == false) {
					// Fall back to using the value as the title
					$field_value_title = $field_value;
				}
				
				$custom_product_field_values[] = $field_value_title;
				
				$load_custom_product_field_values_result->MoveNext();
			}
		}
	}
	
	// Get the admin titles of the regions this method applies for
	$region_admin_titles = array();
	
	$load_region_admin_titles_config_sql = "
		SELECT
			asrat.region,
			asrat.language_id,
			asrat.title
		FROM
			" . TABLE_ADVANCED_SHIPPER_REGION_ADMIN_TITLES . " asrat
		WHERE
			asrat.config_id = '" . $config_id . "'
		AND
			asrat.method = '" . $method_num . "'
		ORDER BY
			asrat.region;";
	
	$load_region_admin_titles_config_result = $db->Execute($load_region_admin_titles_config_sql);
	
	if ($load_region_admin_titles_config_result->EOF) {
		
	} else {
		while (!$load_region_admin_titles_config_result->EOF) {
			$region_admin_titles[$load_region_admin_titles_config_result->fields['region']]
				[$load_region_admin_titles_config_result->fields['language_id']] =
				$load_region_admin_titles_config_result->fields['title'];
			
			$load_region_admin_titles_config_result->MoveNext();
		}
	}
	
	// Get the information about the regions this method applies for
	$region_info = array();
	
	$load_region_info_config_sql = "
		SELECT
			asrc.region,
			asrc.definition_method,
			asrc.countries_postcodes,
			asrc.countries_zones,
			asrc.countries_cities,
			asrc.countries_states,
			asrc.distance,
			asrc.tax_class,
			asrc.rates_include_tax,
			asrc.rate_limits_inc,
			asrc.total_up_price_inc_tax,
			asrc.table_of_rates,
			asrc.surcharge
		FROM
			" . TABLE_ADVANCED_SHIPPER_REGION_CONFIGS . " asrc
		WHERE
			asrc.config_id = '" . $config_id . "'
		AND
			asrc.method = '" . $method_num . "'
		ORDER BY
			asrc.region;";
	
	$load_region_info_config_result = $db->Execute($load_region_info_config_sql);
	
	if ($load_region_info_config_result->EOF) {
		$num_regions = 0;
	} else {
		while (!$load_region_info_config_result->EOF) {
			$region_info[] = $load_region_info_config_result->fields;
			
			$load_region_info_config_result->MoveNext();
		}
		
		$num_regions = sizeof($region_info);
	}
	
	?>
<fieldset class="AdvancedShipperMethod<?php echo (($method_num % 2 == 0) ? 'Even' : 'Odd'); ?>">
	<legend><?php
	echo TEXT_METHOD . ' ' . $method_num;
	if (strlen($method_admin_titles[$method_num][$_SESSION['languages_id']]) > 0) {
		echo ' - &ldquo;' . htmlentities($method_admin_titles[$method_num]
			[$_SESSION['languages_id']], ENT_COMPAT, CHARSET) . '&rdquo;';
	}
?></legend>
<?php
	// Don't collapse this method's display if errors must be displayed!
	if (!isset($collapse)) $collapse = true;
?>
	<table border="0" width="100%" cellpadding="0" cellspacing="0" id="method_<?php echo $method_num; ?>_config" <?php echo ($collapse == true ? 'class="Collapse"' : ''); ?>>
		<tr>
			<td valign="top" width="60%">
				<table border="0" width="100%" cellpadding="0" cellspacing="0">
					<tr>
						<td>
							<fieldset width="100%" class="AdvancedShipperMethodSummary<?php echo (($method_num % 2 == 0) ? 'Even' : 'Odd'); ?>">
								<legend>
								<?php
								echo TEXT_METHOD_TITLE;
								?>
								</legend>
								<table border="0" width="100%" cellpadding="0" cellspacing="0">
									<tr>
										<td class="AdvancedShipperConfigLabel"><label for="<?php echo "method_title_" . $method_num; ?>"><?php echo TEXT_LABEL_METHOD_TITLE; ?></label></td>
										<td class="AdvancedShipperConfigField" id="<?php echo "method_title_" . $method_num; ?>">
											<?php
											echo htmlentities($method_titles[$method_num]
												[$_SESSION['languages_id']], ENT_COMPAT, CHARSET);
											?>
										</td>
									</tr>
								</table>
							</fieldset>
						</td>
					</tr>
					<tr>
						<td>
							<fieldset width="100%" class="AdvancedShipperMethodSummary<?php echo (($method_num % 2 == 0) ? 'Even' : 'Odd'); ?>">
								<legend>
								<?php
								echo TEXT_CATEGORIES_MANUFACTURERS_PRODUCTS_SELECTION;
								?>
								</legend>
								<?php
								if ($method_uses_fallover) {
									echo '<p>' . TEXT_FALLOVER_PRODUCTS . '</p>';
								}
								
								$num_categories = sizeof($categories);
								
								if ($num_categories > 0) {
								?>
								<table border="0" width="100%" cellpadding="0" cellspacing="0">
									<tr>
										<td class="AdvancedShipperConfigLabel"><label for="categories_<?php echo $method_num; ?>"><?php echo TEXT_LABEL_CATEGORIES; ?></label></td>
										<td class="AdvancedShipperConfigField" id="categories_<?php echo $method_num; ?>">
											<?php
											for ($category_i = 0; $category_i < $num_categories;
													$category_i++) {
												echo '<p>' . $categories[$category_i]['name'] . '</p>';
											}
											?>
										</td>
									</tr>
								</table>
								<?php }
								
								
								$num_manufacturers = sizeof($manufacturers);
								
								if ($num_manufacturers > 0) {
								?>
								<table border="0" width="100%" cellpadding="0" cellspacing="0">
									<tr>
										<td class="AdvancedShipperConfigLabel"><label for="manufacturers_<?php echo $method_num; ?>"><?php echo TEXT_LABEL_MANUFACTURERS; ?></label></td>
										<td class="AdvancedShipperConfigField" id="manufacturers_<?php echo $method_num; ?>">
											<?php
											for ($manufacturer_i = 0;
													$manufacturer_i < $num_manufacturers;
													$manufacturer_i++) {
												echo '<p>' . $manufacturers[$manufacturer_i]['name'] . '</p>';
											}
											?>
										</td>
									</tr>
								</table>
								<?php }
								
								
								$num_products = sizeof($products);
								
								if ($num_products > 0) {
								?>
								<table border="0" width="100%" cellpadding="0" cellspacing="0">
									<tr>
										<td class="AdvancedShipperConfigLabel"><label for="products_<?php echo $method_num; ?>"><?php echo TEXT_LABEL_PRODUCTS; ?></label></td>
										<td class="AdvancedShipperConfigField" id="products_<?php echo $method_num; ?>">
											<?php
											for ($product_i = 0; $product_i < $num_products;
													$product_i++) {
												echo '<p>' . $products[$product_i]['name'] . '</p>';
											}
											?>
										</td>
									</tr>
								</table>
								<?php }
								
								
								if (isset($custom_product_field_values)) {
									$num_custom_product_field_values =
										sizeof($custom_product_field_values);
									
									if ($num_custom_product_field_values > 0) {
										// Build the label
										if (strlen(
												TEXT_ADVANCED_SHIPPER_CUSTOM_PRODUCT_FIELD_LABEL) > 0) {
											$label =
												TEXT_ADVANCED_SHIPPER_CUSTOM_PRODUCT_FIELD_LABEL;
										} else {
											$label = $custom_product_field_name;
										}
									?>
								<table border="0" width="100%" cellpadding="0" cellspacing="0">
									<tr>
										<td class="AdvancedShipperConfigLabel"><label for="custom_product_field_values_<?php echo $method_num; ?>"><?php echo $label; ?>:</label></td>
										<td class="AdvancedShipperConfigField" id="custom_product_field_values_<?php echo $method_num; ?>">
											<?php
											for ($cpfv_i = 0; $cpfv_i <
													$num_custom_product_field_values; $cpfv_i++) {
												echo '<p>' . $custom_product_field_values[$cpfv_i] .
													'</p>';
											}
											?>
										</td>
									</tr>
								</table>
								<?php }
								}
								
								
								if (!$method_uses_fallover && $num_categories == 0 &&
										$num_products == 0 && $num_manufacturers == 0 &&
										(!isset($custom_product_field_values) ||
										$num_custom_product_field_values == 0)) {
									echo '<p>' . htmlentities(
										TEXT_NO_CATEGORIES_MANUFACTURERS_PRODUCTS_SELECTIONS,
										ENT_COMPAT, CHARSET) . '</p>';
								}
								?>
							</fieldset>
						</td>
					</tr>
					<tr>
						<td colspan="2">
						<?php
						// Build the summary of the shipping regions for this method ///////////////
						for ($region_i = 0; $region_i < $num_regions; $region_i++) {
							$region_num = $region_i + 1;
						?>
							<fieldset width="100%" class="AdvancedShipperMethodSummary<?php echo (($method_num % 2 == 0) ? 'Even' : 'Odd'); ?> AdvancedShipperMethod<?php echo (($method_num % 2 == 0) ? 'Even' : 'Odd') .
								'Region' . ((($region_i + 1) % 2 == 0) ? 'Odd' : 'Even'); ?>">
								<legend>
								<?php
								echo TEXT_REGION . ' ' . $region_num;
								?>
								</legend>
								<table border="0" width="100%" cellpadding="0" cellspacing="0">
							<?php
							if (strlen($region_admin_titles[$region_num][$_SESSION['languages_id']]) > 0) { ?>
									<tr>
										<td class="AdvancedShipperConfigLabel"><label for="<?php echo "region_admin_titles_" . $method_num . "_" . $region_num; ?>"><?php echo TEXT_LABEL_REGION_ADMIN_TITLE; ?></label></td>
										<td class="AdvancedShipperConfigField" id="<?php echo "region_admin_titles_" . $method_num . "_" . $region_num; ?>">
								<?php
									echo '&ldquo;'  . htmlentities($region_admin_titles[$region_num][$_SESSION['languages_id']], ENT_COMPAT, CHARSET) . '&rdquo;';
								?>
										</td>
									</tr>
							<?php
							}
							?>
							<?php
							if (isset($region_titles) && isset($region_titles[$region_num]) && isset($region_titles[$region_num][$_SESSION['languages_id']]) && strlen($region_titles[$region_num][$_SESSION['languages_id']]) > 0) { ?>
									<tr>
										<td class="AdvancedShipperConfigLabel"><label for="<?php echo "region_titles_" . $method_num . "_" . $region_num; ?>"><?php echo TEXT_LABEL_REGION_TITLE; ?></label></td>
										<td class="AdvancedShipperConfigField" id="<?php echo "region_titles_" . $method_num . "_" . $region_num; ?>">
								<?php
									echo '&ldquo;'  . htmlentities($region_titles[$region_num][$_SESSION['languages_id']], ENT_COMPAT, CHARSET) . '&rdquo;';
								?>
										</td>
									</tr>
							<?php
							}
							?>
									<?php
									if($region_info[$region_i]['definition_method'] == ADVSHIPPER_DEFINITION_METHOD_ADDRESS_MATCHING
										&& strlen($region_info[$region_i]['countries_postcodes']) > 0) {
									?>
									<tr>
										<td class="AdvancedShipperConfigLabel"><label for="<?php echo "countries_postcodes_" . $method_num . "_" . $region_i; ?>"><?php echo TEXT_LABEL_COUNTRIES_POSTCODES; ?></label></td>
										<td class="AdvancedShipperConfigField" id="<?php echo "countries_postcodes_" . $method_num . "_" . $region_i; ?>">
											<?php
											// Replace commas with a comma and a space to prevent
											// long lines
											echo '<p>' . str_replace(',', ', ', $region_info[$region_i]['countries_postcodes']) . '</p>';
											?>
										</td>
									</tr>
									<?php
									}
									if($region_info[$region_i]['definition_method'] == ADVSHIPPER_DEFINITION_METHOD_ADDRESS_MATCHING
										&& strlen($region_info[$region_i]['countries_zones']) > 0) {
									?>
									<tr>
										<td class="AdvancedShipperConfigLabel"><label for="<?php echo "countries_zones_" . $method_num . "_" . $region_i; ?>"><?php echo TEXT_LABEL_COUNTRIES_ZONES; ?></label></td>
										<td class="AdvancedShipperConfigField" id="<?php echo "countries_zones_" . $method_num . "_" . $region_i; ?>">
											<?php
											$countries_zones_info = advshipper_zones_get_ids_and_names_for_zones_string($region_info[$region_i]['countries_zones']);
											
											$num_zones = sizeof($countries_zones_info);
											
											if ($num_zones > 0) {
												foreach ($countries_zones_info as $country_zone) {
													echo '<p>' . htmlentities($country_zone['name'], ENT_COMPAT, CHARSET) . '</p>';
												}
											}
											?>
										</td>
									</tr>
									<?php
									}
									if($region_info[$region_i]['definition_method'] == ADVSHIPPER_DEFINITION_METHOD_ADDRESS_MATCHING
										&& strlen($region_info[$region_i]['countries_states']) > 0) {
									?>
									<tr>
										<td class="AdvancedShipperConfigLabel"><label for="<?php echo "countries_states_" . $method_num . "_" . $region_i; ?>"><?php echo TEXT_LABEL_COUNTRIES_STATES; ?></label></td>
										<td class="AdvancedShipperConfigField" id="<?php echo "countries_states_" . $method_num . "_" . $region_i; ?>">
											<?php
											$countries_states_info = localities_parse_identifiers_string($region_info[$region_i]['countries_states']);
											
											$num_states = sizeof($countries_states_info);
											
											if ($num_states > 0) {
												foreach ($countries_states_info as $country_state) {
													echo '<p>' . htmlentities(localities_get_level_2_locality_name($country_state['level_2_id'], null, true), ENT_COMPAT, CHARSET) . '</p>';
												}
											}
											?>
										</td>
									</tr>
									<?php
									}
									if($region_info[$region_i]['definition_method'] == ADVSHIPPER_DEFINITION_METHOD_ADDRESS_MATCHING
										&& strlen($region_info[$region_i]['countries_cities']) > 0) {
									?>
									<tr>
										<td class="AdvancedShipperConfigLabel"><label for="<?php echo "countries_cities_" . $method_num . "_" . $region_i; ?>"><?php echo TEXT_LABEL_COUNTRIES_CITIES; ?></label></td>
										<td class="AdvancedShipperConfigField" id="<?php echo "countries_cities_" . $method_num . "_" . $region_i; ?>">
											<?php
											$countries_cities_info = localities_parse_identifiers_string($region_info[$region_i]['countries_cities']);
											
											$num_cities = sizeof($countries_cities_info);
											
											if ($num_cities > 0) {
												foreach ($countries_cities_info as $country_city) {
													echo '<p>' . htmlentities(localities_get_level_3_locality_name($country_city['level_3_id'], null, true), ENT_COMPAT, CHARSET) . '</p>';
												}
											}
											?>
										</td>
									</tr>
									<?php
									}
									if($region_info[$region_i]['definition_method'] == ADVSHIPPER_DEFINITION_METHOD_GEOLOCATION) {
									?>
									<tr>
										<td class="AdvancedShipperConfigLabel"><label for="<?php echo "distance_" . $method_num . "_" . $region_i; ?>"><?php echo TEXT_LABEL_DISTANCE; ?></label></td>
										<td class="AdvancedShipperConfigField" id="<?php echo "distance_" . $method_num . "_" . $region_i; ?>">
											<?php
											echo '<p>' . htmlentities($region_info[$region_i]['distance'], ENT_COMPAT, CHARSET) . '</p>';
											?>
										</td>
									</tr>
									<?php
									}
									?>
									<tr>
										<td class="AdvancedShipperConfigLabel"><label for="<?php echo "table_of_rates_" . $method_num . "_" . $region_i; ?>"><?php echo TEXT_LABEL_TABLE_OF_RATES; ?></label></td>
										<td class="AdvancedShipperConfigField" id="<?php echo "table_of_rates_" . $method_num . "_" . $region_i; ?>">
											<?php
											// Replace commas with a comma and a space to prevent
											// long lines
											if (strlen(trim($region_info[$region_i]['table_of_rates'])) == 0) {
												echo '<p>' . TEXT_REGION_HAS_NO_RATES . '</p>';
											} else {
												echo '<p>' . htmlentities(str_replace(',', ', ', $region_info[$region_i]['table_of_rates']), ENT_COMPAT, CHARSET) . '</p>';
											}
											?>
										</td>
									</tr>
									<tr>
										<td class="AdvancedShipperConfigLabel"><label for="<?php echo "surcharge_" . $method_num . "_" . $region_i; ?>"><?php echo TEXT_LABEL_SURCHARGE; ?></label></td>
										<td class="AdvancedShipperConfigField" id="<?php echo "surcharge_" . $method_num . "_" . $region_i; ?>">
											<?php
											// Replace commas with a comma and a space to prevent
											// long lines
											if (strlen(trim($region_info[$region_i]['surcharge'])) == 0) {
												echo '<p>' . TEXT_REGION_HAS_NO_SURCHARGE . '</p>';
											} else {
												echo '<p>' . htmlentities(str_replace(',', ', ', $region_info[$region_i]['surcharge']), ENT_COMPAT, CHARSET) . '</p>';
											}
											?>
										</td>
									</tr>
								</table>
							</fieldset>
						<?php
						}
						if ($num_regions == 0) {
						?>
							<fieldset width="100%" class="AdvancedShipperMethodSummary<?php echo (($method_num % 2 == 0) ? 'Even' : 'Odd'); ?>">
								<legend>
								<?php
								echo TEXT_REGIONS;
								?>
								</legend>
								<p class="NoRegionsDefined"><?php echo htmlentities(TEXT_NO_REGIONS_DEFINED, ENT_COMPAT, CHARSET); ?></p>
							</fieldset>
						<?php
						}
						?>
						</td>
					</tr>
				</table>
			</td>
			<td class="AdvancedShipperConfigButtonPanel" style="padding-left: 1.5em; padding-bottom: 1em;">
				<fieldset width="100%" class="AdvancedShipperMethodSummary<?php echo (($method_num % 2 == 0) ? 'Even' : 'Odd'); ?>">
					<legend>
					<?php
					echo TEXT_INSERT_METHODS_TITLE;
					?>
					</legend>
					<?php
					$insert_select = zen_draw_pull_down_menu('insert_num_shipping_methods_' . $method_num, $insert_select_values);
					echo '<p>' . TEXT_INSERT_METHODS . '</p>';
					echo '<p>' . $insert_select . ' ' . zen_image_submit('button_insert_before.gif', TEXT_INSERT_METHOD, 'name="insert_' . $method_num . '" value="' . $method_num . '"') . '</p>';
					?>
				</fieldset>
				<fieldset width="100%" class="AdvancedShipperMethodSummary<?php echo (($method_num % 2 == 0) ? 'Even' : 'Odd'); ?>">
					<legend>
					<?php
					echo TEXT_COPY_METHOD_TITLE;
					?>
					</legend>
					<?php
					$num_copies_select = zen_draw_pull_down_menu('copy_num_shipping_methods_' . $method_num, $num_copies_select_values);
					$copy_to_select = zen_draw_pull_down_menu('copy_to_' . $method_num, $copy_to_select_values, $method_num);
					echo '<p>' . TEXT_COPY_METHODS . '</p>';
					echo '<p>' . $num_copies_select  . ' ' . $copy_to_select. ' ' . zen_image_submit('button_copy.gif', TEXT_COPY_METHOD, 'name="copy_' . $method_num . '" value="' . $method_num . '"') . '</p>';
					?>
				</fieldset>
				<fieldset width="100%" class="AdvancedShipperMethodSummary<?php echo (($method_num % 2 == 0) ? 'Even' : 'Odd'); ?>">
					<legend>
					<?php
					echo TEXT_DELETE_METHOD_TITLE;
					?>
					</legend>
					<?php
					echo '<p>' . zen_image_submit('button_delete.gif', TEXT_DELETE_METHOD, 'name="delete_' . $method_num . '" value="' . $method_num . '" onClick="javascript:return advshipperConfirmDeletion();"') . '</p>';
					?>
				</fieldset>
			</td>
		</tr>
	</table>
	<table border="0" width="100%" cellpadding="0" cellspacing="0">
		<tr>
			<td>
<?php
	echo '<a href="#" onclick="return advshipperToggleMethod(' . $method_num . ', this, \'' . TEXT_HIDE_METHOD . '\', \'' . TEXT_SHOW_METHOD . '\');">';
	if ($collapse) {
		// Display control to show hidden content
		echo TEXT_SHOW_METHOD . '</a>';
	} else {
		// Display control to hide content
		echo TEXT_HIDE_METHOD . '</a>';
	}
?>
			</td>
			<td class="AdvancedShipperConfigButtonPanel">
				<p>
					<a href="<?php echo zen_href_link(FILENAME_ADVANCED_SHIPPER, 'toggle_method=' . $method_num . '&amp;page=' . $_GET['page']); ?>" style="margin-right: 5px"><?php
	if ($methods->fields['enabled'] == 1) {
		echo zen_image(DIR_WS_IMAGES . 'icon_green_on.gif', TEXT_METHOD_ENABLED_DISABLE_METHOD);
	} else {
		echo zen_image(DIR_WS_IMAGES . 'icon_red_on.gif', TEXT_METHOD_DISABLED_ENABLE_METHOD);
	}?></a>
					<a href="<?php echo zen_href_link(FILENAME_ADVANCED_SHIPPER_METHOD_CONFIG, 'config_id=' . $config_id . '&amp;method_num=' . $method_num . '&amp;page=' . $_GET['page']); ?>"><?php echo zen_image_button('button_edit.gif', TEXT_EDIT_METHOD); ?></a>
				</p>
			</td>
		</tr>
	</table>
</fieldset>
<?php
	$methods->MoveNext();
}
// Only display add method button if on the last page
if ($num_pages == $_GET['page']) {
	if ($num_of_rows == 0) {
?>
	<p style="margin: 0 0 0.7em 0.4em;"><?php echo TEXT_NO_METHODS_DEFINED_YET_INSERT; ?></p>
	<p style="margin: 0 0 0.3em 0.4em;">
		<a href="<?php echo zen_href_link(FILENAME_ADVANCED_SHIPPER_METHOD_CONFIG, 'config_id=' .
			$config_id . '&amp;method_num=' . ($num_shipping_methods + 1) . '&amp;add=true&amp;page=' .
			$_GET['page']); ?>"><?php echo zen_image_button('button_insert.gif', TEXT_ADD_METHOD); ?></a>
	</p>
<?php
	} else {
	if (!empty($num_of_rows) && $num_of_rows > 1) {
		echo '<a href="#" name="selectAdvshipperToggleAllMethods" data-val="' . ($collapse ? 'true' : 'false') . '" onclick="return advshipperToggleAllMethods(this, \'' . TEXT_HIDE_ALL_METHODS . '\', \'' . TEXT_SHOW_ALL_METHODS . '\');">';
		if (!empty($collapse)) {
			// Display control to show hidden content
			echo TEXT_SHOW_ALL_METHODS . '</a>';
		} else {
			// Display control to hide content
			echo TEXT_HIDE_ALL_METHODS . '</a>';
		}
	}

?>
	<p style="padding: 1.2em 0 1.2em 2px;"><a href="<?php
		echo zen_href_link(FILENAME_ADVANCED_SHIPPER_METHOD_CONFIG, 'config_id=' . $config_id .
			'&amp;method_num=' . ($num_shipping_methods + 1) . '&amp;add=true&amp;page=' . $_GET['page']); ?>"><?php
		echo zen_image_button('button_insert.gif', TEXT_ADD_METHOD); ?></a></p>
<?php
	}
}
?>
						</form>
					</td>
				</tr>
<?php if ($num_of_rows > 0) { ?>
				<tr>
					<td>
						<table cellpadding="0" cellspacing="0" border="0" width="100%">
							<tr>
								<td class="smallText" valign="top"><?php echo $methods_split->display_count($num_of_rows, MAX_DISPLAY_SEARCH_RESULTS_ORDERS, $_GET['page'], TEXT_DISPLAY_NUMBER_OF_METHODS); ?></td>
								<td class="smallText" align="right"><?php echo $methods_split->display_links($num_of_rows, MAX_DISPLAY_SEARCH_RESULTS_ORDERS, MAX_DISPLAY_PAGE_LINKS, $_GET['page'], zen_get_all_get_params(array('page', 'oID', 'action'))); ?></td>
							</tr>
						</table>
					</td>
				</tr>
<?php } ?>
							</table>
							</fieldset>
						</div>
					</td>
				</tr><?php }?>
				<tr>
					<td>
						<div id="footer">
							<p><a href="http://dev.ceon.net/web" target="_blank"><img src="<?php echo DIR_WS_IMAGES; ?>ceon-button-logo.png" alt="Ceon" id="ceon-button-logo" /></a>Module 
								&copy; Copyright 2007-<?php echo (date('Y') > 2012 ? date('Y') : 2012); ?>
								<a href="http://dev.ceon.net/web" target="_blank">Ceon</a>
							</p>
						</div>
					</td>
				</tr>
			</table>
		</td>
<!-- body_text_eof //-->
	</tr>
</table>
<!-- body_eof //-->

<!-- footer //-->
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<!-- footer_eof //-->
</body>
</html>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>