<?php

/**
 * Displays a list of the custom product field values for the site so they can be selected to be
 * added to the list of values to which a shipping method applies.
 *
 * @package     ceon_advanced_shipper
 * @author      Conor Kerr <zen-cart.advanced-shipper@dev.ceon.net>
 * @copyright   Copyright 2012 Ceon
 * @copyright   Portions Copyright 2003-2006 Zen Cart Development Team
 * @copyright   Portions Copyright 2003 osCommerce
 * @link        http://dev.ceon.net/web/zen-cart/advanced-shipper
 * @license     http://www.gnu.org/copyleft/gpl.html   GNU Public License V2.0
 * @version     $Id: advshipper_cpfv_selector.php 578 2012-01-05 18:50:09Z conor $
 */

require('includes/application_top.php');

$languages = zen_get_languages();

require_once(DIR_WS_FUNCTIONS . 'advshipper.php');

require_once(DIR_WS_FUNCTIONS . 'advshipper_custom_product_field_functions.php');

// Get the name (key) of the custom product field
$config_id = 1;

$custom_product_field_name_sql = "
	SELECT
		custom_product_field_name		
	FROM
		" . TABLE_ADVANCED_SHIPPER_CONFIGS . "
	WHERE
		config_id = '" . $config_id . "';";

$custom_product_field_name_result = $db->Execute($custom_product_field_name_sql);

$custom_product_field_name =
	trim($custom_product_field_name_result->fields['custom_product_field_name']);

if (!is_null($custom_product_field_name) && strlen($custom_product_field_name) == 0) {
	// Error!
	$custom_product_field_name = null;
}

if (!is_null($custom_product_field_name)) {
	// Build the title for the field
	
	if (strlen(TEXT_ADVANCED_SHIPPER_CUSTOM_PRODUCT_FIELD_LABEL) > 0) {
		$custom_product_field_title = TEXT_ADVANCED_SHIPPER_CUSTOM_PRODUCT_FIELD_LABEL;
		
	} else {
		$custom_product_field_title =
			sprintf(TEXT_CURRENT_CUSTOM_PRODUCT_FIELD_VALUES_FOR, $custom_product_field_name);
	}

	$cpfvs = advshipperGetCustomFieldValueOptions($custom_product_field_name);
	
	$num_cpfvs = sizeof($cpfvs);
	
} else {
	$num_cpfvs = 0;
}

?>
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
	<title><?php echo HEADING_TITLE; ?></title>
	<link rel="stylesheet" type="text/css" href="includes/stylesheet.css">
	<link rel="stylesheet" type="text/css" href="includes/cssjsmenuhover.css" media="all" id="hoverJS">
	<script language="javascript" type="text/javascript" src="includes/menu.js"></script>
	<script language="javascript" type="text/javascript" src="includes/general.js"></script>
	<style type="text/css">
	.AdvancedShipperPageHeading { padding: 0.2em; padding-bottom: 1.2em; }
	fieldset { padding: 0.8em 0.8em; margin-bottom: 2.5em; }
	legend { font-weight: bold; font-size: 1.3em; }
	
	fieldset { background: #f7f6f0; box-shadow: inset 0px 0px 5px 1px #e6e5de; }
	
	.AdvancedShipperConfigLabel, .AdvancedShipperConfigField, .AdvancedShipperConfigDesc {
		vertical-align: top;
	}
	.AdvancedShipperConfigLabel {
		font-weight: bold;
		font-size: 1.05em;
		line-height: 1.3;
		padding-right: 1em;
	}
	.AdvancedShipperConfigLabel { width: 25%; }
	.AdvancedShipperConfigField { padding-top: 0.5em; padding-bottom: 1.3em; }
	.AdvancedShipperConfigIntro { padding-top: 0.5em; padding-bottom: 1.1em; }
	
	select {
		padding: 4px;
		font-size: 1.1em;
	}
	</style>
	<!--[if IE]>
	<style type="text/css">
	fieldset {
		position: relative;
		padding-top: 2.2em;
		margin-bottom: 1.8em;
	}
	legend {
		position: absolute;
		top: -0.55em;
		left: .2em;
		padding: 0;
	}
	</style>
	<![endif]-->
</head>
<body>

<?php
// Display alerts/error messages, if any
if (isset($advshipper_custom_product_field_errors) &&
		is_array($advshipper_custom_product_field_errors) &&
		sizeof($advshipper_custom_product_field_errors) > 0) {
	foreach ($advshipper_custom_product_field_errors as $error) {
		$messageStack->add($error, 'error');
	}
}

if ($messageStack->size > 0) {
	echo $messageStack->output();
}
?>

<!-- body //-->
<table border="0" width="100%" cellspacing="2" cellpadding="2">
	<tr>
<!-- body_text //-->
		<td width="100%" valign="top">
			<table border="0" width="100%" cellspacing="0" cellpadding="0">
				<tr>
					<td class="pageHeading AdvancedShipperPageHeading"><?php
						echo sprintf(HEADING_TITLE, $custom_product_field_title); ?></td>
				</tr>
				<tr>
					<td>
						<?php
						echo zen_draw_form('cpfv-form',
							FILENAME_ADVANCED_SHIPPER_CUSTOM_PRODUCT_FIELD_VALUES_SELECTOR, '',
							'post');
						
						echo zen_hide_session_id();
						?>
						<script language="javascript"  type="text/javascript">
						<!--
function CustomProductFieldValuesSelected()
{
	cpfv_values_el = document.getElementById('cpfv-values');
	
	if (cpfv_values_el == undefined) {
		return;
	}
	
	var cpfv_values_selected = new Array();
	
	for (var i = 0; i < cpfv_values_el.options.length; i++) {
		if (cpfv_values_el.options[i].selected) {
			cpfv_values_selected.push(cpfv_values_el.options[i].value);
		}
	}
	
	var cpfv_values_selected_string = cpfv_values_selected.join('--cpfv--');
	
	window.opener.advshipperAddCustomProductFieldValues(cpfv_values_selected_string);
	
	window.close();
}

function CustomProductFieldValuesSelectionCancelled()
{
	window.close();
}
						//-->
						</script>
						<fieldset id="cpfv-selection">
							<legend><?php echo sprintf(
								TEXT_CUSTOM_PRODUCT_FIELD_VALUES_SELECTION_TITLE,
								$custom_product_field_title); ?></legend>
							<table border="0" width="100%" cellpadding="0" cellspacing="0">
								<tr>
									<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="country"><?php
									if (strlen(
											TEXT_ADVANCED_SHIPPER_CUSTOM_PRODUCT_FIELD_LABEL) > 0) {
										$label = TEXT_ADVANCED_SHIPPER_CUSTOM_PRODUCT_FIELD_LABEL;
										
									} else {
										$label = $custom_product_field_name;
									}
									
									echo $label; ?>:</label></td>
								</tr>
								<tr>
									<td class="AdvancedShipperConfigField">
										<?php if ($num_cpfvs > 0) {
											$select_size = 15;
											
											if ($num_cpfvs < $select_size) {
												$select_size = $num_cpfvs;
											}
											
											echo zen_draw_pull_down_menu('cpfv-values',
												$cpfvs, '',
												'id="cpfv-values" multiple="multiple" size="' .
												$select_size . '"');
											
											echo '<p>' . sprintf(
												TEXT_SELECT_MULTIPLE_CUSTOM_PRODUCT_FIELD_VALUES,
												$custom_product_field_title) . '</p>';
										} else {
											echo sprintf(TEXT_NO_CUSTOM_PRODUCT_FIELD_VALUES,
												$custom_product_field_title);
										}?>
									</td>
								</tr>
							</table>
						</fieldset>
						<?php if (sizeof($cpfvs) > 0) {
							echo zen_draw_input_field('cpfvs_select_submit', IMAGE_SELECT,
								'id="cpfvs_select_submit"' .
								' onclick="javascript:CustomProductFieldValuesSelected(); return false;"',
								false, 'submit');
						}
						
						echo ' ' . zen_draw_input_field('cpfvs_cancel_submit', IMAGE_CANCEL,
							'id="cpfvs_cancel_submit"' .
							' onclick="javascript:CustomProductFieldValuesSelectionCancelled(); return false;"',
							false, 'submit');
						?>
						</form>
					</td>
				</tr>
			</table>
		</td>
<!-- body_text_eof //-->
	</tr>
</table>
<!-- body_eof //-->

</body>
</html>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>