<?php

/**
 * @package     ceon_advanced_shipper
 * @author      Conor Kerr <zen-cart.advanced-shipper@dev.ceon.net>
 * @author      Waqas Hussain <waqas20@gmail.com>
 * @copyright   Copyright 2007-2018 Ceon
 * @copyright   Portions Copyright 2003-2006 Zen Cart Development Team
 * @copyright   Portions Copyright 2003 osCommerce
 * @link        http://dev.ceon.net/web/zen-cart/advanced-shipper
 * @license     http://www.gnu.org/copyleft/gpl.html   GNU Public License V2.0
 * @version     $Id: advshipper_region_config.php 981 2012-03-27 16:28:46Z conor $ Updated v6.0.2
 */

require('includes/application_top.php');

require(DIR_WS_CLASSES . 'currencies.php');
$currencies = new currencies();

$languages = zen_get_languages();

require_once(DIR_WS_FUNCTIONS . 'advshipper.php');


$method_num = isset($_GET['method']) ? (int) $_GET['method'] : null;

$region_num = isset($_GET['region']) ? (int) $_GET['region'] : null;

$update_region = isset($_GET['update_region']) ? ($_GET['update_region'] == 'true' ? true : false) : false;

/**
 * Variables hold values for the region
 */
$region_admin_titles = array();

$region_titles = array();
	
$definition_method = ADVSHIPPER_DEFINITION_METHOD_ADDRESS_MATCHING;

$countries_postcodes = null;

$countries_cities = null;

$countries_states = null;

$distance = null;

$tax_class = null;

$rates_include_tax = ADVSHIPPER_RATES_INC_TAX_INC;

$rate_limits_inc = ADVSHIPPER_RATE_LIMITS_INC_INC;

$total_up_price_inc_tax = ADVSHIPPER_TOTAL_UP_PRICE_INC_TAX_EXC;

$table_of_rates = null;

$max_weight_per_package = null;

$packaging_weights = null;

$surcharge = null;

$surcharge_titles = array();


$ups_calculator_enabled = false;

$ups_source_country = SHIPPING_ORIGIN_COUNTRY;

$ups_source_postcode = SHIPPING_ORIGIN_ZIP;

$ups_pickup_method = 'CC';

$ups_packaging = 'CP';

$ups_delivery_type = 'RES';

$ups_shipping_service_1dm = 1;
$ups_shipping_service_1dml = 1;
$ups_shipping_service_1da = 1;
$ups_shipping_service_1dal = 1;
$ups_shipping_service_1dapi = 1;
$ups_shipping_service_1dp = 1;
$ups_shipping_service_1dpl = 1;
$ups_shipping_service_2dm = 1;
$ups_shipping_service_2dml = 1;
$ups_shipping_service_2da = 1;
$ups_shipping_service_2dal = 1;
$ups_shipping_service_3ds = 1;
$ups_shipping_service_gnd = 1;
$ups_shipping_service_std = 1;
$ups_shipping_service_xpr = 1;
$ups_shipping_service_xprl = 1;
$ups_shipping_service_xdm = 1;
$ups_shipping_service_xdml = 1;
$ups_shipping_service_xpd = 1;
$ups_shipping_service_wxs = 1;


$usps_calculator_enabled = false;

$usps_user_id = 'NONE';

$usps_server = 't';

$usps_source_country = SHIPPING_ORIGIN_COUNTRY;

$usps_source_postcode = SHIPPING_ORIGIN_ZIP;

$usps_machinable = 0;

$usps_display_transit_time = 1;

$usps_domestic_express = 1;
$usps_domestic_priority = 1;
$usps_domestic_first_class = 1;
$usps_domestic_retail_ground = 1;
$usps_domestic_media = 1;
$usps_domestic_bpm = 1;
$usps_domestic_library = 1;

$usps_international_geg = 1;
$usps_international_geg_d = 0;
$usps_international_geg_ndr = 1;
$usps_international_geg_ndnr = 1;
$usps_international_geg_e = 1;
$usps_international_emi = 1;
$usps_international_emi_fre = 1;
$usps_international_emi_lfre = 0;
$usps_international_pmi = 1;
$usps_international_pmi_sfrb = 1;
$usps_international_pmi_mfrb = 1;
$usps_international_pmi_lfrb = 1;
$usps_international_pmi_dfrb = 0;
$usps_international_pmi_lvfrb = 0;
$usps_international_pmi_fre = 1;
$usps_international_pmi_sfre = 1;
$usps_international_pmi_pfre = 0;
$usps_international_pmi_gcfre = 0;
$usps_international_pmi_lfre = 0;
$usps_international_fcmi_le = 1;
$usps_international_fcmi_p = 1;
$usps_international_fcmi_l = 1;


$fedex_calculator_enabled = false;

$fedex_source_country = SHIPPING_ORIGIN_COUNTRY;

$fedex_source_postcode = SHIPPING_ORIGIN_ZIP;

$fedex_key = '';
$fedex_password = '';
$fedex_account = '';
$fedex_meter = '';

$fedex_server = 'p';
$fedex_weight_units = 'lb';
$fedex_rate_request_types = 1;
$fedex_drop_off_type = 'REGULAR_PICKUP';
$fedex_packaging_type = 'YOUR_PACKAGING';

$fedex_shipping_saturday = 1;

$fedex_shipping_service_europe_first_international_priority = 1;
$fedex_shipping_service_fedex_1_day_freight = 1;
$fedex_shipping_service_fedex_2_day = 1;
$fedex_shipping_service_fedex_2_day_freight = 1;
$fedex_shipping_service_fedex_3_day_freight = 1;
$fedex_shipping_service_fedex_express_saver = 1;
$fedex_shipping_service_fedex_ground = 1;
$fedex_shipping_service_first_overnight = 1;
$fedex_shipping_service_ground_home_delivery = 1;
$fedex_shipping_service_international_economy = 1;
$fedex_shipping_service_international_economy_freight = 1;
$fedex_shipping_service_international_first = 1;
$fedex_shipping_service_international_priority = 1;
$fedex_shipping_service_international_priority_freight = 1;
$fedex_shipping_service_priority_overnight = 1;
$fedex_shipping_service_smart_post = 1;
$fedex_shipping_service_standard_overnight = 1;
$fedex_shipping_service_fedex_freight = 1;
$fedex_shipping_service_fedex_national_freight = 1;
$fedex_shipping_service_international_ground = 1;
?>
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
	<title><?php echo HEADING_TITLE; ?></title>
	<link rel="stylesheet" type="text/css" href="includes/stylesheet.css">
	<link rel="stylesheet" type="text/css" href="includes/cssjsmenuhover.css" media="all" id="hoverJS">
	<script language="javascript" type="text/javascript" src="includes/menu.js"></script>
	<script language="javascript" type="text/javascript" src="includes/general.js"></script>
	<script language="JavaScript" type="text/javascript">
	<!--
	var language_ids = new Array();
		<?php
			// Record the language IDs so the javascript functions can access these fields
			for ($language_i = 0, $n = sizeof($languages); $language_i < $n; $language_i++) {
				echo "\t" . 'language_ids[' . $language_i . '] = ' . $languages[$language_i]['id'] . ";\n";
			}
		?>
	// -->
	</script>
	<script language="javascript"  type="text/javascript">
	<!--
<?php require(DIR_WS_INCLUDES . 'javascript/ceon/adv_shipper/advshipper_region_config.php'); ?>
	//-->
	</script>
	
	<script type="text/javascript">
		<!--
		function init()
		{
			cssjsmenu('navbar');
			if (document.getElementById)
			{
				var kill = document.getElementById('hoverJS');
				kill.disabled = true;
			}
		}
		// -->
	</script>
	<style type="text/css">
	.AdvancedShipperPageHeading { padding: 0.2em; padding-bottom: 0.8em; }
	fieldset { padding: 0.8em 0.8em; margin-bottom: 2.5em; }
	fieldset fieldset { margin-bottom: 1em; box-shadow: inset 0px 0px 8px 1px #e3e3e3; }
	legend { font-weight: bold; font-size: 1.3em; }
	
	fieldset#advanced_shipper_general_config { background: #f7f6f0; }
	
	.AdvancedShipperRegionOdd {
		background-color: #d0d0d0;
	}
	.AdvancedShipperRegionEven {
		background-color: #f3f3f3;
	}	.AdvancedShipperRegionOddConfigPanel{
		background-color: #d9d9d9;
	}
	.AdvancedShipperRegionEvenConfigPanel {
		background-color: #fafafa;
	}
	
	.AdvancedShipperConfigLabel, .AdvancedShipperConfigField, .AdvancedShipperConfigDesc,
	.AdvancedShipperConfigButtonPanel, .AdvancedShipperExtendedConfigField {
		vertical-align: top;
	}
	.AdvancedShipperConfigLabel {
		font-weight: bold;
		font-size: 1.05em;
		line-height: 1.3;
		padding-right: 1em;
	}
	.AdvancedShipperConfigLabel { width: 26%; }
	.AdvancedShipperConfigDesc p { margin-bottom: 0.8em; }
	.AdvancedShipperConfigField { padding-top: 0.5em; padding-bottom: 1.3em; }
	.AdvancedShipperConfigIntro { padding-top: 0.5em; padding-bottom: 1.1em; }
	.AdvancedShipperConfigButtonPanel { text-align: right; margin-bottom: 0.8em; }
	
	.AdvancedShipperExtendedConfigField { padding-bottom: 1.3em; }
	
	.ErrorIntro { margin: 2em 0; color: #f00; }
	.FormError { font-weight: bold; color: #f00; }
	
	.Collapse { display:  none; }
	
	input.Textfield, textarea {
		background: #fff url(<?php echo DIR_WS_IMAGES; ?>ceon-input-fade-tb-gray-white.png) repeat-x left top;
		border: 1px solid #ccc;
		color: #000;
		padding: 4px;
		font-size: 1.1em;
		line-height: 1;
	}
	input.Textfield:hover, input.Textfield:focus, textarea:hover, textarea:focus {
		border: 1px solid #999;
	}
	
	textarea {
		line-height: 1.3;
	}
	
	select {
		padding: 4px;
		font-size: 1.1em;
	}
	</style>
	<!--[if IE]>
	<style type="text/css">
	fieldset, fieldset fieldset {
		position: relative;
		padding-top: 2.2em;
		margin-bottom: 1.8em;
	}
	legend {
		position: absolute;
		top: -0.55em;
		left: .2em;
		padding: 0;
	}
	input.Textfield {
		height: 1.8em;
	}
	</style>
	<![endif]-->
	<script language="JavaScript" type="text/javascript" src="<?php echo DIR_WS_INCLUDES . 'javascript/ceon/adv_shipper/cba.js' ?>"></script>
</head>
<body onload="advshipperInitRegionConfig();">
<?php if (defined('ADVSHIPPER_ZONES_SUPPORT') && ADVSHIPPER_ZONES_SUPPORT == 'Yes') { ?>
<script language="javascript"  type="text/javascript">
<!--
<?php require(DIR_WS_INCLUDES . 'javascript/ceon/adv_shipper/advshipper_region_config_zones.js'); ?>
//-->
</script>
<?php } ?>
<?php if (defined('ADVSHIPPER_LOCALITY_SUPPORT') && ADVSHIPPER_LOCALITY_SUPPORT == 'Yes') { ?>
<script language="javascript"  type="text/javascript">
<!--
<?php require(DIR_WS_INCLUDES . 'javascript/ceon/adv_shipper/advshipper_region_config_localities.js'); ?>
//-->
</script>
<?php } ?>

<!-- body //-->
<?php echo zen_draw_form('advshipper', FILENAME_ADVANCED_SHIPPER_REGION_CONFIG,
	zen_output_string_protected(zen_get_all_get_params()), 'post', 'onSubmit="return advshipperSaveRegion(region, \'' .
	$update_region . '\');"', true);
echo zen_hide_session_id(); ?>

<table border="0" width="100%" cellspacing="2" cellpadding="2">
	<tr>
<!-- body_text //-->
		<td width="100%" valign="top">
			<table border="0" width="100%" cellspacing="0" cellpadding="0">
				<tr>
					<td class="pageHeading AdvancedShipperPageHeading"><?php echo HEADING_TITLE; ?></td>
				</tr>
				<tr>
					<td>
<?php
if (isset($errors) && count($errors) == 1) {
	echo '<p class="ErrorIntro">' . TEXT_ERROR_IN_CONFIG;
} else if (isset($errors) && count($errors) > 0 ) {
	printf('<p class="ErrorIntro">' . TEXT_ERRORS_IN_CONFIG, sizeof($errors));
} else {
	echo '<p>';
}
?>
						</p>	
					</td>
				</tr>	
				<tr>
					<td>
<?php

// Build fields for the region's configuration /////////////////////////////////////////////////////
?>
<fieldset class="AdvancedShipperRegion<?php echo ((($method_num) % 2 == 0) ? 'Even' : 'Odd'); ?>">
	<legend><?php echo TEXT_REGION . ' '; ?>
<script language="JavaScript" type="text/javascript">
<!--
document.write(region + 1);
// -->
</script>
	<?php
	if (isset($region_titles) && isset($region_titles[$_SESSION['languages_id']]) && strlen($region_titles[$_SESSION['languages_id']]) > 0) {
		echo ' - &ldquo;' . htmlentities($region_titles[$_SESSION['languages_id']]) . '&rdquo;';
	}
?></legend>
	<fieldset class="AdvancedShipperRegion<?php echo ((($method_num) % 2 == 0) ? 'Even' : 'Odd'); ?>ConfigPanel">
		<legend><?php echo TEXT_REGION_TITLE; ?></legend>
		<table cellpadding="0" cellspacing="0" width="100%" border="0">
			<tr>
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="region_admin_title_<?php echo $languages[0]['id']; ?>"><?php echo TEXT_LABEL_REGION_ADMIN_TITLE; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_REGION_ADMIN_TITLE; ?>
				</td>
			</tr>
			<tr>
				<td class="AdvancedShipperConfigField">
	<?php
		for ($language_i = 0, $n = sizeof($languages); $language_i < $n; $language_i++) {
			if ($language_i != 0) {
				echo '<br />';
			}
			echo zen_image(DIR_WS_CATALOG_LANGUAGES . $languages[$language_i]['directory'] . '/images/' . $languages[$language_i]['image'], $languages[$language_i]['name']);
			echo ' ';
			echo zen_draw_input_field('region_admin_titles[' . $languages[$language_i]['id'] . ']', isset($region_admin_titles[$languages[$language_i]['id']]) ? $region_admin_titles[$languages[$language_i]['id']] : '' , 'maxlength="255" size="80" id="region_admin_title_' . $languages[$language_i]['id'] . '" class="Textfield" onKeyPress="advshipperCheckEnterPressed(event)"');
			echo "\n";
		}
	?>
				</td>
			</tr>
			<tr>
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="region_title_<?php echo $languages[0]['id']; ?>"><?php echo TEXT_LABEL_REGION_TITLE; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_REGION_TITLE; ?>
				</td>
			</tr>
			<tr>
				<td class="AdvancedShipperConfigField">
	<?php
		for ($language_i = 0, $n = sizeof($languages); $language_i < $n; $language_i++) {
			if ($language_i != 0) {
				echo '<br />';
			}
			echo zen_image(DIR_WS_CATALOG_LANGUAGES . $languages[$language_i]['directory'] . '/images/' . $languages[$language_i]['image'], $languages[$language_i]['name']);
			echo ' ';
			echo zen_draw_input_field('region_titles[' . $languages[$language_i]['id'] . ']', isset($region_titles[$languages[$language_i]['id']]) ? $region_titles[$languages[$language_i]['id']] : '', 'maxlength="255" size="80" id="region_title_' . $languages[$language_i]['id'] . '" class="Textfield" onKeyPress="advshipperCheckEnterPressed(event)"');
			echo "\n";
		}
	?>
				</td>
			</tr>
		</table>
	</fieldset>
	
	<fieldset class="AdvancedShipperRegion<?php echo ((($method_num) % 2 == 0) ? 'Even' : 'Odd'); ?>ConfigPanel">
		<legend><?php echo TEXT_DEFINITION_METHOD; ?></legend>
		<table cellpadding="0" cellspacing="0" width="100%" border="0">
			<tr>
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="definition_method_address_matching"><?php echo TEXT_LABEL_DEFINITION_METHOD; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_DEFINITION_METHOD; ?>
				</td>
			</tr>
			<tr>
				<td class="AdvancedShipperConfigField">
					<?php echo advshipperBuildRadioField('definition_method', ADVSHIPPER_DEFINITION_METHOD_ADDRESS_MATCHING, $definition_method == ADVSHIPPER_DEFINITION_METHOD_ADDRESS_MATCHING, null, 'id="definition_method_address_matching" onclick="advshipperDefinitionMethodSelected(' . ADVSHIPPER_DEFINITION_METHOD_ADDRESS_MATCHING . ');" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="definition_method_address_matching"><?php echo TEXT_DEFINITION_METHOD_ADDRESS_MATCHING; ?></label>
					<br /><?php echo advshipperBuildRadioField('definition_method', ADVSHIPPER_DEFINITION_METHOD_GEOLOCATION, $definition_method == ADVSHIPPER_DEFINITION_METHOD_GEOLOCATION, null, 'id="definition_method_geolocation" onclick="advshipperDefinitionMethodSelected(' . ADVSHIPPER_DEFINITION_METHOD_GEOLOCATION . ');" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="definition_method_geolocation"><?php echo TEXT_DEFINITION_METHOD_GEOLOCATION; ?></label>
				</td>
			</tr>
		</table>
	</fieldset>
		
	<fieldset class="AdvancedShipperRegion<?php echo ((($method_num) % 2 == 0) ? 'Even' : 'Odd'); ?>ConfigPanel" <?php echo ($definition_method == ADVSHIPPER_DEFINITION_METHOD_ADDRESS_MATCHING ? '' : 'style="display: none;"'); ?> id="address_matching_panel">
		<legend><?php echo TEXT_ADDRESS_MATCHING; ?></legend>
		<table cellpadding="0" cellspacing="0" width="100%" border="0">
			<tr <?php echo ($definition_method == ADVSHIPPER_DEFINITION_METHOD_ADDRESS_MATCHING ? '' : 'style="display: none;"'); ?> id="address_matching_intro_header">
				<td>&nbsp;</td>
				<td class="AdvancedShipperConfigIntro">
				<?php if (defined('ADVSHIPPER_ZONES_SUPPORT') &&
						ADVSHIPPER_ZONES_SUPPORT == 'Yes' &&
						defined('ADVSHIPPER_LOCALITY_SUPPORT') &&
						ADVSHIPPER_LOCALITY_SUPPORT == 'Yes') {
					echo TEXT_INTRO_DEFINITION_METHOD_ADDRESS_MATCHING_LOCALITY_AND_ZONE_SUPPORT;
				} else if ((defined('ADVSHIPPER_ZONES_SUPPORT') &&
						ADVSHIPPER_ZONES_SUPPORT == 'Yes') &&
						(!defined('ADVSHIPPER_LOCALITY_SUPPORT') ||
						ADVSHIPPER_LOCALITY_SUPPORT != 'Yes')) {
					echo TEXT_INTRO_DEFINITION_METHOD_ADDRESS_MATCHING_ZONE_SUPPORT;
				} else if ((!defined('ADVSHIPPER_ZONES_SUPPORT') ||
						ADVSHIPPER_ZONES_SUPPORT != 'Yes') &&
						(defined('ADVSHIPPER_LOCALITY_SUPPORT') &&
						ADVSHIPPER_LOCALITY_SUPPORT == 'Yes')) {
					echo TEXT_INTRO_DEFINITION_METHOD_ADDRESS_MATCHING_LOCALITY_SUPPORT;
				} else {
					echo TEXT_INTRO_DEFINITION_METHOD_ADDRESS_MATCHING_NO_LOCALITY_OR_ZONE_SUPPORT;
				} ?></td>
			</tr>
			<tr <?php echo ($definition_method == ADVSHIPPER_DEFINITION_METHOD_ADDRESS_MATCHING ? '' : 'style="display: none;"'); ?> id="countries_postcodes_header">
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="countries_postcodes"><?php echo TEXT_LABEL_COUNTRIES_POSTCODES; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_COUNTRIES_POSTCODES; ?>
				</td>
			</tr>
			<tr <?php echo ($definition_method == ADVSHIPPER_DEFINITION_METHOD_ADDRESS_MATCHING ? '' : 'style="display: none;"'); ?> id="countries_postcodes_field">
				<td class="AdvancedShipperConfigField">
					<?php echo zen_draw_textarea_field('countries_postcodes', 'virtual', 50, 6, $countries_postcodes, 'id="countries_postcodes"'); ?>
				</td>
			</tr>
			<?php if (defined('ADVSHIPPER_ZONES_SUPPORT') && ADVSHIPPER_ZONES_SUPPORT == 'Yes') {
				require(DIR_WS_MODULES . FILENAME_ADVANCED_SHIPPER_REGION_CONFIG_ZONE_SELECTION);
			} ?>
			<?php if (defined('ADVSHIPPER_LOCALITY_SUPPORT') && ADVSHIPPER_LOCALITY_SUPPORT == 'Yes') {
				require(DIR_WS_MODULES . FILENAME_ADVANCED_SHIPPER_REGION_CONFIG_LOCALITY_SELECTION);
			} ?>
		</table>
	</fieldset>
	
	<fieldset class="AdvancedShipperRegion<?php echo ((($method_num) % 2 == 0) ? 'Even' : 'Odd'); ?>ConfigPanel" <?php echo ($definition_method == ADVSHIPPER_DEFINITION_METHOD_GEOLOCATION ? '' : 'style="display: none;"'); ?> id="geolocation_panel">
		<legend><?php echo TEXT_GEOLOCATION; ?></legend>
		<table cellpadding="0" cellspacing="0" width="100%" border="0">
			<tr id="distance_header">
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="distance"><?php echo TEXT_LABEL_DISTANCE; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_DISTANCE; ?>
				</td>
			</tr>
			<tr id="distance_field">
				<td class="AdvancedShipperConfigField">
					<?php echo zen_draw_input_field('distance', $distance, 'maxlength="6" size="6" id="distance" onKeyPress="advshipperCheckEnterPressed(event)"'); ?>
				</td>
			</tr>
		</table>
	</fieldset>
	
	<fieldset class="AdvancedShipperRegion<?php echo ((($method_num) % 2 == 0) ? 'Even' : 'Odd'); ?>ConfigPanel">
		<legend><?php echo TEXT_RATES_CONFIG; ?></legend>
		<table cellpadding="0" cellspacing="0" width="100%" border="0">
			<tr>
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="tax_class"><?php echo TEXT_LABEL_TAX_CLASS; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_TAX_CLASS; ?>
				</td>
			</tr>
			<tr>
				<td class="AdvancedShipperConfigField">
					<?php echo advshipperBuildTaxClassesDropdown('tax_class', $tax_class, 'id="tax_class"'); ?>
				</td>
			</tr>
			<tr>
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="rates_include_tax_inc"><?php echo TEXT_LABEL_RATES_INCLUDE_TAX; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_RATES_INCLUDE_TAX; ?>
				</td>
			</tr>
			<tr>
				<td class="AdvancedShipperConfigField">
					<?php echo advshipperBuildRadioField('rates_include_tax', ADVSHIPPER_RATES_INC_TAX_INC, $rates_include_tax == ADVSHIPPER_RATES_INC_TAX_INC, null, 'id="rates_include_tax_inc" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="rates_include_tax_inc"><?php echo TEXT_RATES_INCLUDE_TAX; ?></label>
					<br /><?php echo advshipperBuildRadioField('rates_include_tax', ADVSHIPPER_RATES_INC_TAX_EXC, $rates_include_tax == ADVSHIPPER_RATES_INC_TAX_EXC, null, 'id="rates_include_tax_exc" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="rates_include_tax_exc"><?php echo TEXT_RATES_DO_NOT_INCLUDE_TAX; ?></label>
				</td>
			</tr>
			<tr>
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="rate_limits_inc_inc"><?php echo TEXT_LABEL_RATE_LIMITS_INC; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_RATE_LIMITS_INC; ?>
				</td>
			</tr>
			<tr>
				<td class="AdvancedShipperConfigField">
					<?php echo advshipperBuildRadioField('rate_limits_inc', ADVSHIPPER_RATE_LIMITS_INC_INC, $rate_limits_inc == ADVSHIPPER_RATE_LIMITS_INC_INC, null, 'id="rate_limits_inc_inc" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="rate_limits_inc_inc"><?php echo TEXT_RATE_LIMITS_INC_INC; ?></label>
					<br /><?php echo advshipperBuildRadioField('rate_limits_inc', ADVSHIPPER_RATE_LIMITS_INC_EXC, $rate_limits_inc == ADVSHIPPER_RATE_LIMITS_INC_EXC, null, 'id="rate_limits_inc_exc" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="rate_limits_inc_exc"><?php echo TEXT_RATE_LIMITS_INC_EXC; ?></label>
				</td>
			</tr>
			<tr>
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="total_up_price_inc_tax_inc"><?php echo TEXT_LABEL_TOTAL_UP_PRICE_INC_TAX; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_TOTAL_UP_PRICE_INC_TAX; ?>
				</td>
			</tr>
			<tr>
				<td class="AdvancedShipperConfigField">
					<?php echo advshipperBuildRadioField('total_up_price_inc_tax', ADVSHIPPER_TOTAL_UP_PRICE_INC_TAX_INC, $total_up_price_inc_tax == ADVSHIPPER_TOTAL_UP_PRICE_INC_TAX_INC, null, 'id="total_up_price_inc_tax_inc" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="total_up_price_inc_tax_inc"><?php echo TEXT_TOTAL_UP_PRICE_INC_TAX_INC; ?></label>
					<br /><?php echo advshipperBuildRadioField('total_up_price_inc_tax', ADVSHIPPER_TOTAL_UP_PRICE_INC_TAX_EXC, $total_up_price_inc_tax == ADVSHIPPER_TOTAL_UP_PRICE_INC_TAX_EXC, null, 'id="total_up_price_inc_tax_exc" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="total_up_price_inc_tax_exc"><?php echo TEXT_TOTAL_UP_PRICE_INC_TAX_EXC; ?></label>
				</td>
			</tr>
			<tr>
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="table_of_rates"><?php echo TEXT_LABEL_TABLE_OF_RATES; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_TABLE_OF_RATES; ?>
				</td>
			</tr>
			<tr>
				<td class="AdvancedShipperConfigField">
					<?php echo zen_draw_textarea_field('table_of_rates', 'virtual', 50, 6, $table_of_rates, 'id="table_of_rates"'); ?>
				</td>
			</tr>
			<tr>
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="packaging_weights"><?php echo TEXT_LABEL_MAX_WEIGHT_PER_PACKAGE; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_MAX_WEIGHT_PER_PACKAGE; ?>
				</td>
			</tr>
			<tr>
				<td class="AdvancedShipperConfigField">
					<?php echo zen_draw_input_field('max_weight_per_package', $max_weight_per_package, 'size="10" id="max_weight_per_package" class="Textfield" onKeyPress="advshipperCheckEnterPressed(event)"'); ?>
				</td>
			</tr>
			<tr>
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="packaging_weights"><?php echo TEXT_LABEL_PACKAGING_WEIGHTS; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_PACKAGING_WEIGHTS; ?>
				</td>
			</tr>
			<tr>
				<td class="AdvancedShipperConfigField">
					<?php echo zen_draw_input_field('packaging_weights', $packaging_weights, 'size="45" id="packaging_weights" class="Textfield" onKeyPress="advshipperCheckEnterPressed(event)"'); ?>
				</td>
			</tr>
			<tr>
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="surcharge"><?php echo TEXT_LABEL_SURCHARGE_DISCOUNT; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_SURCHARGE_DISCOUNT; ?>
				</td>
			</tr>
			<tr>
				<td class="AdvancedShipperConfigField">
					<?php echo zen_draw_textarea_field('surcharge', 'virtual', 50, 2, $surcharge, 'id="surcharge"'); ?>
				</td>
			</tr>
			<tr>
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="surcharge_title_<?php echo $languages[0]['id']; ?>" ><?php echo TEXT_LABEL_SURCHARGE_DISCOUNT_TITLE; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_SURCHARGE_DISCOUNT_TITLE; ?>
				</td>
			</tr>
			<tr>
				<td class="AdvancedShipperConfigField">
	<?php
		for ($language_i = 0, $n = sizeof($languages); $language_i < $n; $language_i++) {
			if ($language_i != 0) {
				echo '<br />';
			}
			echo zen_image(DIR_WS_CATALOG_LANGUAGES . $languages[$language_i]['directory'] . '/images/' . $languages[$language_i]['image'], $languages[$language_i]['name']);
			echo ' ';
			echo zen_draw_input_field('surcharge_titles[' . $languages[$language_i]['id'] . ']', isset($surcharge_titles[$languages[$language_i]['id']]) ? $surcharge_titles[$languages[$language_i]['id']] : '', 'maxlength="255" size="45" id="surcharge_title_' . $languages[$language_i]['id'] . '" class="Textfield" onKeyPress="advshipperCheckEnterPressed(event)"');
			echo "\n";
		}
	?>
				</td>
			</tr>
		</table>
	</fieldset>

	<fieldset class="AdvancedShipperRegion<?php echo
		((($method_num) % 2 == 0) ? 'Even' : 'Odd') .	'ConfigPanel'; ?>">
		<legend><?php echo TEXT_UPS_CALC_SETTINGS; ?></legend>
		<table border="0" width="100%" cellpadding="0" cellspacing="0">
			<tr>
				<td class="AdvancedShipperConfigLabel"><label for="ups_calculator_enabled_disabled"><?php echo TEXT_LABEL_UPS_ENABLED; ?></label></td>
				<td class="AdvancedShipperExtendedConfigField">
					<?php echo advshipperBuildRadioField('ups_calculator_enabled', 'disabled',
						($ups_calculator_enabled == false), null,
						'onclick="advshipperUPSCalculatorSelection(\'disable\');"' .
						' id="ups_calculator_enabled_disabled" onKeyPress="advshipperCheckEnterPressed(event)"'); ?>
					<label for="ups_calculator_enabled_disabled"><?php echo TEXT_UPS_CALC_NOT_BEING_USED; ?></label>
					<br /><?php echo advshipperBuildRadioField('ups_calculator_enabled',
						'enabled', ($ups_calculator_enabled == true), null,
						'onclick="advshipperUPSCalculatorSelection(\'enabled\');"' .
						' id="ups_calculator_enabled_enabled" onKeyPress="advshipperCheckEnterPressed(event)"'); ?>
					<label for="ups_calculator_enabled_enabled"><?php echo TEXT_UPS_CALC_BEING_USED; ?></label>
				</td>
			</tr>
			<tr id="ups_source_country_header" style="display: none;">
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="ups_source_country"><?php echo TEXT_LABEL_UPS_SOURCE_COUNTRY; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_UPS_SOURCE_COUNTRY; ?>
				</td>
			</tr>
			<tr id="ups_source_country_field" style="display: none;">
				<td class="AdvancedShipperConfigField">
					<?php
						$countryArr[] = array("id" => "", "text" => "Select...");
						foreach(zen_get_countries() as $country) {
							$countryArr[] = array("id" => $country["countries_id"], "text" => $country["countries_name"]);
						}

						echo $country_select = zen_draw_pull_down_menu('ups_source_country',
						$countryArr,
						$ups_source_country,
						'id="ups_source_country" onKeyPress="advshipperCheckEnterPressed(event)"'
						); ?>
				</td>
			</tr>
			<tr id="ups_source_postcode_header" style="display: none;">
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="ups_source_postcode"><?php echo TEXT_LABEL_UPS_SOURCE_POSTCODE; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_UPS_SOURCE_POSTCODE; ?>
				</td>
			</tr>
			<tr id="ups_source_postcode_field" style="display: none;">
				<td class="AdvancedShipperConfigField">
					<?php echo zen_draw_input_field('ups_source_postcode', $ups_source_postcode, 'size="9" id="ups_source_postcode" class="Textfield" onKeyPress="advshipperCheckEnterPressed(event)"'); ?>
				</td>
			</tr>
			<tr id="ups_pickup_method_header" style="display: none;">
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="ups_pickup_method"><?php echo TEXT_LABEL_UPS_PICKUP_METHOD; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_UPS_PICKUP_METHOD; ?>
				</td>
			</tr>
			<tr id="ups_pickup_method_field" style="display: none;">
				<td class="AdvancedShipperConfigField">
					<?php echo zen_draw_input_field('ups_pickup_method', $ups_pickup_method, 'maxlength="4" size="4" id="ups_pickup_method" class="Textfield" onKeyPress="advshipperCheckEnterPressed(event)"'); ?>
				</td>
			</tr>
			<tr id="ups_packaging_header" style="display: none;">
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="ups_packaging"><?php echo TEXT_LABEL_UPS_PACKAGING; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_UPS_PACKAGING; ?>
				</td>
			</tr>
			<tr id="ups_packaging_field" style="display: none;">
				<td class="AdvancedShipperConfigField">
					<?php echo zen_draw_input_field('ups_packaging', $ups_packaging, 'maxlength="4" size="4" id="ups_packaging" class="Textfield" onKeyPress="advshipperCheckEnterPressed(event)"'); ?>
				</td>
			</tr>
			<tr id="ups_delivery_type_header" style="display: none;">
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="ups_delivery_type"><?php echo TEXT_LABEL_UPS_DELIVERY_TYPE; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_UPS_DELIVERY_TYPE; ?>
				</td>
			</tr>
			<tr id="ups_delivery_type_field" style="display: none;">
				<td class="AdvancedShipperConfigField">
					<?php echo zen_draw_input_field('ups_delivery_type', $ups_delivery_type, 'maxlength="3" size="3" id="ups_delivery_type" class="Textfield" onKeyPress="advshipperCheckEnterPressed(event)"'); ?>
				</td>
			</tr>
			<tr id="ups_shipping_services_header" style="display: none;">
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label><?php echo TEXT_LABEL_UPS_SHIPPING_SERVICES; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_UPS_SHIPPING_SERVICES; ?>
				</td>
			</tr>
			<tr id="ups_shipping_services_field" style="display: none;">
				<td class="AdvancedShipperConfigField">
					<?php echo advshipperBuildCheckboxField('ups_shipping_service_1dm', 1, ($ups_shipping_service_1dm == 1), null,  'id="ups_shipping_service_1dm" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="ups_shipping_service_1dm"><?php echo TEXT_UPS_SHIPPING_SERVICE_1DM; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('ups_shipping_service_1dml', 1, ($ups_shipping_service_1dml == 1), null,  'id="ups_shipping_service_1dml" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="ups_shipping_service_1dml"><?php echo TEXT_UPS_SHIPPING_SERVICE_1DML; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('ups_shipping_service_1da', 1, ($ups_shipping_service_1da == 1), null,  'id="ups_shipping_service_1da" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="ups_shipping_service_1da"><?php echo TEXT_UPS_SHIPPING_SERVICE_1DA; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('ups_shipping_service_1dal', 1, ($ups_shipping_service_1dal == 1), null,  'id="ups_shipping_service_1dal" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="ups_shipping_service_1dal"><?php echo TEXT_UPS_SHIPPING_SERVICE_1DAL; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('ups_shipping_service_1dapi', 1, ($ups_shipping_service_1dapi == 1), null,  'id="ups_shipping_service_1dapi" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="ups_shipping_service_1dapi"><?php echo TEXT_UPS_SHIPPING_SERVICE_1DAPI; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('ups_shipping_service_1dp', 1, ($ups_shipping_service_1dp == 1), null,  'id="ups_shipping_service_1dp" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="ups_shipping_service_1dp"><?php echo TEXT_UPS_SHIPPING_SERVICE_1DP; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('ups_shipping_service_1dpl', 1, ($ups_shipping_service_1dpl == 1), null,  'id="ups_shipping_service_1dpl" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="ups_shipping_service_1dpl"><?php echo TEXT_UPS_SHIPPING_SERVICE_1DPL; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('ups_shipping_service_2dm', 1, ($ups_shipping_service_2dm == 1), null,  'id="ups_shipping_service_2dm" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="ups_shipping_service_2dm"><?php echo TEXT_UPS_SHIPPING_SERVICE_2DM; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('ups_shipping_service_2dml', 1, ($ups_shipping_service_2dml == 1), null,  'id="ups_shipping_service_2dml" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="ups_shipping_service_2dml"><?php echo TEXT_UPS_SHIPPING_SERVICE_2DML; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('ups_shipping_service_2da', 1, ($ups_shipping_service_2da == 1), null,  'id="ups_shipping_service_2da" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="ups_shipping_service_2da"><?php echo TEXT_UPS_SHIPPING_SERVICE_2DA; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('ups_shipping_service_2dal', 1, ($ups_shipping_service_2dal == 1), null,  'id="ups_shipping_service_2dal" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="ups_shipping_service_2dal"><?php echo TEXT_UPS_SHIPPING_SERVICE_2DAL; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('ups_shipping_service_3ds', 1, ($ups_shipping_service_3ds == 1), null,  'id="ups_shipping_service_3ds" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="ups_shipping_service_3ds"><?php echo TEXT_UPS_SHIPPING_SERVICE_3DS; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('ups_shipping_service_gnd', 1, ($ups_shipping_service_gnd == 1), null,  'id="ups_shipping_service_gnd" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="ups_shipping_service_gnd"><?php echo TEXT_UPS_SHIPPING_SERVICE_GND; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('ups_shipping_service_std', 1, ($ups_shipping_service_std == 1), null,  'id="ups_shipping_service_std" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="ups_shipping_service_std"><?php echo TEXT_UPS_SHIPPING_SERVICE_STD; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('ups_shipping_service_xpr', 1, ($ups_shipping_service_xpr == 1), null,  'id="ups_shipping_service_xpr" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="ups_shipping_service_xpr"><?php echo TEXT_UPS_SHIPPING_SERVICE_XPR; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('ups_shipping_service_xprl', 1, ($ups_shipping_service_xprl == 1), null,  'id="ups_shipping_service_xprl" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="ups_shipping_service_xprl"><?php echo TEXT_UPS_SHIPPING_SERVICE_XPRL; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('ups_shipping_service_xdm', 1, ($ups_shipping_service_xdm == 1), null,  'id="ups_shipping_service_xdm" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="ups_shipping_service_xdm"><?php echo TEXT_UPS_SHIPPING_SERVICE_XDM; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('ups_shipping_service_xdml', 1, ($ups_shipping_service_xdml == 1), null,  'id="ups_shipping_service_xdml" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="ups_shipping_service_xdml"><?php echo TEXT_UPS_SHIPPING_SERVICE_XDML; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('ups_shipping_service_xpd', 1, ($ups_shipping_service_xpd == 1), null,  'id="ups_shipping_service_xpd" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="ups_shipping_service_xpd"><?php echo TEXT_UPS_SHIPPING_SERVICE_XPD; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('ups_shipping_service_wxs', 1, ($ups_shipping_service_wxs == 1), null,  'id="ups_shipping_service_wxs" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="ups_shipping_service_wxs"><?php echo TEXT_UPS_SHIPPING_SERVICE_WXS; ?></label>
				</td>
			</tr>
		</table>
	</fieldset>
	
	<fieldset class="AdvancedShipperRegion<?php echo
		((($method_num) % 2 == 0) ? 'Even' : 'Odd') .	'ConfigPanel'; ?>">
		<legend><?php echo TEXT_USPS_CALC_SETTINGS; ?></legend>
		<table border="0" width="100%" cellpadding="0" cellspacing="0">
			<tr>
				<td class="AdvancedShipperConfigLabel"><label for="usps_calculator_enabled_disabled"><?php echo TEXT_LABEL_USPS_ENABLED; ?></label></td>
				<td class="AdvancedShipperExtendedConfigField">
					<?php echo advshipperBuildRadioField('usps_calculator_enabled', 'disabled',
						($usps_calculator_enabled == false), null,
						'onclick="advshipperUSPSCalculatorSelection(\'disable\');"' .
						' id="usps_calculator_enabled_disabled" onKeyPress="advshipperCheckEnterPressed(event)"'); ?>
					<label for="usps_calculator_enabled_disabled"><?php echo TEXT_USPS_CALC_NOT_BEING_USED; ?></label>
					<br /><?php echo advshipperBuildRadioField('usps_calculator_enabled', 'enabled',
						($usps_calculator_enabled == true), null,
						'onclick="advshipperUSPSCalculatorSelection(\'enabled\');"' .
						' id="usps_calculator_enabled_enabled" onKeyPress="advshipperCheckEnterPressed(event)"'); ?>
					<label for="usps_calculator_enabled_enabled"><?php echo TEXT_USPS_CALC_BEING_USED; ?></label>
				</td>
			</tr>
			<tr id="usps_user_id_header" style="display: none;">
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="usps_user_id"><?php echo TEXT_LABEL_USPS_USER_ID; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_USPS_USER_ID; ?>
				</td>
			</tr>
			<tr id="usps_user_id_field" style="display: none;">
				<td class="AdvancedShipperConfigField">
					<?php echo zen_draw_input_field('usps_user_id', $usps_user_id, 'size="20" id="usps_user_id" class="Textfield" onKeyPress="advshipperCheckEnterPressed(event)"'); ?>
				</td>
			</tr>
			<tr id="usps_server_header" style="display: none;">
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="usps_server_field"><?php echo TEXT_LABEL_USPS_SERVER; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_USPS_SERVER; ?>
				</td>
			</tr>
			<tr id="usps_server_field" style="display: none;">
				<td class="AdvancedShipperConfigField">
					<?php echo advshipperBuildRadioField('usps_server', 't', ($usps_server == 't'), null, 'id="usps_server_test" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_server_test"><?php echo TEXT_USPS_SERVER_TEST; ?></label>
					<br /><?php echo advshipperBuildRadioField('usps_server', 'p', ($usps_server == 'p'), null, 'id="usps_server_production" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_server_production"><?php echo TEXT_USPS_SERVER_PRODUCTION; ?></label>
				</td>
			</tr>
			<tr id="usps_source_country_header" style="display: none;">
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="usps_source_country"><?php echo TEXT_LABEL_USPS_SOURCE_COUNTRY; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_USPS_SOURCE_COUNTRY; ?>
				</td>
			</tr>
			<tr id="usps_source_country_field" style="display: none;">
				<td class="AdvancedShipperConfigField">
					<?php
						$countryArr[] = array("id" => "", "text" => "Select...");
						foreach(zen_get_countries() as $country) {
							$countryArr[] = array("id" => $country["countries_id"], "text" => $country["countries_name"]);
						}

						echo $country_select = zen_draw_pull_down_menu('usps_source_country',
						$countryArr,
						$usps_source_country,
						'id="usps_source_country" onKeyPress="advshipperCheckEnterPressed(event)"'
						); ?>
				</td>
			</tr>
			<tr id="usps_source_postcode_header" style="display: none;">
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="usps_source_postcode"><?php echo TEXT_LABEL_USPS_SOURCE_POSTCODE; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_USPS_SOURCE_POSTCODE; ?>
				</td>
			</tr>
			<tr id="usps_source_postcode_field" style="display: none;">
				<td class="AdvancedShipperConfigField">
					<?php echo zen_draw_input_field('usps_source_postcode', $usps_source_postcode, 'size="9" id="usps_source_postcode" class="Textfield" onKeyPress="advshipperCheckEnterPressed(event)"'); ?>
				</td>
			</tr>
			<tr id="usps_machinable_header" style="display: none;">
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="usps_machinable_field"><?php echo TEXT_LABEL_USPS_MACHINABLE; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_USPS_MACHINABLE; ?>
				</td>
			</tr>
			<tr id="usps_machinable_field" style="display: none;">
				<td class="AdvancedShipperConfigField">
					<?php echo advshipperBuildRadioField('usps_machinable', '1', ($usps_machinable == 1), null, 'id="usps_machinable_true" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_machinable_true"><?php echo TEXT_USPS_MACHINABLE_TRUE; ?></label>
					<br /><?php echo advshipperBuildRadioField('usps_machinable', '0', ($usps_machinable == 0), null, 'id="usps_machinable_false" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_machinable_false"><?php echo TEXT_USPS_MACHINABLE_FALSE; ?></label>
				</td>
			</tr>
			<tr id="usps_display_transit_time_header" style="display: none;">
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="usps_display_transit_time_field"><?php echo TEXT_LABEL_USPS_DISPLAY_TRANSIT_TIME; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_USPS_DISPLAY_TRANSIT_TIME; ?>
				</td>
			</tr>
			<tr id="usps_display_transit_time_field" style="display: none;">
				<td class="AdvancedShipperConfigField">
					<?php echo advshipperBuildRadioField('usps_display_transit_time', '1', ($usps_display_transit_time == 1), null, 'id="usps_display_transit_time_true" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_display_transit_time_true"><?php echo TEXT_USPS_DISPLAY_TRANSIT_TIME_TRUE; ?></label>
					<br /><?php echo advshipperBuildRadioField('usps_display_transit_time', '0', ($usps_display_transit_time == 0), null, 'id="usps_display_transit_time_false" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_display_transit_time_false"><?php echo TEXT_USPS_DISPLAY_TRANSIT_TIME_FALSE; ?></label>
				</td>
			</tr>
			<tr id="usps_domestic_services_header" style="display: none;">
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="usps_domestic_express"><?php echo TEXT_LABEL_USPS_DOMESTIC_SERVICES; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_USPS_DOMESTIC_SERVICES; ?>
				</td>
			</tr>
			<tr id="usps_domestic_services_field" style="display: none;">
				<td class="AdvancedShipperConfigField">
					<?php echo advshipperBuildCheckboxField('usps_domestic_express', 1, ($usps_domestic_express == 1), null,  'id="usps_domestic_express" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_domestic_express"><?php echo TEXT_USPS_DOMESTIC_EXPRESS; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('usps_domestic_priority', 1, ($usps_domestic_priority == 1), null,  'id="usps_domestic_priority" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_domestic_priority"><?php echo TEXT_USPS_DOMESTIC_PRIORITY; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('usps_domestic_first_class', 1, ($usps_domestic_first_class == 1), null,  'id="usps_domestic_first_class" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_domestic_first_class"><?php echo TEXT_USPS_DOMESTIC_FIRST_CLASS; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('usps_domestic_retail_ground', 1, ($usps_domestic_retail_ground == 1), null,  'id="usps_domestic_retail_ground" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_domestic_retail_ground"><?php echo TEXT_USPS_DOMESTIC_RETAIL_GROUND; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('usps_domestic_media', 1, ($usps_domestic_media == 1), null,  'id="usps_domestic_media" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_domestic_media"><?php echo TEXT_USPS_DOMESTIC_MEDIA; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('usps_domestic_bpm', 1, ($usps_domestic_bpm == 1), null,  'id="usps_domestic_bpm" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_domestic_bpm"><?php echo TEXT_USPS_DOMESTIC_BPM; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('usps_domestic_library', 1, ($usps_domestic_library == 1), null,  'id="usps_domestic_library" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_domestic_library"><?php echo TEXT_USPS_DOMESTIC_LIBRARY; ?></label>
				</td>
			</tr>
			<tr id="usps_international_services_header" style="display: none;">
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label><?php echo TEXT_LABEL_USPS_INTERNATIONAL_SERVICES; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_USPS_INTERNATIONAL_SERVICES; ?>
				</td>
			</tr>
			<tr id="usps_international_services_field" style="display: none;">
				<td class="AdvancedShipperConfigField">
					<br /><?php echo advshipperBuildCheckboxField('usps_international_geg', 1, ($usps_international_geg == 1), null,  'id="usps_international_geg" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_international_geg"><?php echo TEXT_USPS_INTERNATIONAL_GEG; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('usps_international_geg_d', 1, ($usps_international_geg_d == 1), null,  'id="usps_international_geg_d" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_international_geg_d"><?php echo TEXT_USPS_INTERNATIONAL_GEG_D; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('usps_international_geg_ndr', 1, ($usps_international_geg_ndr == 1), null,  'id="usps_international_geg_ndr" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_international_geg_ndr"><?php echo TEXT_USPS_INTERNATIONAL_GEG_NDR; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('usps_international_geg_ndnr', 1, ($usps_international_geg_ndnr == 1), null,  'id="usps_international_geg_ndnr" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_international_geg_ndnr"><?php echo TEXT_USPS_INTERNATIONAL_GEG_NDNR; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('usps_international_geg_e', 1, ($usps_international_geg_e == 1), null,  'id="usps_international_geg_e" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_international_geg_e"><?php echo TEXT_USPS_INTERNATIONAL_GEG_E; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('usps_international_emi', 1, ($usps_international_emi == 1), null,  'id="usps_international_emi" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_international_emi"><?php echo TEXT_USPS_INTERNATIONAL_EMI; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('usps_international_emi_fre', 1, ($usps_international_emi_fre == 1), null,  'id="usps_international_emi_fre" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_international_emi_fre"><?php echo TEXT_USPS_INTERNATIONAL_EMI_FRE; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('usps_international_emi_lfre', 1, ($usps_international_emi_lfre == 1), null,  'id="usps_international_emi_lfre" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_international_emi_lfre"><?php echo TEXT_USPS_INTERNATIONAL_EMI_LFRE; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('usps_international_pmi', 1, ($usps_international_pmi == 1), null,  'id="usps_international_pmi" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_international_pmi"><?php echo TEXT_USPS_INTERNATIONAL_PMI; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('usps_international_pmi_sfrb', 1, ($usps_international_pmi_sfrb == 1), null,  'id="usps_international_pmi_sfrb" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_international_pmi_sfrb"><?php echo TEXT_USPS_INTERNATIONAL_PMI_SFRB; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('usps_international_pmi_mfrb', 1, ($usps_international_pmi_mfrb == 1), null,  'id="usps_international_pmi_mfrb" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_international_pmi_mfrb"><?php echo TEXT_USPS_INTERNATIONAL_PMI_MFRB; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('usps_international_pmi_lfrb', 1, ($usps_international_pmi_lfrb == 1), null,  'id="usps_international_pmi_lfrb" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_international_pmi_lfrb"><?php echo TEXT_USPS_INTERNATIONAL_PMI_LFRB; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('usps_international_pmi_dfrb', 1, ($usps_international_pmi_dfrb == 1), null,  'id="usps_international_pmi_dfrb" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_international_pmi_dfrb"><?php echo TEXT_USPS_INTERNATIONAL_PMI_DFRB; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('usps_international_pmi_lvfrb', 1, ($usps_international_pmi_lvfrb == 1), null,  'id="usps_international_pmi_lvfrb" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_international_pmi_lvfrb"><?php echo TEXT_USPS_INTERNATIONAL_PMI_LVFRB; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('usps_international_pmi_fre', 1, ($usps_international_pmi_fre == 1), null,  'id="usps_international_pmi_fre" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_international_pmi_fre"><?php echo TEXT_USPS_INTERNATIONAL_PMI_FRE; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('usps_international_pmi_sfre', 1, ($usps_international_pmi_sfre == 1), null,  'id="usps_international_pmi_sfre" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_international_pmi_sfre"><?php echo TEXT_USPS_INTERNATIONAL_PMI_SFRE; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('usps_international_pmi_pfre', 1, ($usps_international_pmi_pfre == 1), null,  'id="usps_international_pmi_pfre" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_international_pmi_pfre"><?php echo TEXT_USPS_INTERNATIONAL_PMI_PFRE; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('usps_international_pmi_gcfre', 1, ($usps_international_pmi_gcfre == 1), null,  'id="usps_international_pmi_gcfre" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_international_pmi_gcfre"><?php echo TEXT_USPS_INTERNATIONAL_PMI_GCFRE; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('usps_international_pmi_lfre', 1, ($usps_international_pmi_lfre == 1), null,  'id="usps_international_pmi_lfre" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_international_pmi_lfre"><?php echo TEXT_USPS_INTERNATIONAL_PMI_LFRE; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('usps_international_fcmi_le', 1, ($usps_international_fcmi_le == 1), null,  'id="usps_international_fcmi_le" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_international_fcmi_le"><?php echo TEXT_USPS_INTERNATIONAL_FCMI_LE; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('usps_international_fcmi_p', 1, ($usps_international_fcmi_p == 1), null,  'id="usps_international_fcmi_p" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_international_fcmi_p"><?php echo TEXT_USPS_INTERNATIONAL_FCMI_P; ?></label>
					<br /><?php echo advshipperBuildCheckboxField('usps_international_fcmi_l', 1, ($usps_international_fcmi_l == 1), null,  'id="usps_international_fcmi_l" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="usps_international_fcmi_l"><?php echo TEXT_USPS_INTERNATIONAL_FCMI_L; ?></label>
				</td>
			</tr>
		</table>
	</fieldset>
	
	<fieldset class="AdvancedShipperRegion<?php echo
		((($method_num) % 2 == 0) ? 'Even' : 'Odd') .	'ConfigPanel'; ?>">
		<legend><?php echo TEXT_FEDEX_CALC_SETTINGS; ?></legend>
		<table border="0" width="100%" cellpadding="0" cellspacing="0">
			<tr>
				<td class="AdvancedShipperConfigLabel"><label for="fedex_calculator_enabled_disabled"><?php echo TEXT_LABEL_FEDEX_ENABLED; ?></label></td>
				<td class="AdvancedShipperExtendedConfigField">
					<?php echo advshipperBuildRadioField('fedex_calculator_enabled', 'disabled',
						($fedex_calculator_enabled == false), null,
						'onclick="advshipperFedExCalculatorSelection(\'disable\');"' .
						' id="fedex_calculator_enabled_disabled" onKeyPress="advshipperCheckEnterPressed(event)"'); ?>
						<label for="fedex_calculator_enabled_disabled"><?php echo TEXT_FEDEX_CALC_NOT_BEING_USED; ?></label>
					<br /><?php echo advshipperBuildRadioField('fedex_calculator_enabled', 'enabled',
						($fedex_calculator_enabled == true), null,
						'onclick="advshipperFedExCalculatorSelection(\'enabled\');"' .
						' id="fedex_calculator_enabled_enabled" onKeyPress="advshipperCheckEnterPressed(event)"'); ?>
						<label for="fedex_calculator_enabled_enabled"><?php echo TEXT_FEDEX_CALC_BEING_USED; ?></label>
				</td>
			</tr>
			<tr id="fedex_source_country_header" style="display: none;">
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="fedex_source_country"><?php echo TEXT_LABEL_FEDEX_SOURCE_COUNTRY; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_FEDEX_SOURCE_COUNTRY; ?>
				</td>
			</tr>
			<tr id="fedex_source_country_field" style="display: none;">
				<td class="AdvancedShipperConfigField">
					<?php
						$countryArr[] = array("id" => "", "text" => "Select...");
						foreach(zen_get_countries() as $country) {
							$countryArr[] = array("id" => $country["countries_id"], "text" => $country["countries_name"]);
						}
					
						echo $country_select = zen_draw_pull_down_menu('fedex_source_country',
						$countryArr, $fedex_source_country,
						'id="fedex_source_country" onKeyPress="advshipperCheckEnterPressed(event)"'
						); ?>
				</td>
			</tr>
			<tr id="fedex_source_postcode_header" style="display: none;">
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="fedex_source_postcode"><?php echo TEXT_LABEL_FEDEX_SOURCE_POSTCODE; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_FEDEX_SOURCE_POSTCODE; ?>
				</td>
			</tr>
			<tr id="fedex_source_postcode_field" style="display: none;">
				<td class="AdvancedShipperConfigField">
					<?php echo zen_draw_input_field('fedex_source_postcode', $fedex_source_postcode, 'size="10" maxlength="15" id="fedex_source_postcode" class="Textfield" onKeyPress="advshipperCheckEnterPressed(event)"'); ?>
				</td>
			</tr>
			<tr id="fedex_key_header" style="display: none;">
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="fedex_key"><?php echo TEXT_LABEL_FEDEX_KEY; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_FEDEX_KEY; ?>
				</td>
			</tr>
			<tr id="fedex_key_field" style="display: none;">
				<td class="AdvancedShipperConfigField">
					<?php echo zen_draw_input_field('fedex_key', $fedex_key, 'style="width: 13em;" maxlength="16" id="fedex_key" class="Textfield" onKeyPress="advshipperCheckEnterPressed(event)"'); ?>
				</td>
			</tr>
			<tr id="fedex_password_header" style="display: none;">
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="fedex_password"><?php echo TEXT_LABEL_FEDEX_PASSWORD; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_FEDEX_PASSWORD; ?>
				</td>
			</tr>
			<tr id="fedex_password_field" style="display: none;">
				<td class="AdvancedShipperConfigField">
					<?php echo zen_draw_input_field('fedex_password', $fedex_password, 'style="width: 20em;" maxlength="25" id="fedex_password" class="Textfield" onKeyPress="advshipperCheckEnterPressed(event)"'); ?>
				</td>
			</tr>
			<tr id="fedex_account_header" style="display: none;">
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="fedex_account"><?php echo TEXT_LABEL_FEDEX_ACCOUNT_NUM; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_FEDEX_ACCOUNT_NUM; ?>
				</td>
			</tr>
			<tr id="fedex_account_field" style="display: none;">
				<td class="AdvancedShipperConfigField">
					<?php echo zen_draw_input_field('fedex_account', $fedex_account, 'size="9" maxlength="9" id="fedex_account" class="Textfield" onKeyPress="advshipperCheckEnterPressed(event)"'); ?>
				</td>
			</tr>
			<tr id="fedex_meter_header" style="display: none;">
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="fedex_meter"><?php echo TEXT_LABEL_FEDEX_METER_NUM; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_FEDEX_METER_NUM; ?>
				</td>
			</tr>
			<tr id="fedex_meter_field" style="display: none;">
				<td class="AdvancedShipperConfigField">
					<?php echo zen_draw_input_field('fedex_meter', $fedex_meter, 'size="9" maxlength="9" id="fedex_meter" class="Textfield" onKeyPress="advshipperCheckEnterPressed(event)"'); ?>
				</td>
			</tr>
			<tr id="fedex_server_header" style="display: none;">
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="fedex_server_field"><?php echo TEXT_LABEL_FEDEX_SERVER; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_FEDEX_SERVER; ?>
				</td>
			</tr>
			<tr id="fedex_server_field" style="display: none;">
				<td class="AdvancedShipperConfigField">
					<?php echo advshipperBuildRadioField('fedex_server', 'p', ($fedex_server == 'p'), null, 'id="fedex_server_production" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="fedex_server_production"><?php echo TEXT_FEDEX_SERVER_PRODUCTION; ?></label>
					<br /><?php echo advshipperBuildRadioField('fedex_server', 't', ($fedex_server == 't'), null, 'id="fedex_server_test" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="fedex_server_test"><?php echo TEXT_FEDEX_SERVER_TEST; ?></label>
				</td>
			</tr>
			<tr id="fedex_weight_units_header" style="display: none;">
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="fedex_weight_units_field"><?php echo TEXT_LABEL_FEDEX_WEIGHT_UNITS; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_FEDEX_WEIGHT_UNITS; ?>
				</td>
			</tr>
			<tr id="fedex_weight_units_field" style="display: none;">
				<td class="AdvancedShipperConfigField">
					<?php echo advshipperBuildRadioField('fedex_weight_units', 'kg', ($fedex_weight_units == 'kg'), null, 'id="fedex_weight_units_kg" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="fedex_weight_units_kg"><?php echo TEXT_FEDEX_WEIGHT_UNITS_KG; ?></label>
					<br /><?php echo advshipperBuildRadioField('fedex_weight_units', 'lb', ($fedex_weight_units == 'lb'), null, 'id="fedex_weight_units_lb" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="fedex_weight_units_lb"><?php echo TEXT_FEDEX_WEIGHT_UNITS_LB; ?></label>
				</td>
			</tr>
			<tr id="fedex_rate_request_types_header" style="display: none;">
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="fedex_rate_request_types_field"><?php echo TEXT_LABEL_FEDEX_RATE_REQUEST_TYPES; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_FEDEX_RATE_REQUEST_TYPES; ?>
				</td>
			</tr>
			<tr id="fedex_rate_request_types_field" style="display: none;">
				<td class="AdvancedShipperConfigField">
					<?php echo advshipperBuildRadioField('fedex_rate_request_types', 1, ($fedex_rate_request_types == 1), null, 'id="fedex_rate_request_types_account_only" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="fedex_rate_request_types_account_only"><?php echo TEXT_FEDEX_RATE_REQUEST_TYPES_ACCOUNT_ONLY; ?></label>
					<br /><?php echo advshipperBuildRadioField('fedex_rate_request_types', 2, ($fedex_rate_request_types == 2), null, 'id="fedex_rate_request_types_list_only" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="fedex_rate_request_types_list_only"><?php echo TEXT_FEDEX_RATE_REQUEST_TYPES_LIST_ONLY; ?></label>
					<br /><?php echo advshipperBuildRadioField('fedex_rate_request_types', 3, ($fedex_rate_request_types == 3), null, 'id="fedex_rate_request_types_account_and_list" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="fedex_rate_request_types_account_and_list"><?php echo TEXT_FEDEX_RATE_REQUEST_TYPES_ACCOUNT_AND_LIST; ?></label>
				</td>
			</tr>
			<tr id="fedex_drop_off_type_header" style="display: none;">
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="fedex_drop_off_type_field"><?php echo TEXT_LABEL_FEDEX_DROP_OFF_TYPE; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_FEDEX_DROP_OFF_TYPE; ?>
				</td>
			</tr>
			<tr id="fedex_drop_off_type_field" style="display: none;">
				<td class="AdvancedShipperConfigField">
					<?php echo advshipperBuildRadioField('fedex_drop_off_type', 'REGULAR_PICKUP', ($fedex_drop_off_type == 'REGULAR_PICKUP'), null, 'id="fedex_drop_off_type_regular_pickup" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="fedex_drop_off_type_regular_pickup"><?php echo TEXT_FEDEX_DROP_OFF_TYPE_REGULAR_PICKUP; ?></label>
					<br /><?php echo advshipperBuildRadioField('fedex_drop_off_type', 'BUSINESS_SERVICE_CENTER', ($fedex_drop_off_type == 'BUSINESS_SERVICE_CENTER'), null, 'id="fedex_drop_off_type_business_service_center" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="fedex_drop_off_type_business_service_center"><?php echo TEXT_FEDEX_DROP_OFF_TYPE_BUSINESS_SERVICE_CENTER; ?></label>
					<br /><?php echo advshipperBuildRadioField('fedex_drop_off_type', 'DROP_BOX', ($fedex_drop_off_type == 'DROP_BOX'), null, 'id="fedex_drop_off_type_drop_box" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="fedex_drop_off_type_drop_box"><?php echo TEXT_FEDEX_DROP_OFF_TYPE_DROP_BOX; ?></label>
					<br /><?php echo advshipperBuildRadioField('fedex_drop_off_type', 'REQUEST_COURIER', ($fedex_drop_off_type == 'REQUEST_COURIER'), null, 'id="fedex_drop_off_type_request_courier" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="fedex_drop_off_type_request_courier"><?php echo TEXT_FEDEX_DROP_OFF_TYPE_REQUEST_COURIER; ?></label>
					<br /><?php echo advshipperBuildRadioField('fedex_drop_off_type', 'STATION', ($fedex_drop_off_type == 'STATION'), null, 'id="fedex_drop_off_type_station" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="fedex_drop_off_type_station"><?php echo TEXT_FEDEX_DROP_OFF_TYPE_STATION; ?></label>
				</td>
			</tr>
			<tr id="fedex_packaging_type_header" style="display: none;">
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="fedex_packaging_type_field"><?php echo TEXT_LABEL_FEDEX_PACKAGING_TYPE; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_LABEL_FEDEX_PACKAGING_TYPE; ?>
				</td>
			</tr>
			<tr id="fedex_packaging_type_field" style="display: none;">
				<td class="AdvancedShipperConfigField">
					<?php echo advshipperBuildRadioField('fedex_packaging_type', 'YOUR_PACKAGING', ($fedex_packaging_type == 'YOUR_PACKAGING'), null, 'id="fedex_packaging_type_your_packaging" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="fedex_packaging_type_your_packaging"><?php echo TEXT_FEDEX_PACKAGING_TYPE_YOUR_PACKAGING; ?></label>
					<br /><?php echo advshipperBuildRadioField('fedex_packaging_type', 'FEDEX_ENVELOPE', ($fedex_packaging_type == 'FEDEX_ENVELOPE'), null, 'id="fedex_packaging_type_fedex_envelope" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="fedex_packaging_type_fedex_envelope"><?php echo TEXT_FEDEX_PACKAGING_TYPE_FEDEX_ENVELOPE; ?></label>
					<br /><?php echo advshipperBuildRadioField('fedex_packaging_type', 'FEDEX_BOX', ($fedex_packaging_type == 'FEDEX_BOX'), null, 'id="fedex_packaging_type_fedex_box" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="fedex_packaging_type_fedex_box"><?php echo TEXT_FEDEX_PACKAGING_TYPE_FEDEX_BOX; ?></label>
					<br /><?php echo advshipperBuildRadioField('fedex_packaging_type', 'FEDEX_10KG_BOX', ($fedex_packaging_type == 'FEDEX_10KG_BOX'), null, 'id="fedex_packaging_type_fedex_10kg_box" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="fedex_packaging_type_fedex_10kg_box"><?php echo TEXT_FEDEX_PACKAGING_TYPE_FEDEX_10KG_BOX; ?></label>
					<br /><?php echo advshipperBuildRadioField('fedex_packaging_type', 'FEDEX_25KG_BOX', ($fedex_packaging_type == 'FEDEX_25KG_BOX'), null, 'id="fedex_packaging_type_fedex_25kg_box" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="fedex_packaging_type_fedex_25kg_box"><?php echo TEXT_FEDEX_PACKAGING_TYPE_FEDEX_25KG_BOX; ?></label>
					<br /><?php echo advshipperBuildRadioField('fedex_packaging_type', 'FEDEX_PAK', ($fedex_packaging_type == 'FEDEX_PAK'), null, 'id="fedex_packaging_type_fedex_pak" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="fedex_packaging_type_fedex_pak"><?php echo TEXT_FEDEX_PACKAGING_TYPE_FEDEX_PAK; ?></label>
					<br /><?php echo advshipperBuildRadioField('fedex_packaging_type', 'FEDEX_TUBE', ($fedex_packaging_type == 'FEDEX_TUBE'), null, 'id="fedex_packaging_type_fedex_tube" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="fedex_packaging_type_fedex_tube"><?php echo TEXT_FEDEX_PACKAGING_TYPE_FEDEX_TUBE; ?></label>
				</td>
			</tr>
			<tr id="fedex_shipping_saturday_header" style="display: none;">
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label for="fedex_shipping_saturday_field"><?php echo TEXT_LABEL_FEDEX_SATURDAY_DELIVERY; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_FEDEX_SATURDAY_DELIVERY; ?>
				</td>
			</tr>
			<tr id="fedex_shipping_saturday_field" style="display: none;">
				<td class="AdvancedShipperConfigField">
					<?php echo advshipperBuildRadioField('fedex_shipping_saturday', '1', ($fedex_shipping_saturday == 1), null, 'id="fedex_shipping_saturday_true" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="fedex_shipping_saturday_true"><?php echo TEXT_FEDEX_SATURDAY_DELIVERY_YES; ?></label>
					<br /><?php echo advshipperBuildRadioField('fedex_shipping_saturday', '0', ($fedex_shipping_saturday == 0), null, 'id="fedex_shipping_saturday_false" onKeyPress="advshipperCheckEnterPressed(event)"'); ?> <label for="fedex_shipping_saturday_false"><?php echo TEXT_FEDEX_SATURDAY_DELIVERY_NO; ?></label>
				</td>
			</tr>
			<tr id="fedex_services_header" style="display: none;">
				<td rowspan="2" class="AdvancedShipperConfigLabel"><label><?php echo TEXT_LABEL_FEDEX_SERVICES; ?></label></td>
				<td class="AdvancedShipperConfigDesc">
					<?php echo TEXT_CONFIG_DESC_FEDEX_SERVICES; ?>
				</td>
			</tr>
			<tr id="fedex_services_field" style="display: none;">
				<td class="AdvancedShipperConfigField">
					
					<br /><?php echo advshipperBuildCheckboxField('fedex_shipping_service_fedex_1_day_freight', 1, ($fedex_shipping_service_fedex_1_day_freight == 1), null,  'id="fedex_shipping_service_fedex_1_day_freight" onkeypress="advshippercheckenterpressed(event)"') . ' <label for="fedex_shipping_service_fedex_1_day_freight">' . TEXT_FEDEX_1_DAY_FREIGHT. "</label>\n"; ?>
					<br /><?php echo advshipperBuildCheckboxField('fedex_shipping_service_fedex_2_day', 1, ($fedex_shipping_service_fedex_2_day == 1), null,  'id="fedex_shipping_service_fedex_2_day" onkeypress="advshippercheckenterpressed(event)"') . ' <label for="fedex_shipping_service_fedex_2_day">' . TEXT_FEDEX_2_DAY. "</label>\n"; ?>
					<br /><?php echo advshipperBuildCheckboxField('fedex_shipping_service_fedex_2_day_freight', 1, ($fedex_shipping_service_fedex_2_day_freight == 1), null,  'id="fedex_shipping_service_fedex_2_day_freight" onkeypress="advshippercheckenterpressed(event)"') . ' <label for="fedex_shipping_service_fedex_2_day_freight">' . TEXT_FEDEX_2_DAY_FREIGHT. "</label>\n"; ?>
					<br /><?php echo advshipperBuildCheckboxField('fedex_shipping_service_fedex_3_day_freight', 1, ($fedex_shipping_service_fedex_3_day_freight == 1), null,  'id="fedex_shipping_service_fedex_3_day_freight" onkeypress="advshippercheckenterpressed(event)"') . ' <label for="fedex_shipping_service_fedex_3_day_freight">' . TEXT_FEDEX_3_DAY_FREIGHT. "</label>\n"; ?>
					<br /><?php echo advshipperBuildCheckboxField('fedex_shipping_service_fedex_express_saver', 1, ($fedex_shipping_service_fedex_express_saver == 1), null,  'id="fedex_shipping_service_fedex_express_saver" onkeypress="advshippercheckenterpressed(event)"') . ' <label for="fedex_shipping_service_fedex_express_saver">' . TEXT_FEDEX_EXPRESS_SAVER. "</label>\n"; ?>
					<br /><?php echo advshipperBuildCheckboxField('fedex_shipping_service_fedex_ground', 1, ($fedex_shipping_service_fedex_ground == 1), null,  'id="fedex_shipping_service_fedex_ground" onkeypress="advshippercheckenterpressed(event)"') . ' <label for="fedex_shipping_service_fedex_ground">' . TEXT_FEDEX_GROUND. "</label>\n"; ?>
					<br /><?php echo advshipperBuildCheckboxField('fedex_shipping_service_ground_home_delivery', 1, ($fedex_shipping_service_ground_home_delivery == 1), null,  'id="fedex_shipping_service_ground_home_delivery" onkeypress="advshippercheckenterpressed(event)"') . ' <label for="fedex_shipping_service_ground_home_delivery">' . TEXT_FEDEX_GROUND_HOME_DELIVERY. "</label>\n"; ?>
					<br /><?php echo advshipperBuildCheckboxField('fedex_shipping_service_standard_overnight', 1, ($fedex_shipping_service_standard_overnight == 1), null,  'id="fedex_shipping_service_standard_overnight" onkeypress="advshippercheckenterpressed(event)"') . ' <label for="fedex_shipping_service_standard_overnight">' . TEXT_FEDEX_STANDARD_OVERNIGHT. "</label>\n"; ?>
					<br /><?php echo advshipperBuildCheckboxField('fedex_shipping_service_first_overnight', 1, ($fedex_shipping_service_first_overnight == 1), null,  'id="fedex_shipping_service_first_overnight" onkeypress="advshippercheckenterpressed(event)"') . ' <label for="fedex_shipping_service_first_overnight">' . TEXT_FEDEX_FIRST_OVERNIGHT. "</label>\n"; ?>
					<br /><?php echo advshipperBuildCheckboxField('fedex_shipping_service_priority_overnight', 1, ($fedex_shipping_service_priority_overnight == 1), null,  'id="fedex_shipping_service_priority_overnight" onkeypress="advshippercheckenterpressed(event)"') . ' <label for="fedex_shipping_service_priority_overnight">' . TEXT_FEDEX_PRIORITY_OVERNIGHT. "</label>\n"; ?>
					<br /><?php echo advshipperBuildCheckboxField('fedex_shipping_service_smart_post', 1, ($fedex_shipping_service_smart_post == 1), null,  'id="fedex_shipping_service_smart_post" onkeypress="advshippercheckenterpressed(event)"') . ' <label for="fedex_shipping_service_smart_post">' . TEXT_FEDEX_SMART_POST. "</label>\n"; ?>
					<br /><?php echo advshipperBuildCheckboxField('fedex_shipping_service_fedex_freight', 1, ($fedex_shipping_service_fedex_freight == 1), null,  'id="fedex_shipping_service_fedex_freight" onkeypress="advshippercheckenterpressed(event)"') . ' <label for="fedex_shipping_service_fedex_freight">' . TEXT_FEDEX_FREIGHT. "</label>\n"; ?>
					<br /><?php echo advshipperBuildCheckboxField('fedex_shipping_service_fedex_national_freight', 1, ($fedex_shipping_service_fedex_national_freight == 1), null,  'id="fedex_shipping_service_fedex_national_freight" onkeypress="advshippercheckenterpressed(event)"') . ' <label for="fedex_shipping_service_fedex_national_freight">' . TEXT_FEDEX_NATIONAL_FREIGHT. "</label>\n"; ?>
					<br /><?php echo advshipperBuildCheckboxField('fedex_shipping_service_international_ground', 1, ($fedex_shipping_service_international_ground == 1), null,  'id="fedex_shipping_service_international_ground" onkeypress="advshippercheckenterpressed(event)"') . ' <label for="fedex_shipping_service_international_ground">' . TEXT_FEDEX_INTERNATIONAL_GROUND. "</label>\n"; ?>
					<br /><?php echo advshipperBuildCheckboxField('fedex_shipping_service_international_economy', 1, ($fedex_shipping_service_international_economy == 1), null,  'id="fedex_shipping_service_international_economy" onkeypress="advshippercheckenterpressed(event)"') . ' <label for="fedex_shipping_service_international_economy">' . TEXT_FEDEX_INTERNATIONAL_ECONOMY. "</label>\n"; ?>
					<br /><?php echo advshipperBuildCheckboxField('fedex_shipping_service_international_economy_freight', 1, ($fedex_shipping_service_international_economy_freight == 1), null,  'id="fedex_shipping_service_international_economy_freight" onkeypress="advshippercheckenterpressed(event)"') . ' <label for="fedex_shipping_service_international_economy_freight">' . TEXT_FEDEX_INTERNATIONAL_ECONOMY_FREIGHT. "</label>\n"; ?>
					<br /><?php echo advshipperBuildCheckboxField('fedex_shipping_service_international_first', 1, ($fedex_shipping_service_international_first == 1), null,  'id="fedex_shipping_service_international_first" onkeypress="advshippercheckenterpressed(event)"') . ' <label for="fedex_shipping_service_international_first">' . TEXT_FEDEX_INTERNATIONAL_FIRST. "</label>\n"; ?>
					<br /><?php echo advshipperBuildCheckboxField('fedex_shipping_service_international_priority', 1, ($fedex_shipping_service_international_priority == 1), null,  'id="fedex_shipping_service_international_priority" onkeypress="advshippercheckenterpressed(event)"') . ' <label for="fedex_shipping_service_international_priority">' . TEXT_FEDEX_INTERNATIONAL_PRIORITY. "</label>\n"; ?>
					<br /><?php echo advshipperBuildCheckboxField('fedex_shipping_service_international_priority_freight', 1, ($fedex_shipping_service_international_priority_freight == 1), null,  'id="fedex_shipping_service_international_priority_freight" onkeypress="advshippercheckenterpressed(event)"') . ' <label for="fedex_shipping_service_international_priority_freight">' . TEXT_FEDEX_INTERNATIONAL_PRIORITY_FREIGHT. "</label>\n"; ?>
					<br /><?php echo advshipperBuildCheckboxField('fedex_shipping_service_europe_first_international_priority', 1, ($fedex_shipping_service_europe_first_international_priority == 1), null,  'id="fedex_shipping_service_europe_first_international_priority" onkeypress="advshippercheckenterpressed(event)"') . ' <label for="fedex_shipping_service_europe_first_international_priority">' . TEXT_FEDEX_EUROPE_FIRST_INTERNATIONAL_PRIORITY. "</label>\n"; ?>
				</td>
			</tr>
		</table>
	</fieldset>
</fieldset>
					</td>
				</tr>
				<tr>
					<td align="right" style="padding-bottom: 1.5em">
						<?php
						if ($update_region == false) {
							echo zen_image_submit('button_insert.gif', IMAGE_INSERT, 'name="region_insert_submit" value="region_insert_submit" id="region_insert_submit" onclick="javascript:advshipperSaveRegion(region, \'' . $update_region . '\'); return false;"');
						} else {
							echo zen_image_submit('button_update.gif', IMAGE_UPDATE, 'name="region_insert_submit" value="region_insert_submit" id="region_insert_submit" onclick="javascript:advshipperSaveRegion(region, \'' . $update_region . '\'); return false;"');
						}
						echo ' ' . zen_image_submit('button_cancel.gif', IMAGE_CANCEL, 'name="region_insert_cancel_submit" value="region_insert_cancel_submit" id="region_insert_cancel_submit" onclick="javascript:advshipperCancelRegionConfig(); return false;"');
						?>
					</td>
				</tr>
			</table>
		</td>
<!-- body_text_eof //-->
	</tr>
</table>
</form>
<!-- body_eof //-->

</body>
</html>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>