<?php

/**
 * Ceon URI Mappings Manager Main Dashboard.
 *
 * Builds the dashboard page for the software.
 * 
 * @package     ceon_uri_mappings_manager
 * @author      Conor Kerr <zen-cart.uri-mappings-manager@ceon.net>
 * @copyright   Copyright 2011-2012 Ceon
 * @copyright   Copyright 2003-2007 Zen Cart Development Team
 * @copyright   Portions Copyright 2003 osCommerce
 * @link        http://ceon.net/software/business/zen-cart/uri-mappings-manager
 * @license     http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version     $Id: ceon_umm.php 1059 2012-10-01 16:43:34Z conor $
 */

require('includes/application_top.php');

$languages = zen_get_languages();
$num_languages = sizeof($languages);

// Be sure each $_GET parameter starts without amp;
if (!empty($_GET) && is_array($_GET)) {
	foreach ($_GET as $getkey => $getval) {
		while (strpos($getkey, 'amp;') === 0 && !isset($_GET[substr($getkey, 4)])) {
			$_GET[substr($getkey, 4)] = $getval;
			unset($_GET[$getkey]);
			$getkey = substr($getkey, 4);
		}
	}
}

/**
 * Load in the Ceon URI Mappings Manager class
 */
require_once(DIR_WS_CLASSES . 'class.CeonUMM.php');

$mappings_manager = new CeonUMM();

?>
<!DOCTYPE html>
<html <?php echo HTML_PARAMS; ?>>
<head>
	<title><?php echo TITLE; ?></title>
	<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
	<meta http-equiv="X-UA-Compatible" content="IE=9">
	<link rel="stylesheet" type="text/css" href="includes/stylesheet.css">
	<link rel="stylesheet" type="text/css" href="includes/cssjsmenuhover.css" media="all" id="hoverJS">
	<script type="text/javascript" src="includes/menu.js"></script>
	<script type="text/javascript" src="includes/general.js"></script>
	<script type="text/javascript">
		<!--
		function init()
		{
			cssjsmenu('navbar');
			if (document.getElementById)
			{
				var kill = document.getElementById('hoverJS');
				kill.disabled = true;
			}
		}
		// -->
	</script>
	<style type="text/css">
	#ceon-uri-mappings-manager-wrapper {
		margin: 0 0.8em 0 0.8em;
	}
	h1.CeonAdminPageHeading { margin: 0; padding-top: 1em; padding-bottom: 1.2em; }
	fieldset { padding: 0.8em 0.8em; }
	fieldset fieldset { margin-bottom: 1em; }
	fieldset fieldset legend { font-size: 1.3em; }
	fieldset fieldset fieldset legend { font-size: 1.2em; }
	legend { font-weight: bold; font-size: 1.3em; background: transparent; }
	.SpacerSmall { clear: both; }
	.Underlined { text-decoration: underline; }
	
	fieldset.CeonPanel {
		display: none;
		background: #fff;
		border: 1px solid #296629;
	}
	fieldset.CeonPanel legend { background: #fff; padding: 0.1em 0.4em 0.6em 0.4em; }
	fieldset.CeonPanel fieldset legend { background: none; }
	
	ul {
		padding-left: 1.4em;
	}
	#ceon-uri-mappings-manager-wrapper ul li {
		margin-bottom: 0.7em;
		line-height: 1.3;
	}
	
	ul#ceon-panels-menu {
		list-style: none;
		margin: 1em 0 0 0;
		padding: 0 0 0.6em 0;
		background: #599659;
		white-space: nowrap;
	}
	ul#ceon-panels-menu li {
		display: inline;
		padding: 0;
		margin: 0;
	}
	ul#ceon-panels-menu li a {
		background: #79b679 url(<?php echo DIR_WS_IMAGES; ?>ceon-tab-background.png) bottom left repeat-x;
		color: #fff;
		padding: 0.4em 2em 0.8em 2em;
		font-weight: bold;
		margin: 0 0.4em 0 0;
		border-left: 1px solid #79b679;
		border-top: 1px solid #79b679;
	}
	ul#ceon-panels-menu li a:hover {
		background: #89c689;
		border-left: 1px solid #89c689;
		border-top: 1px solid #89c689;
	}
	ul#ceon-panels-menu li a:visited, ul#ceon-panels-menu li a:active,
	ul#ceon-panels-menu li a:focus {
		outline: none;
	}
	
	ul#ceon-panels-menu li.CeonPanelTabSelected {
		display: inline;
		padding: 0;
	}
	ul#ceon-panels-menu li.CeonPanelTabSelected a {
		background: #599659 url(<?php echo DIR_WS_IMAGES; ?>ceon-tab-background-selected.png) top left repeat-x;
		padding: 0.8em 2em;
		border-left: 1px solid #69a669;
		border-top: 1px solid #69a669;
	}
	ul#ceon-panels-menu li.CeonPanelTabSelected a:hover {
		text-decoration: none;
		background: #599659;
		border-left: 1px solid #69a669;
		border-top: 1px solid #69a669;
	}
	ul#ceon-panels-menu li.CeonPanelTabSelected a:visited,
	ul#ceon-panels-menu li.CeonPanelTabSelected a:active,
	ul#ceon-panels-menu li.CeonPanelTabSelected a:focus {
		outline: none;
	}
	
	#ceon-panels-wrapper {
		border: 1px solid #599659;
		background: #599659;
		padding: 1em;
		padding-top: 1.4em;
		margin-bottom: 0.8em;
	}
	
	ul li img {
		vertical-align: middle;
	}
	
	ul.SubPanelMenu {
		list-style: none;
		margin: 0 0 1em 0;
		padding: 0;
	}
	.SubPanelMenu li {
		display: inline;
	}
	.SubPanelMenu li a {
		display: block;
		float: left;
		padding: 0.45em 0.9em;
		background: #ccc;
		margin: 0 0.2em 0.2em 0;
		border-top: 2px solid #ddd;
		border-left: 2px solid #ddd;
		border-right: 2px solid #c0c0c0;
		border-bottom: 2px solid #c0c0c0;
		color: #000;
		font-weight: bold;
	}
	.SubPanelMenu li a:hover {
		background: #5989d6;
		border-top: 2px solid #7999e6;
		border-left: 2px solid #7999e6;
		border-right: 2px solid #3959a6;
		border-bottom: 2px solid #3959a6;
		text-decoration: underline;
		color: #fff;
	}
	
	.SubPanelMenuSpacer {
		clear: both;
		margin-bottom: 1.5em;
	}
	
	fieldset.ContainingSubPanel {
		background: #eee;
	}
	fieldset fieldset {
		background: #fff;
	}
	fieldset.ContainingSubPanel fieldset {
		box-shadow: inset 0px 0px 8px 1px #eaeaea;
	}
	
	input.Textfield {
		background: url(<?php echo DIR_WS_IMAGES; ?>ceon-input-fade-tb-gray-white.png) repeat-x left top;
		border: 1px solid #ccc;
		color: #000;
		padding: 4px;
		font-size: 1.1em;
		line-height: 1;
		margin-bottom: 0.2em;
	}
	input.Textfield:hover, input.Textfield:focus {
		border: 1px solid #999;
	}
	
	fieldset#default-categories-products-mapping-templates,
	fieldset#default-manufacturers-mapping-templates
	fieldset#ez-pages-mapping-templates
	fieldset#other-pages-mapping-templates{
		margin-right: 32%;
		
	}
	fieldset#create-manage-category-products, fieldset#create-manage-manufacturers,
	fieldset#create-manage-ez-pages, fieldset#create-manage-other-pages {
		width: 27%;
		float: right;
	}
	
	p#default-product-mapping-templates-intro {
		margin-top: 1.2em;
	}
	
	label.DefaultMappingTemplates, label.Mappings, label.MappingTemplates {
		width: 32%;
		float: left;
		font-weight: bold;
	}
	label.Mappings {
		width: 18%;
	}
	label.MappingTemplates {
		width: 25%;
	}
	ul.DefaultMappingTemplatesFields, ul.MappingsFields, ul.MappingTemplatesFields {
		margin: 0 0 0 34%;
		padding: 0 0 0 0;
		list-style: none;
	}
	ul.MappingsFields {
		margin: 0 0 0 20%;
	}
	ul.MappingTemplatesFields {
		margin: 0 0 0 27%;
	}
	ul.DefaultMappingTemplatesFields li, ul.MappingsFields li,
	ul.MappingTemplatesFields li {
		margin-bottom: 0.4em;
	}
	ul.DefaultMappingTemplatesFields input, ul.MappingsFields input,
	ul.MappingTemplatesFields input, ul.ManufacturerMappings input, ul.PageMappings input,
	ul.OtherPageMappings input {
		vertical-align: middle;
		width: 90%;
		padding: 0.2em;
		font-size: 1.2em;
	}
	
	p.MappingError, p.MappingTemplateError {
		margin: 0.2em 0 0.5em 40px;
		color: #f00;
	}
	
	.DefaultMappingTemplatesSubmit, .MappingsSubmit, .MappingTemplatesSubmit {
		margin-left: 22.8em;
		margin: 0.8em 0 0.3em 40.2%;
	}
	.MappingsSubmit {
		margin: 0.8em 0 0.3em 24.2%;
	}
	.MappingTemplatesSubmit {
		margin: 0.8em 0 0.3em 31.2%;
	}
	
	fieldset#manufacturers-uri-mappings {
		margin-top: 2.5em;
	}
	
	
	h3#manage-category-products-title {
		margin-top: 2em;
	}
	
	fieldset#manage-object-mappings, fieldset#manage-object-mapping-templates {
		box-shadow: inset 0px 0px 8px 1px #ddd;
	}
	
	p.ButtonLink {
		margin: 0.2em 0 0 0;
	}
	
	p.ButtonLink a, input.DefaultMappingTemplatesSubmit, input.MappingsSubmit,
	input.MappingTemplatesSubmit {
		display: block;
		background: #599659;
		border-top: 2px solid #79b679;
		border-left: 2px solid #79b679;
		border-right: 2px solid #397639;
		border-bottom: 2px solid #397639;
		padding: 0.3em 0.7em 0.4em 0.7em;
		color: #fff;
		font-weight: bold;
		white-space: nowrap;
		cursor: pointer;
		font-size: 1.1em;
	}
	p.ButtonLink a:hover, input.DefaultMappingTemplatesSubmit:hover, input.MappingsSubmit:hover,
	input.MappingTemplatesSubmit:hover {
		background: #79b679;
		border-top: 2px solid #99d699;
		border-left: 2px solid #99d699;
		border-right: 2px solid #599659;
		border-bottom: 2px solid #599659;
		text-decoration: underline;
		color: #fff;
	}
	
	.CeonFormItemLabel, .CeonFormItemField, .CeonFormItemDesc {
		vertical-align: top;
	}
	.CeonFormItemLabel { font-weight: bold; padding-right: 1em; }
	.CeonFormItemLabel { width: 20%; }
	.CeonFormItemDesc p { margin-bottom: 0.5em; }
	.CeonFormItemField { padding-bottom: 1.3em; }
	
	fieldset.CeonPanel h1 {
		margin-top: 0;
	}
	
	fieldset.CeonPanel h3 {
		margin-top: 0;
	}
	
	p {
		margin: 0 0 0.8em 0;
		line-height: 1.3;
	}
	
	.ErrorIntro {
		margin: 0em 0 1.5em 0em;
		background: #f00;
		color: #fff;
		padding: 0.4em;
		font-weight: bold;
	}
	.FormError { font-weight: bold; color: #f00; }
	
	#ceon-uri-mappings-manager-wrapper ul li.LastIntro {
		margin-bottom: 2.2em;
	}
	
	.Collapse { display:  none; }
	.FloatLeft { float: left; }
	
	div.AutogenerateControlsWrapper {
		float: right;
	}
	div.AutogenerateControlsWrapper legend {
		padding-bottom: 0;
	}
	
	#autogenerate-controls-top {
		margin-top: 2.5em;
	}
	
	.AutogenerateControls p.AutogenerationOptions {
		margin-right: 0.8em;
	}
	
	input.AutogenerateURIMappingsButton, input.SaveURIMappingsButton {
		background: #599659;
		border-top: 2px solid #79b679;
		border-left: 2px solid #79b679;
		border-right: 2px solid #397639;
		border-bottom: 2px solid #397639;
		padding: 0.3em 0.7em 0.4em 0.7em;
		color: #fff;
		font-weight: bold;
		white-space: nowrap;
		cursor: pointer;
		margin-bottom: 0.2em;
		font-size: 1.1em;
		text-align: left;
	}
	input.AutogenerateURIMappingsButton:hover, input.SaveURIMappingsButton:hover {
		background: #79b679;
		border-top: 2px solid #99d699;
		border-left: 2px solid #99d699;
		border-right: 2px solid #599659;
		border-bottom: 2px solid #599659;
		text-decoration: underline;
	}
	input.AutogenerateURIMappingsButton {
		width: 100%;
	}
	
	h2 {
		font-size: 1.5em;
		margin-top: 0;
	}
	h3 {
		font-size: 1.2em;
	}
	
	ul.MainCategoryMappings, ul.MainMappingTemplates, ul.CategoryMappings,
	ul.CategoryMappingTemplates, ul.ProductMappings, ul.ManufacturerMappings, ul.PageMappings,
	ul.AutogenerationDefineText {
		margin: 0 0 0.4em 0;
		padding: 0 0 0 0em;
		list-style: none;
	}
	.MappingLanguageIcon {
		width: 35px;
		margin-right: 10px;
	}
	
	p.MainMappingTemplatesIntro {
		margin: 0.7em 0 0.6em 0;
		line-height: 1;
	}
	p.MainMappingTemplatesIntro label {
		color: #999;
	}
	
	p.MainMappingTemplatesIntro.Manufacturers, p.MainMappingTemplatesIntro.EZPages,
	p.MainMappingTemplatesIntro.OtherPages {
		margin-top: 2.5em;
	}
	
	h2.CreateManageCategoryHasProducts {
		margin-top: 2em;
	}
	
	.Listing {
		width: 100%;
		clear: both;
	}
	.Listing th {
		text-align: left;
		padding: 0.4em 0.8em 0.4em 0.4em;
		background: #99D699;
		border-right: 1px solid #fff;
		border-bottom: 1px solid #fff;
	}
	.Listing td {
		padding: 0.4em 0.8em 0.4em 0.4em;
		vertical-align: top;
		border-right: 1px solid #fff;
		border-bottom: 1px solid #fff;
	}
	
	.Listing th#checkboxes-col {
		width: 1em;
	}
	.Listing th#id-col {
		width: 3em;
	}
	
	.Listing .EvenRow td {
		background: #eee;
	}
	.Listing .OddRow td {
		background: #dcdcdc;
	}
	
	.Listing .EvenRowOver td {
		background: #a9e6a9;
	}
	.Listing .OddRowOver td {
		background: #a9e6a9;
	}
	
	.Listing h3 a, .Listing h3 a:visited {
		font-size: 1.2em;
		font-weight: bold;
		color: #000;
	}
	
	.NoCurrentMapping {
		color: #777;
	}
	
	#mapping-templates-form h3 {
		margin: 1.8em 0 0.4em 0;
		padding-bottom: 0.2em;
		border-bottom: 1px solid #ccc;
	}
	#mapping-templates-form h3.First {
		margin-top: 0.4em;
	}
	
	p.CategoryMappingTemplatesIntro {
		margin: 0.7em 0 0.6em 0;
		line-height: 1;
	}
	p.CategoryMappingTemplatesIntro label {
		color: #000;
	}
	
	td.ListingItemControls {
		text-align: right;
	}
	
	.ListingItemControls p.ButtonLink a {
		float: right;
		margin-left: 0.2em;
	}
	
	.ListingItemControls p.ButtonLink.ManageMappingsButton a,
	.ListingItemControls p.ButtonLink.ManageTemplatesButton a {
		background: #999;
		border-top: 2px solid #aaa;
		border-left: 2px solid #aaa;
		border-right: 2px solid #888;
		border-bottom: 2px solid #888;
		margin-bottom: 0.2em;
	}
	.ListingItemControls p.ButtonLink.ManageMappingsButton a:hover,
	.ListingItemControls p.ButtonLink.ManageTemplatesButton a:hover {
		background: #79b679;
		border-top: 2px solid #99d699;
		border-left: 2px solid #99d699;
		border-right: 2px solid #599659;
		border-bottom: 2px solid #599659;
	}
	
	.ManufacturerMappings .TextField, .PageMappings .Textfield {
		width: 80%;
	}
	
	p.SaveURIMappingsButton {
		text-align: right;
		margin: 1em 0 2em 0;
	}
	
	#autogenerate-controls-top.OtherPages {
		margin-top: 1.5em;
	}
	.MainMappingTemplatesIntro.OtherPages {
		margin-top: 2em;
	}
	
	
	input.AutogenerationOptionRadioGadget {
		float: left;
	}
	.AutogenerationOptionDesc {
		margin: 0;
		padding: 0;
		margin-left: 2.2em;
	}
	ul.AutogenerationDefineText {
		margin: 0.8em 0 0.6em 0;
	}
	ul.AutogenerationDefineText span {
		color: #5989d6;
	}
	ul.AutogenerationDefineText span:hover {
		color: #5989d6;
		cursor: help;
	}
	ul.AutogenerationDefineText span.AutogenerationOptionNoValueFound {
		color: #666;
		cursor: auto;
	}
	
	
	fieldset.CeonPanel h3.AutogenerationSectionTitle {
		margin: 1.9em 0 0.7em 0;
	}
	
	#ajax-request-in-progress {
		float: right;
	}
	#ajax-request-in-progress img {
		vertical-align: middle;
		margin-right: 6px;
	}
	
	.ProgressBar {
		margin: 1em 0 1em 0;
		border: 1px solid #000;
	}
	.ProgressBarIndicator {
		padding: 1em 2% 1em 2%;
		background: #5989d6;
		border-right: 1px solid #000;
	}
	
	#categories-generated-listing,
	#products-generated-listing,
	#category-errors-listing,
	#product-errors-listing {
		margin: 2em 2em 2em 2em;
		border: 1px solid #000;
		height: 12em;
		overflow: scroll;
	}
	
	#categories-generated-listing p,
	#products-generated-listing p,
	#category-errors-listing p,
	#product-errors-listing p {
		margin: 0 0 0.2em 0;
	}
	
	
	p.BackToTop, p.BackToTopNoSaveButton {
		float: right;
		text-align: right;
		margin-top: 0em;
	}
	p.BackToTopNoSaveButton {
		margin-top: 1.5em;
	}
	.BackToTop img, .BackToTopNoSaveButton img {
		margin-left: 6px;
	}
	p.BackLink, p.BackToSection {
		margin-top: 1.5em;
	}
	.BackLink img, .BackToSection img {
		vertical-align: middle;
	}
	p.BackToSection.TopLink, p.BackLink.TopLink {
		margin-top: 3.5em;
		margin-bottom: 1em;
	}
	
	fieldset.CeonPanel h3.ImportOldURIsTitle {
		margin: 1.2em 0 0.2em 0;
	}
	
	.Steps ol {
		padding-left: 1.5em;
	}
	fieldset.Steps {
		margin-top: 2em;
	}
	p.Ticked {
		background: url(<?php echo DIR_WS_IMAGES; ?>icons/ceon-umm-tick.png) no-repeat left top;
		padding-left: 30px;
	}
	div.Crossed {
		background: url(<?php echo DIR_WS_IMAGES; ?>icons/ceon-umm-cross.png) no-repeat left top;
		padding-left: 30px;
	}
	div.RemainingInstructions {
		padding-left: 30px;
	}
	.Step {
		background: #eee;
		padding: 0.4em 0.5em 0.4em 0.5em;
		border: 1px solid #999;
	}
	div.Step {
		padding-bottom: 0;
		margin-bottom: 0.8em;
	}
	
	#ceon_umm_import_iframe {
		width: 100%;
		height: 600px;
	}
	
	#footer {
		margin-top: 1.5em;
		border-top: 1px solid #000;
		padding-top: 1em;
		text-align: right;
		font-size: 0.9em;
		padding-bottom: 2em;
	}
	#footer img {
		border: none;
	}
	#ceon-button-logo {
		float: left;
		margin-right: 14px;
	}
	#footer p {
		margin: 0 0 0.8em 0;
	}
	#footer p#version-info {
		padding: 0;
		line-height: 1.3
	}
	#footer p.Error {
		font-size: 1.1em;
	}
	</style>
	<!--[if IE]>
	<style type="text/css">
	fieldset {
		position: relative;
		padding-top: 2.2em;
	}
	legend, fieldset.CeonPanel legend {
		position: absolute;
		top: -0.55em;
		left: 0.2em;
		padding: 0 0.4em 0 0.4em;
	}
	fieldset fieldset {
		margin-bottom: 1.8em;
	}
	ul.DefaultMappingTemplatesFields input, ul.MappingsFields input,
	ul.MappingTemplatesFields input {
		width: 80%;
	}
	div.AutogenerateControlsWrapper {
		width: 28em;
	}
	input.TextField {
		height: 1.6em;
	}
	p.ButtonLink a:hover, input.DefaultMappingTemplatesSubmit:hover, input.MappingsSubmit:hover,
	input.MappingTemplatesSubmit:hover {
		background: #79b679;
		border-top: 2px solid #99d699;
		border-left: 2px solid #99d699;
		border-right: 2px solid #599659;
		border-bottom: 2px solid #599659;
		text-decoration: underline;
		color: #fff;
	}
	</style>
	<![endif]-->
</head>
<body onload="init()">
<a name="top" id="top"></a>
<!-- header //-->
<?php require(DIR_WS_INCLUDES . 'header.php'); ?>
<!-- header_eof //-->

<!-- body //-->
<div id="ceon-uri-mappings-manager-wrapper">
	<h1 class="pageHeading CeonAdminPageHeading"><?php echo HEADING_TITLE; ?></h1>
<?php

echo $mappings_manager->getOutput();

?>
</div>
<!-- body_eof //-->

<!-- footer //-->
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<!-- footer_eof //-->
</body>
</html>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>