<?php

include 'includes/application_top.php';

?>
<!doctype html>
<html <?php echo HTML_PARAMS; ?>>
    <head>
        <?php require DIR_WS_INCLUDES . 'admin_html_head.php'; ?>
        <!--Load the AJAX API FOR GOOGLE GRAPHS -->
        <script src="https://www.gstatic.com/charts/loader.js" title="google_graphs_api"></script>
    </head>
    <body class="indexDashboard">
        <!-- header //-->
        <?php require(DIR_WS_INCLUDES . 'header.php'); ?>
        <!-- header_eof //-->

        <?php

        function prePrintPre($arr) {
            echo '<pre>';
            print_r($arr);
            echo '</pre>';
        }

        function generateOrder($txID, $oID) {
            global $db;

            $details = adn_get_details($txID);

            if (isset($details['messages']['resultCode']) && $details['messages']['resultCode'] == "Error")
            {
                if (isset($details['messages']['message'][0]['code']) && $details['messages']['message'][0]['message'] == "E00040")
                {
                    echo "$txID not found in ADN";
                    prePrintPre($details);
                }
                else
                {
                    prePrintPre($details);
                }

                return;
            }

            $details = $details['transaction'];

            $customer = array();
            $cID = $details['customer']['id'] ?? null;

            if (isset($details['customer']['id']))
            {
                $customer['customer'] = array(
                    "email" => $details['customer']['email'],
                    "firstName" => $details['shipTo']['firstName'],
                    "lastName" => $details['shipTo']['lastName'],
                    "company" => $details['shipTo']['company'],
                    "address" => $details['shipTo']['address'],
                    "city" => $details['shipTo']['city'],
                    "state" => $details['shipTo']['state'],
                    "zip" => $details['shipTo']['zip'],
                    "country" => $details['shipTo']['country']
                );

                $customer['shipping'] = array(
                    "firstName" => $details['shipTo']['firstName'],
                    "lastName" => $details['shipTo']['lastName'],
                    "company" => $details['shipTo']['company'],
                    "address" => $details['shipTo']['address'],
                    "city" => $details['shipTo']['city'],
                    "state" => $details['shipTo']['state'],
                    "zip" => $details['shipTo']['zip'],
                    "country" => $details['shipTo']['country']
                );

                $customer['billing'] = array(
                    "firstName" => $details['billTo']['firstName'],
                    "lastName" => $details['billTo']['lastName'],
                    "company" => $details['billTo']['company'],
                    "address" => $details['billTo']['address'],
                    "city" => $details['billTo']['city'],
                    "state" => $details['billTo']['state'],
                    "zip" => $details['billTo']['zip'],
                    "country" => $details['billTo']['country']
                );
            }
            else
            {
                echo 'Customer not set';
                prePrintPre($details);
                return;
            }

            $order_dateTime = str_replace("T", " ", date("Y-m-d H:i:s", strtotime($details['submitTimeLocal'])));
            $order_responseCode = $details['responseCode'];
            $order_responseReasonCode = $details['responseReasonCode'];
            $order_authCode = $details['authCode'];

            $order_subtotalAmount = 0.00;
            $order_shippingAmount = $details['shipping']['amount'] ?? 0.00;
            $order_taxesAmount = $details['tax']['amount'] ?? 0.00;

            $order_totalAmount = $details['authAmount'];

            try
            {
                echo 'Starting transaction...<br>';
                $db->Execute("START TRANSACTION");

                $insertOrderQuery = "INSERT INTO `zen_orders`
                (`orders_id`, `customers_id`, `customers_name`, `customers_company`,
                `customers_street_address`, `customers_suburb`, `customers_city`, `customers_postcode`,
                `customers_state`, `customers_country`, `customers_telephone`, `customers_email_address`,
                `customers_address_format_id`, `delivery_name`, `delivery_company`, `delivery_street_address`,
                `delivery_suburb`, `delivery_city`, `delivery_postcode`, `delivery_state`,
                `delivery_country`, `delivery_address_format_id`, `billing_name`, `billing_company`,
                `billing_street_address`, `billing_suburb`, `billing_city`, `billing_postcode`,
                `billing_state`, `billing_country`, `billing_address_format_id`, `payment_method`,
                `payment_module_code`, `shipping_method`, `shipping_module_code`, `coupon_code`,
                `cc_type`, `cc_owner`, `cc_number`, `cc_expires`,
                `cc_cvv`, `last_modified`, `date_purchased`, `orders_status`,
                `orders_date_finished`, `currency`, `currency_value`, `order_total`,
                `order_tax`, `paypal_ipn_id`, `ip_address`, `order_weight`,
                `language_code`, `quickbooks`)
                VALUES
                ($oID, '$cID', '{$customer['customer']['firstName']} {$customer['customer']['lastName']}', '{$customer['customer']['company']}',
                '{$customer['customer']['address']}', NULL, '{$customer['customer']['city']}', '{$customer['customer']['zip']}',
                '{$customer['customer']['state']}', '{$customer['customer']['country']}', '000-000-0000', '{$customer['customer']['email']}',
                '1', '{$customer['shipping']['firstName']} {$customer['shipping']['lastName']}', '{$customer['shipping']['company']}', '{$customer['shipping']['address']}',
                NULL, '{$customer['shipping']['city']}', '{$customer['shipping']['zip']}', '{$customer['shipping']['state']}',
                '{$customer['shipping']['country']}', '1', '{$customer['billing']['firstName']} {$customer['billing']['lastName']}', '{$customer['billing']['company']}',
                '{$customer['billing']['address']}', NULL, '{$customer['billing']['city']}', '{$customer['billing']['zip']}',
                '{$customer['billing']['state']}', '{$customer['billing']['country']}', '1', 'new',
                'ADN', 'Ground', 'UPS_CUSTOM', '',
                NULL, NULL, NULL, NULL,
                NULL, '$order_dateTime', '$order_dateTime', '1',
                NULL, 'USD', 1, $order_totalAmount,
                $order_taxesAmount, '$txID', '', NULL,
                'en', '')
                ";

                echo 'Inserting order ' . $oID . '...<br>';
                $db->Execute($insertOrderQuery);
                echo 'Done.<br>';

                foreach ($details['lineItems'] as $item)
                {
                    $model = $item['itemId'];

                    $selectProductQuery = "SELECT
                    `products_id`, `products_weight`, `manufacturers_id`
                    FROM `zen_products`
                    WHERE `products_model` = '$model'";

                    $selectProductQueryResult = $db->Execute($selectProductQuery);

                    $prid = $selectProductQueryResult->fields['products_id'];
                    $pname = $item['name'];
                    $pdesc = $item['description'];
                    $pquantity = $item['quantity'];
                    $pprice = $item['unitPrice'];
                    $order_subtotalAmount += $pprice * $pquantity;
                    $pweight = $selectProductQueryResult->fields['products_weight'];
                    $pmanid = $selectProductQueryResult->fields['manufacturer_id'];

                    $insertProductQuery = "INSERT INTO `zen_orders_products`
                    (`orders_products_id`, `orders_id`, `products_id`, `products_model`,
                    `products_name`, `products_alt_name`, `products_price`, `final_price`,
                    `products_tax`, `products_quantity`, `onetime_charges`, `products_priced_by_attribute`,
                    `product_is_free`, `products_discount_type`, `products_discount_type_from`, `products_prid`,
                    `products_weight`, `products_virtual`, `product_is_always_free_shipping`, `products_quantity_order_min`,
                    `products_quantity_order_units`, `products_quantity_order_max`, `products_quantity_mixed`, `products_mixed_discount_quantity`,
                    `products_po`, `products_tracking`, `products_manufacturers_id`)
                    VALUES
                    (NULL, '$oID', '$prid', '$model',
                    '$pname', '$pdesc', '$pprice', '$pprice',
                    '0.0000', '$pquantity', '0.0000', '0',
                    '0', '0', '0', '$prid',
                    '$weight', NULL, NULL, NULL,
                    NULL, NULL, NULL, NULL,
                    NULL, NULL, '$pmanid')
                    ";

                    echo 'Inserting product(s)...';
                    $db->Execute($insertProductQuery);
                    echo 'Done.<br>';
                }

                $insertStatusHistoryQuery = "INSERT INTO `zen_orders_status_history`
                (`orders_status_history_id`, `orders_id`, `orders_status_id`, `date_added`,
                `customer_notified`, `comments`, `updated_by`)
                VALUES
                (NULL, '$oID', '1', '$order_dateTime',
                '0', 'Transaction: [ Auth: $order_authCode ID: $txID C: $order_responseCode:$order_responseReasonCode ]', 'ADN System')";

                echo 'Inserting status history...<br>';
                $db->Execute($insertStatusHistoryQuery);
                echo 'Done.<br>';

                $insertTotalQuery = "INSERT INTO `zen_orders_total`
                (`orders_total_id`, `orders_id`, `title`, `text`,
                `value`, `class`, `sort_order`)
                VALUES
                (NULL, '$oID', 'Sub-Total:', '$$order_subtotalAmount',
                '$order_subtotalAmount', 'ot_subtotal', '100'),
                (NULL, '$oID', 'Shipping:', '$$order_shippingAmount',
                '$order_shippingAmount', 'ot_upsc', '300'),
                (NULL, '$oID', 'Tax:', '$$order_taxesAmount',
                '$order_taxesAmount', 'ot_avatax', '700'),
                (NULL, '$oID', 'Total:', '$$order_totalAmount',
                '$order_totalAmount', 'ot_total', '999')
                ";

                echo 'Inserting totals...<br>';
                $db->Execute($insertTotalQuery);
                echo 'Done.<br>';

                echo 'Committing...<br>';
                $db->Execute("COMMIT");
                echo 'Done.<br>';
            }
            catch (Exception $e)
            {
                echo 'Rolling back...<br>';
                $db->Execute("ROLLBACK");
                echo 'Done.<br>';
            }

            echo '<a href="https://westechequipment.com/westeche?cmd=orders&oID=' . $oID . '&action=edit">Order inserted</a><br>';
        }

        $held = adn_get_held();

        $txs = array();

        foreach ($held['transactions'] as $heldTx)
        {
            $txs[] = "SELECT " . strtok($heldTx['invoiceNumber'], '-') . " AS order_id, " . $heldTx['transId'] . " AS tx_id";
        }

        $txsImp = implode(" UNION ", $txs);

        $query = $db->Execute("SELECT order_id, tx_id FROM ($txsImp) as all_orders LEFT JOIN zen_orders on all_orders.order_id = zen_orders.orders_id WHERE zen_orders.orders_id IS NULL");
        
        $missingTxs = array();

        while (!$query->EOF)
        {
            $missingTxs[$query->fields['tx_id']] = $query->fields['order_id']; 

            $query->MoveNext();
        }

        foreach ($missingTxs as $txid => $oid)
        {
            // generateOrder($txid, $oid);
            // prePrintPre(adn_get_details($txid));

            break;
        }

        prePrintPre(adn_get_details("44223274840"));

        ?>

    </body>
</html>
<?php require('includes/application_bottom.php'); ?>