<?php

/**
 * Ceon URI Mappings Manager Dashboard Class.
 *
 * @package     ceon_uri_mappings_manager
 * @author      Conor Kerr <zen-cart.uri-mappings-manager@ceon.net>
 * @copyright   Copyright 2011-2012 Ceon
 * @copyright   Copyright 2003-2007 Zen Cart Development Team
 * @copyright   Portions Copyright 2003 osCommerce
 * @link        http://ceon.net/software/business/zen-cart/uri-mappings-manager
 * @license     http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version     $Id: class.CeonUMMDashboard.php 1059 2012-10-01 16:43:34Z conor $
 */

/**
 * Load in the Ceon URI Mappings Manager Action class so it can be extended
 */
require_once(DIR_WS_CLASSES . 'class.CeonUMMAction.php');


// {{{ CeonUMMDashboard

/**
 * Being the default panel, displays the output of any installation/upgrade tasks undertaken. Otherwise simply
 * displays the dashboard messages. In future will allow configuration of the software.
 *
 * @package     ceon_uri_mappings_manager
 * @author      Conor Kerr <zen-cart.uri-mappings-manager@ceon.net>
 * @copyright   Copyright 2011-2012 Ceon
 * @copyright   Copyright 2003-2007 Zen Cart Development Team
 * @copyright   Portions Copyright 2003 osCommerce
 * @link        http://ceon.net/software/business/zen-cart/uri-mappings-manager
 * @license     http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 */
class CeonUMMDashboard extends CeonUMMAction
{
	// {{{ Class Constructor
	
	/**
	 * Creates a new instance of the class.
	 * 
	 * @access  public
	 */
	public function __construct($use_ajax_progress_indicators, $ajax_progress_refresh_sec,
		$standard_progress_refresh_sec)
	{
		// Load the language definition file for the current language
		@include_once(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . 'ceon_umm_dashboard.php');
		
		if (!defined('TEXT_SET_MAPPING_TEMPLATES') && $_SESSION['language'] != 'english') {
			// Fall back to english language file
			@include_once(DIR_WS_LANGUAGES . 'english/' . 'ceon_umm_dashboard.php');
		}
		
		parent::__construct($use_ajax_progress_indicators, $ajax_progress_refresh_sec,
			$standard_progress_refresh_sec);
		
		// Run the actual functionality and build the output
		$this->_buildDashboardPanel();
	}
	
	// }}}
	
	
	// {{{ _buildDashboardPanel()
	
	/**
	 * Builds the dashboard panel. Processes the submission of configuration values. Any mistakes/errors are added
	 * to the list of error messages, for display later.
	 *
	 * @access  protected
	 * @return  none
	 */
	protected function _buildDashboardPanel()
	{
		global $db, $languages, $num_languages, $ceon_uri_mapping_demo, $messageStack;
		
		$content = '';
		
		if (!empty($this->_posted_data) && is_array($this->_posted_data)) {
			$this->_use_ajax_progress_indicators =
				(($this->_posted_data['use-ajax-progress-indicators'] == 1) ? true : false);
			
			$this->_ajax_progress_refresh_sec = $this->_posted_data['ajax-progress-refresh-msec'];
			$this->_standard_progress_refresh_sec = $this->_posted_data['standard-progress-refresh-sec'];
			$this->_automatic_version_checking = $this->_posted_data['automatic-version-checking'];
			
			// Save the configuration
			if (!$ceon_uri_mapping_demo && sizeof($this->_error_messages) == 0) {
				
				$save_config_data_array = array(
					'use_ajax_progress_indicators' => ($this->_use_ajax_progress_indicators ? 1 : 0),
					'ajax_progress_refresh_sec' => $this->_ajax_progress_refresh_sec,
					'standard_progress_refresh_sec' => $this->_standard_progress_refresh_sec,
					'automatic_version_checking' => $this->_automatic_version_checking
					);
				
				// Only one config currently supported so ID is hard-coded
				$selection_sql = "id = '1'";
				
				$save_config_result =
					zen_db_perform(TABLE_CEON_UMM_CONFIGS, $save_config_data_array, 'update', $selection_sql);
				
				if ($save_config_result) {
					if ($ceon_uri_mapping_demo) {
						$messageStack->add(SUCCESS_CONFIGURATION_SAVED_DEMO, 'success');
					} else {
						$messageStack->add(SUCCESS_CONFIGURATION_SAVED, 'success');
					}
				}
			}
		}
		
		$content .= '<fieldset id="dashboard-intro" class="ContainingSubPanel">' .
			'<legend>Ceon URI Mappings Manager</legend>' . "\n";
		
		$content .= '<p>' . TEXT_PURCHASE_THANKS . '</p>';
		
		$content .= '<p>' . TEXT_NOTES_1 . '</p>';
		
		$content .= '<p>' . TEXT_NOTES_2 . '</p>';
		
		$content .= '<p>' . TEXT_FORTHCOMING_VERSIONS_NOTES . '</p>';
		
		$content .= '</fieldset>' . "\n";
		
		
		$this->_output = $content;
	}
	
	// }}}
}

// }}}
