<?php

/**
 * Ceon URI Mappings Manager Listing Class.
 *
 * @package     ceon_uri_mappings_manager
 * @author      Conor Kerr <zen-cart.uri-mappings-manager@ceon.net>
 * @copyright   Copyright 2011-2012 Ceon
 * @copyright   Copyright 2003-2007 Zen Cart Development Team
 * @copyright   Portions Copyright 2003 osCommerce
 * @link        http://ceon.net/software/business/zen-cart/uri-mappings-manager
 * @license     http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version     $Id: class.CeonUMMListing.php 1059 2012-10-01 16:43:34Z conor $
 */

/**
 * Load in the Ceon URI Mappings Manager Action class so it can be extended
 */
require_once(DIR_WS_CLASSES . 'class.CeonUMMAction.php');


// {{{ CeonUMMListing

/**
 * Contains shared functionality for actions which involve listings of URI mappings.
 *
 * @package     ceon_uri_mappings_manager
 * @abstract
 * @author      Conor Kerr <zen-cart.uri-mappings-manager@ceon.net>
 * @copyright   Copyright 2011-2012 Ceon
 * @copyright   Copyright 2003-2007 Zen Cart Development Team
 * @copyright   Portions Copyright 2003 osCommerce
 * @link        http://ceon.net/software/business/zen-cart/uri-mappings-manager
 * @license     http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 */
class CeonUMMListing extends CeonUMMAction
{
	// {{{ properties
	
	/**
	 * The status of a listing's select all gadget.
	 *
	 * @var     boolean
	 * @access  protected
	 */
	protected $_select_all = null;
	
	/**
	 * The status of the selection of a list item's checkbox.
	 *
	 * @var     array
	 * @access  protected
	 */
	protected $_selected_items = null;
	
	/**
	 * The previous mappings for the object, or list of objects, currently being managed. Individual mappings are
	 * indexed by language ID.
	 *
	 * @var     array(string)
	 * @access  protected
	 */
	protected $_prev_mappings = null;
	
	/**
	 * The current mappings for the object, or list of objects, currently being managed. Individual mappings are
	 * indexed by language ID.
	 *
	 * @var     array(string)
	 * @access  protected
	 */
	protected $_mappings = array();
	
	// }}}
	
	
	// {{{ Class Constructor
	
	/**
	 * Creates a new instance of the class.
	 * 
	 * @access  public
	 */
	public function __construct()
	{
		parent::__construct();
	}
	
	// }}}
	
	
	
	// {{{ _handleItemSelections()
	
	/**
	 * Simply looks at what items have been selected, by examining the posted data for the given key, and sets up
	 * the variables for the form.
	 *
	 * @access  protected
	 * @return  none
	 */
	protected function _handleItemSelections($key)
	{
		$this->_select_all = (isset($this->_posted_data['select-all']) ? true : false);
		
		if (!isset($this->_posted_data[$key])) {
			// No items selected!
			return;
		}
		
		foreach ($this->_posted_data[$key] as $item_id) {
			$this->_selected_items[] = $item_id;
		}
		
	}
	
	// }}
}

// }}}
