<?php

if (class_exists('AdminRequestSanitizer')) {
  $sanitizer = AdminRequestSanitizer::getInstance();
  $group = array(
  'method_admin_titles' => array(
                                 'sanitizerType' => 'PRODUCT_DESC_REGEX', 
                                 'method' => 'post', 
                                 'pages' => array('advshipper_method_config')
                                 ),
  'method_titles' => array(
                           'sanitizerType' => 'PRODUCT_DESC_REGEX', 
                           'method' => 'post', 
                           'pages' => array('advshipper_method_config')
                           ),
  );
  $sanitizer->addComplexSanitization($group);
  return;
}

if ((isset($_SERVER['HTTP_HOST']) || PHP_SAPI != 'cli') && isset($_SERVER["REMOTE_ADDR"]) && ($_SERVER["REMOTE_ADDR"] != $_SERVER["SERVER_ADDR"])) {
  return;
}

if (!($_SERVER['SCRIPT_NAME'] != DIR_WS_ADMIN . (!strstr(FILENAME_LOGIN, '.php') ? FILENAME_LOGIN . '.php' : FILENAME_LOGIN))) {
  return;
}

$message = 'WARNING: This site is not fully protected from the items identified in the Trustwave Report discussed at <a href="https://www.zen-cart.com/showthread.php?219732-Trustwave-Security-report-Patch-Included-TWSL2016-006" target="_blank">this Zen-Cart site forum thread</a> ';
$errors = array('params' => 'class="messageStackAlert alert alert-warning noprint" role="alert"', 'text' => '<i class="fa fa-2x fa-hand-stop-o"></i> ' . $message);

$tableBox_string = '';

$tableBox_string .= '<table border="0" width="100%" cellspacing="0" cellpadding="2">' . "\n";
$tableBox_string .= '  <tr ' . $errors['params'] . '>' . "\n";

$tableBox_string .= '    <td' . ' ' . $errors['params'] . '>' . $errors['text'] . '</td>' . "\n";
$tableBox_string .= '  </tr>' . "\n";
$tableBox_string .= '</table>' . "\n";

echo $tableBox_string;

