<?php

/**
 * @package     ceon_advanced_shipper
 * @author      Conor Kerr <zen-cart.advanced-shipper@dev.ceon.net>
 * @copyright   Copyright 2007-2012 Ceon
 * @copyright   Portions Copyright 2003-2006 Zen Cart Development Team
 * @copyright   Portions Copyright 2003 osCommerce
 * @link        http://dev.ceon.net/web/zen-cart/advanced-shipper
 * @version     $Id: advshipper.js 981 2012-03-27 16:28:46Z conor $
 */

?>

function advshipperToggleMethod(method, link_obj, link_hide_text, link_show_text)
{
	method_config_el = document.getElementById('method_' + method + '_config');
	
	if (method_config_el.style.display == 'block') {
		method_config_el.style.display = 'none';
		link_obj.innerHTML = link_show_text;
	} else {
		method_config_el.style.display = 'block';
		link_obj.innerHTML = link_hide_text;
	}
	
	return false;
}

function advshipperToggleAllMethods(link_obj, link_hide_text, link_show_text)
{
	var method_des;
	var method_text_begin = "method_";
	var method_text_end = "_config";
	var method_obj;
	var method_hide = false;
	var link_names = document.getElementsByName(link_obj.name);
	var method_hidden = link_names[0].getAttribute("data-val");
	var method_link;
	
	var method_config_list = document.querySelectorAll('[id^=' + method_text_begin + '][id$=' + method_text_end + ']');
	
	Object.keys(method_config_list).forEach(function(method) {
		if (typeof method_config_list[method] == "object") {
			
			method_des = method_config_list[method].id;
			method_des = method_des.replace(method_text_begin, "").replace(method_text_end, "");
			
			method_obj = document.getElementById(method_config_list[method].id);
			
			method_link = method_obj.nextElementSibling.getElementsByTagName("a")[0];
			
			if (method_obj.style.display == 'block') {
				method_hide = true;
			}
			
			if (method_hidden == 'false' && method_obj.style.display == 'block') {
				method_link.click();
			} else if (method_hidden != 'false' && method_obj.style.display !== 'block') {
				method_link.click();
			}
		}
	});
	
	if (method_hidden != 'false') {
		Object.keys(link_names).forEach(function(link) {
			if (typeof link_names[link] == "object") {
				link_names[link].innerHTML = link_hide_text;
				link_names[link].setAttribute("data-val", "false");
			}
		});
	} else {
		Object.keys(link_names).forEach(function(link) {
			if (typeof link_names[link] == "object") {
				link_names[link].innerHTML = link_show_text;
				link_names[link].setAttribute("data-val", "true");
			}
		});
	}
	
	return false;
}

/**
 * Prevent the accidential deletion of a method!
 */
function advshipperConfirmDeletion()
{
	var perform_deletion = confirm('<?php echo addslashes(TEXT_JS_DELETE_CONFIRMATION); ?>');
	if (perform_deletion) {
		return true;
	} else {
		return false;
	}
}