<?php

/** 
 * Ceon URI Mapping Product Admin Pages Language Defines.
 *
 * @package     ceon_uri_mapping
 * @author      Conor Kerr <zen-cart.uri-mapping@ceon.net>
 * @copyright   Copyright 2008-2019 Ceon
 * @copyright   Copyright 2003-2019 Zen Cart Development Team
 * @copyright   Portions Copyright 2003 osCommerce
 * @link        http://ceon.net/software/business/zen-cart/uri-mapping
 * @license     http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version     $Id: ceon_uri_mapping_product_pages.php 1027 2012-07-17 20:31:10Z conor $
 */

define('BOX_CEON_URI_MAPPING', 'Ceon URI Mapping (SEO) Config');

define('CEON_URI_MAPPING_TEXT_PRODUCT_URI', 'URI Mapping:');
define('CEON_URI_MAPPING_TEXT_PRODUCT_NO_URI', 'This product is <strong>not mapped</strong> to a URI.');

define('CEON_URI_MAPPING_TEXT_PRODUCT_URI_AUTOGEN', 'Tick this box to have the URI auto-generated for this product.');
define('CEON_URI_MAPPING_TEXT_PRODUCT_URIS_AUTOGEN', 'Tick this box to have the URIs auto-generated for this product.');

define('CEON_URI_MAPPING_TEXT_PRODUCT_URI_AUTOGENERATED', 'Auto-generated URI Mapping:');
define('CEON_URI_MAPPING_TEXT_PRODUCT_URIS_AUTOGENERATED', 'Auto-generated URI Mappings:');
define('CEON_URI_MAPPING_TEXT_PRODUCT_URI_ENTERED', 'Entered URI Mapping:');
define('CEON_URI_MAPPING_TEXT_PRODUCT_URIS_ENTERED', 'Entered URI Mappings:');
define('CEON_URI_MAPPING_TEXT_PREVIEW_PRODUCT_ERROR_PRODUCT_HAS_NO_NAME', 'URI Mapping cannot be generated as the product has no name!');
define('CEON_URI_MAPPING_TEXT_PREVIEW_PRODUCT_ERROR_PRODUCT_HAS_NO_MODEL', 'URI Mapping cannot be generated as the product has no model code!');
define('CEON_URI_MAPPING_TEXT_PREVIEW_PRODUCT_ERROR_CATEGORY_HAS_NO_NAME', 'URI Mapping cannot be generated for product as a category it is in has no name!');
define('CEON_URI_MAPPING_TEXT_URI_ORIGINALLY_GENERATED', 'The URI Mapping originally generated clashes with a URI already in use on the site. That URI Mapping is:');
define('CEON_URI_MAPPING_TEXT_URI_GENERATED_AUTO_APPENDED', 'As auto-append is enabled, a new, unique URI Mapping has been generated, by appending a number:');
define('CEON_URI_MAPPING_TEXT_UPDATE_WILL_USE_AUTO_APPENDED_MAPPING', 'Clicking &ldquo;Update&rdquo; will use this new URI Mapping, with its auto-appended number. If this isn\'t the desired result, then either:</p><ul style="margin-left: 50px;"><li style="margin-bottom: 0.5em;">Copy the URI mapping, click &ldquo;Back&rdquo; and enter and change it.</li><li>Or make the necessary changes to this product\'s name, or whatever is using the desired URI mapping, so that the desired URI can be used for this product without this clash (for example, check that this product is not using the same name as another in the same category etc.).</ul>');
define('CEON_URI_MAPPING_TEXT_URI_GENERATED_WHICH_IS_CLASHING', 'The URI Mapping auto-generated cannot be used as it clashes with a URI Mapping already in use for the site:');
define('CEON_URI_MAPPING_TEXT_URI_ORIGINALLY_ENTERED', 'The URI Mapping originally entered clashes with a URI already in use on the site. That URI Mapping is:');
define('CEON_URI_MAPPING_TEXT_URI_ENTERED_AUTO_APPENDED', 'As auto-append is enabled, a new, unique URI Mapping has been generated, by appending a number:');
define('CEON_URI_MAPPING_TEXT_URI_ENTERED_WHICH_IS_CLASHING', 'The URI Mapping entered clashes with a URI already in use on the site, so it will not be saved. The URI Mapping entered was:');
define('CEON_URI_MAPPING_TEXT_PRODUCT_NO_URI_ENTERED', 'No URI Mapping');

define('CEON_URI_MAPPING_TEXT_PRODUCT_MAPPING_ADDED', '%s URI Mapping added: %s');
define('CEON_URI_MAPPING_TEXT_PRODUCT_MAPPING_ADDED_WITH_AUTO_APPEND', '%s URI Mapping added. The URI mapping was already being used, so an auto-appended integer was added, as per the site\'s configuration settings: %s - The mapping can be manually changed by <a href="%s" target="_blank">editing the product</a>.');
define('CEON_URI_MAPPING_TEXT_PRODUCT_MAPPING_ADDED_ENFORCED_AUTO_APPEND', '%s URI Mapping added. The URI mapping was already being used, so an auto-appended integer was added, to make the URI mapping unique and prevent it clashing with the existing mapping: %s - The mapping can be manually changed by <a href="%s" target="_blank">editing the product</a>.');
define('CEON_URI_MAPPING_TEXT_PRODUCT_MAPPING_UPDATED', '%s URI Mapping updated: %s');
define('CEON_URI_MAPPING_TEXT_PRODUCT_MAPPING_MADE_HISTORICAL', '%s URI Mapping converted to historical mapping');
define('CEON_URI_MAPPING_TEXT_PRODUCT_RELATED_PAGE_MAPPING_MADE_HISTORICAL', '%s URI Mapping converted to historical mapping (%s)');

if (!defined('CEON_URI_MAPPING_TEXT_URI_AUTOGEN_ONE_EXISTING_MAPPING')) {
	require_once('ceon_uri_mapping_admin_pages.php');
}

define('CEON_URI_MAPPING_TEXT_DUPLICATE_PRODUCT_URI_MAPPING', 'URI Mapping (only applies if product is being duplicated):');
define('CEON_URI_MAPPING_TEXT_COPY_AUTOGEN_URI', 'Auto-generate a new URI mapping for the duplicate product.');
define('CEON_URI_MAPPING_TEXT_COPY_AUTOGEN_URIS', 'Auto-generate new URI mappings for the duplicate product.');
define('CEON_URI_MAPPING_TEXT_COPY_EXISTING_MAPPING', 'Copy existing product\'s URI mapping to the duplicate product (it will have a number appended so that the URI mapping is unique and therefore doesn\'t conflict with the URI mapping of the product being copied).');
define('CEON_URI_MAPPING_TEXT_COPY_EXISTING_MAPPINGS', 'Copy existing product\'s URI mappings to the duplicate product (they will have a number appended so that the URI mappings are unique and therefore don\'t conflict with the URI mappings of the product being copied).');
define('CEON_URI_MAPPING_TEXT_COPY_PRODUCT_DONT_AUTOGEN_URI', 'Don\'t auto-generate a new URI mapping for the duplicate product.');
define('CEON_URI_MAPPING_TEXT_COPY_PRODUCT_DONT_AUTOGEN_URIS', 'Don\'t auto-generate URI mappings for the duplicate product.');
define('CEON_URI_MAPPING_TEXT_COPY_PRODUCT_DONT_COPY_URI', 'Don\'t copy existing product\'s URI mapping to the duplicate product.');
define('CEON_URI_MAPPING_TEXT_COPY_PRODUCT_DONT_COPY_URIS', 'Don\'t copy existing product\'s URI mappings to the duplicate product.');
define('CEON_URI_MAPPING_TEXT_COPY_PRODUCT_DONT_AUTOGEN_COPY_URI', 'Don\'t auto-generate the URI mapping or copy the existing product\'s URI mapping for the duplicate product.');
define('CEON_URI_MAPPING_TEXT_COPY_PRODUCT_DONT_AUTOGEN_COPY_URIS', 'Don\'t auto-generate the URI mappings or copy the existing product\'s URI mappings for the duplicate product.');

define('CEON_URI_MAPPING_TEXT_MOVE_PRODUCT_URI_MAPPING', 'URI Mapping:');
define('CEON_URI_MAPPING_TEXT_MOVE_AUTOGEN_URI', 'Auto-generate a new URI mapping according the category being moved to.');
define('CEON_URI_MAPPING_TEXT_MOVE_AUTOGEN_URIS', 'Auto-generate new URI mappings according the category being moved to.');
define('CEON_URI_MAPPING_TEXT_MOVE_USE_EXISTING_MAPPING', 'Use product\'s existing URI mapping after the product has been moved to its new category.');
define('CEON_URI_MAPPING_TEXT_MOVE_USE_EXISTING_MAPPINGS', 'Use product\'s existing URI mappings after the product has been moved to its new category.');
define('CEON_URI_MAPPING_TEXT_MOVE_PRODUCT_DONT_AUTOGEN_URI', 'Don\'t auto-generate a URI mapping for the product after it has been moved.');
define('CEON_URI_MAPPING_TEXT_MOVE_PRODUCT_DONT_AUTOGEN_URIS', 'Don\'t auto-generate URI mappings for the product after it has been moved.');
define('CEON_URI_MAPPING_TEXT_MOVE_PRODUCT_DONT_MOVE_URI', 'Drop existing URI mapping for the product after it has been moved.');
define('CEON_URI_MAPPING_TEXT_MOVE_PRODUCT_DONT_MOVE_URIS', 'Drop existing URI mappings for the product after it has been moved.');
define('CEON_URI_MAPPING_TEXT_MOVE_PRODUCT_DONT_AUTOGEN_MOVE_URI', 'Drop existing URI mapping for the product after it has been moved, and don\'t generate a new one (the moved product will have no current URI mapping).');
define('CEON_URI_MAPPING_TEXT_MOVE_PRODUCT_DONT_AUTOGEN_MOVE_URIS', 'Drop existing URI mappings for the product after it has been moved, and don\'t generate new ones (the moved product will have no current URI mappings).');

define('CEON_URI_MAPPING_TEXT_ERROR_AUTOGENERATION_PRODUCT_HAS_NO_NAME', '%s URI Mapping cannot be generated as the product has no name! - <a href="%s" target="_blank">Edit the product</a>');
define('CEON_URI_MAPPING_TEXT_ERROR_AUTOGENERATION_PRODUCT_HAS_NO_MODEL', '%s URI Mapping cannot be generated as the product has no model code! - <a href="%s" target="_blank">Edit the product</a>');
define('CEON_URI_MAPPING_TEXT_ERROR_AUTOGENERATION_PRODUCT_CATEGORY_HAS_NO_NAME', '%s URI Mapping cannot be generated for product as a category it is in has no name!');

define('CEON_URI_MAPPING_TEXT_ERROR_COPY_PRODUCT_MAPPING_CLASHED', '%s URI Mapping NOT added as the desired URI mapping clashes with an existing mapping: %s - The product has no URI mapping for %s, it must be added manually by <a href="%s" target="_blank">editing the product</a>.');
define('CEON_URI_MAPPING_TEXT_ERROR_MOVE_PRODUCT_MAPPING_CLASHED', '%s URI Mapping NOT added as the desired URI mapping clashes with an existing mapping: %s - The product has no URI mapping for %s, it must be added manually by <a href="%s" target="_blank">editing the product</a>.');
